/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class ButtonRemote
extends VRPNDevice
implements Runnable {
    protected Vector changeListeners = new Vector();
    protected static final Object notifyingChangeListenersLock = new Object();

    public ButtonRemote(String string, String string2, String string3, String string4, String string5) throws InstantiationException {
        super(string, string2, string3, string4, string5);
    }

    public synchronized void addButtonChangeListener(ButtonChangeListener buttonChangeListener) {
        this.changeListeners.addElement(buttonChangeListener);
    }

    public synchronized boolean removeButtonChangeListener(ButtonChangeListener buttonChangeListener) {
        return this.changeListeners.removeElement(buttonChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stoppedRunning() {
        this.changeListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownButton();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleButtonChange(long l, long l2, int n, int n2) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            ButtonUpdate buttonUpdate = new ButtonUpdate();
            buttonUpdate.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            buttonUpdate.button = n;
            buttonUpdate.state = n2;
            Enumeration enumeration = this.changeListeners.elements();
            while (enumeration.hasMoreElements()) {
                ButtonChangeListener buttonChangeListener = (ButtonChangeListener)enumeration.nextElement();
                buttonChangeListener.buttonUpdate(buttonUpdate, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownButton();

    @Override
    protected native void mainloop();

    public static interface ButtonChangeListener {
        public void buttonUpdate(ButtonUpdate var1, ButtonRemote var2);
    }

    public class ButtonUpdate {
        public Date msg_time = new Date();
        public int button = 0;
        public int state = 0;
    }
}

