﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TeacherAssitant
{
    public class Teacher
    {
        
        # region Private State

        /// <summary>
        /// Player id.
        /// </summary>
        private readonly int id;

        /// <summary>
        /// Player is being tracked.
        /// </summary>
        public bool IsAlive { get; set; }


        public bool clickEvent { get; set; }
        public double clickEventX { get; set; }
        public double clickEventY { get; set; }
        public bool click { get; set; }

        /// <summary>
        /// Last time that the player was tracked.
        /// </summary>
        public DateTime LastUpdated { get; set; }

        public bool hasActiveHand { get; set; }
        public double activeHandX { get; set; }
        public double activeHandY { get; set; }

        #endregion Private State

        #region Ctor

        /// <summary>
        /// Player initialization.
        /// </summary>
        /// <param name="skeletonSlot"></param>
        public Teacher(int skeletonSlot)
        {
            this.id = skeletonSlot;
            this.LastUpdated = DateTime.Now;
        }

        #endregion Ctor

        #region Color update + getId

        /// <summary>
        /// Get id.
        /// </summary>
        public int GetId()
        {
            return this.id;
        }

        #endregion Color update + getId
    }
}
