﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Threading;
using System.Windows.Threading;
using Microsoft.Kinect;
using System.IO;

namespace TeacherAssitant
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

        /// <summary>
        /// Rate at which the control thread is being updated.
        /// </summary>
        private const int TimerResolution = 20;  // ms

        /// <summary>
        /// Flag. Controls when the control thread should stop.
        /// </summary>
        private bool runningControlThread;

        public String uniqueName;

        private Canvas resourcesCanvas;

        private Cover cover;

        private List<PowerPointPresentation> presentations = new List<PowerPointPresentation>();

        private PowerPointPresentation actualPresentation;

        private AppStatus appStatus;

        private String dataTxt;

        public MainWindow()
        {
            dataTxt = "Data:";
            InitializeComponent();
            Init();
        }

        private void Init()
        {
            initializeResourcesCanvas();
            initializeCover();

            appStatus = AppStatus.CalibratingSt;

            //Starts the control thread.
            var myThread = new Thread(this.ControlThread);
            myThread.Start();
        }

        private void initializeResourcesCanvas()
        {
            resourcesCanvas = new Canvas();
            resourcesCanvas.Height = System.Windows.SystemParameters.PrimaryScreenHeight-100;
            resourcesCanvas.Width = 250;
            mainCanvas.Children.Add(resourcesCanvas);
            Canvas.SetTop(resourcesCanvas, 100);
            Canvas.SetLeft(resourcesCanvas, System.Windows.SystemParameters.PrimaryScreenWidth - 300);

            createPowerPnt(0, 0, "Instrucciones", "C:/Users/Diego/Dropbox/Ambientes interactivos/Proyecto/Instrucciones Prueba de usuario.pptx");
            createPowerPnt(0, 110, "Prueba", "C:/Users/Diego/Dropbox/Ambientes interactivos/Proyecto/Prueba.pptx");
            createPowerPnt(0, -200, "Inicial", "C:/Users/Diego/Dropbox/Ambientes interactivos/Proyecto/Instrucciones table.pptx");
        }

        private void createPowerPnt(double x, double y,string name,string url)
        {
            PowerPointPresentation ppt = new PowerPointPresentation(x, y, name, url);
            ppt.addPowerPoint(resourcesCanvas);
            presentations.Add(ppt);
        }

        private void initializeCover()
        {
            cover = new Cover(this);
            cover.Show();
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {

            //Stop the control thread.
            this.runningControlThread = false;


            // create a writer and open the file
            TextWriter tw = new StreamWriter(uniqueName+"_data.txt");
            // write a line of text to the file
            tw.WriteLine(dataTxt);
            // close the stream
            tw.Close();

        }

        public void ControlThread()
        {
            this.runningControlThread = true;

            while (this.runningControlThread)
            {
                Thread.Sleep(TimerResolution);
                this.Dispatcher.Invoke(DispatcherPriority.Send, new Action<int>(this.ControlHandler), 0);
            }
        }

        public int endInitialization(PowerPointPresentation noPPT)
        {
            appStatus = AppStatus.DesktopSt;
            cover.updateStatus("");

            appStatus = AppStatus.Paso1;
            pptSelected(presentations.ElementAt(2));
            return 0;
        }

        int contador3 = 0;
        Rectangle rect;
        AppStatus last;

        public void ControlHandler(int param)
        {
            double[] position = getCursorPosition();
            //if(position != null)
            //  cover.updateStatus("x:"+position[0]+ " - y:"+position[1]);
            //else
            //  cover.updateStatus("null");
            if (appStatus == AppStatus.CalibratingSt)
            {
                cover.updateStatus("Initializing...");
                cover.advanceSelection(null, endInitialization);
            }
            else if (appStatus == AppStatus.Paso1)
            {
                contador3++;
                cover.notSelected(Cover.PptControls.Cerrar);
                if (contador3 == 100)
                {
                    dataTxt += "\nPaso 1: "+DateTime.Now.Hour+":"+DateTime.Now.Minute+":"+DateTime.Now.Second;
                    appStatus = AppStatus.Paso2;
                    actualPresentation.nextSlide();
                }
            }
            else if (appStatus == AppStatus.Paso2)
            {
                if (position != null)
                {
                    dataTxt += "\nPaso 2: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                    appStatus = AppStatus.Paso3;
                    rect = cover.drawRect(100,100);
                    actualPresentation.nextSlide();
                }
            }
            else if (appStatus == AppStatus.Paso3)
            {
                if (position != null)
                {
                    if (cover.isInRect(position[0], position[1]))
                    {
                        dataTxt += "\nPaso 3: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                        cover.removeRect();
                        appStatus = AppStatus.Paso4;
                        rect = cover.drawRect(500, 500);
                        actualPresentation.nextSlide();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso4)
            {
                if (position != null)
                {
                    if (cover.isInRect(position[0], position[1]))
                    {
                        dataTxt += "\nPaso 4: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                        cover.removeRect();
                        appStatus = AppStatus.Paso5;
                        rect = cover.drawRect(500, 100);
                        actualPresentation.nextSlide();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso5)
            {
                if (position != null)
                {
                    if (cover.isInRect(position[0], position[1]))
                    {
                        dataTxt += "\nPaso 5: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                        cover.removeRect();
                        rect = cover.drawRect(700, 500);
                        appStatus = AppStatus.Paso6;
                        actualPresentation.nextSlide();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso6)
            {
                if (position != null)
                {
                    if (cover.isInRect(position[0], position[1]))
                    {
                        dataTxt += "\nPaso 6: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                        cover.removeRect();
                        appStatus = AppStatus.Paso7;
                        actualPresentation.nextSlide();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso7)
            {
                if (position != null)
                {
                    bool found = false;
                    if (cover.isIn(position[0], position[1], Cover.PptControls.Cerrar))
                    {
                        cover.advanceSelection(Cover.PptControls.Cerrar, closePresentation);
                        found = true;
                    }
                    else
                    {
                        cover.notSelected(Cover.PptControls.Cerrar);
                    }

                    if (!found)
                    {
                        cover.noSelection();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.DesktopSt)
            {
                if (position != null)
                {
                    bool found = false;
                    foreach (var ppt in presentations)
                    {
                        double x = position[0] - Canvas.GetLeft(resourcesCanvas);
                        double y = position[1] - Canvas.GetTop(resourcesCanvas);
                        if (ppt.contains(x, y))
                        {
                            cover.advanceSelection(ppt, pptSelected);
                            found = true;
                            break;
                        }
                    }

                    if (!found)
                    {
                        cover.noSelection();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso8)
            {
                if (position != null)
                {
                    bool found = false;
                    foreach (var ppt in presentations)
                    {
                        double x = position[0] - Canvas.GetLeft(resourcesCanvas);
                        double y = position[1] - Canvas.GetTop(resourcesCanvas);
                        if (ppt.contains(x, y))
                        {
                            cover.advanceSelection(ppt, pptSelected);
                            found = true;
                            break;
                        }
                    }

                    if (!found)
                    {
                        cover.noSelection();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.Paso9)
            {
                if (position != null)
                {
                    bool found = false;
                    if (cover.isIn(position[0], position[1], Cover.PptControls.Cerrar))
                    {
                        cover.advanceSelection(Cover.PptControls.Cerrar, closePresentation);
                        found = true;
                    }
                    else
                    {
                        cover.notSelected(Cover.PptControls.Cerrar);
                    }

                    if (cover.isIn(position[0], position[1], Cover.PptControls.RightSliderZone))
                    {
                        cover.showNextSlider();
                        last = appStatus;
                        appStatus = AppStatus.NextSlider;
                    }

                    if (!found)
                    {
                        cover.noSelection();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.PPTPresenterSt)
            {
                if (position != null)
                {
                    bool found = false;
                    if (cover.isIn(position[0], position[1], Cover.PptControls.Cerrar))
                    {
                        cover.advanceSelection(Cover.PptControls.Cerrar, closePresentation);
                        found = true;
                    }
                    else
                    {
                        cover.notSelected(Cover.PptControls.Cerrar);
                    }

                    if (cover.isIn(position[0], position[1], Cover.PptControls.LeftSliderZone))
                    {
                        cover.showPrevSlider();
                        last = appStatus;
                        appStatus = AppStatus.PrevSlider;
                    }
                    if (cover.isIn(position[0], position[1], Cover.PptControls.RightSliderZone))
                    {
                        cover.showNextSlider();
                        last = appStatus;
                        appStatus = AppStatus.NextSlider;
                    }

                    if (!found)
                    {
                        cover.noSelection();
                    }
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.NextSlider)
            {
                if (position != null)
                {
                    if (cover.isIn2(position[0], position[1], Cover.PptControls.LeftSliderZone))
                    {
                        actualPresentation.nextSlide();
                        cover.notSelected(Cover.PptControls.NextSlider);
                        cover.hideSlider();
                        if (last != AppStatus.Paso9)
                            appStatus = AppStatus.PPTPresenterSt;
                        else
                        {
                            dataTxt += "\nPaso 9 - NEXT: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                            appStatus = AppStatus.Paso9;
                        }
                    }
                    else if (!cover.isIn(position[0], position[1], Cover.PptControls.NextSlider))
                    {
                        cover.notSelected(Cover.PptControls.NextSlider);
                        cover.hideSlider();
                        if (last != AppStatus.Paso9)
                            appStatus = AppStatus.PPTPresenterSt;
                        else
                            appStatus = AppStatus.Paso9;
                    }
                    else
                    {
                        cover.showSlider(position[0]);
                    }
                }
                else
                {
                    cover.notSelected(Cover.PptControls.NextSlider);
                    cover.hideSlider();

                    if (last != AppStatus.Paso9)
                        appStatus = AppStatus.PPTPresenterSt;
                    else
                        appStatus = AppStatus.Paso9;
                }
                cover.updateCursorPosition(position);
            }
            else if (appStatus == AppStatus.PrevSlider)
            {
                if (position != null)
                {
                    if (cover.isIn2(position[0], position[1], Cover.PptControls.RightSliderZone))
                    {
                        actualPresentation.previousSlide();
                        cover.notSelected(Cover.PptControls.PrevSlider);
                        cover.hideSlider();
                        appStatus = AppStatus.PPTPresenterSt;
                    }
                    else if (!cover.isIn(position[0], position[1], Cover.PptControls.PrevSlider))
                    {
                        cover.notSelected(Cover.PptControls.PrevSlider);
                        cover.hideSlider();
                        appStatus = AppStatus.PPTPresenterSt;
                    }
                    else
                    {
                        cover.showSlider(position[0]);
                    }
                }
                else
                {
                    cover.notSelected(Cover.PptControls.PrevSlider);
                    cover.hideSlider();
                    appStatus = AppStatus.PPTPresenterSt;
                }

                cover.updateCursorPosition(position);
            }
        }

        private int closePresentation()
        {
            cover.updateStatus("Cerrar");
            actualPresentation.closePresentation();
            if (appStatus != AppStatus.Paso7)
            {
                dataTxt += "\nPaso 9 - CERRAR: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                appStatus = AppStatus.DesktopSt;
            }
            else
            {
                dataTxt += "\nPaso 7: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                appStatus = AppStatus.Paso8;
            }
            cover.unloadPresentationControls();
            this.Activate();
            cover.Activate();
            return 0;
        }

        private int pptSelected(PowerPointPresentation ppt)
        {
            actualPresentation = ppt;
            cover.updateStatus("Selected ppt: "+ppt.name);
            if (appStatus != AppStatus.Paso1 && appStatus != AppStatus.Paso8)
                appStatus = AppStatus.PPTPresenterSt;
            else if (appStatus == AppStatus.Paso8 && ppt.name != "Instrucciones")
            {
                dataTxt += "\nPaso 8-MAL: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                cover.updateStatus("Presentación equivocada");
                return 0;
            }
            else if (appStatus == AppStatus.Paso8)
            {
                dataTxt += "\nPaso 8: " + DateTime.Now.Hour + ":" + DateTime.Now.Minute + ":" + DateTime.Now.Second;
                appStatus = AppStatus.Paso9;
            }
            ppt.startPresentation();
            cover.noSelection();
            cover.loadPresentationControls();
            return 0;
        }

        private double[] getCursorPosition()
        {
            //Point mp = Mouse.GetPosition(this);
            //double[] position = {mp.X,mp.Y};
            double[] position = cover.getCursorPosition();
            return position;
        }


        public enum AppStatus
        {
            CalibratingSt,
            DesktopSt,
            PPTPresenterSt,
            NextSlider,
            PrevSlider,
            Paso1,
            Paso2,
            Paso3,
            Paso4,
            Paso5,
            Paso6,
            Paso7,
            Paso8,
            Paso9,
            Paso10
        }


    }
}
