﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Media;

namespace TeacherAssitant
{
    public class PowerPointPresentation
    {
        public string name { get; set; }
        public string url { get; set; }
        
        private Image PowerPointIcon = null;
        private Rectangle bounds;
        private TextBlock txt;

        private double x;
        private double y;


        Microsoft.Office.Interop.PowerPoint.Application pptApp;
        Microsoft.Office.Interop.PowerPoint.Presentation p;

        public PowerPointPresentation(double x, double y, string name,string url)
        {
            this.x = x;
            this.y = y;
            this.name = name;
            this.url = url;
        }

        public void addPowerPoint(Canvas canvas)
        {
            bounds = new Rectangle { Width = 300, Height = 80, Fill = new SolidColorBrush(Color.FromArgb(50, 0, 200, 250)) };
            canvas.Children.Add(bounds);
            Canvas.SetLeft(bounds, x);
            Canvas.SetTop(bounds, y);

            txt = new TextBlock { Text = name, Foreground = Brushes.White, FontSize = 24 };
            canvas.Children.Add(txt);
            Canvas.SetLeft(txt, x + 100);
            Canvas.SetTop(txt, y + 20);


            PowerPointIcon = new Image { Source = new BitmapImage(new Uri("data/img/powerPointIcon.png", UriKind.RelativeOrAbsolute)) };
            canvas.Children.Add(PowerPointIcon);
            Canvas.SetLeft(PowerPointIcon, x + 10);
            Canvas.SetTop(PowerPointIcon, y + 10);
        }

        public void updatePowerPoint(Canvas canvas)
        {
            Canvas.SetLeft(bounds, x);
            Canvas.SetTop(bounds, y);
            Canvas.SetLeft(txt, x + 100);
            Canvas.SetTop(txt, y + 20);
            Canvas.SetLeft(PowerPointIcon, x + 10);
            Canvas.SetTop(PowerPointIcon, y + 10);
        }

        public Boolean contains(double x, double y)
        {
            return this.x <= x && this.x + bounds.ActualWidth >= x && this.y <= y && this.y + bounds.ActualHeight >= y;
        }

        public void startPresentation()
        {
            pptApp = new Microsoft.Office.Interop.PowerPoint.Application();
            Microsoft.Office.Core.MsoTriState ofalse = Microsoft.Office.Core.MsoTriState.msoFalse;
            Microsoft.Office.Core.MsoTriState otrue = Microsoft.Office.Core.MsoTriState.msoTrue;
            pptApp.Visible = otrue;
            pptApp.Activate();
            Microsoft.Office.Interop.PowerPoint.Presentations ps = pptApp.Presentations;
            p = ps.Open(url, ofalse, ofalse, otrue);
            System.Diagnostics.Debug.Print(p.Windows.Count.ToString());
            p.SlideShowSettings.LoopUntilStopped = otrue;
            p.SlideShowSettings.Run();
        }

        public void nextSlide()
        {
            p.SlideShowWindow.View.Next();
        }

        public void previousSlide()
        {
            p.SlideShowWindow.View.Previous();
        }

        public void closePresentation()
        {
            p.SlideShowWindow.View.Exit();
            p.Close();
            //pptApp.Quit();
        }

    }
}
