/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.core.PStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PApplet
extends Applet
implements PConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public static final String javaVersionName = System.getProperty("java.version");
    public static final float javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
    public static int platform;
    public static final int MENU_SHORTCUT;
    public PGraphics g;
    public Frame frame;
    public Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    public PGraphics recorder;
    public String[] args;
    public String sketchPath;
    static final boolean THREAD_DEBUG = false;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int MIN_WINDOW_WIDTH = 128;
    public static final int MIN_WINDOW_HEIGHT = 128;
    public boolean defaultSize;
    volatile boolean resizeRequest;
    volatile int resizeWidth;
    volatile int resizeHeight;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    public boolean firstMouse;
    public int mouseButton;
    public boolean mousePressed;
    public MouseEvent mouseEvent;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    public boolean focused = false;
    public boolean online = false;
    long millisOffset;
    public float frameRate = 10.0f;
    protected long frameRateLastNanos = 0L;
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean exitCalled;
    Thread thread;
    protected RegisteredMethods sizeMethods;
    protected RegisteredMethods preMethods;
    protected RegisteredMethods drawMethods;
    protected RegisteredMethods postMethods;
    protected RegisteredMethods mouseEventMethods;
    protected RegisteredMethods keyEventMethods;
    protected RegisteredMethods disposeMethods;
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_EXCLUSIVE = "--exclusive";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final String EXTERNAL_STOP = "__STOP__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    boolean external = false;
    static final String ERROR_MIN_MAX = "Cannot use min() or max() on an empty array.";
    MouseEvent[] mouseEventQueue = new MouseEvent[10];
    int mouseEventCount;
    KeyEvent[] keyEventQueue = new KeyEvent[10];
    int keyEventCount;
    static String openLauncher;
    int cursorType = 0;
    boolean cursorVisible = true;
    PImage invisibleCursor;
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    protected String[] loadImageFormats;
    public int requestImageMax = 4;
    volatile int requestImageCount;
    public File selectedFile;
    protected Frame parentFrame;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public static final byte[] ICON_IMAGE;

    @Override
    public void init() {
        this.setFocusTraversalKeysEnabled(false);
        this.millisOffset = System.currentTimeMillis();
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.firstMouse = true;
        this.sizeMethods = new RegisteredMethods();
        this.preMethods = new RegisteredMethods();
        this.drawMethods = new RegisteredMethods();
        this.postMethods = new RegisteredMethods();
        this.mouseEventMethods = new RegisteredMethods();
        this.keyEventMethods = new RegisteredMethods();
        this.disposeMethods = new RegisteredMethods();
        try {
            this.getAppletContext();
            this.online = true;
        }
        catch (NullPointerException nullPointerException) {
            this.online = false;
        }
        try {
            if (this.sketchPath == null) {
                this.sketchPath = System.getProperty("user.dir");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dimension dimension = this.getSize();
        if (dimension.width != 0 && dimension.height != 0) {
            this.g = this.makeGraphics(dimension.width, dimension.height, this.getSketchRenderer(), null, true);
        } else {
            this.defaultSize = true;
            int n = this.getSketchWidth();
            int n2 = this.getSketchHeight();
            this.g = this.makeGraphics(n, n2, this.getSketchRenderer(), null, true);
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
        }
        this.width = this.g.width;
        this.height = this.g.height;
        this.addListeners();
        this.start();
    }

    public int getSketchWidth() {
        return 100;
    }

    public int getSketchHeight() {
        return 100;
    }

    public String getSketchRenderer() {
        return "processing.core.PGraphicsJava2D";
    }

    @Override
    public void start() {
        this.finished = false;
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Animation Thread");
        this.thread.start();
    }

    @Override
    public void stop() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.disposeMethods.handle();
    }

    @Override
    public void destroy() {
        this.stop();
    }

    public void registerSize(Object object) {
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        this.registerWithArgs(this.sizeMethods, "size", object, classArray);
    }

    public void registerPre(Object object) {
        this.registerNoArgs(this.preMethods, "pre", object);
    }

    public void registerDraw(Object object) {
        this.registerNoArgs(this.drawMethods, "draw", object);
    }

    public void registerPost(Object object) {
        this.registerNoArgs(this.postMethods, "post", object);
    }

    public void registerMouseEvent(Object object) {
        Class[] classArray = new Class[]{MouseEvent.class};
        this.registerWithArgs(this.mouseEventMethods, "mouseEvent", object, classArray);
    }

    public void registerKeyEvent(Object object) {
        Class[] classArray = new Class[]{KeyEvent.class};
        this.registerWithArgs(this.keyEventMethods, "keyEvent", object, classArray);
    }

    public void registerDispose(Object object) {
        this.registerNoArgs(this.disposeMethods, "dispose", object);
    }

    protected void registerNoArgs(RegisteredMethods registeredMethods, String string, Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            registeredMethods.add(object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.die("There is no " + string + "() method in the class " + object.getClass().getName());
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    protected void registerWithArgs(RegisteredMethods registeredMethods, String string, Object object, Class<?>[] classArray) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            registeredMethods.add(object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.die("There is no " + string + "() method in the class " + object.getClass().getName());
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    public void unregisterSize(Object object) {
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
        this.unregisterWithArgs(this.sizeMethods, "size", object, classArray);
    }

    public void unregisterPre(Object object) {
        this.unregisterNoArgs(this.preMethods, "pre", object);
    }

    public void unregisterDraw(Object object) {
        this.unregisterNoArgs(this.drawMethods, "draw", object);
    }

    public void unregisterPost(Object object) {
        this.unregisterNoArgs(this.postMethods, "post", object);
    }

    public void unregisterMouseEvent(Object object) {
        Class[] classArray = new Class[]{MouseEvent.class};
        this.unregisterWithArgs(this.mouseEventMethods, "mouseEvent", object, classArray);
    }

    public void unregisterKeyEvent(Object object) {
        Class[] classArray = new Class[]{KeyEvent.class};
        this.unregisterWithArgs(this.keyEventMethods, "keyEvent", object, classArray);
    }

    public void unregisterDispose(Object object) {
        this.unregisterNoArgs(this.disposeMethods, "dispose", object);
    }

    protected void unregisterNoArgs(RegisteredMethods registeredMethods, String string, Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            registeredMethods.remove(object, method);
        }
        catch (Exception exception) {
            this.die("Could not unregister " + string + "() for " + object, exception);
        }
    }

    protected void unregisterWithArgs(RegisteredMethods registeredMethods, String string, Object object, Class<?>[] classArray) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            registeredMethods.remove(object, method);
        }
        catch (Exception exception) {
            this.die("Could not unregister " + string + "() for " + object, exception);
        }
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    protected void resizeRenderer(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.g.setSize(n, n2);
            this.width = n;
            this.height = n2;
        }
    }

    public void size(int n, int n2) {
        this.size(n, n2, "processing.core.PGraphicsJava2D", null);
    }

    public void size(int n, int n2, String string) {
        this.size(n, n2, string, null);
    }

    public void size(final int n, final int n2, String string, String string2) {
        String string3;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PApplet.this.setPreferredSize(new Dimension(n, n2));
                PApplet.this.setSize(n, n2);
            }
        });
        if (string2 != null) {
            string2 = this.savePath(string2);
        }
        if (!(string3 = this.g.getClass().getName()).equals(string)) {
            this.g = this.makeGraphics(n, n2, string, string2, true);
            this.width = n;
            this.height = n2;
            this.defaultSize = false;
            throw new RendererChangeException();
        }
        this.resizeRenderer(n, n2);
    }

    public PGraphics createGraphics(int n, int n2, String string) {
        PGraphics pGraphics = this.makeGraphics(n, n2, string, null, false);
        return pGraphics;
    }

    public PGraphics createGraphics(int n, int n2, String string, String string2) {
        if (string2 != null) {
            string2 = this.savePath(string2);
        }
        PGraphics pGraphics = this.makeGraphics(n, n2, string, string2, false);
        pGraphics.parent = this;
        return pGraphics;
    }

    protected PGraphics makeGraphics(int n, int n2, String string, String string2, boolean bl) {
        String string3;
        if (string.equals("processing.opengl.PGraphicsOpenGL") && platform == 1 && (string3 = System.getProperty("java.version")) != null && string3.equals("1.5.0_10")) {
            System.err.println("OpenGL support is broken with Java 1.5.0_10");
            System.err.println("See http://dev.processing.org/bugs/show_bug.cgi?id=513 for more info.");
            throw new RuntimeException("Please update your Java installation (see bug #513)");
        }
        string3 = "Before using OpenGL, first select Import Library > opengl from the Sketch menu.";
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            PGraphics pGraphics = (PGraphics)constructor.newInstance(new Object[0]);
            pGraphics.setParent(this);
            pGraphics.setPrimary(bl);
            if (string2 != null) {
                pGraphics.setPath(string2);
            }
            pGraphics.setSize(n, n2);
            return pGraphics;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string4 = invocationTargetException.getTargetException().getMessage();
            if (string4 != null && string4.indexOf("no jogl in java.library.path") != -1) {
                throw new RuntimeException(string3 + " (The native library is missing.)");
            }
            invocationTargetException.getTargetException().printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (platform == 2) {
                throwable.printStackTrace(System.out);
            }
            throw new RuntimeException(throwable.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classNotFoundException.getMessage().indexOf("processing.opengl.PGraphicsGL") != -1) {
                throw new RuntimeException(string3 + " (The library .jar file is missing.)");
            }
            throw new RuntimeException("You need to use \"Import Library\" to add " + string + " to your sketch.");
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException || exception instanceof NoSuchMethodException || exception instanceof IllegalAccessException) {
                exception.printStackTrace();
                String string5 = string + " needs to be updated " + "for the current release of Processing.";
                throw new RuntimeException(string5);
            }
            if (platform == 2) {
                exception.printStackTrace(System.out);
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public PImage createImage(int n, int n2, int n3) {
        PImage pImage = new PImage(n, n2, n3);
        pImage.parent = this;
        return pImage;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.frameCount == 0) {
            return;
        }
        if (this.g != null && this.g.image != null) {
            graphics.drawImage(this.g.image, 0, 0, null);
        }
    }

    protected void paint() {
        try {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                if (this.g != null && this.g.image != null) {
                    graphics.drawImage(this.g.image, 0, 0, null);
                }
                Toolkit.getDefaultToolkit().sync();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void run() {
        long l = System.nanoTime();
        long l2 = 0L;
        int n = 0;
        while (Thread.currentThread() == this.thread && !this.finished) {
            long l3;
            long l4;
            long l5;
            if (this.resizeRequest) {
                this.resizeRenderer(this.resizeWidth, this.resizeHeight);
                this.resizeRequest = false;
            }
            this.handleDraw();
            if (this.frameCount == 1) {
                this.requestFocus();
            }
            if ((l5 = this.frameRatePeriod - (l4 = (l3 = System.nanoTime()) - l) - l2) > 0L) {
                try {
                    Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                    n = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.nanoTime() - l3 - l5;
            } else {
                l2 = 0L;
                if (n > 15) {
                    Thread.yield();
                    n = 0;
                }
            }
            l = System.nanoTime();
        }
        this.stop();
        if (this.exitCalled) {
            this.exit2();
        }
    }

    public void handleDraw() {
        if (this.g != null && (this.looping || this.redraw)) {
            if (!this.g.canDraw()) {
                return;
            }
            this.g.beginDraw();
            long l = System.nanoTime();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RendererChangeException rendererChangeException) {
                    return;
                }
                this.defaultSize = false;
            } else {
                double d = 1000000.0 / ((double)(l - this.frameRateLastNanos) / 1000000.0);
                float f = (float)d / 1000.0f;
                this.frameRate = this.frameRate * 0.9f + f * 0.1f;
                this.preMethods.handle();
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dequeueMouseEvents();
                this.dequeueKeyEvents();
                this.drawMethods.handle();
                this.redraw = false;
            }
            this.g.endDraw();
            this.frameRateLastNanos = l;
            ++this.frameCount;
            this.paint();
            this.postMethods.handle();
        }
    }

    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
        }
    }

    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public synchronized void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    public void addListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                PApplet.this.resizeRequest = true;
                PApplet.this.resizeWidth = rectangle.width;
                PApplet.this.resizeHeight = rectangle.height;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueMouseEvent(MouseEvent mouseEvent) {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            if (this.mouseEventCount == this.mouseEventQueue.length) {
                MouseEvent[] mouseEventArray2 = new MouseEvent[this.mouseEventCount << 1];
                System.arraycopy(this.mouseEventQueue, 0, mouseEventArray2, 0, this.mouseEventCount);
                this.mouseEventQueue = mouseEventArray2;
            }
            this.mouseEventQueue[this.mouseEventCount++] = mouseEvent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueMouseEvents() {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            for (int i = 0; i < this.mouseEventCount; ++i) {
                this.mouseEvent = this.mouseEventQueue[i];
                this.handleMouseEvent(this.mouseEvent);
            }
            this.mouseEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (n == 506 || n == 503) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
        }
        this.mouseEvent = mouseEvent;
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 0x10) != 0) {
            this.mouseButton = 37;
        } else if ((n2 & 8) != 0) {
            this.mouseButton = 3;
        } else if ((n2 & 4) != 0) {
            this.mouseButton = 39;
        }
        if (platform == 2 && this.mouseEvent.isPopupTrigger()) {
            this.mouseButton = 39;
        }
        this.mouseEventMethods.handle(new Object[]{mouseEvent});
        if (this.firstMouse) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.firstMouse = false;
        }
        switch (n) {
            case 501: {
                this.mousePressed = true;
                this.mousePressed();
                break;
            }
            case 502: {
                this.mousePressed = false;
                this.mouseReleased();
                break;
            }
            case 500: {
                this.mouseClicked();
                break;
            }
            case 506: {
                this.mouseDragged();
                break;
            }
            case 503: {
                this.mouseMoved();
            }
        }
        if (n == 506 || n == 503) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void checkMouseEvent(MouseEvent mouseEvent) {
        if (this.looping) {
            this.enqueueMouseEvent(mouseEvent);
        } else {
            this.handleMouseEvent(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.checkMouseEvent(mouseEvent);
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void mouseClicked() {
    }

    public void mouseDragged() {
    }

    public void mouseMoved() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueKeyEvent(KeyEvent keyEvent) {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            if (this.keyEventCount == this.keyEventQueue.length) {
                KeyEvent[] keyEventArray2 = new KeyEvent[this.keyEventCount << 1];
                System.arraycopy(this.keyEventQueue, 0, keyEventArray2, 0, this.keyEventCount);
                this.keyEventQueue = keyEventArray2;
            }
            this.keyEventQueue[this.keyEventCount++] = keyEvent;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueKeyEvents() {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            for (int i = 0; i < this.keyEventCount; ++i) {
                this.keyEvent = this.keyEventQueue[i];
                this.handleKeyEvent(this.keyEvent);
            }
            this.keyEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        this.keyEvent = keyEvent;
        this.key = keyEvent.getKeyChar();
        this.keyCode = keyEvent.getKeyCode();
        this.keyEventMethods.handle(new Object[]{keyEvent});
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed = true;
                this.keyPressed();
                break;
            }
            case 402: {
                this.keyPressed = false;
                this.keyReleased();
                break;
            }
            case 400: {
                this.keyTyped();
            }
        }
        if (keyEvent.getID() == 401) {
            if (this.key == '\u001b') {
                this.exit();
            }
            if (this.external && keyEvent.getModifiers() == MENU_SHORTCUT && keyEvent.getKeyCode() == 87) {
                this.exit();
            }
        }
    }

    protected void checkKeyEvent(KeyEvent keyEvent) {
        if (this.looping) {
            this.enqueueKeyEvent(keyEvent);
        } else {
            this.handleKeyEvent(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.checkKeyEvent(keyEvent);
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void focusGained() {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.focused = true;
        this.focusGained();
    }

    public void focusLost() {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.focused = false;
        this.focusLost();
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        return Calendar.getInstance().get(13);
    }

    public static int minute() {
        return Calendar.getInstance().get(12);
    }

    public static int hour() {
        return Calendar.getInstance().get(11);
    }

    public static int day() {
        return Calendar.getInstance().get(5);
    }

    public static int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int year() {
        return Calendar.getInstance().get(1);
    }

    public void delay(int n) {
        if (this.frameCount != 0 && n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void frameRate(float f) {
        this.frameRateTarget = f;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
    }

    public String param(String string) {
        if (this.online) {
            return this.getParameter(string);
        }
        System.err.println("param() only works inside a web browser");
        return null;
    }

    public void status(String string) {
        if (this.online) {
            this.showStatus(string);
        } else {
            System.out.println(string);
        }
    }

    public void link(String string) {
        this.link(string, null);
    }

    public void link(String string, String string2) {
        if (this.online) {
            try {
                if (string2 == null) {
                    this.getAppletContext().showDocument(new URL(string));
                }
                this.getAppletContext().showDocument(new URL(string), string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not open " + string);
            }
        } else {
            try {
                if (platform == 1) {
                    string = string.replaceAll("&", "^&");
                    Runtime.getRuntime().exec("cmd /c start " + string);
                } else if (platform == 2) {
                    try {
                        Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                        Method method = clazz.getMethod("openURL", String.class);
                        method.invoke(null, string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    PApplet.open(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("Could not open " + string);
            }
        }
    }

    public static void open(String string) {
        PApplet.open(new String[]{string});
    }

    public static Process open(String[] stringArray) {
        String[] stringArray2 = null;
        if (platform == 1) {
            stringArray2 = new String[]{"cmd", "/c"};
        } else if (platform == 2) {
            stringArray2 = new String[]{"open"};
        } else if (platform == 3) {
            Process process;
            if (openLauncher == null) {
                try {
                    process = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                    process.waitFor();
                    openLauncher = "gnome-open";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                try {
                    process = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    process.waitFor();
                    openLauncher = "kde-open";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                System.err.println("Could not find gnome-open or kde-open, the open() command may not work.");
            }
            if (openLauncher != null) {
                stringArray2 = new String[]{openLauncher};
            }
        }
        if (stringArray2 != null) {
            if (stringArray2[0].equals(stringArray[0])) {
                return PApplet.exec(stringArray);
            }
            stringArray2 = PApplet.concat(stringArray2, stringArray);
            return PApplet.exec(stringArray2);
        }
        return PApplet.exec(stringArray);
    }

    public static Process exec(String[] stringArray) {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(stringArray, ' '));
        }
    }

    public void die(String string) {
        this.stop();
        throw new RuntimeException(string);
    }

    public void die(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        this.die(string);
    }

    public void exit() {
        if (this.thread == null) {
            this.exit2();
        } else if (this.looping) {
            this.finished = true;
            this.exitCalled = true;
        } else if (!this.looping) {
            this.stop();
            this.exit2();
        }
    }

    void exit2() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void save(String string) {
        this.g.save(this.savePath(string));
    }

    public void saveFrame() {
        try {
            this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
        }
        catch (SecurityException securityException) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    public void saveFrame(String string) {
        try {
            this.g.save(this.savePath(this.insertFrame(string)));
        }
        catch (SecurityException securityException) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    protected String insertFrame(String string) {
        int n = string.indexOf(35);
        int n2 = string.lastIndexOf(35);
        if (n != -1 && n2 - n > 0) {
            String string2 = string.substring(0, n);
            int n3 = n2 - n + 1;
            String string3 = string.substring(n2 + 1);
            return string2 + PApplet.nf(this.frameCount, n3) + string3;
        }
        return string;
    }

    public void cursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
        this.cursorVisible = true;
        this.cursorType = n;
    }

    public void cursor(PImage pImage) {
        this.cursor(pImage, pImage.width / 2, pImage.height / 2);
    }

    public void cursor(PImage pImage, int n, int n2) {
        Image image = this.createImage(new MemoryImageSource(pImage.width, pImage.height, pImage.pixels, 0, pImage.width));
        Point point = new Point(n, n2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor cursor = toolkit.createCustomCursor(image, point, "Custom Cursor");
        this.setCursor(cursor);
        this.cursorVisible = true;
    }

    public void cursor() {
        if (!this.cursorVisible) {
            this.cursorVisible = true;
            this.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }
    }

    public void noCursor() {
        if (!this.cursorVisible) {
            return;
        }
        if (this.invisibleCursor == null) {
            this.invisibleCursor = new PImage(16, 16, 2);
        }
        this.cursor(this.invisibleCursor, 8, 8);
        this.cursorVisible = false;
    }

    public static void print(byte by) {
        System.out.print(by);
        System.out.flush();
    }

    public static void print(boolean bl) {
        System.out.print(bl);
        System.out.flush();
    }

    public static void print(char c) {
        System.out.print(c);
        System.out.flush();
    }

    public static void print(int n) {
        System.out.print(n);
        System.out.flush();
    }

    public static void print(float f) {
        System.out.print(f);
        System.out.flush();
    }

    public static void print(String string) {
        System.out.print(string);
        System.out.flush();
    }

    public static void print(Object object) {
        if (object == null) {
            System.out.print("null");
        } else {
            System.out.println(object.toString());
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte by) {
        PApplet.print(by);
        System.out.println();
    }

    public static void println(boolean bl) {
        PApplet.print(bl);
        System.out.println();
    }

    public static void println(char c) {
        PApplet.print(c);
        System.out.println();
    }

    public static void println(int n) {
        PApplet.print(n);
        System.out.println();
    }

    public static void println(float f) {
        PApplet.print(f);
        System.out.println();
    }

    public static void println(String string) {
        PApplet.print(string);
        System.out.println();
    }

    public static void println(Object object) {
        block17: {
            block18: {
                block16: {
                    if (object != null) break block16;
                    System.out.println("null");
                    break block17;
                }
                String string = object.getClass().getName();
                if (string.charAt(0) != '[') break block18;
                switch (string.charAt(1)) {
                    case '[': {
                        System.out.println(object);
                        break;
                    }
                    case 'L': {
                        Object[] objectArray = (Object[])object;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + objectArray[i] + "\"");
                                continue;
                            }
                            System.out.println("[" + i + "] " + objectArray[i]);
                        }
                        break block17;
                    }
                    case 'Z': {
                        boolean[] blArray = (boolean[])object;
                        for (int i = 0; i < blArray.length; ++i) {
                            System.out.println("[" + i + "] " + blArray[i]);
                        }
                        break block17;
                    }
                    case 'B': {
                        byte[] byArray = (byte[])object;
                        for (int i = 0; i < byArray.length; ++i) {
                            System.out.println("[" + i + "] " + byArray[i]);
                        }
                        break block17;
                    }
                    case 'C': {
                        char[] cArray = (char[])object;
                        for (int i = 0; i < cArray.length; ++i) {
                            System.out.println("[" + i + "] '" + cArray[i] + "'");
                        }
                        break block17;
                    }
                    case 'I': {
                        int[] nArray = (int[])object;
                        for (int i = 0; i < nArray.length; ++i) {
                            System.out.println("[" + i + "] " + nArray[i]);
                        }
                        break block17;
                    }
                    case 'F': {
                        float[] fArray = (float[])object;
                        for (int i = 0; i < fArray.length; ++i) {
                            System.out.println("[" + i + "] " + fArray[i]);
                        }
                        break block17;
                    }
                    default: {
                        System.out.println(object);
                    }
                }
                break block17;
            }
            System.out.println(object);
        }
    }

    public static final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float f) {
        return f * f;
    }

    public static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static final float log(float f) {
        return (float)Math.log(f);
    }

    public static final float exp(float f) {
        return (float)Math.exp(f);
    }

    public static final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : (n2 > n3 ? n2 : n3);
    }

    public static final float max(float f, float f2, float f3) {
        return f > f2 ? (f > f3 ? f : f3) : (f2 > f3 ? f2 : f3);
    }

    public static final int max(int[] nArray) {
        if (nArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static final float max(float[] fArray) {
        if (fArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : (n2 < n3 ? n2 : n3);
    }

    public static final float min(float f, float f2, float f3) {
        return f < f2 ? (f < f3 ? f : f3) : (f2 < f3 ? f2 : f3);
    }

    public static final int min(int[] nArray) {
        if (nArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static final float min(float[] fArray) {
        if (fArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static final float sin(float f) {
        return (float)Math.sin(f);
    }

    public static final float cos(float f) {
        return (float)Math.cos(f);
    }

    public static final float tan(float f) {
        return (float)Math.tan(f);
    }

    public static final float asin(float f) {
        return (float)Math.asin(f);
    }

    public static final float acos(float f) {
        return (float)Math.acos(f);
    }

    public static final float atan(float f) {
        return (float)Math.atan(f);
    }

    public static final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static final float degrees(float f) {
        return f * 57.295776f;
    }

    public static final float radians(float f) {
        return f * ((float)Math.PI / 180);
    }

    public static final int ceil(float f) {
        return (int)Math.ceil(f);
    }

    public static final int floor(float f) {
        return (int)Math.floor(f);
    }

    public static final int round(float f) {
        return Math.round(f);
    }

    public static final float mag(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static final float dist(float f, float f2, float f3, float f4) {
        return PApplet.sqrt(PApplet.sq(f3 - f) + PApplet.sq(f4 - f2));
    }

    public static final float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        return PApplet.sqrt(PApplet.sq(f4 - f) + PApplet.sq(f5 - f2) + PApplet.sq(f6 - f3));
    }

    public static final float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static final float norm(float f, float f2, float f3) {
        return (f - f2) / (f3 - f2);
    }

    public static final float map(float f, float f2, float f3, float f4, float f5) {
        return f4 + (f5 - f4) * ((f - f2) / (f3 - f2));
    }

    public final float random(float f) {
        if (f == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float f2 = 0.0f;
        while ((f2 = this.internalRandom.nextFloat() * f) == f) {
        }
        return f2;
    }

    public final float random(float f, float f2) {
        if (f >= f2) {
            return f;
        }
        float f3 = f2 - f;
        return this.random(f3) + f;
    }

    public final void randomSeed(long l) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(l);
    }

    public float noise(float f) {
        return this.noise(f, 0.0f, 0.0f);
    }

    public float noise(float f, float f2) {
        return this.noise(f, f2, 0.0f);
    }

    public float noise(float f, float f2, float f3) {
        int n;
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            for (n = 0; n < 4096; ++n) {
                this.perlin[n] = this.perlinRandom.nextFloat();
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = 0.0f;
        float f8 = 0.5f;
        for (int i = 0; i < this.perlin_octaves; ++i) {
            int n4 = n + (n2 << 4) + (n3 << 8);
            float f9 = this.noise_fsc(f4);
            float f10 = this.noise_fsc(f5);
            float f11 = this.perlin[n4 & 0xFFF];
            f11 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f11);
            float f12 = this.perlin[n4 + 16 & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f12);
            f11 += f10 * (f12 - f11);
            f12 = this.perlin[(n4 += 256) & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f12);
            float f13 = this.perlin[n4 + 16 & 0xFFF];
            f13 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f13);
            f12 += f10 * (f13 - f12);
            f11 += this.noise_fsc(f6) * (f12 - f11);
            f7 += f11 * f8;
            f8 *= this.perlin_amp_falloff;
            n <<= 1;
            f4 *= 2.0f;
            n2 <<= 1;
            f5 *= 2.0f;
            n3 <<= 1;
            f6 *= 2.0f;
            if (f4 >= 1.0f) {
                ++n;
                f4 -= 1.0f;
            }
            if (f5 >= 1.0f) {
                ++n2;
                f5 -= 1.0f;
            }
            if (!(f6 >= 1.0f)) continue;
            ++n3;
            f6 -= 1.0f;
        }
        return f7;
    }

    private float noise_fsc(float f) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(f * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int n) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
    }

    public void noiseDetail(int n, float f) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
        if (f > 0.0f) {
            this.perlin_amp_falloff = f;
        }
    }

    public void noiseSeed(long l) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(l);
        this.perlin = null;
    }

    public PImage loadImage(String string) {
        return this.loadImage(string, null);
    }

    public PImage loadImage(String string, String string2) {
        Object object;
        if (string2 == null) {
            int n;
            object = string.toLowerCase();
            int n2 = string.lastIndexOf(46);
            if (n2 == -1) {
                string2 = "unknown";
            }
            if ((n = (string2 = ((String)object).substring(n2 + 1)).indexOf(63)) != -1) {
                string2 = string2.substring(0, n);
            }
        }
        if ((string2 = string2.toLowerCase()).equals("tga")) {
            try {
                return this.loadImageTGA(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        if (string2.equals("tif") || string2.equals("tiff")) {
            object = this.loadBytes(string);
            return object == null ? null : PImage.loadTIFF((byte[])object);
        }
        try {
            if (string2.equals("jpg") || string2.equals("jpeg") || string2.equals("gif") || string2.equals("png") || string2.equals("unknown")) {
                object = this.loadBytes(string);
                if (object == null) {
                    return null;
                }
                Image image = Toolkit.getDefaultToolkit().createImage((byte[])object);
                PImage pImage = this.loadImageMT(image);
                if (pImage.width == -1) {
                    System.err.println("The file " + string + " contains bad image data, or may not be an image.");
                }
                if (string2.equals("gif") || string2.equals("png")) {
                    pImage.checkAlpha();
                }
                return pImage;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.loadImageFormats == null) {
            this.loadImageFormats = ImageIO.getReaderFormatNames();
        }
        if (this.loadImageFormats != null) {
            for (int i = 0; i < this.loadImageFormats.length; ++i) {
                if (!string2.equals(this.loadImageFormats[i])) continue;
                return this.loadImageIO(string);
            }
        }
        System.err.println("Could not find a method to load " + string);
        return null;
    }

    public PImage requestImage(String string) {
        return this.requestImage(string, null);
    }

    public PImage requestImage(String string, String string2) {
        PImage pImage = this.createImage(0, 0, 2);
        AsyncImageLoader asyncImageLoader = new AsyncImageLoader(string, string2, pImage);
        asyncImageLoader.start();
        return pImage;
    }

    protected PImage loadImageMT(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        PImage pImage = new PImage(image);
        pImage.parent = this;
        return pImage;
    }

    protected PImage loadImageIO(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream == null) {
            System.err.println("The image " + string + " could not be found.");
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            PImage pImage = new PImage(bufferedImage.getWidth(), bufferedImage.getHeight());
            pImage.parent = this;
            bufferedImage.getRGB(0, 0, pImage.width, pImage.height, pImage.pixels, 0, pImage.width);
            pImage.checkAlpha();
            return pImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected PImage loadImageTGA(String string) throws IOException {
        PImage pImage;
        block47: {
            int n;
            int n2;
            boolean bl;
            int n3;
            int n4;
            int n5;
            InputStream inputStream;
            block45: {
                block46: {
                    inputStream = this.createInput(string);
                    if (inputStream == null) {
                        return null;
                    }
                    byte[] byArray = new byte[18];
                    int n6 = 0;
                    do {
                        if ((n5 = inputStream.read(byArray, n6, byArray.length - n6)) != -1) continue;
                        return null;
                    } while ((n6 += n5) < 18);
                    n5 = 0;
                    if (!(byArray[2] != 3 && byArray[2] != 11 || byArray[16] != 8 || byArray[17] != 8 && byArray[17] != 40)) {
                        n5 = 4;
                    } else if (!(byArray[2] != 2 && byArray[2] != 10 || byArray[16] != 24 || byArray[17] != 32 && byArray[17] != 0)) {
                        n5 = 1;
                    } else if (!(byArray[2] != 2 && byArray[2] != 10 || byArray[16] != 32 || byArray[17] != 8 && byArray[17] != 40)) {
                        n5 = 2;
                    }
                    if (n5 == 0) {
                        System.err.println("Unknown .tga file format for " + string);
                        return null;
                    }
                    n4 = ((byArray[13] & 0xFF) << 8) + (byArray[12] & 0xFF);
                    n3 = ((byArray[15] & 0xFF) << 8) + (byArray[14] & 0xFF);
                    pImage = this.createImage(n4, n3, n5);
                    boolean bl2 = bl = (byArray[17] & 0x20) != 0;
                    if (byArray[2] != 2 && byArray[2] != 3) break block45;
                    if (!bl) break block46;
                    int n7 = (n3 - 1) * n4;
                    switch (n5) {
                        case 4: {
                            for (int i = n3 - 1; i >= 0; --i) {
                                for (int j = 0; j < n4; ++j) {
                                    pImage.pixels[n7 + j] = inputStream.read();
                                }
                                n7 -= n4;
                            }
                            break block47;
                        }
                        case 1: {
                            for (int i = n3 - 1; i >= 0; --i) {
                                for (int j = 0; j < n4; ++j) {
                                    pImage.pixels[n7 + j] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | 0xFF000000;
                                }
                                n7 -= n4;
                            }
                            break block47;
                        }
                        case 2: {
                            for (int i = n3 - 1; i >= 0; --i) {
                                for (int j = 0; j < n4; ++j) {
                                    pImage.pixels[n7 + j] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                                }
                                n7 -= n4;
                            }
                            break;
                        }
                    }
                    break block47;
                }
                int n8 = n4 * n3;
                switch (n5) {
                    case 4: {
                        for (int i = 0; i < n8; ++i) {
                            pImage.pixels[i] = inputStream.read();
                        }
                        break block47;
                    }
                    case 1: {
                        for (int i = 0; i < n8; ++i) {
                            pImage.pixels[i] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | 0xFF000000;
                        }
                        break block47;
                    }
                    case 2: {
                        for (int i = 0; i < n8; ++i) {
                            pImage.pixels[i] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                        }
                        break;
                    }
                }
                break block47;
            }
            int n9 = 0;
            int[] nArray = pImage.pixels;
            block30: while (n9 < nArray.length) {
                int n10 = inputStream.read();
                int n11 = n2 = (n10 & 0x80) != 0 ? 1 : 0;
                if (n2 != 0) {
                    n10 -= 127;
                    n = 0;
                    switch (n5) {
                        case 4: {
                            n = inputStream.read();
                            break;
                        }
                        case 1: {
                            n = 0xFF000000 | inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16;
                            break;
                        }
                        case 2: {
                            n = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                        }
                    }
                    for (int i = 0; i < n10; ++i) {
                        nArray[n9++] = n;
                        if (n9 == nArray.length) continue block30;
                    }
                    continue;
                }
                ++n10;
                switch (n5) {
                    case 4: {
                        for (n = 0; n < n10; ++n) {
                            nArray[n9++] = inputStream.read();
                        }
                        continue block30;
                    }
                    case 1: {
                        for (n = 0; n < n10; ++n) {
                            nArray[n9++] = 0xFF000000 | inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16;
                        }
                        continue block30;
                    }
                    case 2: {
                        for (n = 0; n < n10; ++n) {
                            nArray[n9++] = inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                        }
                        break;
                    }
                }
            }
            if (!bl) {
                int[] nArray2 = new int[n4];
                for (n2 = 0; n2 < n3 / 2; ++n2) {
                    n = n3 - 1 - n2;
                    System.arraycopy(nArray, n2 * n4, nArray2, 0, n4);
                    System.arraycopy(nArray, n * n4, nArray, n2 * n4, n4);
                    System.arraycopy(nArray2, 0, nArray, n * n4, n4);
                }
            }
        }
        return pImage;
    }

    public PShape loadShape(String string) {
        if (string.toLowerCase().endsWith(".svg")) {
            return new PShapeSVG(this, string);
        }
        return null;
    }

    public PFont loadFont(String string) {
        try {
            InputStream inputStream = this.createInput(string);
            return new PFont(inputStream);
        }
        catch (Exception exception) {
            this.die("Could not load font " + string + ". " + "Make sure that the font has been copied " + "to the data folder of your sketch.", exception);
            return null;
        }
    }

    public PFont createFont(String string, float f) {
        return this.createFont(string, f, true, PFont.DEFAULT_CHARSET);
    }

    public PFont createFont(String string, float f, boolean bl) {
        return this.createFont(string, f, bl, PFont.DEFAULT_CHARSET);
    }

    public PFont createFont(String string, float f, boolean bl, char[] cArray) {
        String string2 = string.toLowerCase();
        Font font = null;
        try {
            if (string2.endsWith(".otf") || string2.endsWith(".ttf")) {
                InputStream inputStream = this.createInput(string);
                if (inputStream == null) {
                    System.err.println("The font \"" + string + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
                    return null;
                }
                font = Font.createFont(0, this.createInput(string));
            } else {
                font = PFont.findFont(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Problem using createFont() with " + string);
            exception.printStackTrace();
        }
        return new PFont(font.deriveFont(f), bl, cArray);
    }

    protected void checkParentFrame() {
        if (this.parentFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Frame)) continue;
                this.parentFrame = (Frame)container;
                break;
            }
            if (this.parentFrame == null) {
                this.parentFrame = new Frame();
            }
        }
    }

    public String selectInput() {
        return this.selectInput("Select a file...");
    }

    public String selectInput(String string) {
        return this.selectFileImpl(string, 0);
    }

    public String selectOutput() {
        return this.selectOutput("Save as...");
    }

    public String selectOutput(String string) {
        return this.selectFileImpl(string, 1);
    }

    protected String selectFileImpl(final String string, final int n) {
        this.checkParentFrame();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    FileDialog fileDialog = new FileDialog(PApplet.this.parentFrame, string, n);
                    fileDialog.setVisible(true);
                    String string3 = fileDialog.getDirectory();
                    String string2 = fileDialog.getFile();
                    PApplet.this.selectedFile = string2 == null ? null : new File(string3, string2);
                }
            });
            return this.selectedFile == null ? null : this.selectedFile.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String selectFolder() {
        return this.selectFolder("Select a folder...");
    }

    public String selectFolder(final String string) {
        this.checkParentFrame();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (platform == 2) {
                        FileDialog fileDialog = new FileDialog(PApplet.this.parentFrame, string, 0);
                        System.setProperty("apple.awt.fileDialogForDirectories", "true");
                        fileDialog.setVisible(true);
                        System.setProperty("apple.awt.fileDialogForDirectories", "false");
                        String string2 = fileDialog.getFile();
                        PApplet.this.selectedFile = string2 == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile());
                    } else {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setDialogTitle(string);
                        jFileChooser.setFileSelectionMode(1);
                        int n = jFileChooser.showOpenDialog(PApplet.this.parentFrame);
                        System.out.println(n);
                        PApplet.this.selectedFile = n == 1 ? null : jFileChooser.getSelectedFile();
                    }
                }
            });
            return this.selectedFile == null ? null : this.selectedFile.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BufferedReader createReader(String string) {
        try {
            InputStream inputStream = this.createInput(string);
            if (inputStream == null) {
                System.err.println(string + " does not exist or could not be read");
                return null;
            }
            return PApplet.createReader(inputStream);
        }
        catch (Exception exception) {
            if (string == null) {
                System.err.println("Filename passed to reader() was null");
            } else {
                System.err.println("Couldn't create a reader for " + string);
            }
            return null;
        }
    }

    public static BufferedReader createReader(File file) {
        try {
            InputStream inputStream = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            return PApplet.createReader(inputStream);
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to createReader() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new BufferedReader(inputStreamReader);
    }

    public PrintWriter createWriter(String string) {
        return PApplet.createWriter(this.saveFile(string));
    }

    public static PrintWriter createWriter(File file) {
        try {
            PApplet.createPath(file);
            OutputStream outputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            return PApplet.createWriter(outputStream);
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            return new PrintWriter(outputStreamWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream openStream(String string) {
        return this.createInput(string);
    }

    public InputStream createInput(String string) {
        InputStream inputStream = this.createInputRaw(string);
        if (inputStream != null && string.toLowerCase().endsWith(".gz")) {
            try {
                return new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return inputStream;
    }

    public InputStream createInputRaw(String string) {
        String string2;
        Object object;
        InputStream inputStream = null;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            return inputStream;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            object = new File(this.dataPath(string));
            if (!((File)object).exists()) {
                object = new File(this.sketchPath, string);
            }
            if (((File)object).isDirectory()) {
                return null;
            }
            if (((File)object).exists()) {
                try {
                    string2 = ((File)object).getCanonicalPath();
                    String string3 = new File(string2).getName();
                    String string4 = new File(string).getName();
                    if (!string3.equals(string4)) {
                        throw new RuntimeException("This file is named " + string3 + " not " + string + ". Rename the file " + "or change your code.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((inputStream = new FileInputStream((File)object)) != null) {
                return inputStream;
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = this.getClass().getClassLoader();
        inputStream = ((ClassLoader)object).getResourceAsStream("data/" + string);
        if (inputStream != null && !(string2 = inputStream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return inputStream;
        }
        inputStream = ((ClassLoader)object).getResourceAsStream(string);
        if (inputStream != null && !(string2 = inputStream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return inputStream;
        }
        try {
            try {
                try {
                    inputStream = new FileInputStream(this.dataPath(string));
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    inputStream = new FileInputStream(this.sketchPath(string));
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    inputStream = new FileInputStream(string);
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static InputStream createInput(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(fileInputStream);
            }
            return fileInputStream;
        }
        catch (IOException iOException) {
            if (file == null) {
                throw new RuntimeException("File passed to openStream() was null");
            }
            iOException.printStackTrace();
            throw new RuntimeException("Couldn't openStream() for " + file.getAbsolutePath());
        }
    }

    public byte[] loadBytes(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream != null) {
            return PApplet.loadBytes(inputStream);
        }
        System.err.println("The file \"" + string + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = bufferedInputStream.read();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static byte[] loadBytes(File file) {
        InputStream inputStream = PApplet.createInput(file);
        return PApplet.loadBytes(inputStream);
    }

    public static String[] loadStrings(File file) {
        InputStream inputStream = PApplet.createInput(file);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        return null;
    }

    public String[] loadStrings(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        System.err.println("The file \"" + string + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream inputStream) {
        try {
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String[] stringArray2 = new String[100];
            int n = 0;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (n == stringArray2.length) {
                    stringArray = new String[n << 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    stringArray2 = stringArray;
                }
                stringArray2[n++] = string;
            }
            bufferedReader.close();
            if (n == stringArray2.length) {
                return stringArray2;
            }
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public OutputStream createOutput(String string) {
        return PApplet.createOutput(this.saveFile(string));
    }

    public static OutputStream createOutput(File file) {
        try {
            PApplet.createPath(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fileOutputStream);
            }
            return fileOutputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void saveStream(String string, String string2) {
        this.saveStream(this.saveFile(string), string2);
    }

    public void saveStream(File file, String string) {
        PApplet.saveStream(file, this.createInputRaw(string));
    }

    public static void saveStream(File file, InputStream inputStream) {
        File file2 = null;
        try {
            int n;
            File file3 = file.getParentFile();
            file2 = File.createTempFile(file.getName(), null, file3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedOutputStream = null;
            if (!file2.renameTo(file)) {
                System.err.println("Could not rename temporary file " + file2.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            if (file2 != null) {
                file2.delete();
            }
            iOException.printStackTrace();
        }
    }

    public void saveBytes(String string, byte[] byArray) {
        PApplet.saveBytes(this.saveFile(string), byArray);
    }

    public static void saveBytes(File file, byte[] byArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            OutputStream outputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            PApplet.saveBytes(outputStream, byArray);
            ((OutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error saving bytes to " + file);
            iOException.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveStrings(String string, String[] stringArray) {
        PApplet.saveStrings(this.saveFile(string), stringArray);
    }

    public static void saveStrings(File file, String[] stringArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            OutputStream outputStream = new FileOutputStream(string);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            PApplet.saveStrings(outputStream, stringArray);
            ((OutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream outputStream, String[] stringArray) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String sketchPath(String string) {
        if (this.sketchPath == null) {
            return string;
        }
        try {
            if (new File(string).isAbsolute()) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sketchPath + File.separator + string;
    }

    public File sketchFile(String string) {
        return new File(this.sketchPath(string));
    }

    public String savePath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.sketchPath(string);
        PApplet.createPath(string2);
        return string2;
    }

    public File saveFile(String string) {
        return new File(this.savePath(string));
    }

    public String dataPath(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        return this.sketchPath + File.separator + "data" + File.separator + string;
    }

    public File dataFile(String string) {
        return new File(this.dataPath(string));
    }

    public static void createPath(String string) {
        PApplet.createPath(new File(string));
    }

    public static void createPath(File file) {
        try {
            File file2;
            String string = file.getParent();
            if (string != null && !(file2 = new File(string)).exists()) {
                file2.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }

    public static byte[] sort(byte[] byArray) {
        return PApplet.sort(byArray, byArray.length);
    }

    public static byte[] sort(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.sort(byArray2, 0, n);
        return byArray2;
    }

    public static char[] sort(char[] cArray) {
        return PApplet.sort(cArray, cArray.length);
    }

    public static char[] sort(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Arrays.sort(cArray2, 0, n);
        return cArray2;
    }

    public static int[] sort(int[] nArray) {
        return PApplet.sort(nArray, nArray.length);
    }

    public static int[] sort(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2, 0, n);
        return nArray2;
    }

    public static float[] sort(float[] fArray) {
        return PApplet.sort(fArray, fArray.length);
    }

    public static float[] sort(float[] fArray, int n) {
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        Arrays.sort(fArray2, 0, n);
        return fArray2;
    }

    public static String[] sort(String[] stringArray) {
        return PApplet.sort(stringArray, stringArray.length);
    }

    public static String[] sort(String[] stringArray, int n) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray, 0, n);
        return objectArray;
    }

    public static void arrayCopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public static void arrayCopy(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static void arrayCopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    public static void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public static void arraycopy(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static void arraycopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    public static boolean[] expand(boolean[] blArray) {
        return PApplet.expand(blArray, blArray.length << 1);
    }

    public static boolean[] expand(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(n, blArray.length));
        return blArray2;
    }

    public static byte[] expand(byte[] byArray) {
        return PApplet.expand(byArray, byArray.length << 1);
    }

    public static byte[] expand(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        return byArray2;
    }

    public static char[] expand(char[] cArray) {
        return PApplet.expand(cArray, cArray.length << 1);
    }

    public static char[] expand(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(n, cArray.length));
        return cArray2;
    }

    public static int[] expand(int[] nArray) {
        return PApplet.expand(nArray, nArray.length << 1);
    }

    public static int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(n, nArray.length));
        return nArray2;
    }

    public static float[] expand(float[] fArray) {
        return PApplet.expand(fArray, fArray.length << 1);
    }

    public static float[] expand(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(n, fArray.length));
        return fArray2;
    }

    public static String[] expand(String[] stringArray) {
        return PApplet.expand(stringArray, stringArray.length << 1);
    }

    public static String[] expand(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(n, stringArray.length));
        return stringArray2;
    }

    public static Object expand(Object object) {
        return PApplet.expand(object, Array.getLength(object) << 1);
    }

    public static Object expand(Object object, int n) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        System.arraycopy(object, 0, object2, 0, Math.min(Array.getLength(object), n));
        return object2;
    }

    public static byte[] append(byte[] byArray, byte by) {
        byArray = PApplet.expand(byArray, byArray.length + 1);
        byArray[byArray.length - 1] = by;
        return byArray;
    }

    public static char[] append(char[] cArray, char c) {
        cArray = PApplet.expand(cArray, cArray.length + 1);
        cArray[cArray.length - 1] = c;
        return cArray;
    }

    public static int[] append(int[] nArray, int n) {
        nArray = PApplet.expand(nArray, nArray.length + 1);
        nArray[nArray.length - 1] = n;
        return nArray;
    }

    public static float[] append(float[] fArray, float f) {
        fArray = PApplet.expand(fArray, fArray.length + 1);
        fArray[fArray.length - 1] = f;
        return fArray;
    }

    public static String[] append(String[] stringArray, String string) {
        stringArray = PApplet.expand(stringArray, stringArray.length + 1);
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    public static Object append(Object object, Object object2) {
        int n = Array.getLength(object);
        object = PApplet.expand(object, n + 1);
        Array.set(object, n, object2);
        return object;
    }

    public static boolean[] shorten(boolean[] blArray) {
        return PApplet.subset(blArray, 0, blArray.length - 1);
    }

    public static byte[] shorten(byte[] byArray) {
        return PApplet.subset(byArray, 0, byArray.length - 1);
    }

    public static char[] shorten(char[] cArray) {
        return PApplet.subset(cArray, 0, cArray.length - 1);
    }

    public static int[] shorten(int[] nArray) {
        return PApplet.subset(nArray, 0, nArray.length - 1);
    }

    public static float[] shorten(float[] fArray) {
        return PApplet.subset(fArray, 0, fArray.length - 1);
    }

    public static String[] shorten(String[] stringArray) {
        return PApplet.subset(stringArray, 0, stringArray.length - 1);
    }

    public static Object shorten(Object object) {
        int n = Array.getLength(object);
        return PApplet.subset(object, 0, n - 1);
    }

    public static final boolean[] splice(boolean[] blArray, boolean bl, int n) {
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        blArray2[n] = bl;
        System.arraycopy(blArray, n, blArray2, n + 1, blArray.length - n);
        return blArray2;
    }

    public static final boolean[] splice(boolean[] blArray, boolean[] blArray2, int n) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, n);
        System.arraycopy(blArray2, 0, blArray3, n, blArray2.length);
        System.arraycopy(blArray, n, blArray3, n + blArray2.length, blArray.length - n);
        return blArray3;
    }

    public static final byte[] splice(byte[] byArray, byte by, int n) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        System.arraycopy(byArray, n, byArray2, n + 1, byArray.length - n);
        return byArray2;
    }

    public static final byte[] splice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n, byArray3, n + byArray2.length, byArray.length - n);
        return byArray3;
    }

    public static final char[] splice(char[] cArray, char c, int n) {
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        cArray2[n] = c;
        System.arraycopy(cArray, n, cArray2, n + 1, cArray.length - n);
        return cArray2;
    }

    public static final char[] splice(char[] cArray, char[] cArray2, int n) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
        System.arraycopy(cArray, n, cArray3, n + cArray2.length, cArray.length - n);
        return cArray3;
    }

    public static final int[] splice(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        System.arraycopy(nArray, n2, nArray2, n2 + 1, nArray.length - n2);
        return nArray2;
    }

    public static final int[] splice(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        System.arraycopy(nArray, n, nArray3, n + nArray2.length, nArray.length - n);
        return nArray3;
    }

    public static final float[] splice(float[] fArray, float f, int n) {
        float[] fArray2 = new float[fArray.length + 1];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        fArray2[n] = f;
        System.arraycopy(fArray, n, fArray2, n + 1, fArray.length - n);
        return fArray2;
    }

    public static final float[] splice(float[] fArray, float[] fArray2, int n) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, n);
        System.arraycopy(fArray2, 0, fArray3, n, fArray2.length);
        System.arraycopy(fArray, n, fArray3, n + fArray2.length, fArray.length - n);
        return fArray3;
    }

    public static final String[] splice(String[] stringArray, String string, int n) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        System.arraycopy(stringArray, n, stringArray2, n + 1, stringArray.length - n);
        return stringArray2;
    }

    public static final String[] splice(String[] stringArray, String[] stringArray2, int n) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, stringArray2.length);
        System.arraycopy(stringArray, n, stringArray3, n + stringArray2.length, stringArray.length - n);
        return stringArray3;
    }

    public static final Object splice(Object object, Object object2, int n) {
        Object[] objectArray = null;
        int n2 = Array.getLength(object);
        if (object2.getClass().getName().charAt(0) == '[') {
            int n3 = Array.getLength(object2);
            objectArray = new Object[n2 + n3];
            System.arraycopy(object, 0, objectArray, 0, n);
            System.arraycopy(object2, 0, objectArray, n, n3);
            System.arraycopy(object, n, objectArray, n + n3, n2 - n);
        } else {
            objectArray = new Object[n2 + 1];
            System.arraycopy(object, 0, objectArray, 0, n);
            Array.set(objectArray, n, object2);
            System.arraycopy(object, n, objectArray, n + 1, n2 - n);
        }
        return objectArray;
    }

    public static boolean[] subset(boolean[] blArray, int n) {
        return PApplet.subset(blArray, n, blArray.length - n);
    }

    public static boolean[] subset(boolean[] blArray, int n, int n2) {
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(blArray, n, blArray2, 0, n2);
        return blArray2;
    }

    public static byte[] subset(byte[] byArray, int n) {
        return PApplet.subset(byArray, n, byArray.length - n);
    }

    public static byte[] subset(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] subset(char[] cArray, int n) {
        return PApplet.subset(cArray, n, cArray.length - n);
    }

    public static char[] subset(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static int[] subset(int[] nArray, int n) {
        return PApplet.subset(nArray, n, nArray.length - n);
    }

    public static int[] subset(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static float[] subset(float[] fArray, int n) {
        return PApplet.subset(fArray, n, fArray.length - n);
    }

    public static float[] subset(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, n, fArray2, 0, n2);
        return fArray2;
    }

    public static String[] subset(String[] stringArray, int n) {
        return PApplet.subset(stringArray, n, stringArray.length - n);
    }

    public static String[] subset(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public static Object subset(Object object, int n) {
        int n2 = Array.getLength(object);
        return PApplet.subset(object, n, n2 - n);
    }

    public static Object subset(Object object, int n, int n2) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n2);
        System.arraycopy(object, n, object2, 0, n2);
        return object2;
    }

    public static boolean[] concat(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static char[] concat(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static float[] concat(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    public static String[] concat(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static Object concat(Object object, Object object2) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        int n2 = Array.getLength(object2);
        Object object3 = Array.newInstance(clazz, n + n2);
        System.arraycopy(object, 0, object3, 0, n);
        System.arraycopy(object2, 0, object3, n, n2);
        return object3;
    }

    public static boolean[] reverse(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        int n = blArray.length - 1;
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = blArray[n - i];
        }
        return blArray2;
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = byArray.length - 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[n - i];
        }
        return byArray2;
    }

    public static char[] reverse(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[n - i];
        }
        return cArray2;
    }

    public static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[n - i];
        }
        return nArray2;
    }

    public static float[] reverse(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        int n = fArray.length - 1;
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[n - i];
        }
        return fArray2;
    }

    public static String[] reverse(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = stringArray.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[n - i];
        }
        return stringArray2;
    }

    public static Object reverse(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, Array.get(object, n - 1 - i));
        }
        return object2;
    }

    public static String trim(String string) {
        return string.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].replace('\u00a0', ' ').trim();
        }
        return stringArray2;
    }

    public static String join(String[] stringArray, char c) {
        return PApplet.join(stringArray, String.valueOf(c));
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String[] splitTokens(String string) {
        return PApplet.splitTokens(string, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        if (n == 0) {
            String[] stringArray = new String[]{new String(string)};
            return stringArray;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            stringArray[n2++] = new String(cArray, n3, i - n3);
            n3 = i + 1;
        }
        stringArray[n2] = new String(cArray, n3, cArray.length - n3);
        return stringArray;
    }

    public static String[] split(String string, String string2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n + string2.length();
        }
        arrayList.add(string.substring(n2));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] match(String string, String string2) {
        Pattern pattern = Pattern.compile(string2, 40);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            int n = matcher.groupCount() + 1;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = matcher.group(i);
            }
            return stringArray;
        }
        return null;
    }

    public static String[][] matchAll(String string, String string2) {
        int n;
        String[] stringArray;
        Pattern pattern = Pattern.compile(string2, 40);
        Matcher matcher = pattern.matcher(string);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = matcher.groupCount() + 1;
        while (matcher.find()) {
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = matcher.group(n);
            }
            arrayList.add(stringArray);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        stringArray = new String[arrayList.size()][n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String[])arrayList.get(n);
        }
        return stringArray;
    }

    public static final boolean parseBoolean(int n) {
        return n != 0;
    }

    public static final boolean parseBoolean(String string) {
        return new Boolean(string);
    }

    public static final boolean[] parseBoolean(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            blArray[i] = byArray[i] != 0;
        }
        return blArray;
    }

    public static final boolean[] parseBoolean(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = nArray[i] != 0;
        }
        return blArray;
    }

    public static final boolean[] parseBoolean(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = new Boolean(stringArray[i]);
        }
        return blArray;
    }

    public static final byte parseByte(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    public static final byte parseByte(char c) {
        return (byte)c;
    }

    public static final byte parseByte(int n) {
        return (byte)n;
    }

    public static final byte parseByte(float f) {
        return (byte)f;
    }

    public static final byte[] parseByte(boolean[] blArray) {
        byte[] byArray = new byte[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            byArray[i] = blArray[i] ? (byte)1 : 0;
        }
        return byArray;
    }

    public static final byte[] parseByte(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static final byte[] parseByte(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    public static final byte[] parseByte(float[] fArray) {
        byte[] byArray = new byte[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            byArray[i] = (byte)fArray[i];
        }
        return byArray;
    }

    public static final char parseChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static final char parseChar(int n) {
        return (char)n;
    }

    public static final char[] parseChar(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    public static final char[] parseChar(int[] nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    public static final int parseInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static final int parseInt(byte by) {
        return by & 0xFF;
    }

    public static final int parseInt(char c) {
        return c;
    }

    public static final int parseInt(float f) {
        return (int)f;
    }

    public static final int parseInt(String string) {
        return PApplet.parseInt(string, 0);
    }

    public static final int parseInt(String string, int n) {
        try {
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                return Integer.parseInt(string);
            }
            return Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final int[] parseInt(boolean[] blArray) {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        return nArray;
    }

    public static final int[] parseInt(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static final int[] parseInt(char[] cArray) {
        int[] nArray = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            nArray[i] = cArray[i];
        }
        return nArray;
    }

    public static int[] parseInt(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)fArray[i];
        }
        return nArray;
    }

    public static int[] parseInt(String[] stringArray) {
        return PApplet.parseInt(stringArray, 0);
    }

    public static int[] parseInt(String[] stringArray, int n) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = n;
            }
        }
        return nArray;
    }

    public static final float parseFloat(int n) {
        return n;
    }

    public static final float parseFloat(String string) {
        return PApplet.parseFloat(string, Float.NaN);
    }

    public static final float parseFloat(String string, float f) {
        try {
            return new Float(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static final float[] parseByte(byte[] byArray) {
        float[] fArray = new float[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            fArray[i] = byArray[i];
        }
        return fArray;
    }

    public static final float[] parseFloat(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }

    public static final float[] parseFloat(String[] stringArray) {
        return PApplet.parseFloat(stringArray, Float.NaN);
    }

    public static final float[] parseFloat(String[] stringArray, float f) {
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fArray[i] = new Float(stringArray[i]).floatValue();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                fArray[i] = f;
            }
        }
        return fArray;
    }

    public static final String str(boolean bl) {
        return String.valueOf(bl);
    }

    public static final String str(byte by) {
        return String.valueOf(by);
    }

    public static final String str(char c) {
        return String.valueOf(c);
    }

    public static final String str(int n) {
        return String.valueOf(n);
    }

    public static final String str(float f) {
        return String.valueOf(f);
    }

    public static final String[] str(boolean[] blArray) {
        String[] stringArray = new String[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            stringArray[i] = String.valueOf(blArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(byte[] byArray) {
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = String.valueOf(byArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(char[] cArray) {
        String[] stringArray = new String[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            stringArray[i] = String.valueOf(cArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = String.valueOf(nArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(float[] fArray) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(fArray[i]);
        }
        return stringArray;
    }

    public static String[] nf(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nf(nArray[i], n);
        }
        return stringArray;
    }

    public static String nf(int n, int n2) {
        if (int_nf != null && int_nf_digits == n2 && !int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(n2);
        int_nf_digits = n2;
        return int_nf.format(n);
    }

    public static String[] nfc(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfc(nArray[i]);
        }
        return stringArray;
    }

    public static String nfc(int n) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(n);
    }

    public static String nfs(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : ' ' + PApplet.nf(n, n2);
    }

    public static String[] nfs(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfs(nArray[i], n);
        }
        return stringArray;
    }

    public static String nfp(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : '+' + PApplet.nf(n, n2);
    }

    public static String[] nfp(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfp(nArray[i], n);
        }
        return stringArray;
    }

    public static String[] nf(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nf(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nf(float f, int n, int n2) {
        if (float_nf != null && float_nf_left == n && float_nf_right == n2 && !float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (n != 0) {
            float_nf.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            float_nf.setMinimumFractionDigits(n2);
            float_nf.setMaximumFractionDigits(n2);
        }
        float_nf_left = n;
        float_nf_right = n2;
        return float_nf.format(f);
    }

    public static String[] nfc(float[] fArray, int n) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfc(fArray[i], n);
        }
        return stringArray;
    }

    public static String nfc(float f, int n) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == n && float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (n != 0) {
            float_nf.setMinimumFractionDigits(n);
            float_nf.setMaximumFractionDigits(n);
        }
        float_nf_left = 0;
        float_nf_right = n;
        return float_nf.format(f);
    }

    public static String[] nfs(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfs(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nfs(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : ' ' + PApplet.nf(f, n, n2);
    }

    public static String[] nfp(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfp(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nfp(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : '+' + PApplet.nf(f, n, n2);
    }

    public static final String hex(byte by) {
        return PApplet.hex(by, 2);
    }

    public static final String hex(char c) {
        return PApplet.hex(c, 4);
    }

    public static final String hex(int n) {
        return PApplet.hex(n, 8);
    }

    public static final String hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        int n3 = string.length();
        if (n3 > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            return "00000000".substring(8 - (n2 - n3)) + string;
        }
        return string;
    }

    public static final int unhex(String string) {
        return (int)Long.parseLong(string, 16);
    }

    public static final String binary(byte by) {
        return PApplet.binary(by, 8);
    }

    public static final String binary(char c) {
        return PApplet.binary(c, 16);
    }

    public static final String binary(int n) {
        return Integer.toBinaryString(n);
    }

    public static final String binary(int n, int n2) {
        String string = Integer.toBinaryString(n);
        int n3 = string.length();
        if (n3 > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            int n4 = 32 - (n2 - n3);
            return "00000000000000000000000000000000".substring(n4) + string;
        }
        return string;
    }

    public static final int unbinary(String string) {
        return Integer.parseInt(string, 2);
    }

    public final int color(int n) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(n);
    }

    public final int color(float f) {
        if (this.g == null) {
            int n = (int)f;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f);
    }

    public final int color(int n, int n2) {
        if (this.g == null) {
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n > 255) {
                return n2 << 24 | n & 0xFFFFFF;
            }
            return n2 << 24 | n << 16 | n << 8 | n;
        }
        return this.g.color(n, n2);
    }

    public final int color(float f, float f2) {
        if (this.g == null) {
            int n = (int)f;
            int n2 = (int)f2;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f, f2);
    }

    public final int color(int n, int n2, int n3) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3);
    }

    public final int color(float f, float f2, float f3) {
        if (this.g == null) {
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return 0xFF000000 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3);
    }

    public final int color(int n, int n2, int n3, int n4) {
        if (this.g == null) {
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return n4 << 24 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3, n4);
    }

    public final int color(float f, float f2, float f3, float f4) {
        if (this.g == null) {
            if (f4 > 255.0f) {
                f4 = 255.0f;
            } else if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return (int)f4 << 24 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3, f4);
    }

    public void setupExternalMessages() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Point point = ((Frame)componentEvent.getSource()).getLocation();
                System.err.println("__MOVE__ " + point.x + " " + point.y);
                System.err.flush();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PApplet.this.exit();
            }
        });
    }

    public void setupFrameResizeListener() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Frame frame;
                if (PApplet.this.frame.isResizable() && (frame = (Frame)componentEvent.getComponent()).isVisible()) {
                    Insets insets = frame.getInsets();
                    Dimension dimension = frame.getSize();
                    int n = dimension.width - insets.left - insets.right;
                    int n2 = dimension.height - insets.top - insets.bottom;
                    PApplet.this.setBounds(insets.left, insets.top, n, n2);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        if (platform == 2) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        if (stringArray.length < 1) {
            System.err.println("Usage: PApplet <appletname>");
            System.err.println("For additional options, see the Javadoc for PApplet");
            System.exit(1);
        }
        try {
            Object object;
            GraphicsDevice[] graphicsDeviceArray;
            Object object2;
            boolean bl = false;
            int[] nArray = null;
            int[] nArray2 = null;
            String string = null;
            boolean bl2 = false;
            boolean bl3 = false;
            Color color = Color.BLACK;
            Color color2 = Color.GRAY;
            GraphicsDevice graphicsDevice = null;
            boolean bl4 = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                string4 = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].indexOf(61);
                if (n != -1) {
                    string2 = stringArray[i].substring(0, n);
                    string3 = stringArray[i].substring(n + 1);
                    if (string2.equals(ARGS_EDITOR_LOCATION)) {
                        bl = true;
                        nArray2 = PApplet.parseInt(PApplet.split(string3, ','));
                        continue;
                    }
                    if (string2.equals(ARGS_DISPLAY)) {
                        int n2 = Integer.parseInt(string3) - 1;
                        object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        graphicsDeviceArray = ((GraphicsEnvironment)object2).getScreenDevices();
                        if (n2 >= 0 && n2 < graphicsDeviceArray.length) {
                            graphicsDevice = graphicsDeviceArray[n2];
                            continue;
                        }
                        System.err.println("Display " + string3 + " does not exist, " + "using the default display instead.");
                        continue;
                    }
                    if (string2.equals(ARGS_BGCOLOR)) {
                        if (string3.charAt(0) == '#') {
                            string3 = string3.substring(1);
                        }
                        color = new Color(Integer.parseInt(string3, 16));
                        continue;
                    }
                    if (string2.equals(ARGS_STOP_COLOR)) {
                        if (string3.charAt(0) == '#') {
                            string3 = string3.substring(1);
                        }
                        color2 = new Color(Integer.parseInt(string3, 16));
                        continue;
                    }
                    if (string2.equals(ARGS_SKETCH_FOLDER)) {
                        string4 = string3;
                        continue;
                    }
                    if (!string2.equals(ARGS_LOCATION)) continue;
                    nArray = PApplet.parseInt(PApplet.split(string3, ','));
                    continue;
                }
                if (stringArray[i].equals(ARGS_PRESENT)) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals(ARGS_EXCLUSIVE)) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals(ARGS_HIDE_STOP)) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].equals(ARGS_EXTERNAL)) {
                    bl = true;
                    continue;
                }
                string = stringArray[i];
                break;
            }
            if (graphicsDevice == null) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            }
            Frame frame = new Frame(graphicsDevice.getDefaultConfiguration());
            frame.setResizable(false);
            Image image = Toolkit.getDefaultToolkit().createImage(ICON_IMAGE);
            frame.setIconImage(image);
            frame.setTitle(string);
            object2 = Thread.currentThread().getContextClassLoader().loadClass(string);
            graphicsDeviceArray = (GraphicsDevice[])((Class)object2).newInstance();
            graphicsDeviceArray.frame = frame;
            graphicsDeviceArray.sketchPath = string4;
            graphicsDeviceArray.args = PApplet.subset(stringArray, 1);
            graphicsDeviceArray.external = bl;
            Rectangle rectangle = null;
            if (bl2) {
                frame.setUndecorated(true);
                frame.setBackground(color);
                if (bl3) {
                    graphicsDevice.setFullScreenWindow(frame);
                    rectangle = frame.getBounds();
                } else {
                    object = graphicsDevice.getDisplayMode();
                    rectangle = new Rectangle(0, 0, ((DisplayMode)object).getWidth(), ((DisplayMode)object).getHeight());
                    frame.setBounds(rectangle);
                    frame.setVisible(true);
                }
            }
            frame.setLayout(null);
            frame.add((Component)graphicsDeviceArray);
            if (bl2) {
                frame.invalidate();
            } else {
                frame.pack();
            }
            graphicsDeviceArray.init();
            while (graphicsDeviceArray.defaultSize && !graphicsDeviceArray.finished) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (bl2) {
                frame.setBounds(rectangle);
                graphicsDeviceArray.setBounds((rectangle.width - graphicsDeviceArray.width) / 2, (rectangle.height - graphicsDeviceArray.height) / 2, graphicsDeviceArray.width, graphicsDeviceArray.height);
                if (!bl4) {
                    object = new Label("stop");
                    ((Component)object).setForeground(color2);
                    ((Component)object).addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent mouseEvent) {
                            System.exit(0);
                        }
                    });
                    frame.add((Component)object);
                    Dimension dimension = ((Component)object).getPreferredSize();
                    dimension = new Dimension(100, dimension.height);
                    ((Component)object).setSize(dimension);
                    ((Component)object).setLocation(20, rectangle.height - dimension.height - 20);
                }
                if (bl) {
                    graphicsDeviceArray.setupExternalMessages();
                }
            } else {
                int n;
                object = frame.getInsets();
                int n3 = Math.max(graphicsDeviceArray.width, 128) + ((Insets)object).left + ((Insets)object).right;
                int n4 = Math.max(graphicsDeviceArray.height, 128) + ((Insets)object).top + ((Insets)object).bottom;
                frame.setSize(n3, n4);
                if (nArray != null) {
                    frame.setLocation(nArray[0], nArray[1]);
                } else if (bl) {
                    n = nArray2[0] - 20;
                    int n5 = nArray2[1];
                    if (n - n3 > 10) {
                        frame.setLocation(n - n3, n5);
                    } else {
                        n = nArray2[0] + 66;
                        n5 = nArray2[1] + 66;
                        if (n + n3 > graphicsDeviceArray.screen.width - 33 || n5 + n4 > graphicsDeviceArray.screen.height - 33) {
                            n = (graphicsDeviceArray.screen.width - n3) / 2;
                            n5 = (graphicsDeviceArray.screen.height - n4) / 2;
                        }
                        frame.setLocation(n, n5);
                    }
                } else {
                    frame.setLocation((graphicsDeviceArray.screen.width - graphicsDeviceArray.width) / 2, (graphicsDeviceArray.screen.height - graphicsDeviceArray.height) / 2);
                }
                if (color == Color.black) {
                    color = SystemColor.control;
                }
                frame.setBackground(color);
                n = n4 - ((Insets)object).top - ((Insets)object).bottom;
                graphicsDeviceArray.setBounds((n3 - graphicsDeviceArray.width) / 2, ((Insets)object).top + (n - graphicsDeviceArray.height) / 2, graphicsDeviceArray.width, graphicsDeviceArray.height);
                if (bl) {
                    graphicsDeviceArray.setupExternalMessages();
                } else {
                    frame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            System.exit(0);
                        }
                    });
                }
                graphicsDeviceArray.setupFrameResizeListener();
                if (graphicsDeviceArray.displayable()) {
                    frame.setVisible(true);
                }
            }
            graphicsDeviceArray.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public PGraphics beginRecord(String string, String string2) {
        string2 = this.insertFrame(string2);
        PGraphics pGraphics = this.createGraphics(this.width, this.height, string, string2);
        this.beginRecord(pGraphics);
        return pGraphics;
    }

    public void beginRecord(PGraphics pGraphics) {
        this.recorder = pGraphics;
        pGraphics.beginDraw();
    }

    public void endRecord() {
        if (this.recorder != null) {
            this.recorder.endDraw();
            this.recorder.dispose();
            this.recorder = null;
        }
    }

    public PGraphics beginRaw(String string, String string2) {
        string2 = this.insertFrame(string2);
        PGraphics pGraphics = this.createGraphics(this.width, this.height, string, string2);
        this.g.beginRaw(pGraphics);
        return pGraphics;
    }

    public void beginRaw(PGraphics pGraphics) {
        this.g.beginRaw(pGraphics);
    }

    public void endRaw() {
        this.g.endRaw();
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void updatePixels() {
        this.g.updatePixels();
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.g.updatePixels(n, n2, n3, n4);
    }

    public void flush() {
        if (this.recorder != null) {
            this.recorder.flush();
        }
        this.g.flush();
    }

    public void hint(int n) {
        if (this.recorder != null) {
            this.recorder.hint(n);
        }
        this.g.hint(n);
    }

    public void beginShape() {
        if (this.recorder != null) {
            this.recorder.beginShape();
        }
        this.g.beginShape();
    }

    public void beginShape(int n) {
        if (this.recorder != null) {
            this.recorder.beginShape(n);
        }
        this.g.beginShape(n);
    }

    public void edge(boolean bl) {
        if (this.recorder != null) {
            this.recorder.edge(bl);
        }
        this.g.edge(bl);
    }

    public void normal(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.normal(f, f2, f3);
        }
        this.g.normal(f, f2, f3);
    }

    public void textureMode(int n) {
        if (this.recorder != null) {
            this.recorder.textureMode(n);
        }
        this.g.textureMode(n);
    }

    public void texture(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.texture(pImage);
        }
        this.g.texture(pImage);
    }

    public void vertex(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2);
        }
        this.g.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3);
        }
        this.g.vertex(f, f2, f3);
    }

    public void vertex(float[] fArray) {
        if (this.recorder != null) {
            this.recorder.vertex(fArray);
        }
        this.g.vertex(fArray);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3, f4);
        }
        this.g.vertex(f, f2, f3, f4);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        if (this.recorder != null) {
            this.recorder.vertex(f, f2, f3, f4, f5);
        }
        this.g.vertex(f, f2, f3, f4, f5);
    }

    public void breakShape() {
        if (this.recorder != null) {
            this.recorder.breakShape();
        }
        this.g.breakShape();
    }

    public void endShape() {
        if (this.recorder != null) {
            this.recorder.endShape();
        }
        this.g.endShape();
    }

    public void endShape(int n) {
        if (this.recorder != null) {
            this.recorder.endShape(n);
        }
        this.g.endShape(n);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(f, f2, f3, f4, f5, f6);
        }
        this.g.bezierVertex(f, f2, f3, f4, f5, f6);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        this.g.bezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void curveVertex(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.curveVertex(f, f2);
        }
        this.g.curveVertex(f, f2);
    }

    public void curveVertex(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.curveVertex(f, f2, f3);
        }
        this.g.curveVertex(f, f2, f3);
    }

    public void point(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.point(f, f2);
        }
        this.g.point(f, f2);
    }

    public void point(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.point(f, f2, f3);
        }
        this.g.point(f, f2, f3);
    }

    public void line(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.line(f, f2, f3, f4);
        }
        this.g.line(f, f2, f3, f4);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.line(f, f2, f3, f4, f5, f6);
        }
        this.g.line(f, f2, f3, f4, f5, f6);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.triangle(f, f2, f3, f4, f5, f6);
        }
        this.g.triangle(f, f2, f3, f4, f5, f6);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.quad(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.quad(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void rectMode(int n) {
        if (this.recorder != null) {
            this.recorder.rectMode(n);
        }
        this.g.rectMode(n);
    }

    public void rect(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.rect(f, f2, f3, f4);
        }
        this.g.rect(f, f2, f3, f4);
    }

    public void ellipseMode(int n) {
        if (this.recorder != null) {
            this.recorder.ellipseMode(n);
        }
        this.g.ellipseMode(n);
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.ellipse(f, f2, f3, f4);
        }
        this.g.ellipse(f, f2, f3, f4);
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.arc(f, f2, f3, f4, f5, f6);
        }
        this.g.arc(f, f2, f3, f4, f5, f6);
    }

    public void box(float f) {
        if (this.recorder != null) {
            this.recorder.box(f);
        }
        this.g.box(f);
    }

    public void box(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.box(f, f2, f3);
        }
        this.g.box(f, f2, f3);
    }

    public void sphereDetail(int n) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(n);
        }
        this.g.sphereDetail(n);
    }

    public void sphereDetail(int n, int n2) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(n, n2);
        }
        this.g.sphereDetail(n, n2);
    }

    public void sphere(float f) {
        if (this.recorder != null) {
            this.recorder.sphere(f);
        }
        this.g.sphere(f);
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierPoint(f, f2, f3, f4, f5);
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierTangent(f, f2, f3, f4, f5);
    }

    public void bezierDetail(int n) {
        if (this.recorder != null) {
            this.recorder.bezierDetail(n);
        }
        this.g.bezierDetail(n);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.bezier(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (this.recorder != null) {
            this.recorder.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.curvePoint(f, f2, f3, f4, f5);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.curveTangent(f, f2, f3, f4, f5);
    }

    public void curveDetail(int n) {
        if (this.recorder != null) {
            this.recorder.curveDetail(n);
        }
        this.g.curveDetail(n);
    }

    public void curveTightness(float f) {
        if (this.recorder != null) {
            this.recorder.curveTightness(f);
        }
        this.g.curveTightness(f);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.recorder != null) {
            this.recorder.curve(f, f2, f3, f4, f5, f6, f7, f8);
        }
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (this.recorder != null) {
            this.recorder.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        }
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void smooth() {
        if (this.recorder != null) {
            this.recorder.smooth();
        }
        this.g.smooth();
    }

    public void noSmooth() {
        if (this.recorder != null) {
            this.recorder.noSmooth();
        }
        this.g.noSmooth();
    }

    public void imageMode(int n) {
        if (this.recorder != null) {
            this.recorder.imageMode(n);
        }
        this.g.imageMode(n);
    }

    public void image(PImage pImage, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2);
        }
        this.g.image(pImage, f, f2);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2, f3, f4);
        }
        this.g.image(pImage, f, f2, f3, f4);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (this.recorder != null) {
            this.recorder.image(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
        this.g.image(pImage, f, f2, f3, f4, n, n2, n3, n4);
    }

    public void shapeMode(int n) {
        if (this.recorder != null) {
            this.recorder.shapeMode(n);
        }
        this.g.shapeMode(n);
    }

    public void shape(PShape pShape) {
        if (this.recorder != null) {
            this.recorder.shape(pShape);
        }
        this.g.shape(pShape);
    }

    public void shape(PShape pShape, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.shape(pShape, f, f2);
        }
        this.g.shape(pShape, f, f2);
    }

    public void shape(PShape pShape, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.shape(pShape, f, f2, f3, f4);
        }
        this.g.shape(pShape, f, f2, f3, f4);
    }

    public void textAlign(int n) {
        if (this.recorder != null) {
            this.recorder.textAlign(n);
        }
        this.g.textAlign(n);
    }

    public void textAlign(int n, int n2) {
        if (this.recorder != null) {
            this.recorder.textAlign(n, n2);
        }
        this.g.textAlign(n, n2);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont pFont) {
        if (this.recorder != null) {
            this.recorder.textFont(pFont);
        }
        this.g.textFont(pFont);
    }

    public void textFont(PFont pFont, float f) {
        if (this.recorder != null) {
            this.recorder.textFont(pFont, f);
        }
        this.g.textFont(pFont, f);
    }

    public void textLeading(float f) {
        if (this.recorder != null) {
            this.recorder.textLeading(f);
        }
        this.g.textLeading(f);
    }

    public void textMode(int n) {
        if (this.recorder != null) {
            this.recorder.textMode(n);
        }
        this.g.textMode(n);
    }

    public void textSize(float f) {
        if (this.recorder != null) {
            this.recorder.textSize(f);
        }
        this.g.textSize(f);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String string) {
        return this.g.textWidth(string);
    }

    public void text(char c) {
        if (this.recorder != null) {
            this.recorder.text(c);
        }
        this.g.text(c);
    }

    public void text(char c, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(c, f, f2);
        }
        this.g.text(c, f, f2);
    }

    public void text(char c, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(c, f, f2, f3);
        }
        this.g.text(c, f, f2, f3);
    }

    public void text(String string) {
        if (this.recorder != null) {
            this.recorder.text(string);
        }
        this.g.text(string);
    }

    public void text(String string, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2);
        }
        this.g.text(string, f, f2);
    }

    public void text(char[] cArray, int n, int n2, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(cArray, n, n2, f, f2);
        }
        this.g.text(cArray, n, n2, f, f2);
    }

    public void text(String string, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3);
        }
        this.g.text(string, f, f2, f3);
    }

    public void text(char[] cArray, int n, int n2, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(cArray, n, n2, f, f2, f3);
        }
        this.g.text(cArray, n, n2, f, f2, f3);
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3, f4);
        }
        this.g.text(string, f, f2, f3, f4);
    }

    public void text(String string, float f, float f2, float f3, float f4, float f5) {
        if (this.recorder != null) {
            this.recorder.text(string, f, f2, f3, f4, f5);
        }
        this.g.text(string, f, f2, f3, f4, f5);
    }

    public void text(int n, float f, float f2) {
        if (this.recorder != null) {
            this.recorder.text(n, f, f2);
        }
        this.g.text(n, f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(n, f, f2, f3);
        }
        this.g.text(n, f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.text(f, f2, f3);
        }
        this.g.text(f, f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.text(f, f2, f3, f4);
        }
        this.g.text(f, f2, f3, f4);
    }

    public void pushMatrix() {
        if (this.recorder != null) {
            this.recorder.pushMatrix();
        }
        this.g.pushMatrix();
    }

    public void popMatrix() {
        if (this.recorder != null) {
            this.recorder.popMatrix();
        }
        this.g.popMatrix();
    }

    public void translate(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.translate(f, f2);
        }
        this.g.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.translate(f, f2, f3);
        }
        this.g.translate(f, f2, f3);
    }

    public void rotate(float f) {
        if (this.recorder != null) {
            this.recorder.rotate(f);
        }
        this.g.rotate(f);
    }

    public void rotateX(float f) {
        if (this.recorder != null) {
            this.recorder.rotateX(f);
        }
        this.g.rotateX(f);
    }

    public void rotateY(float f) {
        if (this.recorder != null) {
            this.recorder.rotateY(f);
        }
        this.g.rotateY(f);
    }

    public void rotateZ(float f) {
        if (this.recorder != null) {
            this.recorder.rotateZ(f);
        }
        this.g.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.rotate(f, f2, f3, f4);
        }
        this.g.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        if (this.recorder != null) {
            this.recorder.scale(f);
        }
        this.g.scale(f);
    }

    public void scale(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.scale(f, f2);
        }
        this.g.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.scale(f, f2, f3);
        }
        this.g.scale(f, f2, f3);
    }

    public void resetMatrix() {
        if (this.recorder != null) {
            this.recorder.resetMatrix();
        }
        this.g.resetMatrix();
    }

    public void applyMatrix(PMatrix pMatrix) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(pMatrix);
        }
        this.g.applyMatrix(pMatrix);
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(pMatrix2D);
        }
        this.g.applyMatrix(pMatrix2D);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(f, f2, f3, f4, f5, f6);
        }
        this.g.applyMatrix(f, f2, f3, f4, f5, f6);
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(pMatrix3D);
        }
        this.g.applyMatrix(pMatrix3D);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        }
        this.g.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public PMatrix getMatrix() {
        return this.g.getMatrix();
    }

    public PMatrix2D getMatrix(PMatrix2D pMatrix2D) {
        return this.g.getMatrix(pMatrix2D);
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        return this.g.getMatrix(pMatrix3D);
    }

    public void setMatrix(PMatrix pMatrix) {
        if (this.recorder != null) {
            this.recorder.setMatrix(pMatrix);
        }
        this.g.setMatrix(pMatrix);
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        if (this.recorder != null) {
            this.recorder.setMatrix(pMatrix2D);
        }
        this.g.setMatrix(pMatrix2D);
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        if (this.recorder != null) {
            this.recorder.setMatrix(pMatrix3D);
        }
        this.g.setMatrix(pMatrix3D);
    }

    public void printMatrix() {
        if (this.recorder != null) {
            this.recorder.printMatrix();
        }
        this.g.printMatrix();
    }

    public void beginCamera() {
        if (this.recorder != null) {
            this.recorder.beginCamera();
        }
        this.g.beginCamera();
    }

    public void endCamera() {
        if (this.recorder != null) {
            this.recorder.endCamera();
        }
        this.g.endCamera();
    }

    public void camera() {
        if (this.recorder != null) {
            this.recorder.camera();
        }
        this.g.camera();
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.recorder != null) {
            this.recorder.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
        }
        this.g.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void printCamera() {
        if (this.recorder != null) {
            this.recorder.printCamera();
        }
        this.g.printCamera();
    }

    public void ortho() {
        if (this.recorder != null) {
            this.recorder.ortho();
        }
        this.g.ortho();
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.ortho(f, f2, f3, f4, f5, f6);
        }
        this.g.ortho(f, f2, f3, f4, f5, f6);
    }

    public void perspective() {
        if (this.recorder != null) {
            this.recorder.perspective();
        }
        this.g.perspective();
    }

    public void perspective(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.perspective(f, f2, f3, f4);
        }
        this.g.perspective(f, f2, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.frustum(f, f2, f3, f4, f5, f6);
        }
        this.g.frustum(f, f2, f3, f4, f5, f6);
    }

    public void printProjection() {
        if (this.recorder != null) {
            this.recorder.printProjection();
        }
        this.g.printProjection();
    }

    public float screenX(float f, float f2) {
        return this.g.screenX(f, f2);
    }

    public float screenY(float f, float f2) {
        return this.g.screenY(f, f2);
    }

    public float screenX(float f, float f2, float f3) {
        return this.g.screenX(f, f2, f3);
    }

    public float screenY(float f, float f2, float f3) {
        return this.g.screenY(f, f2, f3);
    }

    public float screenZ(float f, float f2, float f3) {
        return this.g.screenZ(f, f2, f3);
    }

    public float modelX(float f, float f2, float f3) {
        return this.g.modelX(f, f2, f3);
    }

    public float modelY(float f, float f2, float f3) {
        return this.g.modelY(f, f2, f3);
    }

    public float modelZ(float f, float f2, float f3) {
        return this.g.modelZ(f, f2, f3);
    }

    public void pushStyle() {
        if (this.recorder != null) {
            this.recorder.pushStyle();
        }
        this.g.pushStyle();
    }

    public void popStyle() {
        if (this.recorder != null) {
            this.recorder.popStyle();
        }
        this.g.popStyle();
    }

    public void style(PStyle pStyle) {
        if (this.recorder != null) {
            this.recorder.style(pStyle);
        }
        this.g.style(pStyle);
    }

    public void strokeWeight(float f) {
        if (this.recorder != null) {
            this.recorder.strokeWeight(f);
        }
        this.g.strokeWeight(f);
    }

    public void strokeJoin(int n) {
        if (this.recorder != null) {
            this.recorder.strokeJoin(n);
        }
        this.g.strokeJoin(n);
    }

    public void strokeCap(int n) {
        if (this.recorder != null) {
            this.recorder.strokeCap(n);
        }
        this.g.strokeCap(n);
    }

    public void noStroke() {
        if (this.recorder != null) {
            this.recorder.noStroke();
        }
        this.g.noStroke();
    }

    public void stroke(int n) {
        if (this.recorder != null) {
            this.recorder.stroke(n);
        }
        this.g.stroke(n);
    }

    public void stroke(int n, float f) {
        if (this.recorder != null) {
            this.recorder.stroke(n, f);
        }
        this.g.stroke(n, f);
    }

    public void stroke(float f) {
        if (this.recorder != null) {
            this.recorder.stroke(f);
        }
        this.g.stroke(f);
    }

    public void stroke(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2);
        }
        this.g.stroke(f, f2);
    }

    public void stroke(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2, f3);
        }
        this.g.stroke(f, f2, f3);
    }

    public void stroke(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.stroke(f, f2, f3, f4);
        }
        this.g.stroke(f, f2, f3, f4);
    }

    public void noTint() {
        if (this.recorder != null) {
            this.recorder.noTint();
        }
        this.g.noTint();
    }

    public void tint(int n) {
        if (this.recorder != null) {
            this.recorder.tint(n);
        }
        this.g.tint(n);
    }

    public void tint(int n, float f) {
        if (this.recorder != null) {
            this.recorder.tint(n, f);
        }
        this.g.tint(n, f);
    }

    public void tint(float f) {
        if (this.recorder != null) {
            this.recorder.tint(f);
        }
        this.g.tint(f);
    }

    public void tint(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2);
        }
        this.g.tint(f, f2);
    }

    public void tint(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2, f3);
        }
        this.g.tint(f, f2, f3);
    }

    public void tint(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.tint(f, f2, f3, f4);
        }
        this.g.tint(f, f2, f3, f4);
    }

    public void noFill() {
        if (this.recorder != null) {
            this.recorder.noFill();
        }
        this.g.noFill();
    }

    public void fill(int n) {
        if (this.recorder != null) {
            this.recorder.fill(n);
        }
        this.g.fill(n);
    }

    public void fill(int n, float f) {
        if (this.recorder != null) {
            this.recorder.fill(n, f);
        }
        this.g.fill(n, f);
    }

    public void fill(float f) {
        if (this.recorder != null) {
            this.recorder.fill(f);
        }
        this.g.fill(f);
    }

    public void fill(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2);
        }
        this.g.fill(f, f2);
    }

    public void fill(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2, f3);
        }
        this.g.fill(f, f2, f3);
    }

    public void fill(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.fill(f, f2, f3, f4);
        }
        this.g.fill(f, f2, f3, f4);
    }

    public void ambient(int n) {
        if (this.recorder != null) {
            this.recorder.ambient(n);
        }
        this.g.ambient(n);
    }

    public void ambient(float f) {
        if (this.recorder != null) {
            this.recorder.ambient(f);
        }
        this.g.ambient(f);
    }

    public void ambient(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.ambient(f, f2, f3);
        }
        this.g.ambient(f, f2, f3);
    }

    public void specular(int n) {
        if (this.recorder != null) {
            this.recorder.specular(n);
        }
        this.g.specular(n);
    }

    public void specular(float f) {
        if (this.recorder != null) {
            this.recorder.specular(f);
        }
        this.g.specular(f);
    }

    public void specular(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.specular(f, f2, f3);
        }
        this.g.specular(f, f2, f3);
    }

    public void shininess(float f) {
        if (this.recorder != null) {
            this.recorder.shininess(f);
        }
        this.g.shininess(f);
    }

    public void emissive(int n) {
        if (this.recorder != null) {
            this.recorder.emissive(n);
        }
        this.g.emissive(n);
    }

    public void emissive(float f) {
        if (this.recorder != null) {
            this.recorder.emissive(f);
        }
        this.g.emissive(f);
    }

    public void emissive(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.emissive(f, f2, f3);
        }
        this.g.emissive(f, f2, f3);
    }

    public void lights() {
        if (this.recorder != null) {
            this.recorder.lights();
        }
        this.g.lights();
    }

    public void noLights() {
        if (this.recorder != null) {
            this.recorder.noLights();
        }
        this.g.noLights();
    }

    public void ambientLight(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.ambientLight(f, f2, f3);
        }
        this.g.ambientLight(f, f2, f3);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.ambientLight(f, f2, f3, f4, f5, f6);
        }
        this.g.ambientLight(f, f2, f3, f4, f5, f6);
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.directionalLight(f, f2, f3, f4, f5, f6);
        }
        this.g.directionalLight(f, f2, f3, f4, f5, f6);
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.recorder != null) {
            this.recorder.pointLight(f, f2, f3, f4, f5, f6);
        }
        this.g.pointLight(f, f2, f3, f4, f5, f6);
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.recorder != null) {
            this.recorder.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        }
        this.g.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
    }

    public void lightFalloff(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.lightFalloff(f, f2, f3);
        }
        this.g.lightFalloff(f, f2, f3);
    }

    public void lightSpecular(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.lightSpecular(f, f2, f3);
        }
        this.g.lightSpecular(f, f2, f3);
    }

    public void background(int n) {
        if (this.recorder != null) {
            this.recorder.background(n);
        }
        this.g.background(n);
    }

    public void background(int n, float f) {
        if (this.recorder != null) {
            this.recorder.background(n, f);
        }
        this.g.background(n, f);
    }

    public void background(float f) {
        if (this.recorder != null) {
            this.recorder.background(f);
        }
        this.g.background(f);
    }

    public void background(float f, float f2) {
        if (this.recorder != null) {
            this.recorder.background(f, f2);
        }
        this.g.background(f, f2);
    }

    public void background(float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.background(f, f2, f3);
        }
        this.g.background(f, f2, f3);
    }

    public void background(float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.background(f, f2, f3, f4);
        }
        this.g.background(f, f2, f3, f4);
    }

    public void background(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.background(pImage);
        }
        this.g.background(pImage);
    }

    public void colorMode(int n) {
        if (this.recorder != null) {
            this.recorder.colorMode(n);
        }
        this.g.colorMode(n);
    }

    public void colorMode(int n, float f) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f);
        }
        this.g.colorMode(n, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f, f2, f3);
        }
        this.g.colorMode(n, f, f2, f3);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        if (this.recorder != null) {
            this.recorder.colorMode(n, f, f2, f3, f4);
        }
        this.g.colorMode(n, f, f2, f3, f4);
    }

    public final float alpha(int n) {
        return this.g.alpha(n);
    }

    public final float red(int n) {
        return this.g.red(n);
    }

    public final float green(int n) {
        return this.g.green(n);
    }

    public final float blue(int n) {
        return this.g.blue(n);
    }

    public final float hue(int n) {
        return this.g.hue(n);
    }

    public final float saturation(int n) {
        return this.g.saturation(n);
    }

    public final float brightness(int n) {
        return this.g.brightness(n);
    }

    public int lerpColor(int n, int n2, float f) {
        return this.g.lerpColor(n, n2, f);
    }

    public static int lerpColor(int n, int n2, float f, int n3) {
        return PGraphics.lerpColor(n, n2, f, n3);
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public void setCache(Object object, Object object2) {
        if (this.recorder != null) {
            this.recorder.setCache(object, object2);
        }
        this.g.setCache(object, object2);
    }

    public Object getCache(Object object) {
        return this.g.getCache(object);
    }

    public void removeCache(Object object) {
        if (this.recorder != null) {
            this.recorder.removeCache(object);
        }
        this.g.removeCache(object);
    }

    public int get(int n, int n2) {
        return this.g.get(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        return this.g.get(n, n2, n3, n4);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int n, int n2, int n3) {
        if (this.recorder != null) {
            this.recorder.set(n, n2, n3);
        }
        this.g.set(n, n2, n3);
    }

    public void set(int n, int n2, PImage pImage) {
        if (this.recorder != null) {
            this.recorder.set(n, n2, pImage);
        }
        this.g.set(n, n2, pImage);
    }

    public void mask(int[] nArray) {
        if (this.recorder != null) {
            this.recorder.mask(nArray);
        }
        this.g.mask(nArray);
    }

    public void mask(PImage pImage) {
        if (this.recorder != null) {
            this.recorder.mask(pImage);
        }
        this.g.mask(pImage);
    }

    public void filter(int n) {
        if (this.recorder != null) {
            this.recorder.filter(n);
        }
        this.g.filter(n);
    }

    public void filter(int n, float f) {
        if (this.recorder != null) {
            this.recorder.filter(n, f);
        }
        this.g.filter(n, f);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.recorder != null) {
            this.recorder.copy(n, n2, n3, n4, n5, n6, n7, n8);
        }
        this.g.copy(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.recorder != null) {
            this.recorder.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
        }
        this.g.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static int blendColor(int n, int n2, int n3) {
        return PGraphics.blendColor(n, n2, n3);
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.recorder != null) {
            this.recorder.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        this.g.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.recorder != null) {
            this.recorder.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
        this.g.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    static {
        String string = System.getProperty("os.name");
        platform = string.indexOf("Mac") != -1 ? 2 : (string.indexOf("Windows") != -1 ? 1 : (string.equals("Linux") ? 3 : 0));
        MENU_SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ICON_IMAGE = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, 0, 0, 0, -1, -1, -1, 12, 12, 13, -15, -15, -14, 45, 57, 74, 54, 80, 111, 47, 71, 97, 62, 88, 117, 1, 14, 27, 7, 41, 73, 15, 52, 85, 2, 31, 55, 4, 54, 94, 18, 69, 109, 37, 87, 126, -1, -1, -1, 33, -7, 4, 1, 0, 0, 15, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 122, -16, -107, 114, -86, -67, 83, 30, -42, 26, -17, -100, -45, 56, -57, -108, 48, 40, 122, -90, 104, 67, -91, -51, 32, -53, 77, -78, -100, 47, -86, 12, 76, -110, -20, -74, -101, 97, -93, 27, 40, 20, -65, 65, 48, -111, 99, -20, -112, -117, -123, -47, -105, 24, 114, -112, 74, 69, 84, 25, 93, 88, -75, 9, 46, 2, 49, 88, -116, -67, 7, -19, -83, 60, 38, 3, -34, 2, 66, -95, 27, -98, 13, 4, -17, 55, 33, 109, 11, 11, -2, -128, 121, 123, 62, 91, 120, -128, 127, 122, 115, 102, 2, 119, 0, -116, -113, -119, 6, 102, 121, -108, -126, 5, 18, 6, 4, -102, -101, -100, 114, 15, 17, 0, 59};
    }

    class AsyncImageLoader
    extends Thread {
        String filename;
        String extension;
        PImage vessel;

        public AsyncImageLoader(String string, String string2, PImage pImage) {
            this.filename = string;
            this.extension = string2;
            this.vessel = pImage;
        }

        public void run() {
            while (PApplet.this.requestImageCount == PApplet.this.requestImageMax) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++PApplet.this.requestImageCount;
            PImage pImage = PApplet.this.loadImage(this.filename, this.extension);
            if (pImage == null) {
                this.vessel.width = -1;
                this.vessel.height = -1;
            } else {
                this.vessel.width = pImage.width;
                this.vessel.height = pImage.height;
                this.vessel.format = pImage.format;
                this.vessel.pixels = pImage.pixels;
            }
            --PApplet.this.requestImageCount;
        }
    }

    public class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;

        public void handle() {
            this.handle(new Object[0]);
        }

        public void handle(Object[] objectArray) {
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.methods[i].invoke(this.objects[i], objectArray);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void add(Object object, Method method) {
            if (this.objects == null) {
                this.objects = new Object[5];
                this.methods = new Method[5];
            }
            if (this.count == this.objects.length) {
                this.objects = (Object[])PApplet.expand(this.objects);
                this.methods = (Method[])PApplet.expand(this.methods);
            }
            this.objects[this.count] = object;
            this.methods[this.count] = method;
            ++this.count;
        }

        public void remove(Object object, Method method) {
            int n = this.findIndex(object, method);
            if (n != -1) {
                --this.count;
                for (int i = n; i < this.count; ++i) {
                    this.objects[i] = this.objects[i + 1];
                    this.methods[i] = this.methods[i + 1];
                }
                this.objects[this.count] = null;
                this.methods[this.count] = null;
            }
        }

        protected int findIndex(Object object, Method method) {
            for (int i = 0; i < this.count; ++i) {
                if (this.objects[i] != object || !this.methods[i].equals(method)) continue;
                return i;
            }
            return -1;
        }
    }

    public static class RendererChangeException
    extends RuntimeException {
    }
}

