/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.Slider;
import processing.core.PApplet;

public class Textarea
extends ControllerGroup
implements ControlListener {
    protected String _myText;
    protected Slider _myScrollbar;
    protected int _myWidth = 200;
    protected int _myHeight = 20;
    protected int _myColorBackground = 0;
    protected boolean isColorBackground = false;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    protected int _myBottomOffset = 4;

    public Textarea(ControlP5 controlP5, ControllerGroup controllerGroup, String string, String string2, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myWidth = n3;
        this._myHeight = n4;
        this._myText = string2;
        this.setup();
    }

    public Textarea(String string, int n, int n2) {
        super(n, n2);
        this._myText = string;
        this.setup();
    }

    private void setup() {
        this._myValueLabel = new Label(this._myText, this._myWidth - 4, this._myHeight - 4);
        this._myValueLabel.setFont(1);
        this._myValueLabel.multiline(true);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.update();
        this._myValueLabel.position.set(2.0f, 2.0f);
        this._myValueLabel.setColor(this.color.colorValueLabel);
        this.addDrawable(this._myValueLabel);
        this._myScrollbar = new Slider(this.controlP5, this._myParent, this.name() + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth, 0, 10, this._myHeight);
        this._myScrollbar.init();
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.isMoveable = false;
        this._myScrollbar.isLabelVisible = false;
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this.add(this._myScrollbar);
        this.setWidth(this._myWidth);
        this.setHeight(this._myHeight);
        this._myScrollbar.color.set(this.color);
    }

    public void controlEvent(ControlEvent controlEvent) {
        this._myScrollValue = -(1.0f - controlEvent.value());
        this.scroll();
    }

    public void hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
    }

    public void showScrollbar() {
        boolean bl;
        this.isScrollbarVisible = true;
        boolean bl2 = bl = this._myHeight < this._myValueLabel.textHeight() + this._myValueLabel.lineHeight();
        if (bl) {
            this._myScrollbar.show();
        }
    }

    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    public void setColorBackground(int n) {
        this._myColorBackground = n;
        this.isColorBackground = true;
    }

    public void disableColorBackground() {
        this.isColorBackground = false;
    }

    public void enableColorBackground() {
        this.isColorBackground = true;
    }

    public void scroll(float f) {
        this._myScrollbar.setValue(1.0f - f);
    }

    private void scroll() {
        boolean bl;
        this._myScrollValue = PApplet.min((float)PApplet.max((float)-1.0f, (float)this._myScrollValue), (float)0.0f);
        float f = this._myValueLabel.textHeight() + this._myValueLabel.getLineHeight();
        float f2 = 0.0f;
        boolean bl2 = bl = (float)this._myHeight < f;
        if (bl) {
            f2 = this._myScrollValue * (f - (float)this._myHeight + (float)this._myBottomOffset);
        }
        bl = this.isScrollbarVisible ? bl : false;
        this._myScrollbar.setVisible(bl);
        this._myValueLabel.setOffset(f2);
        this._myValueLabel.update();
    }

    public Textarea setWidth(int n) {
        this._myWidth = n = n < 10 ? 10 : n;
        this._myValueLabel.setWidth(this._myWidth - 2);
        this._myScrollValue = (float)this._myHeight / (float)this._myValueLabel.textHeight();
        this._myScrollbar.setHeight(this._myHeight + this._myValueLabel.style().paddingTop + this._myValueLabel.style().paddingBottom);
        return this;
    }

    public Textarea setHeight(int n) {
        this._myHeight = n = n < 10 ? 10 : n;
        this._myValueLabel.setHeight(this._myHeight - 2);
        this._myScrollValue = (float)this._myHeight / (float)this._myValueLabel.textHeight();
        this._myScrollbar.setHeight(this._myHeight + this._myValueLabel.style().paddingTop + this._myValueLabel.style().paddingBottom);
        return this;
    }

    public void setLineHeight(int n) {
        this._myValueLabel.setLineHeight(n);
        this.scroll();
    }

    public void setColor(int n) {
        this._myValueLabel.setColor(n, true);
    }

    public Label valueLabel() {
        return this._myValueLabel;
    }

    public void setText(String string) {
        this._myValueLabel.set(string, true);
        this._myScrollValue = (float)this._myHeight / (float)this._myValueLabel.textHeight();
        this._myScrollbar.setHeight(this._myHeight + this._myValueLabel.style().paddingTop + this._myValueLabel.style().paddingBottom);
    }

    public void setPosition(float f, float f2) {
        this.position.x = f;
        this.position.y = f2;
    }

    protected void preDraw(PApplet pApplet) {
        if (this._myScrollbar.isVisible() || this.isColorBackground) {
            this._myScrollbar.position().x = this._myWidth + this._myValueLabel.style().paddingLeft + this._myValueLabel.style().paddingRight;
            pApplet.stroke(this.color.colorBackground);
            if (!this.isColorBackground) {
                pApplet.noFill();
            } else {
                pApplet.fill(this._myColorBackground);
            }
            if (!this._myScrollbar.isVisible()) {
                pApplet.noStroke();
            }
            pApplet.rect(0.0f, 0.0f, (float)(this._myWidth + 1 + this._myValueLabel.style().paddingLeft + this._myValueLabel.style().paddingRight), (float)(this._myHeight - 1 + this._myValueLabel.style().paddingTop + this._myValueLabel.style().paddingBottom));
            pApplet.noStroke();
        }
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x() + this._myParent.absolutePosition().x() && (float)this._myControlWindow.mouseX < this.position.x() + this._myParent.absolutePosition().x() + (float)this._myWidth && (float)this._myControlWindow.mouseY > this.position.y() + this._myParent.absolutePosition().y() && (float)this._myControlWindow.mouseY < this.position.y() + this._myParent.absolutePosition().y() + (float)this._myHeight;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "textarea");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myHeight));
        controlP5XMLElement.setContent(this._myValueLabel.toString());
    }

    public String stringValue() {
        return this._myValueLabel.toString();
    }

    public String text() {
        return this.stringValue();
    }

    public float value() {
        return 0.0f;
    }
}

