/*
 * Decompiled with CFR 0.152.
 */
package hypermedia.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import processing.core.PApplet;

public class UDP
implements Runnable {
    DatagramSocket ucSocket = null;
    MulticastSocket mcSocket = null;
    boolean log = false;
    boolean listen = false;
    int timeout = 0;
    int size = 65507;
    InetAddress group = null;
    Thread thread = null;
    Object owner = null;
    String receiveHandler = "receive";
    String timeoutHandler = "timeout";
    String header = "";
    public static final int BUFFER_SIZE = 65507;

    public UDP(Object object) {
        this(object, 0);
    }

    public UDP(Object object, int n) {
        this(object, n, null);
    }

    public UDP(Object object, int n, String string) {
        this.owner = object;
        try {
            if (object instanceof PApplet) {
                ((PApplet)object).registerDispose((Object)this);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            InetAddress inetAddress;
            InetAddress inetAddress2 = InetAddress.getByName(string);
            InetAddress inetAddress3 = inetAddress = string == null ? (InetAddress)null : inetAddress2;
            if (!inetAddress2.isMulticastAddress()) {
                this.ucSocket = new DatagramSocket(n, inetAddress);
                this.log("bound socket to host:" + this.address() + ", port: " + this.port());
            } else {
                this.mcSocket = new MulticastSocket(n);
                this.mcSocket.joinGroup(inetAddress2);
                this.group = inetAddress2;
                this.log("bound multicast socket to host:" + this.address() + ", port: " + this.port() + ", group:" + this.group);
            }
        }
        catch (IOException iOException) {
            this.error("opening socket failed!\n\t> address:" + string + ", port:" + n + " [group:" + this.group + "]" + "\n\t> " + iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("opening socket failed!\n\t> bad arguments: " + illegalArgumentException.getMessage());
        }
        catch (SecurityException securityException) {
            this.error((this.isMulticast() ? "could not joined the group" : "warning") + "\n\t> " + securityException.getMessage());
        }
    }

    public void dispose() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        int n = this.port();
        String string = this.address();
        try {
            if (this.isMulticast()) {
                if (this.group != null) {
                    this.mcSocket.leaveGroup(this.group);
                    this.log("leave group < address:" + this.group + " >");
                }
                this.mcSocket.close();
                this.mcSocket = null;
            } else {
                this.ucSocket.close();
                this.ucSocket = null;
            }
        }
        catch (IOException iOException) {
            this.error("Error while closing the socket!\n\t> " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
        }
        finally {
            this.log("close socket < port:" + n + ", address:" + string + " >\n");
        }
    }

    public boolean isClosed() {
        if (this.isMulticast()) {
            return this.mcSocket == null ? true : this.mcSocket.isClosed();
        }
        return this.ucSocket == null ? true : this.ucSocket.isClosed();
    }

    public int port() {
        if (this.isClosed()) {
            return -1;
        }
        return this.isMulticast() ? this.mcSocket.getLocalPort() : this.ucSocket.getLocalPort();
    }

    public String address() {
        if (this.isClosed()) {
            return null;
        }
        InetAddress inetAddress = this.isMulticast() ? this.mcSocket.getLocalAddress() : this.ucSocket.getLocalAddress();
        return inetAddress.isAnyLocalAddress() ? null : inetAddress.getHostAddress();
    }

    public boolean send(String string) {
        return this.send(string.getBytes());
    }

    public boolean send(byte[] byArray) {
        if (this.isMulticast() && this.group == null) {
            return false;
        }
        String string = this.isMulticast() ? this.group.getHostAddress() : this.address();
        return this.send(byArray, string, this.port());
    }

    public boolean send(String string, String string2) {
        return this.send(string.getBytes(), string2);
    }

    public boolean send(byte[] byArray, String string) {
        return this.send(byArray, string, this.port());
    }

    public boolean send(String string, String string2, int n) {
        return this.send(string.getBytes(), string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte[] byArray, String string, int n) {
        boolean bl = false;
        DatagramPacket datagramPacket = null;
        try {
            datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n);
            if (this.isMulticast()) {
                this.mcSocket.send(datagramPacket);
            } else {
                this.ucSocket.send(datagramPacket);
            }
            bl = true;
            this.log("send packet -> address:" + datagramPacket.getAddress() + ", port:" + datagramPacket.getPort() + ", length: " + datagramPacket.getLength());
        }
        catch (IOException iOException) {
            this.error("could not send message!\t\n> port:" + n + ", ip:" + string + ", buffer size: " + this.size + ", packet length: " + datagramPacket.getLength() + "\t\n> " + iOException.getMessage());
        }
        finally {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBuffer(int n) {
        boolean bl = false;
        if (this.isListening()) {
            return bl;
        }
        try {
            if (this.isMulticast()) {
                this.mcSocket.setSendBufferSize(n > 0 ? n : 65507);
                this.mcSocket.setReceiveBufferSize(n > 0 ? n : 65507);
            } else {
                this.ucSocket.setSendBufferSize(n > 0 ? n : 65507);
                this.ucSocket.setReceiveBufferSize(n > 0 ? n : 65507);
            }
            this.size = n > 0 ? n : 65507;
            bl = true;
            return bl;
        }
        catch (SocketException socketException) {
            this.error("could not set the buffer!\n> " + socketException.getMessage());
        }
        finally {
            return bl;
        }
    }

    public int getBuffer() {
        return this.size;
    }

    public boolean isListening() {
        return this.listen;
    }

    public void listen(boolean bl) {
        this.listen = bl;
        this.timeout = 0;
        if (bl && this.thread == null && !this.isClosed()) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (!bl && this.thread != null) {
            this.send(new byte[0]);
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void listen(int n) {
        if (this.isClosed()) {
            return;
        }
        this.listen = true;
        this.timeout = n;
        if (this.thread != null) {
            this.send(new byte[0]);
        }
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void listen() {
        block9: {
            try {
                byte[] byArray = new byte[this.size];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                if (this.isMulticast()) {
                    this.mcSocket.setSoTimeout(this.timeout);
                    this.mcSocket.receive(datagramPacket);
                } else {
                    this.ucSocket.setSoTimeout(this.timeout);
                    this.ucSocket.receive(datagramPacket);
                }
                this.log("receive packet <- from " + datagramPacket.getAddress() + ", port:" + datagramPacket.getPort() + ", length: " + datagramPacket.getLength());
                if (datagramPacket.getLength() != 0) {
                    byte[] byArray2 = new byte[datagramPacket.getLength()];
                    System.arraycopy(datagramPacket.getData(), 0, byArray2, 0, byArray2.length);
                    try {
                        this.callReceiveHandler(byArray2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.callReceiveHandler(byArray2, datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                this.listen = false;
                this.thread = null;
            }
            catch (IOException iOException) {
                this.listen = false;
                this.thread = null;
                if (iOException instanceof SocketTimeoutException) {
                    this.callTimeoutHandler();
                }
                if (this.ucSocket == null || this.mcSocket == null) break block9;
                this.error("listen failed!\n\t> " + iOException.getMessage());
            }
        }
    }

    public void run() {
        while (this.listen) {
            this.listen();
        }
    }

    public void setReceiveHandler(String string) {
        this.receiveHandler = string;
    }

    private void callReceiveHandler(byte[] byArray) throws NoSuchMethodException {
        try {
            Class[] classArray = new Class[]{byArray.getClass()};
            Object[] objectArray = new Object[]{byArray};
            Method method = this.owner.getClass().getMethod(this.receiveHandler, classArray);
            method.invoke(this.owner, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.error(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void callReceiveHandler(byte[] byArray, String string, int n) {
        try {
            Class[] classArray = new Class[]{byArray.getClass(), string.getClass(), Integer.TYPE};
            Object[] objectArray = new Object[]{byArray, string, new Integer(n)};
            Method method = this.owner.getClass().getMethod(this.receiveHandler, classArray);
            method.invoke(this.owner, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            this.error(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setTimeoutHandler(String string) {
        this.timeoutHandler = string;
    }

    private void callTimeoutHandler() {
        try {
            Method method = this.owner.getClass().getDeclaredMethod(this.timeoutHandler, null);
            method.invoke(this.owner, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            this.error(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public boolean isMulticast() {
        return this.mcSocket != null;
    }

    public boolean isJoined() {
        return this.group != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroadcast() {
        boolean bl = false;
        try {
            bl = this.ucSocket == null ? false : this.ucSocket.getBroadcast();
            return bl;
        }
        catch (SocketException socketException) {
            this.error(socketException.getMessage());
        }
        finally {
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean broadcast(boolean bl) {
        boolean bl2 = false;
        try {
            if (this.ucSocket != null) {
                this.ucSocket.setBroadcast(bl);
                bl2 = this.isBroadcast();
                return bl2;
            }
        }
        catch (SocketException socketException) {
            this.error(socketException.getMessage());
        }
        finally {
            return bl2;
        }
    }

    public void loopback(boolean bl) {
        try {
            if (this.isMulticast()) {
                this.mcSocket.setLoopbackMode(!bl);
            }
        }
        catch (SocketException socketException) {
            this.error("could not set the loopback mode!\n\t>" + socketException.getMessage());
        }
    }

    public boolean isLoopback() {
        try {
            if (this.isMulticast() && !this.isClosed()) {
                return !this.mcSocket.getLoopbackMode();
            }
        }
        catch (SocketException socketException) {
            this.error("could not get the loopback mode!\n\t> " + socketException.getMessage());
        }
        return false;
    }

    public boolean setTimeToLive(int n) {
        try {
            if (this.isMulticast() && !this.isClosed()) {
                this.mcSocket.setTimeToLive(n);
            }
            return true;
        }
        catch (IOException iOException) {
            this.error("setting the default \"Time to Live\" value failed!\n\t> " + iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error("\"Time to Live\" value must be in the range of 0-255");
        }
        return false;
    }

    public int getTimeToLive() {
        try {
            if (this.isMulticast() && !this.isClosed()) {
                return this.mcSocket.getTimeToLive();
            }
        }
        catch (IOException iOException) {
            this.error("could not retrieve the current time-to-live value!\n\t> " + iOException.getMessage());
        }
        return -1;
    }

    public void log(boolean bl) {
        this.log = bl;
    }

    private void log(String string) {
        Date date = new Date();
        if (!this.log && this.header.equals("")) {
            this.header = "-- UDP session started at " + date + " --\n-- " + string + " --\n";
        }
        if (this.log) {
            String string2 = "yy-MM-dd HH:mm:ss.S Z";
            String string3 = new SimpleDateFormat(string2).format(date);
            System.out.println(this.header + "[" + string3 + "] " + string);
            this.header = "";
        }
    }

    private void error(String string) {
        System.err.println(string);
    }
}

