/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.nyidmarker;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator_O1;
import jp.nyatla.nyartoolkit.nyidmarker.MarkerPattEncoder;

final class PerspectivePixelReader {
    private static int READ_RESOLUTION = 100;
    private NyARPerspectiveParamGenerator _param_gen = new NyARPerspectiveParamGenerator_O1(1, 1);
    private double[] _cparam = new double[8];
    private static final int FRQ_EDGE = 5;
    private static final int FRQ_STEP = 2;
    private static final int FRQ_POINTS = 45;
    private static final int MIN_FREQ = 3;
    private static final int MAX_FREQ = 10;
    private static final int FREQ_SAMPLE_NUM = 4;
    private static final int MAX_DATA_BITS = 19;
    private final int[] _ref_x = new int[108];
    private final int[] _ref_y = new int[108];
    private int[] _pixcel_temp = new int[324];
    private final int[] _freq_count_table = new int[10];
    private final int[] _freq_table = new int[190];
    private static final int THRESHOLD_EDGE = 10;
    private static final int THRESHOLD_STEP = 2;
    private static final int THRESHOLD_WIDTH = 10;
    private static final int THRESHOLD_PIXEL = 5;
    private static final int THRESHOLD_SAMPLE = 25;
    private static final int THRESHOLD_SAMPLE_LT = 10;
    private static final int THRESHOLD_SAMPLE_RB = 80;
    private THighAndLow __detectThresholdValue_hl = new THighAndLow();
    private NyARIntPoint2d __detectThresholdValue_tpt = new NyARIntPoint2d();
    private int[] _th_pixels = new int[100];
    private int[] __detectDataBitsIndex_freq_index1 = new int[45];
    private int[] __detectDataBitsIndex_freq_index2 = new int[45];
    private double[] __readDataBits_index_bit_x = new double[38];
    private double[] __readDataBits_index_bit_y = new double[38];

    public boolean setSourceSquare(NyARIntPoint2d[] i_vertex) throws NyARException {
        return this._param_gen.getParam(READ_RESOLUTION, READ_RESOLUTION, i_vertex, this._cparam);
    }

    public boolean setSourceSquare(NyARDoublePoint2d[] i_vertex) throws NyARException {
        return this._param_gen.getParam(READ_RESOLUTION, READ_RESOLUTION, i_vertex, this._cparam);
    }

    private boolean rectPixels(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, int i_lt_x, int i_lt_y, int i_step_x, int i_step_y, int i_width, int i_height, int i_out_st, int[] o_pixel) throws NyARException {
        double[] cpara = this._cparam;
        int[] ref_x = this._ref_x;
        int[] ref_y = this._ref_y;
        int[] pixcel_temp = this._pixcel_temp;
        int raster_width = i_raster_size.w;
        int raster_height = i_raster_size.h;
        int out_index = i_out_st;
        double cpara_6 = cpara[6];
        double cpara_0 = cpara[0];
        double cpara_3 = cpara[3];
        int i = 0;
        while (i < i_height) {
            int cy0 = 1 + i * i_step_y + i_lt_y;
            double cpy0_12 = cpara[1] * (double)cy0 + cpara[2];
            double cpy0_45 = cpara[4] * (double)cy0 + cpara[5];
            double cpy0_7 = cpara[7] * (double)cy0 + 1.0;
            int pt = 0;
            int i2 = 0;
            while (i2 < i_width) {
                int cx0 = 1 + i2 * i_step_x + i_lt_x;
                double d = cpara_6 * (double)cx0 + cpy0_7;
                int x = (int)((cpara_0 * (double)cx0 + cpy0_12) / d);
                int y = (int)((cpara_3 * (double)cx0 + cpy0_45) / d);
                if (x < 0 || y < 0 || x >= raster_width || y >= raster_height) {
                    return false;
                }
                ref_x[pt] = x;
                ref_y[pt] = y;
                ++pt;
                ++i2;
            }
            i_reader.getPixelSet(ref_x, ref_y, i_width, pixcel_temp);
            i2 = 0;
            while (i2 < i_width) {
                int index = i2 * 3;
                o_pixel[out_index] = (pixcel_temp[index + 0] + pixcel_temp[index + 1] + pixcel_temp[index + 2]) / 3;
                ++out_index;
                ++i2;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkFreqWidth(int[] i_freq, int i_width) {
        int c = i_freq[1] - i_freq[0];
        int count = i_width * 2 - 1;
        int i = 1;
        while (i < count) {
            int n = i_freq[i + 1] - i_freq[i];
            int v = n * 100 / c;
            if (v > 150 || v < 50) {
                return false;
            }
            c = n;
            ++i;
        }
        return true;
    }

    private static int getMaxFreq(int[] i_freq_count_table, int[] i_freq_table, int[] o_freq_table) {
        int index = -1;
        int max = 0;
        int i = 0;
        while (i < 10) {
            if (max < i_freq_count_table[i]) {
                index = i;
                max = i_freq_count_table[i];
            }
            ++i;
        }
        if (index == -1) {
            return -1;
        }
        int st = (index - 1) * index;
        int i2 = 0;
        while (i2 < index * 2) {
            o_freq_table[i2] = i_freq_table[st + i2] * 2 / max;
            ++i2;
        }
        return index;
    }

    public int getRowFrequency(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, int i_y1, int i_th_h, int i_th_l, int[] o_edge_index) throws NyARException {
        int[] freq_count_table = this._freq_count_table;
        int[] freq_table = this._freq_table;
        double[] cpara = this._cparam;
        int[] ref_x = this._ref_x;
        int[] ref_y = this._ref_y;
        int[] pixcel_temp = this._pixcel_temp;
        int i = 0;
        while (i < 10) {
            freq_count_table[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 110) {
            freq_table[i] = 0;
            ++i;
        }
        int raster_width = i_raster_size.w;
        int raster_height = i_raster_size.h;
        double cpara_0 = cpara[0];
        double cpara_3 = cpara[3];
        double cpara_6 = cpara[6];
        int i2 = 0;
        while (i2 < 4) {
            double cy0 = 1 + i_y1 + i2;
            double cpy0_12 = cpara[1] * cy0 + cpara[2];
            double cpy0_45 = cpara[4] * cy0 + cpara[5];
            double cpy0_7 = cpara[7] * cy0 + 1.0;
            int pt = 0;
            int i22 = 0;
            while (i22 < 45) {
                double cx0 = 1 + i22 * 2 + 5;
                double d = cpara_6 * cx0 + cpy0_7;
                int x = (int)((cpara_0 * cx0 + cpy0_12) / d);
                int y = (int)((cpara_3 * cx0 + cpy0_45) / d);
                if (x < 0 || y < 0 || x >= raster_width || y >= raster_height) {
                    return -1;
                }
                ref_x[pt] = x;
                ref_y[pt] = y;
                ++pt;
                ++i22;
            }
            i_reader.getPixelSet(ref_x, ref_y, 45, pixcel_temp);
            int freq_t = PerspectivePixelReader.getFreqInfo(pixcel_temp, i_th_h, i_th_l, o_edge_index);
            if (freq_t >= 3 && freq_t <= 10 && PerspectivePixelReader.checkFreqWidth(o_edge_index, freq_t)) {
                int n = freq_t;
                freq_count_table[n] = freq_count_table[n] + 1;
                int table_st = (freq_t - 1) * freq_t;
                int i23 = 0;
                while (i23 < freq_t * 2) {
                    int n2 = table_st + i23;
                    freq_table[n2] = freq_table[n2] + o_edge_index[i23];
                    ++i23;
                }
            }
            ++i2;
        }
        return PerspectivePixelReader.getMaxFreq(freq_count_table, freq_table, o_edge_index);
    }

    public int getColFrequency(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, int i_x1, int i_th_h, int i_th_l, int[] o_edge_index) throws NyARException {
        double[] cpara = this._cparam;
        int[] ref_x = this._ref_x;
        int[] ref_y = this._ref_y;
        int[] pixcel_temp = this._pixcel_temp;
        int[] freq_count_table = this._freq_count_table;
        int i = 0;
        while (i < 10) {
            freq_count_table[i] = 0;
            ++i;
        }
        int[] freq_table = this._freq_table;
        int i2 = 0;
        while (i2 < 110) {
            freq_table[i2] = 0;
            ++i2;
        }
        int raster_width = i_raster_size.w;
        int raster_height = i_raster_size.h;
        double cpara7 = cpara[7];
        double cpara4 = cpara[4];
        double cpara1 = cpara[1];
        int i3 = 0;
        while (i3 < 4) {
            int cx0 = 1 + i3 + i_x1;
            double cp6_0 = cpara[6] * (double)cx0;
            double cpx0_0 = cpara[0] * (double)cx0 + cpara[2];
            double cpx3_0 = cpara[3] * (double)cx0 + cpara[5];
            int pt = 0;
            int i22 = 0;
            while (i22 < 45) {
                int cy = 1 + i22 * 2 + 5;
                double d = cp6_0 + cpara7 * (double)cy + 1.0;
                int x = (int)((cpx0_0 + cpara1 * (double)cy) / d);
                int y = (int)((cpx3_0 + cpara4 * (double)cy) / d);
                if (x < 0 || y < 0 || x >= raster_width || y >= raster_height) {
                    return -1;
                }
                ref_x[pt] = x;
                ref_y[pt] = y;
                ++pt;
                ++i22;
            }
            i_reader.getPixelSet(ref_x, ref_y, 45, pixcel_temp);
            int freq_t = PerspectivePixelReader.getFreqInfo(pixcel_temp, i_th_h, i_th_l, o_edge_index);
            if (freq_t >= 3 && freq_t <= 10 && PerspectivePixelReader.checkFreqWidth(o_edge_index, freq_t)) {
                int n = freq_t;
                freq_count_table[n] = freq_count_table[n] + 1;
                int table_st = (freq_t - 1) * freq_t;
                int i23 = 0;
                while (i23 < freq_t * 2) {
                    int n2 = table_st + i23;
                    freq_table[n2] = freq_table[n2] + o_edge_index[i23];
                    ++i23;
                }
            }
            ++i3;
        }
        return PerspectivePixelReader.getMaxFreq(freq_count_table, freq_table, o_edge_index);
    }

    /*
     * Exception decompiling
     */
    private static int getFreqInfo(int[] i_pixcels, int i_th_h, int i_th_l, int[] o_edge_index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getPtailHighAndLow(int[] i_pixcel, THighAndLow i_out) {
        int l0;
        int l1 = l0 = i_pixcel[0];
        int l2 = l0;
        int l3 = l0;
        int h0 = l0;
        int h1 = l0;
        int h2 = l0;
        int h3 = l0;
        int i = i_pixcel.length - 1;
        while (i >= 1) {
            int pix = i_pixcel[i];
            if (h0 < pix) {
                if (h1 < pix) {
                    if (h2 < pix) {
                        if (h3 < pix) {
                            h0 = h1;
                            h1 = h2;
                            h2 = h3;
                            h3 = pix;
                        } else {
                            h0 = h1;
                            h1 = h2;
                            h2 = pix;
                        }
                    } else {
                        h0 = h1;
                        h1 = pix;
                    }
                } else {
                    h0 = pix;
                }
            }
            if (l0 > pix) {
                if (l1 > pix) {
                    if (l2 > pix) {
                        if (l3 > pix) {
                            l0 = l1;
                            l1 = l2;
                            l2 = l3;
                            l3 = pix;
                        } else {
                            l0 = l1;
                            l1 = l2;
                            l2 = pix;
                        }
                    } else {
                        l0 = l1;
                        l1 = pix;
                    }
                } else {
                    l0 = pix;
                }
            }
            --i;
        }
        i_out.l = (l0 + l1 + l2 + l3) / 4;
        i_out.h = (h0 + h1 + h2 + h3) / 4;
    }

    public void detectThresholdValue(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, TThreshold o_threshold) throws NyARException {
        int rb_y;
        int rb_x;
        int rt_y;
        int rt_x;
        int lb_y;
        int lb_x;
        int lt_y;
        int lt_x;
        int[] th_pixels = this._th_pixels;
        this.rectPixels(i_reader, i_raster_size, 10, 10, 2, 2, 5, 5, 0, th_pixels);
        this.rectPixels(i_reader, i_raster_size, 10, 80, 2, 2, 5, 5, 25, th_pixels);
        this.rectPixels(i_reader, i_raster_size, 80, 10, 2, 2, 5, 5, 50, th_pixels);
        this.rectPixels(i_reader, i_raster_size, 80, 80, 2, 2, 5, 5, 75, th_pixels);
        THighAndLow hl = this.__detectThresholdValue_hl;
        this.getPtailHighAndLow(th_pixels, hl);
        int th = (hl.h + hl.l) / 2;
        int th_sub = (hl.h - hl.l) / 5;
        o_threshold.th = th;
        o_threshold.th_h = th + th_sub;
        o_threshold.th_l = th - th_sub;
        NyARIntPoint2d tpt = this.__detectThresholdValue_tpt;
        if (this.getHighPixelCenter(0, th_pixels, 5, 5, th, tpt)) {
            lt_x = tpt.x * 2;
            lt_y = tpt.y * 2;
        } else {
            lt_x = 11;
            lt_y = 11;
        }
        if (this.getHighPixelCenter(25, th_pixels, 5, 5, th, tpt)) {
            lb_x = tpt.x * 2;
            lb_y = tpt.y * 2;
        } else {
            lb_x = 11;
            lb_y = -1;
        }
        if (this.getHighPixelCenter(50, th_pixels, 5, 5, th, tpt)) {
            rt_x = tpt.x * 2;
            rt_y = tpt.y * 2;
        } else {
            rt_x = -1;
            rt_y = 11;
        }
        if (this.getHighPixelCenter(75, th_pixels, 5, 5, th, tpt)) {
            rb_x = tpt.x * 2;
            rb_y = tpt.y * 2;
        } else {
            rb_x = -1;
            rb_y = -1;
        }
        o_threshold.lt_x = (lt_x + lb_x) / 2 + 10 - 1;
        o_threshold.rb_x = (rt_x + rb_x) / 2 + 80 + 1;
        o_threshold.lt_y = (lt_y + rt_y) / 2 + 10 - 1;
        o_threshold.rb_y = (lb_y + rb_y) / 2 + 80 + 1;
    }

    private boolean getHighPixelCenter(int i_st, int[] i_pixels, int i_width, int i_height, int i_th, NyARIntPoint2d o_point) {
        int rp = i_st;
        int pos_x = 0;
        int pos_y = 0;
        int number_of_pos = 0;
        int i = 0;
        while (i < i_height) {
            int i2 = 0;
            while (i2 < i_width) {
                if (i_pixels[rp++] > i_th) {
                    pos_x += i2;
                    pos_y += i;
                    ++number_of_pos;
                }
                ++i2;
            }
            ++i;
        }
        if (number_of_pos <= 0) {
            return false;
        }
        o_point.x = pos_x /= number_of_pos;
        o_point.y = pos_y /= number_of_pos;
        return true;
    }

    private int detectDataBitsIndex(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, TThreshold i_th, double[] o_index_row, double[] o_index_col) throws NyARException {
        int freq_v;
        int[] index;
        int freq_h;
        int[] freq_index1 = this.__detectDataBitsIndex_freq_index1;
        int[] freq_index2 = this.__detectDataBitsIndex_freq_index2;
        int frq_t = this.getRowFrequency(i_reader, i_raster_size, i_th.lt_y, i_th.th_h, i_th.th_l, freq_index1);
        int frq_b = this.getRowFrequency(i_reader, i_raster_size, i_th.rb_y, i_th.th_h, i_th.th_l, freq_index2);
        if (frq_t < 0 && frq_b < 0 || frq_t == frq_b) {
            return -1;
        }
        if (frq_t > frq_b) {
            freq_h = frq_t;
            index = freq_index1;
        } else {
            freq_h = frq_b;
            index = freq_index2;
        }
        int i = 0;
        while (i < freq_h + freq_h - 1) {
            o_index_row[i * 2] = (index[i + 1] - index[i]) * 2 / 5 + index[i] + 5;
            o_index_row[i * 2 + 1] = (index[i + 1] - index[i]) * 3 / 5 + index[i] + 5;
            ++i;
        }
        int frq_l = this.getColFrequency(i_reader, i_raster_size, i_th.lt_x, i_th.th_h, i_th.th_l, freq_index1);
        int frq_r = this.getColFrequency(i_reader, i_raster_size, i_th.rb_x, i_th.th_h, i_th.th_l, freq_index2);
        if (frq_l < 0 && frq_r < 0 || frq_l == frq_r) {
            return -1;
        }
        if (frq_l > frq_r) {
            freq_v = frq_l;
            index = freq_index1;
        } else {
            freq_v = frq_r;
            index = freq_index2;
        }
        if (freq_v != freq_h) {
            return -1;
        }
        int i2 = 0;
        while (i2 < freq_v + freq_v - 1) {
            int w = index[i2];
            int w2 = index[i2 + 1] - w;
            o_index_col[i2 * 2] = w2 * 2 / 5 + w + 5;
            o_index_col[i2 * 2 + 1] = w2 * 3 / 5 + w + 5;
            ++i2;
        }
        if (freq_v > 10) {
            return -1;
        }
        return freq_v;
    }

    public boolean readDataBits(INyARRgbPixelReader i_reader, NyARIntSize i_raster_size, TThreshold i_th, MarkerPattEncoder o_bitbuffer) throws NyARException {
        int raster_width = i_raster_size.w;
        int raster_height = i_raster_size.h;
        double[] index_x = this.__readDataBits_index_bit_x;
        double[] index_y = this.__readDataBits_index_bit_y;
        int size = this.detectDataBitsIndex(i_reader, i_raster_size, i_th, index_x, index_y);
        int resolution = size + size - 1;
        if (size < 0) {
            return false;
        }
        if (!o_bitbuffer.initEncoder(size - 1)) {
            return false;
        }
        double[] cpara = this._cparam;
        int[] ref_x = this._ref_x;
        int[] ref_y = this._ref_y;
        int[] pixcel_temp = this._pixcel_temp;
        double cpara_0 = cpara[0];
        double cpara_1 = cpara[1];
        double cpara_3 = cpara[3];
        double cpara_6 = cpara[6];
        int th = i_th.th;
        int p = 0;
        int i = 0;
        while (i < resolution) {
            double cy0 = 1.0 + index_y[i * 2 + 0];
            double cy1 = 1.0 + index_y[i * 2 + 1];
            double cpy0_12 = cpara_1 * cy0 + cpara[2];
            double cpy0_45 = cpara[4] * cy0 + cpara[5];
            double cpy0_7 = cpara[7] * cy0 + 1.0;
            double cpy1_12 = cpara_1 * cy1 + cpara[2];
            double cpy1_45 = cpara[4] * cy1 + cpara[5];
            double cpy1_7 = cpara[7] * cy1 + 1.0;
            int pt = 0;
            int i2 = 0;
            while (i2 < resolution) {
                int yy;
                int xx;
                double cx0 = 1.0 + index_x[i2 * 2 + 0];
                double cx1 = 1.0 + index_x[i2 * 2 + 1];
                double cp6_0 = cpara_6 * cx0;
                double cpx0_0 = cpara_0 * cx0;
                double cpx3_0 = cpara_3 * cx0;
                double cp6_1 = cpara_6 * cx1;
                double cpx0_1 = cpara_0 * cx1;
                double cpx3_1 = cpara_3 * cx1;
                double d = cp6_0 + cpy0_7;
                ref_x[pt] = xx = (int)((cpx0_0 + cpy0_12) / d);
                ref_y[pt] = yy = (int)((cpx3_0 + cpy0_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : raster_width);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : raster_height);
                }
                d = cp6_0 + cpy1_7;
                ref_x[++pt] = xx = (int)((cpx0_0 + cpy1_12) / d);
                ref_y[pt] = yy = (int)((cpx3_0 + cpy1_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : raster_width);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : raster_height);
                }
                d = cp6_1 + cpy0_7;
                ref_x[++pt] = xx = (int)((cpx0_1 + cpy0_12) / d);
                ref_y[pt] = yy = (int)((cpx3_1 + cpy0_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : raster_width);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : raster_height);
                }
                d = cp6_1 + cpy1_7;
                ref_x[++pt] = xx = (int)((cpx0_1 + cpy1_12) / d);
                ref_y[pt] = yy = (int)((cpx3_1 + cpy1_45) / d);
                if (xx < 0 || xx >= raster_width || yy < 0 || yy >= raster_height) {
                    int n = xx < 0 ? 0 : (ref_x[pt] = xx >= raster_width ? raster_width - 1 : raster_width);
                    ref_y[pt] = yy < 0 ? 0 : (yy >= raster_height ? raster_height - 1 : raster_height);
                }
                ++pt;
                ++i2;
            }
            i_reader.getPixelSet(ref_x, ref_y, resolution * 4, pixcel_temp);
            i2 = 0;
            while (i2 < resolution) {
                int index = i2 * 3 * 4;
                int pixel = (pixcel_temp[index + 0] + pixcel_temp[index + 1] + pixcel_temp[index + 2] + pixcel_temp[index + 3] + pixcel_temp[index + 4] + pixcel_temp[index + 5] + pixcel_temp[index + 6] + pixcel_temp[index + 7] + pixcel_temp[index + 8] + pixcel_temp[index + 9] + pixcel_temp[index + 10] + pixcel_temp[index + 11]) / 12;
                o_bitbuffer.setBitByBitIndex(p, pixel > th ? 0 : 1);
                ++p;
                ++i2;
            }
            ++i;
        }
        return true;
    }

    class THighAndLow {
        public int h;
        public int l;

        THighAndLow() {
        }
    }

    public static class TThreshold {
        public int th_h;
        public int th_l;
        public int th;
        public int lt_x;
        public int lt_y;
        public int rb_x;
        public int rb_y;
    }
}

