/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class CubeReader
extends AtomSetCollectionReader {
    boolean negativeAtomCount;
    int atomCount;
    boolean isAngstroms = false;
    final int[] voxelCounts = new int[3];
    final float[] origin = new float[3];
    final float[][] voxelVectors = new float[3][];

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("cube");
        try {
            this.atomSetCollection.newAtomSet();
            this.readTitleLines();
            this.readAtomCountAndOrigin();
            this.readVoxelVectors();
            this.readAtoms();
            this.readExtraLine();
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void readTitleLines() throws Exception {
        if (this.readLine().indexOf("#JVXL") == 0) {
            while (this.readLine().indexOf("#") == 0) {
            }
        }
        this.atomSetCollection.setAtomSetName(this.line.trim() + " - " + this.readLineTrimmed());
    }

    void readAtomCountAndOrigin() throws Exception {
        this.readLine();
        this.isAngstroms = this.line.indexOf("ANGSTROMS") >= 0;
        String[] stringArray = this.getTokens();
        if (stringArray[0].charAt(0) == '+') {
            stringArray[0] = '-' + stringArray[0].substring(1);
        }
        this.atomCount = this.parseInt(stringArray[0]);
        this.origin[0] = this.parseFloat(stringArray[1]);
        this.origin[1] = this.parseFloat(stringArray[2]);
        this.origin[2] = this.parseFloat(stringArray[3]);
        if (this.atomCount < 0) {
            this.atomCount = -this.atomCount;
            this.negativeAtomCount = true;
        }
    }

    void readVoxelVectors() throws Exception {
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
    }

    void readVoxelVector(int n) throws Exception {
        this.readLine();
        float[] fArray = new float[3];
        this.voxelVectors[n] = fArray;
        this.voxelCounts[n] = this.parseInt(this.line);
        fArray[0] = this.parseFloat();
        fArray[1] = this.parseFloat();
        fArray[2] = this.parseFloat();
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(this.line);
            atom.partialCharge = this.parseFloat();
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            if (this.isAngstroms) continue;
            atom.scale(0.5291772f);
        }
    }

    void readExtraLine() throws Exception {
        int n;
        if (this.negativeAtomCount) {
            this.readLine();
        }
        if ((n = this.parseInt(this.line)) != Integer.MIN_VALUE && n < 0) {
            this.atomSetCollection.setFileTypeName("jvxl");
        }
    }
}

