/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacDataReader {
    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("webmo");
        this.modelNumber = 0;
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.equals("[HEADER]")) {
                    this.readHeader();
                    continue;
                }
                if (this.line.equals("[ATOMS]")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.equals("[BONDS]")) {
                    this.readBonds();
                    continue;
                }
                if (this.line.equals("[AO_ORDER]")) {
                    this.readAtomicOrbitalOrder();
                    continue;
                }
                if (this.line.equals("[GTO]")) {
                    this.readGaussianBasis();
                    continue;
                }
                if (this.line.equals("[STO]")) {
                    this.readSlaterBasis();
                    continue;
                }
                if (this.line.indexOf("[MO") == 0) {
                    if (!this.doGetModel(++this.modelNumber)) continue;
                    this.readMolecularOrbital();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.readLine();
            }
            if (Logger.debugging) {
                Logger.debug((String)(this.orbitals.size() + " molecular orbitals read"));
            }
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    void readHeader() throws Exception {
        while (this.readLine() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] stringArray = this.getTokens();
            stringArray[0] = stringArray[0].substring(0, 1).toLowerCase() + stringArray[0].substring(1, stringArray[0].length());
            String string = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + (i == 1 ? "" : " ") + stringArray[i].toLowerCase();
            }
            this.moData.put(stringArray[0], string);
        }
    }

    void readAtoms() throws Exception {
        boolean bl;
        this.readLine();
        boolean bl2 = bl = this.parseInt(this.line) != Integer.MIN_VALUE;
        while (this.line != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() != 0) {
                Atom atom = this.atomSetCollection.addNewAtom();
                String[] stringArray = this.getTokens();
                atom.elementSymbol = bl ? AtomSetCollectionReader.getElementSymbol((int)this.parseInt(stringArray[0])) : stringArray[0];
                atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
                atom.scale(0.5291772f);
            }
            this.readLine();
        }
    }

    void readBonds() throws Exception {
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] stringArray = this.getTokens();
            int n = this.parseInt(stringArray[0]);
            int n2 = this.parseInt(stringArray[1]);
            int n3 = this.parseInt(stringArray[2]);
            this.atomSetCollection.addBond(new Bond(n - 1, n2 - 1, n3));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] stringArray = this.getTokens();
            hashtable.put(stringArray[0].substring(0, 1), stringArray);
        }
        this.moData.put("atomicOrbitalOrder", hashtable);
    }

    void readGaussianBasis() throws Exception {
        Object object;
        Vector<int[]> vector = new Vector<int[]>();
        Vector<float[]> vector2 = new Vector<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            object = this.getTokens();
            if (((float[][])object).length == 0) continue;
            if (((float[][])object).length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] nArray = new int[4];
            n = this.parseInt((String)object[0]) - 1;
            object = AtomSetCollectionReader.getTokens((String)this.readLine());
            int n3 = this.parseInt((String)object[1]);
            nArray[0] = n;
            nArray[1] = JmolAdapter.getQuantumShellTagID((String)object[0]);
            nArray[2] = n2;
            nArray[3] = n3;
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                int n4 = stringArray.length;
                float[] fArray = new float[n4];
                for (int j = 0; j < n4; ++j) {
                    fArray[j] = this.parseFloat(stringArray[j]);
                }
                vector2.addElement(fArray);
                ++n2;
            }
            vector.addElement(nArray);
        }
        object = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])vector2.get(i);
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug((String)(vector.size() + " slater shells read"));
            Logger.debug((String)(((float[][])object).length + " gaussian primitives read"));
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 7) continue;
            this.addSlater(this.parseInt(stringArray[0]) - 1, this.parseInt(stringArray[1]), this.parseInt(stringArray[2]), this.parseInt(stringArray[3]), this.parseInt(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]));
        }
        this.setSlaters();
    }

    void readMolecularOrbital() throws Exception {
        Object[] objectArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<float> vector = new Vector<float>();
        float f = this.parseFloat(this.readLine());
        float f2 = this.parseFloat(this.readLine());
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            objectArray = this.getTokens();
            vector.addElement(objectArray[1]);
        }
        objectArray = new float[vector.size()];
        int n = vector.size();
        while (--n >= 0) {
            objectArray[n] = this.parseFloat((String)vector.get(n));
        }
        hashtable.put("energy", new Float(f));
        hashtable.put("occupancy", new Float(f2));
        hashtable.put("coefficients", objectArray);
        this.orbitals.addElement(hashtable);
        this.setMOs("eV");
    }
}

