/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.TextFormat;

public class Wien2kReader
extends AtomSetCollectionReader {
    private boolean isrhombohedral;
    private char latticeCode;
    private boolean doSymmetry = true;
    private final String cxyz = " x y z";

    public void readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("wien2k");
        this.doSymmetry = !this.spaceGroup.equals("none");
        try {
            this.setFractionalCoordinates(true);
            this.atomSetCollection.setCollectionName(this.readLine());
            this.readUnitCell();
            this.readAtoms();
            this.readSymmetry();
            this.applySymmetryAndSetTrajectory();
            this.readEmbeddedScript();
        }
        catch (Exception exception) {
            this.setError(exception);
        }
    }

    private void readUnitCell() throws Exception {
        float f;
        this.readLine();
        this.latticeCode = this.line.charAt(0);
        boolean bl = this.isrhombohedral = this.latticeCode == 'R';
        if (this.line.startsWith("CYZ")) {
            this.latticeCode = (char)65;
        } else if (this.line.startsWith("CXZ")) {
            this.latticeCode = (char)66;
        } else if (this.line.startsWith("B")) {
            this.latticeCode = (char)73;
        }
        if (this.latticeCode != 'R' && this.latticeCode != 'H') {
            this.atomSetCollection.setLatticeParameter((int)this.latticeCode);
        }
        if (this.line.length() > 32) {
            String string = this.line.substring(32).trim();
            if (string.indexOf(" ") >= 0) {
                string = string.substring(string.indexOf(" ") + 1);
            }
            if (string.indexOf("_") >= 0) {
                string = string.substring(string.indexOf("_") + 1);
            }
            this.setSpaceGroupName(string);
        }
        float f2 = this.readLine().toLowerCase().indexOf("ang") >= 0 ? 1.0f : 0.5291772f;
        this.readLine();
        float f3 = this.parseFloat(this.line.substring(0, 10)) * f2;
        float f4 = this.parseFloat(this.line.substring(10, 20)) * f2;
        float f5 = this.parseFloat(this.line.substring(20, 30)) * f2;
        int n = this.line.length();
        float f6 = n >= 40 ? this.parseFloat(this.line.substring(30, 40)) : 0.0f;
        float f7 = n >= 50 ? this.parseFloat(this.line.substring(40, 50)) : 0.0f;
        float f8 = f = n >= 60 ? this.parseFloat(this.line.substring(50, 60)) : 0.0f;
        if (this.isrhombohedral) {
            float f9 = (float)Math.sqrt(f3 * f3 / 3.0f + f5 * f5 / 9.0f);
            f7 = f = (float)(Math.acos((2.0f * f5 * f5 - 3.0f * f3 * f3) / (2.0f * f5 * f5 + 6.0f * f3 * f3)) * 180.0 / Math.PI);
            f6 = f;
            f4 = f5 = f9;
            f3 = f5;
        }
        if (Float.isNaN(f6) || f6 == 0.0f) {
            f6 = 90.0f;
        }
        if (Float.isNaN(f7) || f7 == 0.0f) {
            f7 = 90.0f;
        }
        if (Float.isNaN(f) || f == 0.0f) {
            f = 90.0f;
        }
        this.setUnitCell(f3, f4, f5, f6, f7, f);
    }

    private void readAtoms() throws Exception {
        this.readLine();
        while (this.line != null && (this.line.indexOf("ATOM") == 0 || !this.doSymmetry && this.line.indexOf(":") == 8)) {
            String string;
            String string2;
            int n = this.atomSetCollection.getAtomCount();
            this.addAtom();
            if (this.readLine().indexOf("MULT=") == 10) {
                int n2 = this.parseInt(this.line.substring(15, 18));
                while (--n2 >= 0) {
                    this.readLine();
                    if (this.doSymmetry) continue;
                    this.addAtom();
                }
            }
            if ((string2 = (string = this.line.substring(0, 10)).substring(0, 2).trim()).length() == 2 && Character.isDigit(string2.charAt(1))) {
                string2 = string2.substring(0, 1);
            }
            string = TextFormat.simpleReplace((String)string, (String)" ", (String)"");
            int n3 = 0;
            int n4 = this.atomSetCollection.getAtomCount();
            while (--n4 >= n) {
                Atom atom = this.atomSetCollection.getAtom(n4);
                atom.elementSymbol = string2;
                atom.atomName = string + "_" + n3++;
            }
            while (this.readLine() != null && this.line.indexOf("ATOM") < 0 && this.line.indexOf("SYMMETRY") < 0) {
            }
        }
    }

    private void addAtom() {
        float f = this.parseFloat(this.line.substring(12, 22));
        float f2 = this.parseFloat(this.line.substring(25, 35));
        float f3 = this.parseFloat(this.line.substring(38, 48));
        Atom atom = this.atomSetCollection.addNewAtom();
        this.setAtomCoord(atom, f, f2, f3);
    }

    private void readSymmetry() throws Exception {
        int n;
        if (this.line.indexOf("SYMMETRY") < 0) {
            return;
        }
        int n2 = n = this.parseInt(this.line.substring(0, 4).trim());
        while (--n2 >= 0) {
            String string = this.getJones() + "," + this.getJones() + "," + this.getJones();
            if (this.doSymmetry) {
                this.setSymmetryOperator(string);
            }
            this.readLine();
        }
    }

    private String getJones() throws Exception {
        this.readLine();
        String string = "";
        float f = this.parseFloat(this.line.substring(6));
        for (int i = 0; i < 6; ++i) {
            if (this.line.charAt(i) == '-') {
                string = string + "-";
            }
            if (this.line.charAt(++i) != '1') continue;
            string = string + " x y z".charAt(i);
            if (f > 0.0f) {
                string = string + "+";
            }
            if (f == 0.0f) continue;
            string = string + f;
        }
        return string;
    }

    private void readEmbeddedScript() throws Exception {
        while (this.line != null) {
            this.checkLineForScript();
            this.readLine();
        }
    }
}

