/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.gstreamer.Caps;
import org.gstreamer.ClockTime;
import org.gstreamer.MiniObject;
import org.gstreamer.lowlevel.GstBufferAPI;
import org.gstreamer.lowlevel.GstMiniObjectAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;

public class Buffer
extends MiniObject {
    public static final String GTYPE_NAME = "GstBuffer";
    private static final API gst = GstNative.load(API.class);
    private final GstBufferAPI.BufferStruct struct = new GstBufferAPI.BufferStruct(this.handle());
    private ByteBuffer byteBuffer;

    public Buffer(NativeObject.Initializer init) {
        super(init);
    }

    public Buffer() {
        this(Buffer.initializer(gst.ptr_gst_buffer_new()));
    }

    public Buffer(int size) {
        this(Buffer.initializer(Buffer.allocBuffer(size)));
    }

    private static Pointer allocBuffer(int size) {
        Pointer ptr = gst.ptr_gst_buffer_new_and_alloc(size);
        if (ptr == null) {
            throw new OutOfMemoryError("Could not allocate Buffer of size " + size);
        }
        return ptr;
    }

    public Pointer getAddress() {
        return this.handle();
    }

    public Buffer createSubBuffer(int offset, int size) {
        return gst.gst_buffer_create_sub(this, offset, size);
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    public Buffer makeWritable() {
        Buffer buf = (Buffer)gst.gst_mini_object_make_writable(this);
        if (buf == null) {
            throw new NullPointerException("Could not make Buffer writable");
        }
        return buf;
    }

    public boolean isMetadataWritable() {
        return false;
    }

    public int getSize() {
        return (Integer)this.struct.readField("size");
    }

    public ClockTime getDuration() {
        return (ClockTime)this.struct.readField("duration");
    }

    public void setDuration(ClockTime dur) {
        this.struct.duration = dur;
        this.struct.writeField("duration");
    }

    public ClockTime getTimestamp() {
        return (ClockTime)this.struct.readField("timestamp");
    }

    public void setTimestamp(ClockTime timestamp) {
        this.struct.timestamp = timestamp;
        this.struct.writeField("timestamp");
    }

    public Caps getCaps() {
        return gst.gst_buffer_get_caps(this);
    }

    public void setCaps(Caps caps) {
        gst.gst_buffer_set_caps(this, caps);
    }

    public synchronized ByteBuffer getByteBuffer() {
        if (this.byteBuffer == null) {
            int size = this.getSize();
            Pointer data = (Pointer)this.struct.readField("data");
            if (data != null && size > 0) {
                this.byteBuffer = data.getByteBuffer(0L, (long)size);
            }
        }
        return this.byteBuffer;
    }

    public long getOffset() {
        return (Long)this.struct.readField("offset");
    }

    public void setOffset(long offset) {
        this.struct.offset = offset;
        this.struct.writeField("offset");
    }

    public long getLastOffset() {
        return (Long)this.struct.readField("offset_end");
    }

    public void setLastOffset(long offset) {
        this.struct.offset_end = offset;
        this.struct.writeField("offset_end");
    }

    public int getFlags() {
        return this.struct.mini_object.flags;
    }

    private static interface API
    extends GstBufferAPI,
    GstMiniObjectAPI {
        @CallerOwnsReturn
        public Pointer ptr_gst_buffer_new();

        @CallerOwnsReturn
        public Pointer ptr_gst_buffer_new_and_alloc(int var1);
    }
}

