/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Platform;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Message;
import org.gstreamer.State;
import org.gstreamer.TagList;
import org.gstreamer.TestPipe;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstBusAPI;
import org.gstreamer.lowlevel.GstElementAPI;
import org.gstreamer.lowlevel.GstMessageAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.message.EOSMessage;
import org.gstreamer.message.StateChangedMessage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BusTest {
    private static final API gst = GstNative.load(API.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("BusTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void endOfStream() {
        final TestPipe pipe = new TestPipe("endOfStream");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.EOS eosSignal = new Bus.EOS(){

            public void endOfStream(GstObject source) {
                signalFired.set(true);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(eosSignal);
        for (Element elem : pipe.pipe.getSinks()) {
            gst.gst_element_post_message(elem, gst.gst_message_new_eos(elem));
        }
        pipe.run();
        pipe.getBus().disconnect(eosSignal);
        Assert.assertTrue((String)"EOS signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void stateChanged() {
        final TestPipe pipe = new TestPipe("stateChanged");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        Bus.STATE_CHANGED stateChanged = new Bus.STATE_CHANGED(){

            public void stateChanged(GstObject source, State old, State current, State pending) {
                if (pending == State.PLAYING || current == State.PLAYING) {
                    signalFired.set(true);
                    pipe.quit();
                }
            }
        };
        pipe.getBus().connect(stateChanged);
        gst.gst_element_post_message(pipe.pipe, new StateChangedMessage(pipe.pipe, State.READY, State.PLAYING, State.VOID_PENDING));
        pipe.run();
        pipe.getBus().disconnect(stateChanged);
        Assert.assertTrue((String)"STATE_CHANGED signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void errorMessage() {
        final TestPipe pipe = new TestPipe("errorMessage");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.ERROR errorSignal = new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                signalFired.set(true);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(errorSignal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_error(pipe.src, msg, "testing error messages"));
        pipe.play().run();
        pipe.getBus().disconnect(errorSignal);
        pipe.dispose();
        Assert.assertTrue((String)"ERROR signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void warningMessage() {
        final TestPipe pipe = new TestPipe("warningMessage");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.WARNING signal = new Bus.WARNING(){

            public void warningMessage(GstObject source, int code, String message) {
                signalFired.set(true);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(signal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        pipe.play();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_warning(pipe.src, msg, "testing warning messages"));
        pipe.run();
        pipe.getBus().disconnect(signal);
        pipe.dispose();
        Assert.assertTrue((String)"WARNING signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void infoMessage() {
        if (Platform.isWindows()) {
            return;
        }
        final TestPipe pipe = new TestPipe("infoMessage");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.INFO signal = new Bus.INFO(){

            public void infoMessage(GstObject source, int code, String message) {
                signalFired.set(true);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(signal);
        GstAPI.GErrorStruct msg = new GstAPI.GErrorStruct();
        pipe.play();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_info(pipe.src, msg, "testing warning messages"));
        pipe.run();
        pipe.getBus().disconnect(signal);
        pipe.dispose();
        Assert.assertTrue((String)"INFO signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void bufferingData() {
        final TestPipe pipe = new TestPipe("bufferingData");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicInteger signalValue = new AtomicInteger(-1);
        final AtomicReference signalSource = new AtomicReference();
        int PERCENT = 95;
        Bus.BUFFERING signal = new Bus.BUFFERING(){

            public void bufferingData(GstObject source, int percent) {
                signalFired.set(true);
                signalValue.set(percent);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(signal);
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_buffering(pipe.src, 95));
        pipe.play().run();
        pipe.getBus().disconnect(signal);
        pipe.dispose();
        Assert.assertTrue((String)"BUFFERING signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Wrong percent value received for signal", (long)95L, (long)signalValue.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void tagsFound() {
        final TestPipe pipe = new TestPipe("tagsFound");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.TAG signal = new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                signalFired.set(true);
                signalSource.set(source);
                pipe.quit();
            }
        };
        pipe.getBus().connect(signal);
        TagList tagList = new TagList();
        gst.gst_element_post_message(pipe.src, gst.gst_message_new_tag(pipe.src, tagList));
        pipe.play().run();
        pipe.getBus().disconnect(signal);
        pipe.dispose();
        Assert.assertTrue((String)"TAG signal not received", (boolean)signalFired.get());
        Assert.assertEquals((String)"Incorrect source object on signal", (Object)pipe.src, signalSource.get());
    }

    @Test
    public void anyMessage() {
        final TestPipe pipe = new TestPipe("anyMessage");
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.MESSAGE listener = new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalSource.set(msg.getSource());
                pipe.quit();
            }
        };
        pipe.getBus().connect(listener);
        for (Element elem : pipe.pipe.getSinks()) {
            gst.gst_element_post_message(elem, gst.gst_message_new_eos(elem));
        }
        pipe.play().run();
        pipe.getBus().disconnect(listener);
        Assert.assertTrue((String)"EOS signal not received", (boolean)signalFired.get());
        pipe.dispose();
    }

    @Test
    public void postMessage() {
        final TestPipe pipe = new TestPipe();
        final AtomicBoolean signalFired = new AtomicBoolean(false);
        final AtomicReference signalSource = new AtomicReference();
        Bus.MESSAGE listener = new Bus.MESSAGE(){

            public void busMessage(Bus bus, Message msg) {
                signalFired.set(true);
                signalSource.set(msg.getSource());
                pipe.quit();
            }
        };
        pipe.getBus().connect(listener);
        pipe.getBus().post(new EOSMessage(pipe.src));
        pipe.run();
        Assert.assertTrue((String)"Message not posted", (boolean)signalFired.get());
        Assert.assertEquals((String)"Wrong source in message", (Object)pipe.src, signalSource.get());
    }

    private static interface API
    extends GstBusAPI,
    GstElementAPI,
    GstMessageAPI {
    }
}

