/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Library;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.IntegerEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventType implements IntegerEnum
{
    UNKNOWN(0, 0),
    FLUSH_START(1, 3),
    FLUSH_STOP(2, 7),
    EOS(5, 6),
    NEWSEGMENT(6, 6),
    TAG(7, 6),
    BUFFERSIZE(8, 6),
    QOS(15, 1),
    SEEK(16, 1),
    NAVIGATION(17, 1),
    LATENCY(18, 1),
    CUSTOM_UPSTREAM(32, 1),
    CUSTOM_DOWNSTREAM(32, 6),
    CUSTOM_DOWNSTREAM_OOB(32, 2),
    CUSTOM_BOTH(32, 7),
    CUSTOM_BOTH_OOB(32, 3);

    private static final API gst;
    private static final int SHIFT = 4;
    private final int value;

    static {
        gst = GstNative.load(API.class);
    }

    private EventType(int num, int flags) {
        this.value = num << 4 | flags;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public String getName() {
        return gst.gst_event_type_get_name(this);
    }

    public static EventType valueOf(String string) {
        return Enum.valueOf(EventType.class, string);
    }

    private static interface API
    extends Library {
        public String gst_event_type_get_name(EventType var1);
    }

    private static final class Flags {
        public static final int UPSTREAM = 1;
        public static final int DOWNSTREAM = 2;
        public static final int SERIALIZED = 4;
        public static final int BOTH = 3;

        private Flags() {
        }
    }
}

