/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.lang.ref.WeakReference;
import org.gstreamer.Bin;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.Tracker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarbageCollectionTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("test", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public static boolean waitGC(WeakReference<?> ref) {
        System.gc();
        int i = 0;
        while (ref.get() != null && i < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.gc();
            ++i;
        }
        return ref.get() == null;
    }

    @Test
    public void testElement() throws Exception {
        Element e = ElementFactory.make("fakesrc", "test element");
        Tracker tracker = new Tracker(e);
        e = null;
        Assert.assertTrue((String)"Element not garbage collected", (boolean)tracker.waitGC());
        Assert.assertTrue((String)"GObject not destroyed", (boolean)tracker.waitDestroyed());
    }

    @Test
    public void testBin() throws Exception {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        Assert.assertEquals((String)"source not returned", (Object)e1, (Object)bin.getElementByName("source"));
        Assert.assertEquals((String)"sink not returned", (Object)e2, (Object)bin.getElementByName("sink"));
        WeakReference<Bin> binRef = new WeakReference<Bin>(bin);
        bin = null;
        Assert.assertTrue((String)"Bin not garbage collected", (boolean)GarbageCollectionTest.waitGC(binRef));
        WeakReference<Element> e1Ref = new WeakReference<Element>(e1);
        WeakReference<Element> e2Ref = new WeakReference<Element>(e2);
        e1 = null;
        e2 = null;
        Assert.assertTrue((String)"First Element not garbage collected", (boolean)GarbageCollectionTest.waitGC(e1Ref));
        Assert.assertTrue((String)"Second Element not garbage collected", (boolean)GarbageCollectionTest.waitGC(e2Ref));
    }

    @Test
    public void testBinRetrieval() throws Exception {
        Bin bin = new Bin("test");
        Element e1 = ElementFactory.make("fakesrc", "source");
        Element e2 = ElementFactory.make("fakesink", "sink");
        bin.addMany(e1, e2);
        int id1 = System.identityHashCode(e1);
        int id2 = System.identityHashCode(e2);
        e1 = null;
        e2 = null;
        System.gc();
        Thread.sleep(10L);
        Assert.assertEquals((String)"source ID does not match", (long)id1, (long)System.identityHashCode(bin.getElementByName("source")));
        Assert.assertEquals((String)"sink ID does not match", (long)id2, (long)System.identityHashCode(bin.getElementByName("sink")));
    }

    @Test
    public void pipeline() {
        Pipeline pipe = new Pipeline("test");
        Tracker pipeTracker = new Tracker(pipe);
        pipe = null;
        Assert.assertTrue((String)"Pipe not garbage collected", (boolean)pipeTracker.waitGC());
        System.out.println("checking if pipeline is destroyed");
        Assert.assertTrue((String)"Pipe not destroyed", (boolean)pipeTracker.waitDestroyed());
    }

    @Test
    public void pipelineBus() {
        Pipeline pipe = new Pipeline("test");
        Bus bus = pipe.getBus();
        Tracker busTracker = new Tracker(bus);
        Tracker pipeTracker = new Tracker(pipe);
        pipe = null;
        bus = null;
        Assert.assertTrue((String)"Bus not garbage collected", (boolean)busTracker.waitGC());
        Assert.assertTrue((String)"Bus not destroyed", (boolean)busTracker.waitDestroyed());
        Assert.assertTrue((String)"Pipe not garbage collected", (boolean)pipeTracker.waitGC());
        Assert.assertTrue((String)"Pipe not destroyed", (boolean)pipeTracker.waitDestroyed());
    }

    @Test
    public void busWithListeners() {
        Pipeline pipe = new Pipeline("test");
        Bus bus = pipe.getBus();
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject source) {
            }
        });
        Tracker busTracker = new Tracker(bus);
        Tracker pipeTracker = new Tracker(pipe);
        bus = null;
        pipe = null;
        Assert.assertTrue((String)"Bus not garbage collected", (boolean)busTracker.waitGC());
        Assert.assertTrue((String)"Bus not destroyed", (boolean)busTracker.waitDestroyed());
        Assert.assertTrue((String)"Pipe not garbage collected", (boolean)pipeTracker.waitGC());
        Assert.assertTrue((String)"Pipe not destroyed", (boolean)pipeTracker.waitDestroyed());
    }
}

