/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Clock;
import org.gstreamer.DateTime;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Event;
import org.gstreamer.GError;
import org.gstreamer.GhostPad;
import org.gstreamer.GstException;
import org.gstreamer.Message;
import org.gstreamer.Pad;
import org.gstreamer.PadTemplate;
import org.gstreamer.Pipeline;
import org.gstreamer.Plugin;
import org.gstreamer.PluginFeature;
import org.gstreamer.Query;
import org.gstreamer.Registry;
import org.gstreamer.ValueList;
import org.gstreamer.Version;
import org.gstreamer.elements.AppSink;
import org.gstreamer.elements.AppSrc;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.BaseSrc;
import org.gstreamer.elements.BaseTransform;
import org.gstreamer.elements.DecodeBin;
import org.gstreamer.elements.DecodeBin2;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.elements.FakeSrc;
import org.gstreamer.elements.FileSink;
import org.gstreamer.elements.FileSrc;
import org.gstreamer.elements.Identity;
import org.gstreamer.elements.InputSelector;
import org.gstreamer.elements.MultiQueue;
import org.gstreamer.elements.OSXVideoSink;
import org.gstreamer.elements.PlayBin;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.Queue;
import org.gstreamer.elements.Queue2;
import org.gstreamer.elements.Tee;
import org.gstreamer.elements.TypeFind;
import org.gstreamer.elements.good.RTPBin;
import org.gstreamer.elements.good.RTSPSrc;
import org.gstreamer.glib.GDate;
import org.gstreamer.glib.MainContextExecutorService;
import org.gstreamer.interfaces.ColorBalanceChannel;
import org.gstreamer.interfaces.MixerTrack;
import org.gstreamer.interfaces.TunerChannel;
import org.gstreamer.interfaces.TunerNorm;
import org.gstreamer.lowlevel.GMainContext;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstControlSourceAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gst {
    private static Logger logger = Logger.getLogger(Gst.class.getName());
    private static ScheduledExecutorService executorService;
    private static volatile CountDownLatch quit;
    private static GMainContext mainContext;
    private static boolean useDefaultContext;
    private static final AtomicInteger initCount;
    private static List<Runnable> shutdownTasks;
    private static final GstAPI gst;
    private static final ThreadFactory threadFactory;
    private static Class[] nativeClasses;

    static {
        quit = new CountDownLatch(1);
        useDefaultContext = false;
        initCount = new AtomicInteger(0);
        shutdownTasks = Collections.synchronizedList(new ArrayList());
        gst = GstNative.load(GstAPI.class);
        threadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            private ThreadGroup getThreadGroup() {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                try {
                    Class<?> atgClass = Class.forName("sun.applet.AppletThreadGroup");
                    return atgClass.isInstance(tg) ? tg.getParent() : null;
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public Thread newThread(Runnable task) {
                String name = "gstreamer service thread " + this.counter.incrementAndGet();
                Thread t = new Thread(this.getThreadGroup(), task, name);
                t.setDaemon(true);
                t.setPriority(5);
                return t;
            }
        };
        nativeClasses = new Class[]{GDate.class, GValueAPI.GValue.class, GValueAPI.GValueArray.class, GstControlSourceAPI.TimedValue.class, ValueList.class, GstControlSourceAPI.ValueArray.class, ColorBalanceChannel.class, MixerTrack.class, TunerChannel.class, TunerNorm.class, Bus.class, Caps.class, Clock.class, DateTime.class, Element.class, ElementFactory.class, GhostPad.class, Pad.class, PadTemplate.class, Plugin.class, PluginFeature.class, Registry.class, Buffer.class, Event.class, Message.class, Query.class, AppSink.class, AppSrc.class, BaseSrc.class, BaseSink.class, BaseTransform.class, Bin.class, DecodeBin.class, DecodeBin2.class, FakeSink.class, FakeSrc.class, FileSink.class, FileSrc.class, Identity.class, InputSelector.class, MultiQueue.class, OSXVideoSink.class, Pipeline.class, PlayBin.class, PlayBin2.class, Queue.class, Queue2.class, Tee.class, TypeFind.class, RTPBin.class, RTSPSrc.class};
    }

    private Gst() {
    }

    public static Version getVersion() {
        long[] major = new long[1];
        long[] minor = new long[1];
        long[] micro = new long[1];
        long[] nano = new long[1];
        gst.gst_version(major, minor, micro, nano);
        return new Version(major[0], minor[0], micro[0], nano[0]);
    }

    public static String getVersionString() {
        return gst.gst_version_string();
    }

    public static boolean isSegTrapEnabled() {
        return gst.gst_segtrap_is_enabled();
    }

    public static void setSegTrap(boolean enabled) {
        gst.gst_segtrap_set_enabled(enabled);
    }

    public static final synchronized boolean isInitialized() {
        return initCount.get() > 0;
    }

    public static Executor getExecutor() {
        return Gst.getScheduledExecutorService();
    }

    public static ExecutorService getExecutorService() {
        return Gst.getScheduledExecutorService();
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return executorService;
    }

    public static void quit() {
        quit.countDown();
    }

    public static void main() {
        try {
            try {
                CountDownLatch latch = quit;
                if (latch != null) {
                    latch.await();
                }
            }
            catch (InterruptedException interruptedException) {
                quit = new CountDownLatch(1);
            }
        }
        finally {
            quit = new CountDownLatch(1);
        }
    }

    public static void invokeLater(Runnable task) {
        Gst.getExecutor().execute(task);
    }

    public static void invokeAndWait(Runnable task) {
        try {
            Gst.getExecutorService().submit(task).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static GMainContext getMainContext() {
        return mainContext;
    }

    public static final void init() throws GstException {
        Gst.init("unknown", new String[0]);
    }

    public static final synchronized String[] init(String progname, String[] args) throws GstException {
        if (initCount.getAndIncrement() > 0) {
            return args;
        }
        NativeArgs argv = new NativeArgs(progname, args);
        Logger.getLogger("org.gstreamer").setLevel(Level.WARNING);
        Pointer[] error = new Pointer[1];
        if (!gst.gst_init_check(argv.argcRef, argv.argvRef, error)) {
            initCount.decrementAndGet();
            throw new GstException(new GError(new GstAPI.GErrorStruct(error[0])));
        }
        logger.fine("after gst_init, argc=" + argv.argcRef.getValue());
        if (useDefaultContext) {
            mainContext = GMainContext.getDefaultContext();
            executorService = new MainContextExecutorService(mainContext);
        } else {
            mainContext = new GMainContext();
            executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        }
        quit = new CountDownLatch(1);
        Gst.loadAllClasses();
        return argv.toStringArray();
    }

    public static final synchronized void deinit() {
        if (initCount.decrementAndGet() > 0) {
            return;
        }
        Object[] objectArray = shutdownTasks.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object task = objectArray[n2];
            ((Runnable)task).run();
            ++n2;
        }
        executorService.shutdown();
        Gst.quit();
        try {
            if (!executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mainContext = null;
        System.gc();
        gst.gst_deinit();
    }

    public static void addStaticShutdownTask(Runnable task) {
        shutdownTasks.add(task);
    }

    public static void setUseDefaultContext(boolean useDefault) {
        useDefaultContext = useDefault;
    }

    private static String getField(Class<? extends NativeObject> cls, String name) throws SecurityException, IllegalArgumentException {
        try {
            Field f = cls.getDeclaredField(name);
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isFinal(mod) && f.getType().equals(String.class)) {
                f.setAccessible(true);
                return (String)f.get(null);
            }
        }
        catch (NoSuchFieldException f) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static synchronized void loadAllClasses() {
        Class[] classArray = nativeClasses;
        int n = nativeClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            String value = null;
            value = Gst.getField(cls, "GTYPE_NAME");
            if (value != null) {
                GstTypes.registerType(cls, value);
            }
            value = Gst.getField(cls, "GST_NAME");
            if (Element.class.isAssignableFrom(cls) && value != null) {
                ElementFactory.registerElement(cls, value);
            }
            ++n2;
        }
    }

    public static class NativeArgs {
        public IntByReference argcRef;
        public PointerByReference argvRef;
        Memory[] argsCopy;
        Memory argvMemory;

        public NativeArgs(String progname, String[] args) {
            this.argsCopy = new Memory[args.length + 2];
            this.argvMemory = new Memory((long)(this.argsCopy.length * Pointer.SIZE));
            Memory arg = new Memory((long)(progname.length() + 4));
            arg.setString(0L, progname, false);
            this.argsCopy[0] = arg;
            int i = 0;
            while (i < args.length) {
                arg = new Memory((long)(args[i].length() + 1));
                arg.setString(0L, args[i], false);
                this.argsCopy[i + 1] = arg;
                ++i;
            }
            this.argvMemory.write(0L, (Pointer[])this.argsCopy, 0, this.argsCopy.length);
            this.argvRef = new PointerByReference((Pointer)this.argvMemory);
            this.argcRef = new IntByReference(args.length + 1);
        }

        String[] toStringArray() {
            ArrayList<String> args = new ArrayList<String>();
            Pointer argv = this.argvRef.getValue();
            int i = 1;
            while (i < this.argcRef.getValue()) {
                Pointer arg = argv.getPointer((long)(i * Pointer.SIZE));
                if (arg != null) {
                    args.add(arg.getString(0L, false));
                }
                ++i;
            }
            return args.toArray(new String[args.size()]);
        }
    }
}

