/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gstreamer.lowlevel.GstIteratorAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GstIterator<T extends NativeObject>
extends NativeObject
implements Iterable<T> {
    private static final GstIteratorAPI gst = GstNative.load(GstIteratorAPI.class);
    private Class<T> objectType;

    GstIterator(Pointer ptr, Class<T> cls) {
        super(GstIterator.initializer(ptr));
        this.objectType = cls;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    @Override
    protected void disposeNativeHandle(Pointer ptr) {
        gst.gst_iterator_free(ptr);
    }

    public List<T> asList() {
        LinkedList<NativeObject> list = new LinkedList<NativeObject>();
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            list.add((NativeObject)it.next());
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IteratorImpl
    implements Iterator<T> {
        T next = this.getNext();

        IteratorImpl() {
        }

        private T getNext() {
            PointerByReference nextRef = new PointerByReference();
            if (gst.gst_iterator_next(GstIterator.this.handle(), nextRef) == 1) {
                return NativeObject.objectFor(nextRef.getValue(), GstIterator.this.objectType, -1, true);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object result = this.next;
            this.next = this.getNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Items cannot be removed.");
        }
    }
}

