/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gstreamer.ClockTime;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.Query;
import org.gstreamer.QueryType;
import org.gstreamer.Structure;
import org.gstreamer.lowlevel.GstMiniObjectAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstQueryAPI;
import org.gstreamer.query.ApplicationQuery;
import org.gstreamer.query.DurationQuery;
import org.gstreamer.query.FormatsQuery;
import org.gstreamer.query.LatencyQuery;
import org.gstreamer.query.PositionQuery;
import org.gstreamer.query.SeekingQuery;
import org.gstreamer.query.SegmentQuery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        Gst.init("QueryTest", new String[0]);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void gst_query_new_position() {
        Query query = GstQueryAPI.GSTQUERY_API.gst_query_new_position(Format.TIME);
        Assert.assertNotNull((String)"Query.newPosition returned null", (Object)query);
        Assert.assertTrue((String)"Returned query not instance of PositionQuery", (boolean)(query instanceof PositionQuery));
    }

    @Test
    public void getPositionQueryFormat() {
        Format[] formatArray = Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            PositionQuery query = new PositionQuery(format);
            Assert.assertEquals((String)"Format returned from getFormat() is incorrect", (Object)format, (Object)query.getFormat());
            ++n2;
        }
    }

    @Test
    public void getPosition() {
        PositionQuery query = new PositionQuery(Format.TIME);
        long POSITION = -559038737L;
        query.setPosition(Format.TIME, -559038737L);
        Assert.assertEquals((String)"Incorrect position returned", (long)-559038737L, (long)query.getPosition());
    }

    @Test
    public void positionQueryToString() {
        PositionQuery query = new PositionQuery(Format.TIME);
        query.setPosition(Format.TIME, 1234L);
        String s = query.toString();
        Assert.assertTrue((String)"toString() did not return format", (boolean)s.contains("format=TIME"));
        Assert.assertTrue((String)"toString() did not return position", (boolean)s.contains("position=1234"));
    }

    @Test
    public void newDurationQuery() {
        DurationQuery query = new DurationQuery(Format.TIME);
        Assert.assertNotNull((String)"Query.newDuration returned null", (Object)query);
        Assert.assertTrue((String)"Returned query not instance of DurationQuery", (boolean)(query instanceof DurationQuery));
    }

    @Test
    public void gst_query_new_duration() {
        Query query = GstQueryAPI.GSTQUERY_API.gst_query_new_duration(Format.TIME);
        Assert.assertNotNull((String)"Query.newDuration returned null", (Object)query);
        Assert.assertTrue((String)"Returned query not instance of DurationQuery", (boolean)(query instanceof DurationQuery));
    }

    @Test
    public void getDurationQueryFormat() {
        Format[] formatArray = Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            DurationQuery query = new DurationQuery(format);
            Assert.assertEquals((String)"Format returned from getFormat() is incorrect", (Object)format, (Object)query.getFormat());
            ++n2;
        }
    }

    @Test
    public void getDuration() {
        DurationQuery query = new DurationQuery(Format.TIME);
        long DURATION2 = -559038737L;
        query.setDuration(Format.TIME, -559038737L);
        Assert.assertEquals((String)"Incorrect duration returned", (long)-559038737L, (long)query.getDuration());
    }

    @Test
    public void durationQueryToString() {
        DurationQuery query = new DurationQuery(Format.TIME);
        query.setDuration(Format.TIME, 1234L);
        String s = query.toString();
        Assert.assertTrue((String)"toString() did not return format", (boolean)s.contains("format=TIME"));
        Assert.assertTrue((String)"toString() did not return duration", (boolean)s.contains("duration=1234"));
    }

    @Test
    public void gst_query_new_latency() {
        Query query = GstQueryAPI.GSTQUERY_API.gst_query_new_latency();
        Assert.assertNotNull((String)"gst_query_new_latency() returned null", (Object)query);
        Assert.assertTrue((String)"Returned query not instance of LatencyQuery", (boolean)(query instanceof LatencyQuery));
    }

    @Test
    public void latencyIsLive() {
        LatencyQuery query = new LatencyQuery();
        query.setLatency(true, ClockTime.ZERO, ClockTime.ZERO);
        Assert.assertTrue((String)"isLive not set to true", (boolean)query.isLive());
        query.setLatency(false, ClockTime.ZERO, ClockTime.ZERO);
        Assert.assertFalse((String)"isLive not set to true", (boolean)query.isLive());
    }

    @Test
    public void getMinimumLatency() {
        LatencyQuery query = new LatencyQuery();
        ClockTime MIN = ClockTime.fromMillis(13000L);
        query.setLatency(false, MIN, ClockTime.valueOf(-1L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Min latency not set", (Object)MIN, (Object)query.getMinimumLatency());
    }

    @Test
    public void getMaximumLatency() {
        LatencyQuery query = new LatencyQuery();
        ClockTime MAX = ClockTime.fromMillis(123000L);
        query.setLatency(false, ClockTime.ZERO, MAX);
        Assert.assertEquals((String)"Min latency not set", (Object)MAX, (Object)query.getMaximumLatency());
    }

    @Test
    public void latencyQueryToString() {
        LatencyQuery query = new LatencyQuery();
        ClockTime minLatency = ClockTime.fromMillis(13000L);
        ClockTime maxLatency = ClockTime.fromMillis(200000L);
        query.setLatency(true, minLatency, maxLatency);
        String s = query.toString();
        Assert.assertTrue((String)"toString() did not return isLive", (boolean)s.contains("live=true"));
        Assert.assertTrue((String)"toString() did not return minLatency", (boolean)s.contains("min=" + minLatency));
        Assert.assertTrue((String)"toString() did not return minLatency", (boolean)s.contains("max=" + maxLatency));
    }

    @Test
    public void applicationQuery() {
        QueryType type = GstQueryAPI.GSTQUERY_API.gst_query_type_register("application_test", "An application query");
        Structure s = new Structure("test");
        ApplicationQuery query = new ApplicationQuery(type, s);
        s = query.getStructure();
        query.dispose();
    }

    @Test
    public void segmentQuery() {
        SegmentQuery query = new SegmentQuery(Format.TIME);
        ClockTime end = ClockTime.fromMillis(1000L);
        query.setSegment(1.0, Format.TIME, 0L, end.toNanos());
        Assert.assertEquals((String)"Format not set correctly", (Object)Format.TIME, (Object)query.getFormat());
        Assert.assertEquals((String)"Start time not set correctly", (long)0L, (long)query.getStart());
        Assert.assertEquals((String)"End time not set correctly", (long)end.toNanos(), (long)query.getEnd());
    }

    @Test
    public void seekingQuery() {
        SeekingQuery query = new SeekingQuery(Format.TIME);
        ClockTime start = ClockTime.ZERO;
        ClockTime end = ClockTime.fromMillis(1000L);
        query.setSeeking(Format.TIME, true, start.toNanos(), end.toNanos());
        Assert.assertEquals((String)"Format not set", (Object)Format.TIME, (Object)query.getFormat());
        Assert.assertEquals((String)"Start time not set", (long)start.toNanos(), (long)query.getStart());
        Assert.assertEquals((String)"End time not set", (long)end.toNanos(), (long)query.getEnd());
    }

    @Test
    public void formatsQuery() {
        Query query = GstQueryAPI.GSTQUERY_API.gst_query_new_formats();
        Assert.assertNotNull((String)"gst_query_new_latency() returned null", (Object)query);
        Assert.assertTrue((String)"Returned query not instance of LatencyQuery", (boolean)(query instanceof FormatsQuery));
    }

    @Test
    public void formatsQueryCount() {
        FormatsQuery query = new FormatsQuery();
        query.setFormats(Format.TIME, Format.PERCENT);
        Assert.assertEquals((String)"Wrong formats count", (long)2L, (long)query.getCount());
    }

    @Test
    public void formatsQueryFormats() {
        FormatsQuery query = new FormatsQuery();
        query.setFormats(Format.TIME, Format.PERCENT);
        Assert.assertEquals((String)"First format incorrect", (Object)Format.TIME, (Object)query.getFormat(0));
        Assert.assertEquals((String)"Second format incorrect", (Object)Format.PERCENT, (Object)query.getFormat(1));
        List<Format> formats = query.getFormats();
        Assert.assertEquals((String)"First format incorrect", (Object)Format.TIME, (Object)formats.get(0));
        Assert.assertEquals((String)"Second format incorrect", (Object)Format.PERCENT, (Object)formats.get(1));
    }

    @Test
    public void queryTypeNick() {
        QueryType qt = QueryType.POSITION;
        Assert.assertEquals((String)"nick mismatch", (Object)qt, (Object)QueryType.fromNick(qt.getName()));
    }

    @Test
    public void customQueryType() {
        QueryType qt = GstQueryAPI.GSTQUERY_API.gst_query_type_register("test", "A test query type");
        Assert.assertEquals((String)"nick mismatch", (Object)qt, (Object)QueryType.fromNick("test"));
    }

    @Test
    public void makeWriteable() {
        Query query = new SegmentQuery(Format.TIME);
        Assert.assertTrue((String)"New query is not writable", (boolean)query.isWritable());
        GstNative.load(GstMiniObjectAPI.class).gst_mini_object_ref(query);
        Assert.assertFalse((String)"Query with multiple references should not be writable", (boolean)query.isWritable());
        query = query.makeWritable();
        Assert.assertTrue((String)"Query not writable after makeWritable", (boolean)query.isWritable());
    }
}

