/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GObject;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.StreamInfo;
import org.gstreamer.Tracker;
import org.gstreamer.elements.PlayBin;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StreamInfoTest {
    private static File testSrc;
    private PlayBin playBin;
    private StreamInfo videoStream;
    private StreamInfo audioStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Gst.init("StreamInfoTest", new String[0]);
        final String sync = "";
        final AtomicBoolean success = new AtomicBoolean();
        final AtomicReference<String> error = new AtomicReference<String>("");
        testSrc = File.createTempFile("StreamInfoTest-", ".ogg");
        testSrc.deleteOnExit();
        Pipeline p = Pipeline.launch(String.format("videotestsrc num-buffers=25 ! theoraenc ! oggmux name=mux ! filesink location=%s audiotestsrc num-buffers=44 !  vorbisenc ! mux.", testSrc.getAbsolutePath()));
        Bus bus = p.getBus();
        bus.connect(new Bus.EOS(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void endOfStream(GstObject source) {
                Object object = sync;
                synchronized (object) {
                    sync.notify();
                }
                success.set(true);
            }
        });
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                error.set(": " + message);
            }
        });
        String string = sync;
        synchronized (string) {
            p.play();
            sync.wait(10000L);
            p.stop();
        }
        if (!success.get()) {
            throw new Exception("could not create test src file" + error.get());
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Gst.deinit();
    }

    @Before
    public void setUp() throws Exception {
        this.playBin = new PlayBin("playbin", testSrc.toURI());
        Element videoSink = ElementFactory.make("fakesink", "videosink");
        Element audioSink = ElementFactory.make("fakesink", "audiosink");
        this.playBin.setVideoSink(videoSink);
        this.playBin.setAudioSink(audioSink);
        State state = State.PAUSED;
        long timeout = 1000L;
        this.waitState(state, 1000L);
        StreamInfo[] streams = this.getStreamInfo();
        this.videoStream = streams[0];
        this.audioStream = streams[1];
    }

    private StreamInfo[] getStreamInfo() throws Exception {
        List<StreamInfo> list = this.playBin.getStreamInfo();
        Assert.assertEquals((long)2L, (long)list.size());
        StreamInfo s1 = list.get(0);
        StreamInfo s2 = list.get(1);
        String codec1 = s1.getCodec();
        String codec2 = s2.getCodec();
        StreamInfo video = "Theora".equals(codec1) ? s1 : s2;
        StreamInfo audio = "Vorbis".equals(codec2) ? s2 : s1;
        return new StreamInfo[]{video, audio};
    }

    private void waitState(State state, long timeout) throws Exception {
        Exception exception = new Exception(String.format("playbin refuses to go into the '%s' state", state));
        switch (this.playBin.setState(state)) {
            case SUCCESS: {
                break;
            }
            case ASYNC: {
                if (this.playBin.getState(timeout, TimeUnit.MILLISECONDS) == state) break;
                throw exception;
            }
            default: {
                throw exception;
            }
        }
    }

    @Test
    public void testGetStreamType() {
        Assert.assertEquals((Object)((Object)StreamInfo.StreamType.VIDEO), (Object)((Object)this.videoStream.getStreamType()));
        Assert.assertEquals((Object)((Object)StreamInfo.StreamType.AUDIO), (Object)((Object)this.audioStream.getStreamType()));
    }

    @Test
    public void testGetMute() {
        Assert.assertEquals((Object)false, (Object)this.audioStream.getMute());
        this.audioStream.set("mute", true);
        Assert.assertEquals((Object)true, (Object)this.audioStream.getMute());
    }

    @Test
    public void testGetCaps() {
        Caps videoCaps = this.videoStream.getCaps();
        Caps audioCaps = this.audioStream.getCaps();
        Caps videoYuv = Caps.fromString("video/x-raw-yuv");
        Caps audioFloat = Caps.fromString("audio/x-raw-float");
        Assert.assertTrue((boolean)videoCaps.isSubset(videoYuv));
        Assert.assertTrue((boolean)audioCaps.isSubset(audioFloat));
    }

    @Test
    public void testUseStreamInfoAfterBinStop() throws Exception {
        this.waitState(State.NULL, 1000L);
        Assert.assertEquals((Object)State.NULL, (Object)this.playBin.getState());
        Tracker binTracker = new Tracker(this.playBin);
        this.playBin = null;
        Assert.assertTrue((String)"Bin not garbage collected", (boolean)binTracker.waitGC());
        Assert.assertTrue((String)"Bin not destroyed", (boolean)binTracker.waitDestroyed());
        Assert.assertTrue((!this.videoStream.getMute() ? 1 : 0) != 0);
    }

    @Test
    public void testStreamInfoGC() throws Exception {
        StreamInfo[] streams = this.getStreamInfo();
        int i = 0;
        while (i < 100) {
            this.getStreamInfo();
            ++i;
        }
        this.waitState(State.NULL, 1000L);
        Assert.assertEquals((Object)State.NULL, (Object)this.playBin.getState());
        Tracker binTracker = new Tracker(this.playBin);
        this.playBin = null;
        GObjectRipper videoRipper = new GObjectRipper("local Video StreamInfo", streams[0]);
        GObjectRipper audioRipper = new GObjectRipper("local Audio StreamInfo", streams[1]);
        streams[0] = null;
        streams[1] = null;
        GObjectRipper videoRipper0 = new GObjectRipper("Video StreamInfo", this.videoStream);
        this.videoStream = null;
        GObjectRipper audioRipper0 = new GObjectRipper("Audio StreamInfo", this.audioStream);
        this.audioStream = null;
        videoRipper.rip(false);
        videoRipper0.rip(true);
        audioRipper.rip(false);
        audioRipper0.rip(true);
        Assert.assertTrue((String)"Bin not garbage collected", (boolean)binTracker.waitGC());
        Assert.assertTrue((String)"Bin not destroyed", (boolean)binTracker.waitDestroyed());
    }

    private static class GObjectRipper {
        GObject obj;
        final String name;

        public GObjectRipper(String name, GObject obj) {
            this.obj = obj;
            this.name = name;
        }

        void rip(boolean expectSuccess) {
            Tracker tracker = new Tracker(this.obj);
            this.obj = null;
            if (expectSuccess) {
                Assert.assertTrue((String)(String.valueOf(this.name) + " not garbage collected"), (boolean)tracker.waitGC());
                Assert.assertTrue((String)(String.valueOf(this.name) + " not destroyed"), (boolean)tracker.waitDestroyed());
            } else {
                Assert.assertFalse((String)(String.valueOf(this.name) + " should not have been garbage collected"), (boolean)tracker.waitGC());
                Assert.assertFalse((String)(String.valueOf(this.name) + " should not have been destroyed"), (boolean)tracker.waitDestroyed());
            }
        }
    }
}

