/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.gstreamer.Fraction;
import org.gstreamer.Range;
import org.gstreamer.ValueList;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstStructureAPI;
import org.gstreamer.lowlevel.GstValueAPI;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure
extends NativeObject {
    private static final API gst = GstNative.load(API.class);

    public Structure(NativeObject.Initializer init) {
        super(init);
    }

    private Structure(Pointer ptr) {
        this(Structure.initializer(ptr));
    }

    public Structure(String name) {
        this(gst.ptr_gst_structure_empty_new(name));
    }

    public Structure(String name, String firstFieldName, Object ... data) {
        this(gst.ptr_gst_structure_new(name, firstFieldName, data));
    }

    public static Structure fromString(String data) {
        return new Structure(gst.ptr_gst_structure_from_string(data, new PointerByReference()));
    }

    public Structure copy() {
        return gst.gst_structure_copy(this);
    }

    public ValueList getValueList(String fieldName) {
        GValueAPI.GValue val = gst.gst_structure_get_value(this, fieldName);
        if (val == null) {
            throw new InvalidFieldException("ValueList", fieldName);
        }
        return new ValueList(val);
    }

    public Object getValue(String fieldName) {
        GValueAPI.GValue val = gst.gst_structure_get_value(this, fieldName);
        if (val == null) {
            throw new InvalidFieldException("Object", fieldName);
        }
        return val.getValue();
    }

    public int getInteger(String fieldName) {
        int[] val = new int[1];
        if (!gst.gst_structure_get_int(this, fieldName, val)) {
            throw new InvalidFieldException("integer", fieldName);
        }
        return val[0];
    }

    public int getInteger(String fieldName, int i) {
        return this.getValueList(fieldName).getInteger(i);
    }

    public double getDouble(String fieldName) {
        double[] val = new double[]{0.0};
        if (!gst.gst_structure_get_double(this, fieldName, val)) {
            throw new InvalidFieldException("double", fieldName);
        }
        return val[0];
    }

    public double getDouble(String fieldName, int i) {
        return this.getValueList(fieldName).getDouble(i);
    }

    public String getString(String fieldName) {
        return gst.gst_structure_get_string(this, fieldName);
    }

    public String getString(String fieldName, int i) {
        return this.getValueList(fieldName).getString(i);
    }

    public boolean getBoolean(String fieldName) {
        int[] val = new int[1];
        if (!gst.gst_structure_get_boolean(this, fieldName, val)) {
            throw new InvalidFieldException("boolean", fieldName);
        }
        return val[0] != 0;
    }

    public boolean getBoolean(String fieldName, int i) {
        return this.getValueList(fieldName).getBoolean(i);
    }

    public Fraction getFraction(String fieldName) {
        int[] numerator = new int[1];
        int[] denominator = new int[1];
        if (!gst.gst_structure_get_fraction(this, fieldName, numerator, denominator)) {
            throw new InvalidFieldException("fraction", fieldName);
        }
        return new Fraction(numerator[0], denominator[0]);
    }

    public int getFourcc(String fieldName) {
        int[] val = new int[1];
        if (!gst.gst_structure_get_fourcc(this, fieldName, val)) {
            throw new InvalidFieldException("FOURCC", fieldName);
        }
        return val[0];
    }

    public String getFourccString(String fieldName) {
        int f = this.getFourcc(fieldName);
        byte[] b = new byte[]{(byte)(f >> 0 & 0xFF), (byte)(f >> 8 & 0xFF), (byte)(f >> 16 & 0xFF), (byte)(f >> 24 & 0xFF)};
        return new String(b);
    }

    public Range getRange(String fieldName) {
        GValueAPI.GValue val = gst.gst_structure_get_value(this, fieldName);
        if (val == null) {
            throw new InvalidFieldException("Range", fieldName);
        }
        return new Range(val);
    }

    public boolean fixateNearestInteger(String field, Integer value) {
        return gst.gst_structure_fixate_field_nearest_int(this, field, value);
    }

    public void setInteger(String field, Integer value) {
        gst.gst_structure_set(this, field, new Object[]{GType.INT, value});
    }

    public void setValue(String field, GType type, Object value) {
        gst.gst_structure_set(this, field, new Object[]{type, value});
    }

    public void setDouble(String field, Double value) {
        gst.gst_structure_set(this, field, new Object[]{GType.DOUBLE, value});
    }

    public void setPointer(String field, Pointer value) {
        gst.gst_structure_set(this, field, new Object[]{GType.POINTER, value});
    }

    public void setIntegerRange(String field, Integer min, Integer max) {
        gst.gst_structure_set(this, field, new Object[]{gst.gst_int_range_get_type(), min, max});
    }

    public void setDoubleRange(String field, Double min, Double max) {
        gst.gst_structure_set(this, field, new Object[]{gst.gst_double_range_get_type(), min, max});
    }

    public String getName() {
        return gst.gst_structure_get_name(this);
    }

    public void setName(String name) {
        gst.gst_structure_set_name(this, name);
    }

    public boolean hasName(String name) {
        return gst.gst_structure_has_name(this, name);
    }

    public boolean hasField(String fieldName) {
        return gst.gst_structure_has_field(this, fieldName);
    }

    public int getFields() {
        return gst.gst_structure_n_fields(this);
    }

    public boolean hasField(String fieldName, GType fieldType) {
        return gst.gst_structure_has_field_typed(this, fieldName, fieldType);
    }

    public boolean hasField(String fieldName, Class<?> fieldType) {
        return gst.gst_structure_has_field_typed(this, fieldName, GType.valueOf(fieldType));
    }

    public boolean hasIntField(String fieldName) {
        return this.hasField(fieldName, GType.INT);
    }

    public boolean hasDoubleField(String fieldName) {
        return this.hasField(fieldName, GType.DOUBLE);
    }

    public void removeField(String fieldName) {
        gst.gst_structure_remove_field(this, fieldName);
    }

    public void removeFields(String ... fieldNames) {
        gst.gst_structure_remove_fields(this, fieldNames);
    }

    public String getName(int i) {
        return gst.gst_structure_nth_field_name(this, i);
    }

    @Override
    public String toString() {
        return gst.gst_structure_to_string(this);
    }

    public static Structure objectFor(Pointer ptr, boolean needRef, boolean ownsHandle) {
        return NativeObject.objectFor(ptr, Structure.class, needRef, ownsHandle);
    }

    @Override
    protected void disposeNativeHandle(Pointer ptr) {
        gst.gst_structure_free(ptr);
    }

    private static interface API
    extends GstStructureAPI,
    GstValueAPI {
        @CallerOwnsReturn
        public Pointer ptr_gst_structure_from_string(String var1, PointerByReference var2);

        @CallerOwnsReturn
        public Pointer ptr_gst_structure_empty_new(String var1);

        @CallerOwnsReturn
        public Pointer ptr_gst_structure_new(String var1, String var2, Object ... var3);

        public void gst_structure_free(Pointer var1);
    }

    public class InvalidFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 864118748304334069L;

        public InvalidFieldException(String type, String fieldName) {
            super(String.format("Structure does not contain %s field '%s'", type, fieldName));
        }
    }
}

