/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gstreamer.Structure;
import org.gstreamer.Tag;
import org.gstreamer.TagMergeMode;
import org.gstreamer.glib.GDate;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstTagAPI;
import org.gstreamer.lowlevel.GstTagListAPI;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagList
extends Structure {
    private static final API gst = GstNative.load(API.class);

    public TagList(NativeObject.Initializer init) {
        super(init);
    }

    public TagList() {
        super(TagList.initializer(gst.ptr_gst_tag_list_new()));
    }

    public int getValueCount(String tag) {
        return gst.gst_tag_list_get_tag_size(this, tag);
    }

    public List<Object> getValues(final String tag) {
        final int size = this.getValueCount(tag);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public Object get(int index) {
                return TagList.this.getValue(tag, index);
            }
        };
    }

    public List<Object> getValues(Tag tag) {
        return this.getValues(tag.getId());
    }

    public Object getValue(String tag, int index) {
        TagGetter get = (TagGetter)MapHolder.getterMap.get((Object)TagList.getTagType(tag));
        return get != null ? get.get(this, tag, index) : "";
    }

    public Object getValue(Tag tag, int index) {
        return this.getValue(tag.getId(), index);
    }

    @Override
    public String getString(String tag, int index) {
        return this.getValue(tag, index).toString();
    }

    public String getString(Tag tag, int index) {
        return this.getString(tag.getId(), index);
    }

    public Number getNumber(String tag, int index) {
        Object data = this.getValue(tag, index);
        if (!(data instanceof Number)) {
            throw new IllegalArgumentException("Tag [" + tag + "] is not a number");
        }
        return (Number)data;
    }

    public Number getNumber(Tag tag, int index) {
        return this.getNumber(tag.getId(), index);
    }

    public List<String> getTagNames() {
        final LinkedList<String> list = new LinkedList<String>();
        gst.gst_tag_list_foreach(this, new GstTagListAPI.TagForeachFunc(){

            public void callback(Pointer ptr, String tag, Pointer user_data) {
                list.add(tag);
            }
        }, null);
        return list;
    }

    public TagList merge(TagList list2, TagMergeMode mode) {
        return gst.gst_tag_list_merge(this, list2, mode);
    }

    private static GType getTagType(String tag) {
        GType type = (GType)((Object)MapHolder.tagTypeMap.get(tag));
        if (type != null) {
            return type;
        }
        type = gst.gst_tag_get_type(tag);
        MapHolder.tagTypeMap.put(tag, type);
        return type;
    }

    @Override
    protected void disposeNativeHandle(Pointer ptr) {
        gst.gst_tag_list_free(ptr);
    }

    private static interface API
    extends GstTagListAPI,
    GstTagAPI {
        @CallerOwnsReturn
        public Pointer ptr_gst_tag_list_new();

        @CallerOwnsReturn
        public Pointer ptr_gst_tag_list_copy(TagList var1);

        @CallerOwnsReturn
        public Pointer ptr_gst_tag_list_merge(TagList var1, TagList var2, TagMergeMode var3);

        public void gst_tag_list_free(Pointer var1);
    }

    private static final class MapHolder {
        private static final Map<GType, TagGetter> getterMap = new HashMap<GType, TagGetter>(){
            {
                this.put(GType.INT, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        int[] value = new int[1];
                        gst.gst_tag_list_get_int_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.UINT, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        int[] value = new int[1];
                        gst.gst_tag_list_get_uint_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.INT64, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        long[] value = new long[1];
                        gst.gst_tag_list_get_int64_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.DOUBLE, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        double[] value = new double[]{0.0};
                        gst.gst_tag_list_get_double_index(tl, tag, index, value);
                        return value[0];
                    }
                });
                this.put(GType.STRING, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        Pointer[] value = new Pointer[1];
                        gst.gst_tag_list_get_string_index(tl, tag, index, value);
                        if (value[0] == null) {
                            return null;
                        }
                        String ret = value[0].getString(0L, false);
                        GlibAPI.GLIB_API.g_free(value[0]);
                        return ret;
                    }
                });
                this.put(GDate.GTYPE, new TagGetter(){

                    public Object get(TagList tl, String tag, int index) {
                        PointerByReference value = new PointerByReference();
                        gst.gst_tag_list_get_date_index(tl, tag, index, value);
                        if (value.getValue() == null) {
                            return null;
                        }
                        return new GDate(value.getValue(), false, true);
                    }
                });
            }
        };
        private static final Map<String, GType> tagTypeMap = new ConcurrentHashMap<String, GType>();

        private MapHolder() {
        }
    }

    private static interface TagGetter {
        public Object get(TagList var1, String var2, int var3);
    }
}

