/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.StreamInfo;
import org.gstreamer.Video;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PlayBin
extends Pipeline {
    public static final String GST_NAME = "playbin";
    public static final String GTYPE_NAME = "GstPlayBin";

    public PlayBin(String name) {
        this(PlayBin.makeRawElement(GST_NAME, name));
    }

    public PlayBin(String name, URI uri) {
        this(name);
        this.setURI(uri);
    }

    public PlayBin(NativeObject.Initializer init) {
        super(init);
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setURI(URI uri) {
        this.set("uri", uri);
    }

    public void setAudioSink(Element element) {
        this.setElement("audio-sink", element);
    }

    public void setVideoSink(Element element) {
        this.setElement("video-sink", element);
    }

    public void setVisualization(Element element) {
        this.setElement("vis-plugin", element);
    }

    private void setElement(String key, Element element) {
        if (element == null) {
            element = ElementFactory.make("fakesink", "fake-" + key);
        }
        this.set(key, element);
    }

    public void setVolumePercent(int percent) {
        this.setVolume(Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0);
    }

    public int getVolumePercent() {
        return (int)(this.getVolume() * 100.0 + 0.5);
    }

    public void setVolume(double volume) {
        this.set("volume", Math.max(Math.min(volume, 1.0), 0.0));
    }

    public double getVolume() {
        return ((Number)this.get("volume")).doubleValue();
    }

    public List<StreamInfo> getStreamInfo() {
        Pointer ptr = this.getPointer("stream-info-value-array");
        if (ptr != null) {
            GValueAPI.GValueArray garray = new GValueAPI.GValueArray(ptr);
            ArrayList<StreamInfo> list = new ArrayList<StreamInfo>(garray.getNValues());
            GValueAPI.GValue[] gValueArray = garray.values;
            int n = garray.values.length;
            int n2 = 0;
            while (n2 < n) {
                GValueAPI.GValue value = gValueArray[n2];
                Pointer p = GValueAPI.GVALUE_NOMAPPER_API.g_value_get_object(value);
                StreamInfo streamInfo = NativeObject.objectFor(p, StreamInfo.class, -1, true);
                list.add(streamInfo);
                ++n2;
            }
            return list;
        }
        return null;
    }

    public double getVideoSinkFrameRate() {
        for (Element sink : this.getSinks()) {
            for (Pad pad : sink.getPads()) {
                Fraction frameRate = Video.getVideoFrameRate(pad);
                if (frameRate == null) continue;
                return frameRate.toDouble();
            }
        }
        return 0.0;
    }

    public Dimension getVideoSize() {
        for (Element sink : this.getSinks()) {
            for (Pad pad : sink.getPads()) {
                Dimension size = Video.getVideoSize(pad);
                if (size == null) continue;
                return size;
            }
        }
        return null;
    }
}

