/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class RGBDataSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private final BaseSink videosink;
    private boolean passDirectBuffer = false;
    private Listener listener;

    public RGBDataSink(String name, Listener listener) {
        super(RGBDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.videosink = (FakeSink)ElementFactory.make("fakesink", name);
        this.videosink.set("signal-handoffs", true);
        this.videosink.set("sync", true);
        this.videosink.set("preroll-queue-len", 1);
        this.videosink.connect(new VideoHandoffListener());
        this.videosink.connect(new VideoHandoffListener());
        Element conv = ElementFactory.make("ffmpegcolorspace", "ColorConverter");
        Element videofilter = ElementFactory.make("capsfilter", "ColorFilter");
        StringBuilder caps = new StringBuilder("video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ");
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            caps.append("red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000");
        } else {
            caps.append("red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF");
        }
        videofilter.setCaps(new Caps(caps.toString()));
        this.addMany(conv, videofilter, this.videosink);
        Element.linkMany(conv, videofilter, this.videosink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public RGBDataSink(String name, Pipeline pipeline, Listener listener) {
        super(RGBDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName(name);
        if (element == null) {
            this.videosink = null;
            throw new RuntimeException("Element with name " + name + " not found in the pipeline");
        }
        this.videosink = (BaseSink)element;
        this.videosink.set("signal-handoffs", true);
        this.videosink.set("sync", true);
        this.videosink.set("preroll-queue-len", 1);
        this.videosink.connect(new VideoHandoffListener());
        this.videosink.connect(new VideoHandoffListener());
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setPassDirectBuffer(boolean passThru) {
        this.passDirectBuffer = passThru;
    }

    public BaseSink getSinkElement() {
        return this.videosink;
    }

    public static interface Listener {
        public void rgbFrame(boolean var1, int var2, int var3, IntBuffer var4);
    }

    class VideoHandoffListener
    implements BaseSink.HANDOFF,
    BaseSink.PREROLL_HANDOFF {
        VideoHandoffListener() {
        }

        public void handoff(BaseSink sink, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, false);
        }

        public void prerollHandoff(BaseSink sink, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, true);
        }

        private void doHandoff(Buffer buffer, Pad pad, boolean isPrerollFrame) {
            IntBuffer rgb;
            Caps caps = buffer.getCaps();
            Structure struct = caps.getStructure(0);
            int width = struct.getInteger("width");
            int height = struct.getInteger("height");
            if (width < 1 || height < 1) {
                return;
            }
            if (RGBDataSink.this.passDirectBuffer) {
                rgb = buffer.getByteBuffer().asIntBuffer();
            } else {
                rgb = IntBuffer.allocate(width * height);
                rgb.put(buffer.getByteBuffer().asIntBuffer()).flip();
            }
            RGBDataSink.this.listener.rgbFrame(isPrerollFrame, width, height, rgb);
            buffer.dispose();
        }
    }
}

