/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.interfaces;

import com.sun.jna.Pointer;
import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.GObject;
import org.gstreamer.interfaces.GstInterface;
import org.gstreamer.interfaces.TunerChannel;
import org.gstreamer.interfaces.TunerNorm;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstTunerAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuner
extends GstInterface {
    public static final Tuner wrap(Element element) {
        return new Tuner(element);
    }

    private Tuner(Element element) {
        super(element, GstTunerAPI.GSTTUNER_API.gst_tuner_get_type());
    }

    public List<TunerChannel> getChannelList() {
        return this.objectList(GstTunerAPI.GSTTUNER_API.gst_tuner_list_channels(this), new GstInterface.ListElementCreator<TunerChannel>(){

            @Override
            public TunerChannel create(Pointer pointer) {
                return Tuner.this.channelFor(pointer, true);
            }
        });
    }

    private final TunerChannel channelFor(Pointer pointer, boolean needRef) {
        return new TunerChannel(this, pointer, needRef, true);
    }

    public List<TunerNorm> getNormList() {
        return this.objectList(GstTunerAPI.GSTTUNER_API.gst_tuner_list_norms(this), new GstInterface.ListElementCreator<TunerNorm>(){

            @Override
            public TunerNorm create(Pointer pointer) {
                return GObject.objectFor(pointer, TunerNorm.class, true);
            }
        });
    }

    public void setChannel(TunerChannel channel) {
        GstTunerAPI.GSTTUNER_API.gst_tuner_set_channel(this, channel);
    }

    public TunerChannel getChannel() {
        Pointer ptr = GstTunerAPI.GSTTUNER_API.gst_tuner_get_channel(this);
        if (ptr == null) {
            return null;
        }
        return new TunerChannel(this, ptr, false, true);
    }

    public TunerChannel getChannelByName(String name) {
        Pointer ptr = GstTunerAPI.GSTTUNER_API.gst_tuner_find_channel_by_name(this, name);
        if (ptr == null) {
            return null;
        }
        return new TunerChannel(this, ptr, false, true);
    }

    public void setNorm(TunerNorm norm) {
        GstTunerAPI.GSTTUNER_API.gst_tuner_set_norm(this, norm);
    }

    public TunerNorm getNorm() {
        return GstTunerAPI.GSTTUNER_API.gst_tuner_get_norm(this);
    }

    public TunerNorm getNormByName(String name) {
        return GstTunerAPI.GSTTUNER_API.gst_tuner_find_norm_by_name(this, name);
    }

    public void connect(final NORM_CHANGED listener) {
        this.element.connect(NORM_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer tuner, TunerNorm norm) {
                listener.normChanged(Tuner.this, norm);
                return true;
            }
        });
    }

    public void disconnect(NORM_CHANGED listener) {
        this.element.disconnect(NORM_CHANGED.class, listener);
    }

    public void connect(final CHANNEL_CHANGED listener) {
        this.element.connect(CHANNEL_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer tuner, Pointer channel) {
                listener.channelChanged(Tuner.this, Tuner.this.channelFor(channel, false));
                return true;
            }
        });
    }

    public void disconnect(CHANNEL_CHANGED listener) {
        this.element.disconnect(CHANNEL_CHANGED.class, listener);
    }

    public void connect(final FREQUENCY_CHANGED listener) {
        this.element.connect(FREQUENCY_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer tuner, Pointer channel, long frequency) {
                listener.frequencyChanged(Tuner.this, Tuner.this.channelFor(channel, false), frequency);
                return true;
            }
        });
    }

    public void disconnect(FREQUENCY_CHANGED listener) {
        this.element.disconnect(FREQUENCY_CHANGED.class, listener);
    }

    public void connect(final SIGNAL_CHANGED listener) {
        this.element.connect(SIGNAL_CHANGED.class, listener, new GstAPI.GstCallback(){

            public boolean callback(Pointer tuner, Pointer channel, int signal) {
                listener.signalChanged(Tuner.this, Tuner.this.channelFor(channel, false), signal);
                return true;
            }
        });
    }

    public void disconnect(SIGNAL_CHANGED listener) {
        this.element.disconnect(SIGNAL_CHANGED.class, listener);
    }

    public static interface CHANNEL_CHANGED {
        public void channelChanged(Tuner var1, TunerChannel var2);
    }

    public static interface FREQUENCY_CHANGED {
        public void frequencyChanged(Tuner var1, TunerChannel var2, long var3);
    }

    public static interface NORM_CHANGED {
        public void normChanged(Tuner var1, TunerNorm var2);
    }

    public static interface SIGNAL_CHANGED {
        public void signalChanged(Tuner var1, TunerChannel var2, int var3);
    }
}

