/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gstreamer.ClockTime;
import org.gstreamer.lowlevel.EnumMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GNative {
    private static final Converter enumConverter = new Converter(){

        @Override
        public Class<?> nativeType() {
            return Integer.TYPE;
        }

        @Override
        public Object toNative(Object value) {
            return value != null ? EnumMapper.getInstance().intValue((Enum)value) : 0;
        }

        public Object fromNative(Object value, Class javaType) {
            return EnumMapper.getInstance().valueOf((Integer)value, javaType);
        }
    };
    private static final Converter booleanConverter = new Converter(){

        @Override
        public Class<?> nativeType() {
            return Integer.TYPE;
        }

        @Override
        public Object toNative(Object value) {
            return value != null ? (Boolean.TRUE.equals(value) ? 1 : 0) : 0;
        }

        public Object fromNative(Object value, Class javaType) {
            return value != null ? (Comparable<Boolean>)Boolean.valueOf((Integer)value != 0) : (Comparable<Boolean>)Integer.valueOf(0);
        }
    };
    private static final Converter clocktimeConverter = new Converter(){

        @Override
        public Class<?> nativeType() {
            return Long.TYPE;
        }

        @Override
        public Object toNative(Object value) {
            return value != null ? ((ClockTime)value).toNanos() : 0L;
        }

        @Override
        public Object fromNative(Object value, Class<?> javaType) {
            return ClockTime.valueOf(value != null ? (Long)value : 0L, TimeUnit.NANOSECONDS);
        }
    };

    private GNative() {
    }

    public static synchronized <T extends Library> T loadLibrary(String name, Class<T> interfaceClass, Map<String, ?> options) {
        if (Platform.isWindows()) {
            return GNative.loadWin32Library(name, interfaceClass, options);
        }
        return GNative.loadNativeLibrary(name, interfaceClass, options);
    }

    private static <T extends Library> T loadNativeLibrary(String name, Class<T> interfaceClass, Map<String, ?> options) {
        Library library = (Library)interfaceClass.cast(Native.loadLibrary((String)name, interfaceClass, options));
        boolean needCustom = false;
        Method[] methodArray = interfaceClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] classArray = m.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> cls = classArray[n4];
                if (cls.isArray() && GNative.getConverter(cls.getComponentType()) != null) {
                    needCustom = true;
                }
                ++n4;
            }
            ++n2;
        }
        if (!needCustom) {
            return (T)library;
        }
        return (T)((Library)interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new Handler<Library>(library, options))));
    }

    private static <T extends Library> T loadWin32Library(String name, Class<T> interfaceClass, Map<String, ?> options) {
        String[] nameFormats = new String[]{"%s", "lib%s", "lib%s-0"};
        int i = 0;
        while (i < nameFormats.length) {
            try {
                return (T)((Library)interfaceClass.cast(GNative.loadNativeLibrary(String.format(nameFormats[i], name), interfaceClass, options)));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ++i;
            }
        }
        throw new UnsatisfiedLinkError("Could not load library " + name);
    }

    private static NativeLibrary getWin32NativeLibrary(String name) {
        String[] nameFormats = new String[]{"%s", "lib%s", "lib%s-0"};
        int i = 0;
        while (i < nameFormats.length) {
            try {
                return NativeLibrary.getInstance((String)String.format(nameFormats[i], name));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ++i;
            }
        }
        throw new UnsatisfiedLinkError("Could not load library " + name);
    }

    public static synchronized NativeLibrary getNativeLibrary(String name) {
        if (Platform.isWindows()) {
            return GNative.getWin32NativeLibrary(name);
        }
        return NativeLibrary.getInstance((String)name);
    }

    private static Converter getConverter(Class<?> javaType) {
        if (Enum.class.isAssignableFrom(javaType)) {
            return enumConverter;
        }
        if (ClockTime.class == javaType) {
            return clocktimeConverter;
        }
        if (Boolean.TYPE == javaType || Boolean.class == javaType) {
            return booleanConverter;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Converter {
        public Class<?> nativeType();

        public Object toNative(Object var1);

        public Object fromNative(Object var1, Class<?> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler<T>
    implements InvocationHandler {
        private final InvocationHandler proxy;
        private final T library;
        private static final ArrayIO intArrayIO = new ArrayIO(){

            @Override
            public void set(Object array, int index, Object data) {
                Array.setInt(array, index, data != null ? (Integer)data : 0);
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getInt(array, index);
            }
        };
        private static final ArrayIO longArrayIO = new ArrayIO(){

            @Override
            public void set(Object array, int index, Object data) {
                Array.setLong(array, index, data != null ? (Long)data : 0L);
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getLong(array, index);
            }
        };

        public Handler(T library, Map<String, ?> options) {
            this.library = library;
            this.proxy = Proxy.getInvocationHandler(library);
        }

        @Override
        public Object invoke(Object self, Method method, Object[] args) throws Throwable {
            int lastArg;
            int n = lastArg = args != null ? args.length : 0;
            if (method.isVarArgs()) {
                --lastArg;
            }
            Runnable[] postInvoke = null;
            int postCount = 0;
            int i = 0;
            while (i < lastArg) {
                Converter converter;
                Class<?> cls;
                if (args[i] != null && (cls = args[i].getClass()).isArray() && !cls.getComponentType().isPrimitive() && cls.getComponentType() != String.class && (converter = GNative.getConverter(cls.getComponentType())) != null) {
                    final Object[] src = (Object[])args[i];
                    final Object dst = Array.newInstance(converter.nativeType(), src.length);
                    final ArrayIO io = Handler.getArrayIO(converter.nativeType());
                    int a = 0;
                    while (a < src.length) {
                        io.set(dst, a, converter.toNative(src[a]));
                        ++a;
                    }
                    if (postInvoke == null) {
                        postInvoke = new Runnable[lastArg];
                    }
                    postInvoke[postCount++] = new Runnable(){

                        public void run() {
                            int a = 0;
                            while (a < src.length) {
                                src[a] = converter.fromNative(io.get(dst, a), cls.getComponentType());
                                ++a;
                            }
                        }
                    };
                    args[i] = dst;
                }
                ++i;
            }
            Object retval = this.proxy.invoke(self, method, args);
            int i2 = 0;
            while (i2 < postCount) {
                postInvoke[i2].run();
                ++i2;
            }
            return retval;
        }

        Class<?> getNativeClass(Class<?> cls) {
            if (cls == Integer.class) {
                return Integer.TYPE;
            }
            if (cls == Long.class) {
                return Long.TYPE;
            }
            return cls;
        }

        private static ArrayIO getArrayIO(Class<?> cls) {
            if (cls == Integer.TYPE || cls == Integer.class) {
                return intArrayIO;
            }
            if (cls == Long.TYPE || cls == Long.class) {
                return longArrayIO;
            }
            throw new IllegalArgumentException("No such conversion");
        }

        private static interface ArrayIO {
            public void set(Object var1, int var2, Object var3);

            public Object get(Object var1, int var2);
        }
    }
}

