/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Library;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import java.util.HashMap;
import org.gstreamer.GObject;
import org.gstreamer.lowlevel.GNative;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GTypeMapper;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;
import org.gstreamer.lowlevel.annotations.Invalidate;

public interface GValueAPI
extends Library {
    public static final NoMapperAPI GVALUE_NOMAPPER_API = GNative.loadLibrary("gobject-2.0", NoMapperAPI.class, new HashMap<String, Object>(){});
    public static final GValueAPI GVALUE_API = GNative.loadLibrary("gobject-2.0", GValueAPI.class, new HashMap<String, Object>(){
        {
            this.put("type-mapper", new GTypeMapper());
        }
    });

    public GValue g_value_init(GValue var1, GType var2);

    public GValue g_value_reset(GValue var1);

    public void g_value_unset(GValue var1);

    public void g_value_set_char(GValue var1, byte var2);

    public byte g_value_get_char(GValue var1);

    public void g_value_set_uchar(GValue var1, byte var2);

    public byte g_value_get_uchar(GValue var1);

    public void g_value_set_boolean(GValue var1, boolean var2);

    public boolean g_value_get_boolean(GValue var1);

    public void g_value_set_int(GValue var1, int var2);

    public int g_value_get_int(GValue var1);

    public void g_value_set_uint(GValue var1, int var2);

    public int g_value_get_uint(GValue var1);

    public void g_value_set_long(GValue var1, NativeLong var2);

    public NativeLong g_value_get_long(GValue var1);

    public void g_value_set_ulong(GValue var1, NativeLong var2);

    public NativeLong g_value_get_ulong(GValue var1);

    public void g_value_set_int64(GValue var1, long var2);

    public long g_value_get_int64(GValue var1);

    public void g_value_set_uint64(GValue var1, long var2);

    public long g_value_get_uint64(GValue var1);

    public void g_value_set_float(GValue var1, float var2);

    public float g_value_get_float(GValue var1);

    public void g_value_set_double(GValue var1, double var2);

    public double g_value_get_double(GValue var1);

    public void g_value_set_enum(GValue var1, int var2);

    public int g_value_get_enum(GValue var1);

    public void g_value_set_string(GValue var1, String var2);

    public void g_value_set_static_string(GValue var1, String var2);

    public String g_value_get_string(GValue var1);

    public Pointer g_value_get_pointer(GValue var1);

    public boolean g_value_type_compatible(GType var1, GType var2);

    public boolean g_value_type_transformable(GType var1, GType var2);

    public boolean g_value_transform(GValue var1, GValue var2);

    @CallerOwnsReturn
    public String g_strdup_value_contents(GValue var1);

    public void g_value_set_object(GValue var1, GObject var2);

    public void g_value_take_object(GValue var1, @Invalidate GObject var2);

    public GObject g_value_get_object(GValue var1);

    @CallerOwnsReturn
    public GObject g_value_dup_object(GValue var1);

    public Pointer g_value_get_boxed(GValue var1);

    public GValue g_value_array_get_nth(GValueArray var1, int var2);

    public Pointer g_value_array_new(int var1);

    public void g_value_array_free(GValueArray var1);

    public Pointer g_value_array_copy(GValueArray var1);

    public Pointer g_value_array_prepend(GValueArray var1, GValue var2);

    public Pointer g_value_array_append(GValueArray var1, GValue var2);

    public Pointer g_value_array_insert(GValueArray var1, int var2, GValue var3);

    public Pointer g_value_array_remove(GValueArray var1, int var2);

    public boolean g_type_check_value_holds(GValue var1, GType var2);

    public static class GValue
    extends Structure {
        public static final String GTYPE_NAME = "GValue";
        public volatile GType g_type;
        public volatile GValueData[] data = new GValueData[2];

        public GValue() {
        }

        public GValue(Pointer ptr) {
            this.useMemory(ptr);
            this.read();
        }

        public boolean checkHolds(GType type) {
            return GVALUE_API.g_type_check_value_holds(this, type);
        }

        public GType getType() {
            return this.g_type;
        }

        public Object getValue() {
            if (this.g_type.equals((Object)GType.INT)) {
                return this.toInt();
            }
            if (this.g_type.equals((Object)GType.UINT)) {
                return this.toUInt();
            }
            if (this.g_type.equals((Object)GType.CHAR)) {
                return this.toChar();
            }
            if (this.g_type.equals((Object)GType.UCHAR)) {
                return this.toUChar();
            }
            if (this.g_type.equals((Object)GType.LONG)) {
                return this.toLong();
            }
            if (this.g_type.equals((Object)GType.ULONG)) {
                return this.toULong();
            }
            if (this.g_type.equals((Object)GType.INT64)) {
                return this.toInt64();
            }
            if (this.g_type.equals((Object)GType.UINT64)) {
                return this.toUInt64();
            }
            if (this.g_type.equals((Object)GType.BOOLEAN)) {
                return this.toBoolean();
            }
            if (this.g_type.equals((Object)GType.FLOAT)) {
                return this.toFloat();
            }
            if (this.g_type.equals((Object)GType.DOUBLE)) {
                return this.toDouble();
            }
            if (this.g_type.equals((Object)GType.STRING)) {
                return this.toJavaString();
            }
            if (this.g_type.equals((Object)GType.OBJECT)) {
                return this.toObject();
            }
            if (this.g_type.equals((Object)GType.POINTER)) {
                return this.toPointer();
            }
            return null;
        }

        public Integer toInt() {
            return this.g_type.equals((Object)GType.INT) ? new Integer(GVALUE_API.g_value_get_int(this)) : null;
        }

        public Integer toUInt() {
            return this.g_type.equals((Object)GType.UINT) ? new Integer(GVALUE_API.g_value_get_uint(this)) : null;
        }

        public Byte toChar() {
            return this.g_type.equals((Object)GType.CHAR) ? new Byte(GVALUE_API.g_value_get_char(this)) : null;
        }

        public Byte toUChar() {
            return this.g_type.equals((Object)GType.UCHAR) ? new Byte(GVALUE_API.g_value_get_uchar(this)) : null;
        }

        public Long toLong() {
            return this.g_type.equals((Object)GType.LONG) ? new Long(GVALUE_API.g_value_get_long(this).longValue()) : null;
        }

        public Long toULong() {
            return this.g_type.equals((Object)GType.ULONG) ? new Long(GVALUE_API.g_value_get_ulong(this).longValue()) : null;
        }

        public Long toInt64() {
            return this.g_type.equals((Object)GType.INT64) ? new Long(GVALUE_API.g_value_get_int64(this)) : null;
        }

        public Long toUInt64() {
            return this.g_type.equals((Object)GType.UINT64) ? new Long(GVALUE_API.g_value_get_uint64(this)) : null;
        }

        public Boolean toBoolean() {
            return this.g_type.equals((Object)GType.BOOLEAN) ? new Boolean(GVALUE_API.g_value_get_boolean(this)) : null;
        }

        public Float toFloat() {
            return this.g_type.equals((Object)GType.FLOAT) ? new Float(GVALUE_API.g_value_get_float(this)) : null;
        }

        public Double toDouble() {
            return this.g_type.equals((Object)GType.DOUBLE) ? new Double(GVALUE_API.g_value_get_double(this)) : null;
        }

        public String toJavaString() {
            return this.g_type.equals((Object)GType.STRING) ? GVALUE_API.g_value_get_string(this) : null;
        }

        public Object toObject() {
            return this.g_type.equals((Object)GType.OBJECT) ? GVALUE_API.g_value_get_object(this) : null;
        }

        public Pointer toPointer() {
            return this.g_type.equals((Object)GType.POINTER) ? GVALUE_API.g_value_get_pointer(this) : null;
        }

        public String toString() {
            return GVALUE_API.g_strdup_value_contents(this);
        }

        public static class GValueData
        extends Union {
            public volatile int v_int;
            public volatile long v_long;
            public volatile long v_int64;
            public volatile float v_float;
            public volatile double v_double;
            public volatile Pointer v_pointer;
        }
    }

    public static class GValueArray
    extends Structure {
        public static final String GTYPE_NAME = "GValueArray";
        public volatile int n_values;
        public volatile GValue[] values;
        public volatile int n_prealloced;

        public GValueArray() {
            this.clear();
        }

        public GValueArray(Pointer pointer) {
            this.n_values = pointer.getInt(0L);
            if (this.n_values > 0) {
                Pointer pointerToArray = pointer.getPointer((long)GType.SIZE);
                GValue val = new GValue(pointerToArray);
                this.values = (GValue[])val.toArray(this.n_values);
            } else {
                this.values = new GValue[0];
            }
        }

        private static GValueArray valueOf(Pointer ptr) {
            return ptr != null ? new GValueArray(ptr) : null;
        }

        public int getNValues() {
            return this.n_values;
        }

        public Object getValue(int i) {
            return this.values[i].getValue();
        }
    }

    public static interface NoMapperAPI
    extends Library {
        public Pointer g_value_get_object(GValue var1);

        public Pointer g_value_dup_object(GValue var1);
    }
}

