/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GstTypes {
    private static final Logger logger = Logger.getLogger(GstTypes.class.getName());
    private static final Map<String, Class<? extends NativeObject>> gTypeNameMap = new HashMap<String, Class<? extends NativeObject>>();
    private static final Map<Pointer, Class<? extends NativeObject>> gTypeInstanceMap = new ConcurrentHashMap<Pointer, Class<? extends NativeObject>>();

    private GstTypes() {
    }

    public static void registerType(Class<? extends NativeObject> cls, String gTypeName) {
        if (!gTypeNameMap.containsKey(gTypeName)) {
            gTypeNameMap.put(gTypeName, cls);
        }
    }

    public static Class<? extends NativeObject> find(GType gType) {
        logger.entering("GstTypes", "find", (Object)gType);
        return gTypeNameMap.get(GObjectAPI.GOBJECT_API.g_type_name(gType));
    }

    public static Class<? extends NativeObject> find(String gTypeName) {
        logger.entering("GstTypes", "find", gTypeName);
        return gTypeNameMap.get(gTypeName);
    }

    public static final boolean isGType(Pointer p, long type) {
        return GstTypes.getGType(p).longValue() == type;
    }

    public static final GType getGType(Pointer ptr) {
        Pointer g_class = ptr.getPointer(0L);
        return GType.valueOf(g_class.getNativeLong(0L).longValue());
    }

    public static final Class<? extends NativeObject> classFor(Pointer ptr) {
        Pointer g_class = ptr.getPointer(0L);
        Class<? extends NativeObject> cls = gTypeInstanceMap.get(g_class);
        if (cls != null) {
            return cls;
        }
        GType type = GType.valueOf(g_class.getNativeLong(0L).longValue());
        logger.finer("Type of " + ptr + " = " + (Object)((Object)type));
        while (cls == null && !type.equals((Object)GType.OBJECT) && !type.equals((Object)GType.INVALID)) {
            cls = GstTypes.find(type);
            if (cls != null) {
                logger.finer("Found type of " + ptr + " = " + cls);
                gTypeInstanceMap.put(g_class, cls);
                break;
            }
            type = GObjectAPI.GOBJECT_API.g_type_parent(type);
        }
        return cls;
    }

    public static final Class<? extends NativeObject> classFor(GType type) {
        return GstTypes.find(type);
    }

    public static final GType typeFor(Class<? extends NativeObject> cls) {
        for (Map.Entry<String, Class<? extends NativeObject>> e : gTypeNameMap.entrySet()) {
            if (!e.getValue().equals(cls)) continue;
            return GObjectAPI.GOBJECT_API.g_type_from_name(e.getKey());
        }
        return GType.INVALID;
    }
}

