/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.platform.unix.X11;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.gstreamer.Bin;
import org.gstreamer.BusSyncReply;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Message;
import org.gstreamer.MessageType;
import org.gstreamer.State;
import org.gstreamer.Structure;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.event.BusSyncHandler;
import org.gstreamer.swt.overlay.SWTOverlay;

public class VideoComponent
extends Canvas
implements BusSyncHandler,
DisposeListener {
    private static int counter = 0;
    private final Bin autosink;
    private SWTOverlay overlay;
    private BaseSink videosink;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean x11Events;
    private long nativeHandle;
    private boolean watcherRunning = false;

    public VideoComponent(Composite parent, int style, boolean enableX11Events) {
        super(parent, style | 0x1000000);
        this.x11Events = enableX11Events;
        this.addDisposeListener(this);
        this.autosink = (Bin)ElementFactory.make("autovideosink", "Sink4VideoComponent" + counter++);
        this.autosink.connect(new Bin.ELEMENT_ADDED(){

            public void elementAdded(Bin bin, Element element) {
                if (element instanceof BaseSink) {
                    VideoComponent.this.videosink = (BaseSink)element;
                    for (Map.Entry e : VideoComponent.this.properties.entrySet()) {
                        VideoComponent.this.videosink.set((String)e.getKey(), e.getValue());
                    }
                    VideoComponent.this.setOverlay();
                    VideoComponent.this.autosink.disconnect(this);
                }
            }
        });
    }

    public VideoComponent(Composite parent, int style) {
        this(parent, style, false);
    }

    private void setOverlay() {
        this.nativeHandle = SWTOverlay.getNativeHandle((Composite)this);
        this.overlay = SWTOverlay.wrap(this.videosink);
        this.overlay.setWindowHandle(this.nativeHandle);
        this.handleX11Events();
        this.expose();
    }

    public BusSyncReply syncMessage(Message message) {
        if (message.getType() != MessageType.ELEMENT) {
            return BusSyncReply.PASS;
        }
        Structure s = message.getStructure();
        if (s == null || !s.hasName("prepare-xwindow-id")) {
            return BusSyncReply.PASS;
        }
        this.setOverlay();
        return BusSyncReply.DROP;
    }

    public void widgetDisposed(DisposeEvent arg0) {
        this.removeDisposeListener(this);
        if (this.x11Events) {
            this.watcherRunning = false;
        }
        if (this.videosink != null && !this.videosink.getState().equals(State.NULL)) {
            throw new IllegalStateException("");
        }
    }

    public void expose() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!VideoComponent.this.isDisposed() && VideoComponent.this.overlay != null) {
                    VideoComponent.this.overlay.expose();
                }
            }
        });
    }

    public void set(String property, Object data) {
        this.properties.put(property, data);
        if (this.videosink != null) {
            this.videosink.set(property, data);
        }
    }

    public void setKeepAspect(boolean keepAspect) {
        this.set("force-aspect-ratio", keepAspect);
    }

    public Element getElement() {
        return this.autosink;
    }

    public Element getSinkElement() {
        return this.videosink;
    }

    private void handleX11Events() {
        if (this.x11Events && Platform.isLinux()) {
            this.videosink.set("handle-events", !this.x11Events);
            this.overlay.handleEvent(!this.x11Events);
            this.watcherRunning = true;
            new Thread(){

                public void run() {
                    try {
                        X11 x11 = X11.INSTANCE;
                        X11.Display display = x11.XOpenDisplay(null);
                        X11.Window window = new X11.Window(VideoComponent.this.nativeHandle);
                        x11.XSelectInput(display, window, new NativeLong(2326576L));
                        while (VideoComponent.this.watcherRunning) {
                            final X11.XEvent xEvent = new X11.XEvent();
                            x11.XNextEvent(display, xEvent);
                            if (!VideoComponent.this.watcherRunning || VideoComponent.this.isDisposed()) continue;
                            VideoComponent.this.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (VideoComponent.this.watcherRunning && !VideoComponent.this.isDisposed()) {
                                        Event swtEvent = new Event();
                                        switch (xEvent.type) {
                                            case 7: {
                                                X11.XCrossingEvent ce = (X11.XCrossingEvent)xEvent.readField("xcrossing");
                                                swtEvent.x = ce.x;
                                                swtEvent.y = ce.y;
                                                VideoComponent.this.notifyListeners(6, swtEvent);
                                                break;
                                            }
                                            case 8: {
                                                X11.XCrossingEvent ce = (X11.XCrossingEvent)xEvent.readField("xcrossing");
                                                swtEvent.x = ce.x;
                                                swtEvent.y = ce.y;
                                                VideoComponent.this.notifyListeners(7, swtEvent);
                                                break;
                                            }
                                            default: {
                                                VideoComponent.this.overlay.expose();
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        x11.XCloseDisplay(display);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

