/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.RGBDataAppSink;
import org.gstreamer.interfaces.Property;
import org.gstreamer.interfaces.PropertyProbe;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSCapture
extends PImage
implements PConstants {
    public static String capturePlugin;
    public static String devicePropertyName;
    public static String indexPropertyName;
    protected String source;
    protected boolean capturing = false;
    protected String fps;
    protected int bufWidth;
    protected int bufHeight;
    protected Pipeline gpipeline;
    protected Element gsource;
    protected Method captureEventMethod;
    protected Method copyBufferMethod;
    protected Object eventHandler;
    protected Object copyHandler;
    protected boolean available;
    protected boolean pipelineReady;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected BufferDataAppSink natSink = null;
    protected Buffer natBuffer = null;
    protected IntBuffer rgbBuffer = null;
    protected boolean copyNatBuf = true;
    protected boolean copyBufferMode = false;
    protected String copyMask;
    protected boolean firstFrame = true;
    protected boolean newFrame = false;
    protected ArrayList<int[]> suppResList;
    protected ArrayList<String> suppFpsList;
    protected int reqWidth;
    protected int reqHeight;

    public GSCapture(PApplet pApplet, int n, int n2) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, capturePlugin, new String[0], new int[0], new String[0], new String[0], "");
    }

    public GSCapture(PApplet pApplet, int n, int n2, int n3) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, capturePlugin, new String[0], new int[0], new String[0], new String[0], n3 + "/1");
    }

    public GSCapture(PApplet pApplet, int n, int n2, String string) {
        super(n, n2, 1);
        if (devicePropertyName.equals("")) {
            this.initGStreamer(pApplet, n, n2, capturePlugin, new String[]{indexPropertyName}, new int[]{PApplet.parseInt((String)string)}, new String[0], new String[0], "");
        } else {
            this.initGStreamer(pApplet, n, n2, capturePlugin, new String[0], new int[0], new String[]{devicePropertyName}, new String[]{string}, "");
        }
    }

    public GSCapture(PApplet pApplet, int n, int n2, String string, int n3) {
        super(n, n2, 1);
        if (devicePropertyName.equals("")) {
            this.initGStreamer(pApplet, n, n2, capturePlugin, new String[]{indexPropertyName}, new int[]{PApplet.parseInt((String)string)}, new String[0], new String[0], n3 + "/1");
        } else {
            this.initGStreamer(pApplet, n, n2, capturePlugin, new String[0], new int[0], new String[]{devicePropertyName}, new String[]{string}, n3 + "/1");
        }
    }

    public GSCapture(PApplet pApplet, int n, int n2, String string, String string2, int n3) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, string, new String[0], new int[0], new String[]{devicePropertyName}, new String[]{string2}, n3 + "/1");
    }

    public GSCapture(PApplet pApplet, int n, int n2, String string, String[] stringArray, String[] stringArray2, String string2) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, string, new String[0], new int[0], stringArray, stringArray2, string2);
    }

    public GSCapture(PApplet pApplet, int n, int n2, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray, String string2) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, string, stringArray3, nArray, stringArray, stringArray2, string2);
    }

    public void delete() {
        if (this.gpipeline != null) {
            try {
                if (this.gpipeline.isPlaying()) {
                    this.gpipeline.stop();
                }
            }
            catch (IllegalStateException illegalStateException) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.gpipeline.dispose();
            this.gpipeline = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public void printElements() {
        List list = this.gpipeline.getElementsRecursive();
        PApplet.println((Object)list);
        for (Element element : list) {
            PApplet.println((String)element.toString());
        }
    }

    public void setPixelDest(Object object) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = false;
    }

    public void setPixelDest(Object object, boolean bl) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = bl;
    }

    public void setPixelDest(Object object, String string, boolean bl) {
        this.copyHandler = object;
        this.copyMask = string;
        this.copyNatBuf = bl;
    }

    public void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.captureEventMethod = this.parent.getClass().getMethod("captureEvent", GSCapture.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean ready() {
        return 0 < this.bufWidth && 0 < this.bufHeight && this.pipelineReady;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public synchronized void oldFrame() {
        this.newFrame = false;
    }

    public boolean available() {
        return this.available;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public void start() {
        boolean bl = false;
        if (!this.pipelineReady) {
            this.initPipeline();
            bl = true;
        }
        this.capturing = true;
        this.gpipeline.play();
        if (bl) {
            this.initResAndFps();
        }
    }

    public void stop() {
        boolean bl = false;
        if (!this.pipelineReady) {
            this.initPipeline();
            bl = true;
        }
        this.capturing = false;
        this.gpipeline.stop();
        if (bl) {
            this.initResAndFps();
        }
    }

    public synchronized void read() {
        this.loadPixels();
        if (this.copyBufferMode) {
            if (this.natBuffer == null || this.copyBufferMethod == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1);
                this.loadPixels();
                this.firstFrame = false;
            }
            if (this.copyNatBuf) {
                IntBuffer intBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                intBuffer.rewind();
                if (this.rgbBuffer == null) {
                    this.rgbBuffer = IntBuffer.allocate(this.bufWidth * this.bufHeight);
                }
                this.rgbBuffer.rewind();
                this.rgbBuffer.put(intBuffer);
                this.rgbBuffer.rewind();
                this.natBuffer.dispose();
                this.natBuffer = null;
            } else {
                this.rgbBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
            }
            try {
                this.copyBufferMethod.invoke(this.copyHandler, this.natBuffer, this.rgbBuffer, this.bufWidth, this.bufHeight);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1);
                this.loadPixels();
                this.firstFrame = false;
            }
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
            this.newFrame = true;
        }
        this.available = false;
    }

    public int[][] resolutions() {
        int n = this.suppResList.size();
        int[][] nArray = new int[n][2];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = this.suppResList.get(i);
            nArray[i] = new int[]{nArray2[0], nArray2[1]};
        }
        return nArray;
    }

    public String[] framerates() {
        int n = this.suppFpsList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.suppFpsList.get(i);
        }
        return stringArray;
    }

    public static String[] list() {
        return GSCapture.list(capturePlugin);
    }

    public static String[] list(String string) {
        return GSCapture.list(string, devicePropertyName);
    }

    protected static String[] list(String string, String string2) {
        Object[] objectArray;
        Property property;
        GSVideo.init();
        String[] stringArray = new String[]{};
        Element element = ElementFactory.make((String)string, (String)"Source");
        PropertyProbe propertyProbe = PropertyProbe.wrap((Element)element);
        if (propertyProbe != null && (property = propertyProbe.getProperty(string2)) != null && (objectArray = propertyProbe.getValues(property)) != null) {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                stringArray[i] = (String)objectArray[i];
            }
        }
        return stringArray;
    }

    protected synchronized void invokeEvent(int n, int n2, IntBuffer intBuffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.copyPixels == null) {
            this.copyPixels = new int[n * n2];
        }
        intBuffer.rewind();
        try {
            intBuffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling captureEvent() for capture object");
                exception.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    protected synchronized void invokeEvent(int n, int n2, Buffer buffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        this.natBuffer = buffer;
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling captureEvent() for capture object");
                exception.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    protected void initGStreamer(PApplet pApplet, int n, int n2, String string, String[] stringArray, int[] nArray, String[] stringArray2, String[] stringArray3, String string2) {
        int n3;
        this.parent = pApplet;
        GSVideo.init();
        pApplet.registerDispose((Object)this);
        this.setEventHandlerObject(pApplet);
        this.gpipeline = new Pipeline("GSCapture");
        this.source = string;
        this.fps = string2;
        this.reqWidth = n;
        this.reqHeight = n2;
        this.gsource = ElementFactory.make((String)string, (String)"Source");
        if (stringArray.length != nArray.length) {
            pApplet.die("Error: number of integer property names is different from number of values.", null);
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            this.gsource.set(stringArray[n3], (Object)nArray[n3]);
        }
        if (stringArray2.length != stringArray3.length) {
            pApplet.die("Error: number of string property names is different from number of values.", null);
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            this.gsource.set(stringArray2[n3], (Object)stringArray3[n3]);
        }
        this.bufHeight = 0;
        this.bufWidth = 0;
        this.pipelineReady = false;
    }

    protected void initPipeline() {
        Object object;
        String string = "";
        if (!this.fps.equals("")) {
            string = ", framerate=" + this.fps;
        }
        if (this.copyHandler != null) {
            try {
                this.copyBufferMethod = this.copyHandler.getClass().getMethod("addPixelsToBuffer", Object.class, IntBuffer.class, Integer.TYPE, Integer.TYPE);
                this.copyBufferMode = true;
            }
            catch (Exception exception) {
                this.copyBufferMode = false;
            }
            if (this.copyBufferMode) {
                try {
                    object = this.copyHandler.getClass().getMethod("setPixelSource", Object.class);
                    ((Method)object).invoke(this.copyHandler, new Object[]{this});
                }
                catch (Exception exception) {
                    this.copyBufferMode = false;
                }
                if (this.copyBufferMode) {
                    object = "width=" + this.reqWidth + ", height=" + this.reqHeight + ", " + this.copyMask;
                    this.natSink = new BufferDataAppSink("nat", (String)object, new BufferDataAppSink.Listener(){

                        public void bufferFrame(int n, int n2, Buffer buffer) {
                            GSCapture.this.invokeEvent(n, n2, buffer);
                        }
                    });
                    this.natSink.setAutoDisposeBuffer(false);
                    this.gpipeline.addMany(new Element[]{this.gsource, this.natSink});
                    Element.linkMany((Element[])new Element[]{this.gsource, this.natSink});
                }
            }
        }
        if (!this.copyBufferMode) {
            object = ElementFactory.make((String)"ffmpegcolorspace", (String)"ColorConverter");
            Element element = ElementFactory.make((String)"capsfilter", (String)"ColorFilter");
            element.setCaps(new Caps("video/x-raw-rgb, width=" + this.reqWidth + ", height=" + this.reqHeight + ", bpp=32, depth=24" + string));
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int n, int n2, IntBuffer intBuffer) {
                    GSCapture.this.invokeEvent(n, n2, intBuffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
            this.gpipeline.addMany(new Element[]{this.gsource, object, element, this.rgbSink});
            Element.linkMany((Element[])new Element[]{this.gsource, object, element, this.rgbSink});
        }
        this.pipelineReady = true;
    }

    protected void initResAndFps() {
        String string;
        int n;
        int[] nArray;
        int n2;
        this.getSuppResAndFpsList();
        boolean bl = 0 >= this.suppResList.size();
        for (n2 = 0; n2 < this.suppResList.size(); ++n2) {
            nArray = this.suppResList.get(n2);
            if (this.reqWidth != nArray[0] || this.reqHeight != nArray[1]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            System.err.println("The requested resolution of " + this.reqWidth + "x" + this.reqHeight + " is not supported by the capture device.");
            System.err.println("Use one of the following resolutions instead:");
            for (n2 = 0; n2 < this.suppResList.size(); ++n2) {
                nArray = this.suppResList.get(n2);
                System.err.println(nArray[0] + "x" + nArray[1]);
            }
        }
        n2 = 0 >= this.suppFpsList.size() ? 1 : 0;
        for (n = 0; n < this.suppFpsList.size(); ++n) {
            string = this.suppFpsList.get(n);
            if (!this.fps.equals("") && !this.fps.equals(string)) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            System.err.println("The requested framerate of " + this.fps + " is not supported by the capture device.");
            System.err.println("Use one of the following framerates instead:");
            for (n = 0; n < this.suppFpsList.size(); ++n) {
                string = this.suppFpsList.get(n);
                System.err.println(string);
            }
        }
    }

    protected void getSuppResAndFpsList() {
        this.suppResList = new ArrayList();
        this.suppFpsList = new ArrayList();
        for (Element element : this.gpipeline.getSources()) {
            for (Pad pad : element.getPads()) {
                Caps caps = pad.getCaps();
                int n = caps.size();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    int n2;
                    Structure structure = caps.getStructure(i);
                    if (!structure.hasIntField("width") || !structure.hasIntField("height")) continue;
                    int n3 = (Integer)structure.getValue("width");
                    int n4 = (Integer)structure.getValue("height");
                    boolean bl = true;
                    for (n2 = 0; n2 < this.suppResList.size(); ++n2) {
                        object = this.suppResList.get(n2);
                        if (n3 != object[0] || n4 != object[1]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        this.suppResList.add(new int[]{n3, n4});
                    }
                    if (PApplet.platform == 1) {
                        int n5;
                        String string = structure.toString();
                        int n6 = string.indexOf("framerate=(fraction)");
                        if (-1 >= n6) continue;
                        String string2 = string.substring(n6 + 20, string.length());
                        int n7 = string2.indexOf("[");
                        int n8 = string2.indexOf("]");
                        if (-1 < n7 && -1 < n8) {
                            string2 = string2.substring(n7 + 1, n8);
                            String[] stringArray = string2.split(",");
                            for (n5 = 0; n5 < stringArray.length; ++n5) {
                                this.addFpsStr(stringArray[n5].trim());
                            }
                            continue;
                        }
                        int n9 = string2.indexOf(",");
                        n5 = string2.indexOf(";");
                        if (-1 >= n9 && -1 >= n5) continue;
                        int n10 = -1;
                        n10 = n9 == -1 ? n5 : (n5 == -1 ? n9 : PApplet.min((int)n9, (int)n5));
                        string2 = string2.substring(0, n10);
                        this.addFpsStr(string2.trim());
                        continue;
                    }
                    n2 = 0;
                    try {
                        object = structure.getFraction("framerate");
                        this.addFps((Fraction)object);
                        n2 = 1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n2 != 0) continue;
                    object = null;
                    try {
                        object = structure.getValueList("framerate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object == null) continue;
                    for (int j = 0; j < object.getSize(); ++j) {
                        Fraction fraction = object.getFraction(j);
                        this.addFps(fraction);
                    }
                }
            }
        }
    }

    protected void addFps(Fraction fraction) {
        int n = fraction.numerator;
        int n2 = fraction.denominator;
        this.addFpsStr(n + "/" + n2);
    }

    protected void addFpsStr(String string) {
        boolean bl = true;
        for (int i = 0; i < this.suppFpsList.size(); ++i) {
            String string2 = this.suppFpsList.get(i);
            if (!string.equals(string2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.suppFpsList.add(string);
        }
    }

    public synchronized void disposeBuffer(Object object) {
        if (object != null) {
            ((Buffer)object).dispose();
        }
    }

    static {
        if (PApplet.platform == 2) {
            if (GSVideo.bitsJVM == 32) {
                capturePlugin = "osxvideosrc";
                devicePropertyName = "device";
                indexPropertyName = "";
            } else if (GSVideo.bitsJVM == 64) {
                capturePlugin = "qtkitvideosrc";
                devicePropertyName = "";
                indexPropertyName = "device-index";
            }
        } else if (PApplet.platform == 1) {
            capturePlugin = "ksvideosrc";
            devicePropertyName = "device-name";
            indexPropertyName = "device-index";
        } else if (PApplet.platform == 3) {
            capturePlugin = "v4l2src";
            devicePropertyName = "device";
            indexPropertyName = "device-fd";
        }
    }
}

