/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSLibraryLoader {
    private static GSLibraryLoader instance;
    static final Object[][] WIN32_DEPENDENCIES;
    static final Object[][] OSX_DEPENDENCIES;
    static final Object[][] DEFAULT_DEPENDENCIES;
    static final Object[][] dependencies;
    private static final Map<String, Object> loadedMap;
    private static final int RECURSIVE_LOAD_MAX_DEPTH = 5;

    private GSLibraryLoader() {
    }

    private void preLoadLibs() {
        for (Object[] objectArray : dependencies) {
            this.load(objectArray[0].toString(), DummyLibrary.class, true, 0, (Boolean)objectArray[2]);
        }
    }

    private String[] findDeps(String string) {
        for (Object[] objectArray : dependencies) {
            if (!string.equals(objectArray[0])) continue;
            return (String[])objectArray[1];
        }
        return new String[0];
    }

    public Object load(String string, Class<?> clazz, boolean bl) {
        return this.load(string, clazz, true, 0, bl);
    }

    private Object load(String string, Class<?> clazz, boolean bl, int n, boolean bl2) {
        assert (n < 5) : String.format("recursive max load depth %s has been exceeded", n);
        Object object = loadedMap.get(string);
        if (null == object || bl) {
            try {
                String[] stringArray;
                for (String string2 : stringArray = this.findDeps(string)) {
                    this.load(string2, DummyLibrary.class, false, n + 1, bl2);
                }
                object = GSLibraryLoader.loadLibrary(string, clazz, bl2);
                if (object != null) {
                    loadedMap.put(string, object);
                }
            }
            catch (Exception exception) {
                if (bl2) {
                    throw new RuntimeException(String.format("can not load library %s", string, exception));
                }
                System.out.println(String.format("can not load library %s", string, exception));
            }
        }
        return object;
    }

    private static Object loadLibrary(String string, Class<?> clazz, boolean bl) {
        String[] stringArray;
        if (Platform.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "lib%s";
            stringArray2[1] = "lib%s-0";
            stringArray = stringArray2;
            stringArray2[2] = "%s";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "%s-0";
            stringArray = stringArray3;
            stringArray3[1] = "%s";
        }
        String[] stringArray4 = stringArray;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (String string2 : stringArray4) {
            try {
                String string3 = String.format(string2, string);
                Object object = Native.loadLibrary((String)string3, clazz);
                return object;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        if (bl) {
            throw new UnsatisfiedLinkError(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", string, System.getProperty("jna.library.path"), unsatisfiedLinkError));
        }
        System.out.println(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", string, System.getProperty("jna.library.path"), unsatisfiedLinkError));
        return null;
    }

    public static synchronized GSLibraryLoader getInstance() {
        if (null == instance) {
            instance = new GSLibraryLoader();
            instance.preLoadLibs();
        }
        return instance;
    }

    static {
        WIN32_DEPENDENCIES = new Object[][]{{"gio-2.0", new String[0], true}, {"glib-2.0", new String[0], true}, {"gmodule-2.0", new String[0], true}, {"gobject-2.0", new String[0], true}, {"gthread-2.0", new String[0], true}, {"gstapp-0.10", new String[0], true}, {"gstaudio-0.10", new String[0], true}, {"gstbase-0.10", new String[0], true}, {"gstbasevideo-0.10", new String[0], true}, {"gstcdda-0.10", new String[0], true}, {"gstcontroller-0.10", new String[0], true}, {"gstdataprotocol-0.10", new String[0], true}, {"gstfft-0.10", new String[0], true}, {"gstinterfaces-0.10", new String[0], true}, {"gstnet-0.10", new String[0], true}, {"gstnetbuffer-0.10", new String[0], true}, {"gstpbutils-0.10", new String[0], true}, {"gstphotography-0.10", new String[0], true}, {"gstreamer-0.10", new String[0], true}, {"gstriff-0.10", new String[0], true}, {"gstrtp-0.10", new String[0], true}, {"gstrtsp-0.10", new String[0], true}, {"gstsdp-0.10", new String[0], true}, {"gstsignalprocessor-0.10", new String[0], true}, {"gsttag-0.10", new String[0], true}, {"gstvideo-0.10", new String[0], true}, {"libiconv-2", new String[0], false}, {"libintl-8", new String[0], false}, {"libjpeg-8", new String[0], false}, {"libmp3lame-0", new String[0], false}, {"libogg-0", new String[0], false}, {"liborc-0.4-0", new String[0], false}, {"liborc-test-0.4-0", new String[0], false}, {"libpng14-14", new String[0], false}, {"libtheora-0", new String[0], false}, {"libtheoradec-1", new String[0], false}, {"libtheoraenc-1", new String[0], false}, {"libvorbis-0", new String[0], false}, {"libvorbisenc-2", new String[0], false}, {"libvorbisfile-3", new String[0], false}, {"libwavpack-1", new String[0], false}, {"libxml2-2", new String[0], false}, {"zlib1", new String[0], false}};
        OSX_DEPENDENCIES = new Object[][]{{"gstbase-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstinterfaces-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstcontroller-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstaudio-0.10", new String[]{"gstbase-0.10"}, true}, {"gstvideo-0.10", new String[]{"gstbase-0.10"}, true}};
        DEFAULT_DEPENDENCIES = new Object[][]{{"gstreamer-0.10", new String[0], true}, {"gstbase-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstinterfaces-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstcontroller-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstaudio-0.10", new String[]{"gstbase-0.10"}, true}, {"gstvideo-0.10", new String[]{"gstbase-0.10"}, true}};
        dependencies = Platform.isWindows() ? WIN32_DEPENDENCIES : (Platform.isMac() ? OSX_DEPENDENCIES : DEFAULT_DEPENDENCIES);
        loadedMap = new HashMap<String, Object>();
    }

    public static interface DummyLibrary
    extends Library {
    }
}

