/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSMovie
extends PImage
implements PConstants {
    protected String filename;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected float fps;
    protected float rate;
    protected int bufWidth;
    protected int bufHeight;
    protected PlayBin2 gplayer;
    protected Method movieEventMethod;
    protected Method copyBufferMethod;
    protected Object eventHandler;
    protected Object copyHandler;
    protected boolean available;
    protected boolean sinkReady;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected BufferDataAppSink natSink = null;
    protected Buffer natBuffer = null;
    protected IntBuffer rgbBuffer = null;
    protected boolean copyNatBuf = false;
    protected boolean copyBufferMode = false;
    protected String copyMask;
    protected boolean firstFrame = true;
    protected boolean newFrame = false;
    protected boolean seeking = false;

    public GSMovie(PApplet pApplet, String string) {
        super(0, 0, 1);
        this.initGStreamer(pApplet, string);
    }

    public void delete() {
        if (this.gplayer != null) {
            try {
                if (this.gplayer.isPlaying()) {
                    this.gplayer.stop();
                }
            }
            catch (IllegalStateException illegalStateException) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.gplayer.dispose();
            this.gplayer = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public void printElements() {
        List list = this.gplayer.getElementsRecursive();
        PApplet.println((Object)list);
        for (Element element : list) {
            PApplet.println((String)element.toString());
        }
    }

    public void setPixelDest(Object object) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = false;
    }

    public void setPixelDest(Object object, boolean bl) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = bl;
    }

    public void setPixelDest(Object object, String string, boolean bl) {
        this.copyHandler = object;
        this.copyMask = string;
        this.copyNatBuf = bl;
    }

    public void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", GSMovie.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSourceWidth() {
        Dimension dimension = this.gplayer.getVideoSize();
        if (dimension != null) {
            return dimension.width;
        }
        return 0;
    }

    public int getSourceHeight() {
        Dimension dimension = this.gplayer.getVideoSize();
        if (dimension != null) {
            return dimension.height;
        }
        return 0;
    }

    public float getSourceFrameRate() {
        return (float)this.gplayer.getVideoSinkFrameRate();
    }

    public void frameRate(float f) {
        long l;
        long l2;
        float f2;
        float f3 = f2 = 0.0f < f && 0.0f < this.fps ? f / this.fps : 1.0f;
        if (this.playing) {
            this.gplayer.pause();
        }
        long l3 = this.gplayer.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            l2 = l3;
            l = -1L;
        } else {
            l2 = 0L;
            l = l3;
        }
        boolean bl = this.gplayer.seek((double)(this.rate * f2), Format.TIME, 1, SeekType.SET, l2, SeekType.SET, l);
        if (!bl) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gplayer.play();
        }
        this.fps = f;
    }

    public void speed(float f) {
        if ((double)PApplet.abs((float)(this.rate - f)) > 0.1) {
            this.rate = f;
            this.frameRate(this.fps);
        }
    }

    public float duration() {
        float f = this.gplayer.queryDuration().toSeconds();
        float f2 = this.gplayer.queryDuration().getNanoSeconds();
        return f + GSVideo.nanoSecToSecFrac(f2);
    }

    public float time() {
        float f = this.gplayer.queryPosition().toSeconds();
        float f2 = this.gplayer.queryPosition().getNanoSeconds();
        return f + GSVideo.nanoSecToSecFrac(f2);
    }

    public long length() {
        return (int)(this.duration() * this.getSourceFrameRate());
    }

    public int frame() {
        double d = (double)this.gplayer.queryPosition().toSeconds() + (double)this.gplayer.queryPosition().getNanoSeconds() * 1.0E-9;
        return (int)Math.ceil(d * (double)this.getSourceFrameRate()) - 1;
    }

    public void jump(float f) {
        long l = GSVideo.secToNanoLong(f);
        boolean bl = this.gplayer.seek(1.0, Format.TIME, 1, SeekType.SET, l, SeekType.NONE, -1L);
        if (!bl) {
            System.err.println("Seek operation failed.");
        }
        this.seeking = true;
        this.gplayer.getState();
        this.seeking = false;
    }

    public void jump(int n) {
        float f = this.getSourceFrameRate();
        float f2 = 1.0f / f;
        float f3 = ((float)n + 0.5f) * f2;
        float f4 = this.duration() - f3;
        if (f4 < 0.0f) {
            f3 += f4 - 0.25f * f2;
        }
        this.jump(f3);
    }

    public boolean ready() {
        return 0 < this.bufWidth && 0 < this.bufHeight && this.sinkReady && !this.seeking;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public synchronized void oldFrame() {
        this.newFrame = false;
    }

    public boolean available() {
        return this.available;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    public boolean isSeeking() {
        return this.seeking;
    }

    public void play() {
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = true;
        this.paused = false;
        this.gplayer.play();
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        if (!this.sinkReady) {
            this.initSink();
        }
        this.repeat = false;
    }

    public void pause() {
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = false;
        this.paused = true;
        this.gplayer.pause();
    }

    public void stop() {
        if (!this.sinkReady) {
            this.initSink();
        }
        if (this.playing) {
            this.goToBeginning();
            this.playing = false;
        }
        this.paused = false;
        this.gplayer.stop();
    }

    public synchronized void read() {
        if (this.fps <= 0.0f) {
            this.fps = this.getSourceFrameRate();
        }
        this.loadPixels();
        if (this.copyBufferMode) {
            if (this.natBuffer == null || this.copyBufferMethod == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1);
                this.loadPixels();
                this.firstFrame = false;
            }
            if (this.copyNatBuf) {
                IntBuffer intBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                intBuffer.rewind();
                if (this.rgbBuffer == null) {
                    this.rgbBuffer = IntBuffer.allocate(this.bufWidth * this.bufHeight);
                }
                this.rgbBuffer.rewind();
                this.rgbBuffer.put(intBuffer);
                this.rgbBuffer.rewind();
                this.natBuffer.dispose();
                this.natBuffer = null;
            } else {
                this.rgbBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
            }
            try {
                this.copyBufferMethod.invoke(this.copyHandler, this.natBuffer, this.rgbBuffer, this.bufWidth, this.bufHeight);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                this.resize(this.bufWidth, this.bufHeight);
                this.firstFrame = false;
            }
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
            this.newFrame = true;
        }
        this.available = false;
    }

    public void goToBeginning() {
        this.jump(0.0f);
    }

    public void goToEnd() {
        this.jump(this.duration());
    }

    public void volume(float f) {
        if (this.playing) {
            this.gplayer.setVolume((double)f);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    protected void initGStreamer(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.gplayer = null;
        GSVideo.init();
        try {
            File file;
            try {
                file = new File(pApplet.dataPath(string));
                if (file.exists()) {
                    this.gplayer = new PlayBin2("GSMovie Player");
                    this.gplayer.setInputFile(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.gplayer == null) {
                try {
                    file = new File(string);
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSMovie Player");
                        this.gplayer.setInputFile(file);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.gplayer == null && string.startsWith("http://")) {
                try {
                    this.gplayer = new PlayBin2("GSMovie Player");
                    this.gplayer.setURI(URI.create(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.gplayer == null) {
            pApplet.die("Could not load movie file " + string, null);
        }
        try {
            this.filename = string;
            pApplet.registerDispose((Object)this);
            this.setEventHandlerObject(pApplet);
            this.rate = 1.0f;
            this.fps = -1.0f;
            this.sinkReady = false;
            this.bufHeight = 0;
            this.bufWidth = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initSink() {
        Object object;
        if (this.copyHandler != null) {
            try {
                this.copyBufferMethod = this.copyHandler.getClass().getMethod("addPixelsToBuffer", Object.class, IntBuffer.class, Integer.TYPE, Integer.TYPE);
                this.copyBufferMode = true;
            }
            catch (Exception exception) {
                this.copyBufferMode = false;
            }
            if (this.copyBufferMode) {
                try {
                    object = this.copyHandler.getClass().getMethod("setPixelSource", Object.class);
                    ((Method)object).invoke(this.copyHandler, new Object[]{this});
                }
                catch (Exception exception) {
                    this.copyBufferMode = false;
                }
                if (this.copyBufferMode) {
                    this.natSink = new BufferDataAppSink("nat", this.copyMask, new BufferDataAppSink.Listener(){

                        public void bufferFrame(int n, int n2, Buffer buffer) {
                            GSMovie.this.invokeEvent(n, n2, buffer);
                        }
                    });
                    this.natSink.setAutoDisposeBuffer(false);
                    this.gplayer.setVideoSink((Element)this.natSink);
                    this.natSink.dispose();
                }
            }
        }
        if (!this.copyBufferMode) {
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int n, int n2, IntBuffer intBuffer) {
                    GSMovie.this.invokeEvent(n, n2, intBuffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
            this.gplayer.setVideoSink((Element)this.rgbSink);
            this.rgbSink.dispose();
        }
        object = this.gplayer.getBus();
        object.connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                GSMovie.this.eosEvent();
            }
        });
        this.sinkReady = true;
    }

    protected synchronized void invokeEvent(int n, int n2, IntBuffer intBuffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.copyPixels == null) {
            this.copyPixels = new int[n * n2];
        }
        intBuffer.rewind();
        try {
            intBuffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.playing && this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                exception.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    protected synchronized void invokeEvent(int n, int n2, Buffer buffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        this.natBuffer = buffer;
        if (this.playing && this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                exception.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    public synchronized void disposeBuffer(Object object) {
        if (object != null) {
            ((Buffer)object).dispose();
        }
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        } else {
            this.playing = false;
        }
    }
}

