/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.io.File;
import java.nio.ByteBuffer;
import org.gstreamer.Buffer;
import org.gstreamer.elements.RGBDataFileSink;
import processing.core.PApplet;

public class GSMovieMaker {
    protected PApplet parent;
    protected boolean recording;
    protected RGBDataFileSink recorder;
    protected int width;
    protected int height;
    public static final int THEORA = 0;
    public static final int XVID = 1;
    public static final int X264 = 2;
    public static final int DIRAC = 3;
    public static final int MJPEG = 4;
    public static final int MJPEG2K = 5;
    public static final int WORST = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int BEST = 4;

    public GSMovieMaker(PApplet pApplet, int n, int n2, String string) {
        this.init(pApplet, n, n2, string, 0, 2, 30);
    }

    public GSMovieMaker(PApplet pApplet, int n, int n2, String string, int n3, int n4) {
        this.init(pApplet, n, n2, string, n3, 2, n4);
    }

    public GSMovieMaker(PApplet pApplet, int n, int n2, String string, int n3, int n4, int n5) {
        this.init(pApplet, n, n2, string, n3, n4, n5);
    }

    public GSMovieMaker(PApplet pApplet, int n, int n2, String string, String string2, String string3, int n3) {
        this.init(pApplet, n, n2, string, string2, string3, null, null, n3);
    }

    public GSMovieMaker(PApplet pApplet, int n, int n2, String string, String string2, String string3, String[] stringArray, Object[] objectArray, int n3) {
        this.init(pApplet, n, n2, string, string2, string3, stringArray, objectArray, n3);
    }

    public void delete() {
        this.recorder.stop();
        this.recorder.dispose();
    }

    public void dispose() {
        this.delete();
    }

    public void addFrame(int[] nArray) {
        if (this.recording && nArray.length == this.width * this.height) {
            Buffer buffer = new Buffer(this.width * this.height * 4);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            byteBuffer.clear();
            byteBuffer.asIntBuffer().put(nArray);
            this.recorder.pushRGBFrame(buffer);
        }
    }

    public void start() {
        this.recorder.start();
        this.recording = true;
    }

    public void finish() {
        this.recording = false;
        this.recorder.stop();
    }

    public int getQueuedFrames() {
        return this.recorder.getNumQueuedFrames();
    }

    public int getDroppedFrames() {
        return this.recorder.getNumDroppedFrames();
    }

    public void setQueueSize(int n, int n2) {
        this.recorder.setPreQueueSize(n);
        this.recorder.setSrcQueueSize(n2);
    }

    public boolean isRecording() {
        return this.recording;
    }

    protected void init(PApplet pApplet, int n, int n2, String string, int n3, int n4, int n5) {
        this.parent = pApplet;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        this.width = n;
        this.height = n2;
        String[] stringArray = null;
        Object[] objectArray = null;
        String string2 = "";
        String string3 = "";
        String string4 = string.toLowerCase();
        if (string4.endsWith(".ogg")) {
            string3 = "oggmux";
        } else if (string4.endsWith(".avi")) {
            string3 = "avimux";
        } else if (string4.endsWith(".mov")) {
            string3 = "qtmux";
        } else if (string4.endsWith(".flv")) {
            string3 = "flvmux";
        } else if (string4.endsWith(".mkv")) {
            string3 = "matroskamux";
        } else if (string4.endsWith(".mp4")) {
            string3 = "mp4mux";
        } else if (string4.endsWith(".3gp")) {
            string3 = "gppmux";
        } else if (string4.endsWith(".mpg")) {
            string3 = "ffmux_mpeg";
        } else if (string4.endsWith(".mj2")) {
            string3 = "mj2mux";
        } else {
            this.parent.die("Unrecognized video container", null);
        }
        if (n3 == 0) {
            string2 = "theoraenc";
            stringArray = new String[1];
            objectArray = new Object[1];
            stringArray[0] = "quality";
            Integer n6 = 31;
            if (n4 == 0) {
                n6 = 0;
            } else if (n4 == 1) {
                n6 = 15;
            } else if (n4 == 2) {
                n6 = 31;
            } else if (n4 == 3) {
                n6 = 47;
            } else if (n4 == 4) {
                n6 = 63;
            }
            objectArray[0] = n6;
        } else if (n3 == 3) {
            string2 = "schroenc";
            stringArray = new String[1];
            objectArray = new Object[1];
            stringArray[0] = "quality";
            Double d = 5.0;
            if (n4 == 0) {
                d = 0.0;
            } else if (n4 == 1) {
                d = 2.5;
            } else if (n4 == 2) {
                d = 5.0;
            } else if (n4 == 3) {
                d = 7.5;
            } else if (n4 == 4) {
                d = 10.0;
            }
            objectArray[0] = d;
        } else if (n3 == 1) {
            string2 = "xvidenc";
        } else if (n3 == 2) {
            string2 = "x264enc";
            stringArray = new String[2];
            objectArray = new Object[2];
            stringArray[0] = "pass";
            Integer n7 = 5;
            objectArray[0] = n7;
            stringArray[1] = "quantizer";
            Integer n8 = 21;
            if (n4 == 0) {
                n8 = 50;
            } else if (n4 == 1) {
                n8 = 35;
            } else if (n4 == 2) {
                n8 = 21;
            } else if (n4 == 3) {
                n8 = 15;
            } else if (n4 == 4) {
                n8 = 1;
            }
            objectArray[1] = n8;
        } else if (n3 == 4) {
            string2 = "jpegenc";
            stringArray = new String[1];
            objectArray = new Object[1];
            stringArray[0] = "quality";
            Integer n9 = 85;
            if (n4 == 0) {
                n9 = 0;
            } else if (n4 == 1) {
                n9 = 30;
            } else if (n4 == 2) {
                n9 = 50;
            } else if (n4 == 3) {
                n9 = 85;
            } else if (n4 == 4) {
                n9 = 100;
            }
            objectArray[0] = n9;
        } else if (n3 == 5) {
            string2 = "jp2kenc";
        } else {
            this.parent.die("Unrecognized video codec", null);
        }
        this.initRecorder(string, n5, string2, string3, stringArray, objectArray);
    }

    protected void init(PApplet pApplet, int n, int n2, String string, String string2, String string3, String[] stringArray, Object[] objectArray, int n3) {
        this.parent = pApplet;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        this.width = n;
        this.height = n2;
        this.initRecorder(string, n3, string2, string3, stringArray, objectArray);
    }

    protected void initRecorder(String string, int n, String string2, String string3, String[] stringArray, Object[] objectArray) {
        File file = new File(this.parent.savePath(string));
        this.recorder = new RGBDataFileSink("MovieMaker", this.width, this.height, n, string2, stringArray, objectArray, string3, file);
        this.recording = false;
        this.setQueueSize(60, 30);
    }
}

