/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.SeekType;
import org.gstreamer.elements.BufferDataSink;
import org.gstreamer.elements.ByteDataSink;
import org.gstreamer.elements.RGBDataSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSPipeline
extends PImage
implements PConstants {
    protected int streamType;
    protected String pipeline;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected int bufWidth;
    protected int bufHeight;
    protected int bufSize;
    protected Pipeline gpipeline;
    protected Method pipelineEventMethod;
    protected Method copyBufferMethod;
    protected Object eventHandler;
    protected Object copyHandler;
    protected boolean available;
    protected boolean pipelineReady;
    protected RGBDataSink rgbSink = null;
    protected int[] copyPixels = null;
    protected BufferDataSink natSink = null;
    protected Buffer natBuffer = null;
    protected IntBuffer rgbBuffer = null;
    protected boolean copyNatBuf = false;
    protected boolean copyBufferMode = false;
    protected String copyMask;
    protected ByteDataSink dataSink = null;
    protected byte[] copyData = null;
    public byte[] data = null;
    public String dataCaps;
    protected String tempDataCaps;
    protected boolean firstFrame = true;
    protected boolean newFrame = false;
    protected boolean seeking = false;

    public GSPipeline(PApplet pApplet, String string) {
        super(0, 0, 1);
        this.initGStreamer(pApplet, string, 1);
    }

    public GSPipeline(PApplet pApplet, String string, int n) {
        super(0, 0, 1);
        this.initGStreamer(pApplet, string, n);
    }

    public void delete() {
        if (this.gpipeline != null) {
            try {
                if (this.gpipeline.isPlaying()) {
                    this.gpipeline.stop();
                }
            }
            catch (IllegalStateException illegalStateException) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pixels = null;
            this.data = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.copyData = null;
            if (this.dataSink != null) {
                this.dataSink.removeListener();
                this.dataSink.dispose();
                this.dataSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.gpipeline.dispose();
            this.gpipeline = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public void setPixelDest(Object object) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = false;
    }

    public void setPixelDest(Object object, boolean bl) {
        this.copyHandler = object;
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
        this.copyNatBuf = bl;
    }

    public void setPixelDest(Object object, String string, boolean bl) {
        this.copyHandler = object;
        this.copyMask = string;
        this.copyNatBuf = bl;
    }

    public void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.pipelineEventMethod = this.eventHandler.getClass().getMethod("pipelineEvent", GSPipeline.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float duration() {
        float f = this.gpipeline.queryDuration().toSeconds();
        float f2 = this.gpipeline.queryDuration().getNanoSeconds();
        return f + GSVideo.nanoSecToSecFrac(f2);
    }

    public float time() {
        float f = this.gpipeline.queryPosition().toSeconds();
        float f2 = this.gpipeline.queryPosition().getNanoSeconds();
        return f + GSVideo.nanoSecToSecFrac(f2);
    }

    public void jump(float f) {
        long l = GSVideo.secToNanoLong(f);
        boolean bl = this.gpipeline.seek(1.0, Format.TIME, 1, SeekType.SET, l, SeekType.NONE, -1L);
        if (!bl) {
            System.err.println("Seek operation failed.");
        }
        this.seeking = true;
        this.gpipeline.getState();
        this.seeking = false;
    }

    public boolean ready() {
        return 0 < this.bufSize && this.pipelineReady && !this.seeking;
    }

    public boolean newFrame() {
        return this.newFrame;
    }

    public synchronized void oldFrame() {
        this.newFrame = false;
    }

    public boolean available() {
        return this.available;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    public boolean isSeeking() {
        return this.seeking;
    }

    public void play() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        this.playing = true;
        this.paused = false;
        this.gpipeline.play();
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        this.repeat = false;
    }

    public void pause() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        this.playing = false;
        this.paused = true;
        this.gpipeline.pause();
    }

    public void stop() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        if (this.playing) {
            this.goToBeginning();
            this.playing = false;
        }
        this.paused = false;
        this.gpipeline.stop();
    }

    public synchronized void read() {
        if (this.streamType == 1) {
            this.loadPixels();
            if (this.copyBufferMode) {
                if (this.natBuffer == null || this.copyBufferMethod == null) {
                    return;
                }
                if (this.firstFrame) {
                    super.init(this.bufWidth, this.bufHeight, 1);
                    this.loadPixels();
                    this.firstFrame = false;
                }
                if (this.copyNatBuf) {
                    IntBuffer intBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                    intBuffer.rewind();
                    if (this.rgbBuffer == null) {
                        this.rgbBuffer = IntBuffer.allocate(this.bufWidth * this.bufHeight);
                    }
                    this.rgbBuffer.rewind();
                    this.rgbBuffer.put(intBuffer);
                    this.rgbBuffer.rewind();
                    this.natBuffer.dispose();
                    this.natBuffer = null;
                } else {
                    this.rgbBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                }
                try {
                    this.copyBufferMethod.invoke(this.copyHandler, this.natBuffer, this.rgbBuffer, this.bufWidth, this.bufHeight);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.natBuffer = null;
            } else {
                if (this.copyPixels == null) {
                    return;
                }
                if (this.firstFrame) {
                    super.init(this.bufWidth, this.bufHeight, 1);
                    this.loadPixels();
                    this.firstFrame = false;
                }
                int[] nArray = this.pixels;
                this.pixels = this.copyPixels;
                this.updatePixels();
                this.copyPixels = nArray;
                this.newFrame = true;
            }
        } else if (this.streamType == 2) {
            if (this.copyData == null) {
                return;
            }
            this.dataCaps = this.tempDataCaps;
            if (this.data == null) {
                this.data = new byte[this.copyData.length];
            }
            byte[] byArray = this.data;
            this.data = this.copyData;
            this.copyData = byArray;
            this.newFrame = true;
        }
        this.available = false;
    }

    public void goToBeginning() {
        this.jump(0.0f);
    }

    public void goToEnd() {
        this.jump(this.duration());
    }

    public float getProperty(String string) {
        if (this.playing) {
            return ((Number)this.gpipeline.get(string)).floatValue();
        }
        return 0.0f;
    }

    public void setProperty(String string, float f) {
        if (this.playing) {
            this.gpipeline.set(string, (Object)Float.valueOf(f));
        }
    }

    public void volume(float f) {
        this.setProperty("volume", f);
    }

    public String getPipeline() {
        return this.pipeline;
    }

    protected void initGStreamer(PApplet pApplet, String string, int n) {
        this.parent = pApplet;
        this.gpipeline = null;
        GSVideo.init();
        pApplet.registerDispose((Object)this);
        this.setEventHandlerObject(pApplet);
        this.pipeline = string;
        this.streamType = n;
        this.bufSize = 0;
        this.bufHeight = 0;
        this.bufWidth = 0;
        this.pipelineReady = false;
    }

    protected void initPipeline() {
        Object object;
        int n = this.pipeline.lastIndexOf(33);
        String string = this.pipeline.substring(n + 1, this.pipeline.length()).trim();
        String[] stringArray = string.split(" ");
        String string2 = 0 < stringArray.length ? stringArray[0] : "";
        boolean bl = string2.equals("fakesink");
        boolean bl2 = string2.equals("filesink");
        if (PApplet.platform == 1) {
            this.pipeline = this.pipeline.replace("\\", "\\\\");
        }
        if (bl || bl2) {
            this.gpipeline = Pipeline.launch((String)this.pipeline);
        } else if (this.streamType == 1) {
            StringBuilder stringBuilder;
            if (this.copyHandler != null) {
                try {
                    this.copyBufferMethod = this.copyHandler.getClass().getMethod("addPixelsToBuffer", Object.class, IntBuffer.class, Integer.TYPE, Integer.TYPE);
                    this.copyBufferMode = true;
                }
                catch (Exception exception) {
                    this.copyBufferMode = false;
                }
                if (this.copyBufferMode) {
                    try {
                        object = this.copyHandler.getClass().getMethod("setPixelSource", Object.class);
                        ((Method)object).invoke(this.copyHandler, new Object[]{this});
                    }
                    catch (Exception exception) {
                        this.copyBufferMode = false;
                    }
                    if (this.copyBufferMode) {
                        object = " ! ffmpegcolorspace ! video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ";
                        object = (String)object + this.copyMask;
                        stringBuilder = new StringBuilder(this.pipeline);
                        stringBuilder.append((String)object);
                        stringBuilder.append(" ! fakesink name=nat");
                        this.pipeline = stringBuilder.toString();
                        this.gpipeline = Pipeline.launch((String)this.pipeline);
                        this.natSink = new BufferDataSink("nat", this.gpipeline, new BufferDataSink.Listener(){

                            public void bufferFrame(int n, int n2, Buffer buffer) {
                                GSPipeline.this.invokeEvent(n, n2, buffer);
                            }
                        });
                        this.natSink.setAutoDisposeBuffer(false);
                    }
                }
            }
            if (!this.copyBufferMode) {
                object = " ! ffmpegcolorspace ! video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ";
                object = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (String)object + "red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000" : (String)object + "red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF";
                stringBuilder = new StringBuilder(this.pipeline);
                stringBuilder.append((String)object);
                stringBuilder.append(" ! fakesink name=rgb");
                this.pipeline = stringBuilder.toString();
                this.gpipeline = Pipeline.launch((String)this.pipeline);
                this.rgbSink = new RGBDataSink("rgb", this.gpipeline, new RGBDataSink.Listener(){

                    public void rgbFrame(boolean bl, int n, int n2, IntBuffer intBuffer) {
                        GSPipeline.this.invokeEvent(n, n2, intBuffer);
                    }
                });
                this.rgbSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
            }
        } else if (this.streamType == 0) {
            this.gpipeline = Pipeline.launch((String)this.pipeline);
        } else if (this.streamType == 2) {
            object = new StringBuilder(this.pipeline);
            ((StringBuilder)object).append(" ! fakesink name=data");
            this.pipeline = ((StringBuilder)object).toString();
            this.gpipeline = Pipeline.launch((String)this.pipeline);
            this.dataSink = new ByteDataSink("data", this.gpipeline, new ByteDataSink.Listener(){

                public void byteFrame(boolean bl, Caps caps, int n, ByteBuffer byteBuffer) {
                    GSPipeline.this.invokeEvent(caps, n, byteBuffer);
                }
            });
            this.dataSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
        } else {
            System.err.println("Unrecognized stream type: Please use VIDEO, AUDIO, or RAW.");
            return;
        }
        object = this.gpipeline.getBus();
        object.connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                GSPipeline.this.eosEvent();
            }
        });
        this.pipelineReady = true;
    }

    protected synchronized void invokeEvent(int n, int n2, IntBuffer intBuffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        this.bufSize = n * n2;
        if (this.copyPixels == null) {
            this.copyPixels = new int[n * n2];
        }
        intBuffer.rewind();
        try {
            intBuffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling pipelineEvent() for " + this.pipeline);
                exception.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }

    protected synchronized void invokeEvent(int n, int n2, Buffer buffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        this.bufSize = n * n2;
        this.natBuffer = buffer;
        if (this.playing && this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling movieEvent() for " + this.pipeline);
                exception.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }

    protected synchronized void invokeEvent(Caps caps, int n, ByteBuffer byteBuffer) {
        this.available = true;
        this.bufSize = n;
        this.tempDataCaps = caps.toString();
        if (this.copyData == null) {
            this.copyData = new byte[n];
        }
        byteBuffer.rewind();
        try {
            byteBuffer.get(this.copyData);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyData = null;
            return;
        }
        if (this.playing && this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling pipelineEvent() for " + this.pipeline);
                exception.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }

    public synchronized void disposeBuffer(Object object) {
        if (object != null) {
            ((Buffer)object).dispose();
        }
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        } else {
            this.playing = false;
        }
    }
}

