/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSLibraryLoader;
import codeanticode.gsvideo.GSLibraryPath;
import java.io.File;
import java.util.List;
import org.gstreamer.Gst;
import org.gstreamer.Plugin;
import org.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;

public class GSVideo
implements PConstants {
    protected static String VERSION_STRING = "1.0.0";
    protected static long INSTANCES_COUNT = 0L;
    protected static String gstreamerBinPath = "";
    protected static String gstreamerPluginsPath = "";
    protected static boolean defaultGLibContext = false;
    public static boolean globalGStreamer = true;
    public static boolean passDirectBuffer = true;
    public static String globalGStreamerPath;
    public static String globalPluginsFolder;
    protected static int bitsJVM;
    public static String localGStreamerPath;
    public static String localPluginsFolder;
    public static final int AUDIO = 0;
    public static final int VIDEO = 1;
    public static final int RAW = 2;

    public static void init() {
        if (INSTANCES_COUNT == 0L) {
            PApplet.println((String)("GSVideo version: " + VERSION_STRING));
            GSVideo.initImpl();
        }
        ++INSTANCES_COUNT;
    }

    public static void restart() {
        GSVideo.removePlugins();
        Gst.deinit();
        GSVideo.initImpl();
    }

    protected static void initImpl() {
        String[] stringArray;
        if (PApplet.platform == 3) {
            globalGStreamer = true;
            GSVideo.setLinuxPath();
        } else if (PApplet.platform == 1) {
            GSVideo.setWindowsPath();
        } else if (PApplet.platform == 2) {
            GSVideo.setMacOSXPath();
        }
        if (!gstreamerBinPath.equals("")) {
            System.setProperty("jna.library.path", gstreamerBinPath);
        }
        if (PApplet.platform == 3 && !globalGStreamer) {
            System.err.println("Loading local version of GStreamer not supported in Linux at this time.");
        }
        if (PApplet.platform == 1 && !globalGStreamer && (stringArray = GSLibraryLoader.getInstance()) == null) {
            System.err.println("Cannot load local version of GStreamer libraries.");
        }
        if (PApplet.platform != 2 || !globalGStreamer) {
            // empty if block
        }
        stringArray = new String[]{""};
        Gst.setUseDefaultContext((boolean)defaultGLibContext);
        Gst.init((String)"GSVideo", (String[])stringArray);
        GSVideo.addPlugins();
    }

    protected static void addPlugins() {
        Registry registry;
        boolean bl;
        if (!gstreamerPluginsPath.equals("") && !(bl = (registry = Registry.getDefault()).scanPath(gstreamerPluginsPath))) {
            System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginsPath);
        }
    }

    protected static void removePlugins() {
        Registry registry = Registry.getDefault();
        List list = registry.getPluginList();
        for (int i = 0; i < list.size(); ++i) {
            Plugin plugin = (Plugin)list.get(i);
            registry.removePlugin(plugin);
        }
    }

    protected static void setLinuxPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath gSLibraryPath = new GSLibraryPath();
                String string = gSLibraryPath.get();
                gstreamerBinPath = string + "/gstreamer/linux" + bitsJVM;
                gstreamerPluginsPath = gstreamerBinPath + "/" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = localGStreamerPath + "/" + localPluginsFolder;
            }
        }
    }

    protected static void setWindowsPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath gSLibraryPath = new GSLibraryPath();
                String string = gSLibraryPath.get();
                gstreamerBinPath = string + "\\gstreamer\\windows" + bitsJVM;
                gstreamerPluginsPath = gstreamerBinPath + "\\" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = localGStreamerPath + "\\" + localPluginsFolder;
            }
        }
    }

    protected static void setMacOSXPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = globalGStreamerPath;
            gstreamerPluginsPath = globalGStreamerPath + "/" + globalPluginsFolder;
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath gSLibraryPath = new GSLibraryPath();
                String string = gSLibraryPath.get();
                gstreamerBinPath = string + "/gstreamer/macosx" + bitsJVM;
                gstreamerPluginsPath = gstreamerBinPath + "/" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = localGStreamerPath + "/" + localPluginsFolder;
            }
        }
    }

    protected static boolean lookForGlobalGStreamer() {
        String string;
        GSLibraryPath gSLibraryPath = new GSLibraryPath();
        String string2 = gSLibraryPath.get();
        string2 = string2.replace("/", System.getProperty("file.separator"));
        String[] stringArray = null;
        if (!globalGStreamerPath.equals("")) {
            stringArray = new String[]{globalGStreamerPath};
        }
        if (stringArray == null) {
            String string3 = System.getProperty("java.library.path");
            string = System.getProperty("path.separator");
            stringArray = string3.split(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (!string2.equals("") && string.indexOf(string2) != -1 || !GSVideo.libgstreamerPresent(string, "libgstreamer")) continue;
            globalGStreamerPath = string;
            return true;
        }
        return false;
    }

    protected static boolean libgstreamerPresent(String string, String string2) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (-1 >= stringArray[i].indexOf(string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected static float nanoSecToSecFrac(float f) {
        for (int i = 0; i < 3; ++i) {
            f = (float)((double)f / 1000.0);
        }
        return f;
    }

    protected static long secToNanoLong(float f) {
        Double d = new Double((double)f * 1.0E9);
        return d.longValue();
    }

    static {
        globalPluginsFolder = "gstreamer-0.10";
        if (PApplet.platform == 2) {
            globalGStreamerPath = "/System/Library/Frameworks/GStreamer.framework/Versions/Current/lib";
        } else if (PApplet.platform == 1) {
            globalGStreamerPath = "";
        } else if (PApplet.platform == 3) {
            globalGStreamerPath = "/usr/lib";
        }
        bitsJVM = PApplet.parseInt((String)System.getProperty("sun.arch.data.model"));
        localGStreamerPath = "";
        localPluginsFolder = "plugins";
    }
}

