/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class ModelLoader
extends ModelSet {
    private ModelLoader mergeModelSet;
    private boolean merging;
    private String jmolData;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private String[] group3Lists;
    private int[][] group3Counts;
    private boolean someModelsHaveUnitcells;
    private boolean isTrajectory;
    private String fileHeader;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    private final Hashtable htAtomMap = new Hashtable();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseTrajectoryCount = 0;
    private boolean appendNew;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private static Hashtable htAtom = new Hashtable();

    public ModelLoader(Viewer viewer, String string) {
        if (this.shapes == null && !viewer.isDataOnly()) {
            this.shapes = new Shape[32];
        }
        this.viewer = viewer;
        this.initializeInfo(string, 1, null, null);
        this.createModelSet(null, null);
        this.modelSetName = "zapped";
        viewer.setStringProperty("_fileType", "");
    }

    public ModelLoader(Viewer viewer, Object object, ModelLoader modelLoader, String string) {
        if (this.shapes == null && !viewer.isDataOnly()) {
            this.shapes = new Shape[32];
        }
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        this.modelSetName = string;
        this.mergeModelSet = modelLoader;
        this.merging = modelLoader != null && modelLoader.atomCount > 0;
        this.viewer = viewer;
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), jmolAdapter.getEstimatedAtomCount(object), jmolAdapter.getAtomSetCollectionProperties(object), jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object));
        this.createModelSet(jmolAdapter, object);
    }

    private void initializeInfo(String string, int n, Properties properties, Hashtable hashtable) {
        this.g3d = this.viewer.getGraphics3D();
        this.modelSetTypeName = string;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.setModelSetProperties(properties);
        this.setModelSetAuxiliaryInfo(hashtable);
        this.isPDB = this.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.jmolData = (String)this.getModelSetAuxiliaryInfo("jmolData");
        this.fileHeader = (String)this.getModelSetAuxiliaryInfo("fileHeader");
        this.trajectorySteps = (Vector)this.getModelSetAuxiliaryInfo("trajectorySteps");
        this.isTrajectory = this.trajectorySteps != null;
        this.adapterTrajectoryCount = this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
        this.someModelsHaveSymmetry = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
        }
        this.initializeBuild(n);
    }

    private void initializeBuild(int n) {
        if (n <= 0) {
            n = 2000;
        }
        if (this.merging) {
            this.atoms = this.mergeModelSet.atoms;
            this.bonds = this.mergeModelSet.bonds;
        } else {
            this.atoms = new Atom[n];
            this.bonds = new Bond[250 + n];
        }
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    private void initializeGroupBuild() {
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
    }

    private void createModelSet(JmolAdapter jmolAdapter, Object object) {
        this.adapterModelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        boolean bl = this.appendNew = !this.merging || jmolAdapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.viewer.getAppendNew();
        if (this.merging) {
            this.mergeModelArrays();
        }
        this.initializeAtomBondModelCounts();
        if (jmolAdapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, false, null);
        } else {
            Quaternion quaternion;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((quaternion = (Quaternion)this.getModelSetAuxiliaryInfo("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + quaternion);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(jmolAdapter, object);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            this.iterateOverAllNewStructures(jmolAdapter, object);
            if (jmolAdapter != null) {
                jmolAdapter.finish(object);
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        this.calculatePolymers(null);
        this.freeze();
        this.calcBoundBoxDimensions(null);
        this.finalizeShapes();
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    protected void releaseModelSet() {
        this.group3Lists = null;
        this.group3Counts = null;
        this.groups = null;
        super.releaseModelSet();
    }

    private void mergeModelArrays() {
        this.baseModelCount = this.mergeModelSet.modelCount;
        this.baseTrajectoryCount = this.mergeModelSet.getTrajectoryCount();
        if (this.baseTrajectoryCount > 0) {
            if (this.isTrajectory) {
                for (int i = 0; i < this.trajectorySteps.size(); ++i) {
                    this.mergeModelSet.trajectorySteps.addElement(this.trajectorySteps.elementAt(i));
                }
            }
            this.trajectorySteps = this.mergeModelSet.trajectorySteps;
        }
        this.modelFileNumbers = this.mergeModelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = this.mergeModelSet.modelNumbersForAtomLabel;
        this.modelNames = this.mergeModelSet.modelNames;
        this.modelNumbers = this.mergeModelSet.modelNumbers;
        this.frameTitles = this.mergeModelSet.frameTitles;
    }

    private void initializeAtomBondModelCounts() {
        this.atomCount = 0;
        this.bondCount = 0;
        int n = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelCount = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelCount = this.baseModelCount;
            }
            this.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.bondCount = this.mergeModelSet.bondCount;
            this.groupCount = this.baseGroupIndex = this.mergeModelSet.groupCount;
        } else {
            this.modelCount = this.adapterModelCount;
        }
        if (n > 1) {
            this.modelCount += n - 1;
        }
        this.models = (Model[])ArrayUtil.setLength(this.models, this.modelCount);
        this.modelFileNumbers = ArrayUtil.setLength(this.modelFileNumbers, this.modelCount);
        this.modelNumbers = ArrayUtil.setLength(this.modelNumbers, this.modelCount);
        this.modelNumbersForAtomLabel = ArrayUtil.setLength(this.modelNumbersForAtomLabel, this.modelCount);
        this.modelNames = ArrayUtil.setLength(this.modelNames, this.modelCount);
        this.frameTitles = ArrayUtil.setLength(this.frameTitles, this.modelCount);
    }

    private void initializeMerge() {
        this.merge(this.mergeModelSet);
        this.bsSymmetry = this.mergeModelSet.bsSymmetry;
        Hashtable hashtable = this.mergeModelSet.getAuxiliaryInfo(null);
        String[] stringArray = (String[])hashtable.get("group3Lists");
        int[][] nArray = (int[][])hashtable.get("group3Counts");
        if (stringArray != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = stringArray[i + 1];
                this.group3Counts[i + 1] = nArray[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = stringArray[0];
            this.group3Counts[0] = nArray[0];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
        this.surfaceDistance100s = null;
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object) {
        int n;
        if (this.modelCount > 0) {
            this.nullGroup = new Group(new Chain(this, this.getModel(this.baseModelIndex), ' '), "", 0, -1, -1);
        }
        this.group3Lists = new String[this.modelCount + 1];
        this.group3Counts = new int[this.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.initializeMerge();
        }
        int n2 = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int n3 = this.baseModelIndex;
        int n4 = 0;
        while (n4 < this.adapterModelCount) {
            boolean bl;
            n = this.appendNew ? jmolAdapter.getAtomSetNumber(object, n4) : Integer.MAX_VALUE;
            String string = jmolAdapter.getAtomSetName(object, n4);
            Properties properties = jmolAdapter.getAtomSetProperties(object, n4);
            Hashtable hashtable = jmolAdapter.getAtomSetAuxiliaryInfo(object, n4);
            this.viewer.setStringProperty("_fileType", (String)hashtable.get("fileType"));
            if (string == null) {
                String string2 = this.jmolData != null ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (string = n == Integer.MAX_VALUE ? "" : "" + n % 1000000);
            }
            if (bl = this.setModelNameNumberProperties(n3, n2, string, n, properties, hashtable, this.isPDB, this.jmolData)) {
                this.group3Lists[n3 + 1] = JmolConstants.group3List;
                this.group3Counts[n3 + 1] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[0] == null) {
                    this.group3Lists[0] = JmolConstants.group3List;
                    this.group3Counts[0] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.getModelAuxiliaryInfo(n3, "periodicOriginXyz") != null) {
                this.someModelsHaveSymmetry = true;
            }
            ++n4;
            ++n3;
        }
        if (this.isTrajectory) {
            Logger.info(this.modelCount - n3 + 1 + " trajectory steps read");
            n4 = this.adapterModelCount;
            for (n = n3; n < this.modelCount; ++n) {
                this.models[n] = this.models[this.baseModelCount];
                this.modelNumbers[n] = jmolAdapter.getAtomSetNumber(object, n4++);
                this.structuresDefinedInFile.set(n);
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private boolean setModelNameNumberProperties(int n, int n2, String string, int n3, Properties properties, Hashtable hashtable, boolean bl, String string2) {
        if (n3 != Integer.MAX_VALUE) {
            this.models[n] = new Model(this, n, n2, string2, properties, hashtable);
            this.modelNumbers[n] = n3;
            this.modelNames[n] = string;
        }
        String string3 = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        this.models[n].setNAltLocs(string3 == null ? 0 : string3.length());
        string3 = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        this.models[n].setNInsertions(string3 == null ? 0 : string3.length());
        this.models[n].isPDB = this.getModelAuxiliaryInfoBoolean(n, "isPDB");
        return this.models[n].isPDB;
    }

    private void finalizeModels(int n) {
        int n2;
        int n3;
        if (this.modelCount == n) {
            return;
        }
        int n4 = 0;
        int n5 = -1;
        if (this.isTrajectory) {
            n3 = n;
            while (++n3 < this.modelCount) {
                this.modelNumbers[n3] = this.modelNumbers[n3 - 1] + 1;
            }
        }
        if (n > 0) {
            if (this.modelNumbers[0] < 1000000) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.modelNames[n3].length() == 0) {
                        this.modelNames[n3] = "" + this.modelNumbers[n3];
                    }
                    int n6 = n3;
                    this.modelNumbers[n6] = this.modelNumbers[n6] + 1000000;
                    this.modelNumbersForAtomLabel[n3] = "1." + (n3 + 1);
                }
            }
            n3 = this.modelNumbers[n - 1];
            n3 -= n3 % 1000000;
            if (this.modelNumbers[n] < 1000000) {
                n3 += 1000000;
            }
            n2 = n;
            while (n2 < this.modelCount) {
                int n7 = n2++;
                this.modelNumbers[n7] = this.modelNumbers[n7] + n3;
            }
        }
        for (n3 = n; n3 < this.modelCount; ++n3) {
            String string;
            if (this.fileHeader != null) {
                this.setModelAuxiliaryInfo(n3, "fileHeader", this.fileHeader);
            }
            if ((n2 = this.modelNumbers[n3] / 1000000) != n5) {
                n4 = 0;
                n5 = n2;
            }
            ++n4;
            if (n2 == 0) {
                string = "" + this.getModelNumber(n3);
                n2 = 1;
            } else {
                string = n2 + "." + n4;
            }
            this.modelNumbersForAtomLabel[n3] = string;
            this.models[n3].fileIndex = n2 - 1;
            this.modelFileNumbers[n3] = n2 * 1000000 + n4;
            if (this.modelNames[n3] != null && this.modelNames[n3].length() != 0) continue;
            this.modelNames[n3] = string;
        }
        if (this.merging) {
            for (n3 = 0; n3 < n; ++n3) {
                this.models[n3].modelSet = this;
            }
        }
        for (n3 = 0; n3 < this.modelCount; ++n3) {
            this.setModelAuxiliaryInfo(n3, "modelName", this.modelNames[n3]);
            this.setModelAuxiliaryInfo(n3, "modelNumber", new Integer(this.modelNumbers[n3] % 1000000));
            this.setModelAuxiliaryInfo(n3, "modelFileNumber", new Integer(this.modelFileNumbers[n3]));
            this.setModelAuxiliaryInfo(n3, "modelNumberDotted", this.getModelNumberDotted(n3));
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        short s;
        short s2 = this.viewer.getDefaultMadAtom();
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        while (atomIterator.hasNext()) {
            s = (short)atomIterator.getElementNumber();
            if (s <= 0) {
                s = JmolConstants.elementNumberFromSymbol(atomIterator.getElementSymbol());
            }
            char c = atomIterator.getAlternateLocationID();
            this.addAtom(atomIterator.getAtomSetIndex() + this.baseModelIndex, atomIterator.getAtomSymmetry(), atomIterator.getAtomSite(), atomIterator.getUniqueID(), s, atomIterator.getAtomName(), s2, atomIterator.getFormalCharge(), atomIterator.getPartialCharge(), atomIterator.getEllipsoid(), atomIterator.getOccupancy(), atomIterator.getBfactor(), atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), atomIterator.getIsHetero(), atomIterator.getAtomSerial(), atomIterator.getChainID(), atomIterator.getGroup3(), atomIterator.getSequenceNumber(), atomIterator.getInsertionCode(), atomIterator.getVectorX(), atomIterator.getVectorY(), atomIterator.getVectorZ(), c, atomIterator.getClientAtomReference(), atomIterator.getRadius());
        }
        short s3 = -1;
        for (s = 0; s < this.atomCount; ++s) {
            if (this.atoms[s].modelIndex == s3) continue;
            s3 = this.atoms[s].modelIndex;
            this.models[s3].firstAtomIndex = s;
            this.models[s3].bsAtoms = null;
        }
    }

    private void addAtom(int n, BitSet bitSet, int n2, Object object, short s, String string, int n3, int n4, float f, Object[] objectArray, int n5, float f2, float f3, float f4, float f5, boolean bl, int n6, char c, String string2, int n7, char c2, float f6, float f7, float f8, char c3, Object object2, float f9) {
        Atom atom;
        this.checkNewGroup(this.atomCount, n, c, string2, n7, c2);
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays(2000);
        }
        this.atoms[this.atomCount] = atom = new Atom(this.viewer, this.currentModelIndex, this.atomCount, bitSet, n2, s, n3, n4, f3, f4, f5, bl, c, c3, f9);
        this.setBFactor(this.atomCount, f2);
        this.setOccupancy(this.atomCount, n5);
        this.setPartialCharge(this.atomCount, f);
        if (objectArray != null) {
            this.setEllipsoid(this.atomCount, objectArray);
        }
        atom.group = this.nullGroup;
        atom.colixAtom = this.viewer.getColixAtomPalette(atom, (byte)1);
        if (string != null) {
            int n8;
            if (this.atomNames == null) {
                this.atomNames = new String[this.atoms.length];
            }
            if ((n8 = string.indexOf(0)) >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.atoms.length];
                }
                this.atomTypes[this.atomCount] = string.substring(n8 + 1);
                string = string.substring(0, n8);
            }
            this.atomNames[this.atomCount] = string.intern();
            byte by = ModelLoader.lookupSpecialAtomID(string);
            if (by == 2 && string2 != null && string2.equalsIgnoreCase("CA")) {
                by = 0;
            }
            if (by != 0) {
                if (this.specialAtomIDs == null) {
                    this.specialAtomIDs = new byte[this.atoms.length];
                }
                this.specialAtomIDs[this.atomCount] = by;
            }
        }
        if (n6 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.atoms.length];
            }
            this.atomSerials[this.atomCount] = n6;
        }
        if (object2 != null) {
            if (this.clientAtomReferences == null) {
                this.clientAtomReferences = new Object[this.atoms.length];
            }
            this.clientAtomReferences[this.atomCount] = object2;
        }
        if (!Float.isNaN(f6)) {
            this.setVibrationVector(this.atomCount, f6, f7, f8);
        }
        this.htAtomMap.put(object, atom);
        ++this.atomCount;
    }

    private static byte lookupSpecialAtomID(String string) {
        if (string != null) {
            Integer n;
            if (string.indexOf(42) >= 0) {
                string = string.replace('*', '\'');
            }
            if ((n = (Integer)htAtom.get(string)) != null) {
                return (byte)n.intValue();
            }
        }
        return 0;
    }

    private void checkNewGroup(int n, int n2, char c, String string, int n3, char c2) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (n2 != this.currentModelIndex) {
            this.currentModel = this.getModel(n2);
            this.currentModelIndex = n2;
            this.currentChainID = (char)65535;
        }
        if (c != this.currentChainID) {
            this.currentChainID = c;
            this.currentChain = this.getOrAllocateChain(this.currentModel, c);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (n3 != this.currentGroupSequenceNumber || c2 != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            this.currentGroupSequenceNumber = n3;
            this.currentGroupInsertionCode = c2;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])ArrayUtil.doubleLength(this.chainOf);
                this.group3Of = ArrayUtil.doubleLength(this.group3Of);
                this.seqcodes = ArrayUtil.doubleLength(this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = n;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcode(n3, c2);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, char c) {
        Chain chain = model.getChain(c);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])ArrayUtil.doubleLength(model.chains);
        }
        Chain chain2 = new Chain(this, model, c);
        model.chains[model.chainCount++] = chain2;
        return chain2;
    }

    private void growAtomArrays(int n) {
        int n2 = this.atomCount + n;
        this.atoms = (Atom[])ArrayUtil.setLength(this.atoms, n2);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])ArrayUtil.setLength(this.clientAtomReferences, n2);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength(this.vibrationVectors, n2);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength(this.occupancies, n2);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength(this.bfactor100s, n2);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength(this.partialCharges, n2);
        }
        if (this.ellipsoids != null) {
            this.ellipsoids = (Object[][])ArrayUtil.setLength(this.ellipsoids, n2);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength(this.atomNames, n2);
        }
        if (this.atomTypes != null) {
            this.atomTypes = ArrayUtil.setLength(this.atomTypes, n2);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength(this.atomSerials, n2);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = ArrayUtil.setLength(this.specialAtomIDs, n2);
        }
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.BondIterator bondIterator = jmolAdapter.getBondIterator(object);
        if (bondIterator == null) {
            return;
        }
        short s = this.viewer.getMadBond();
        this.defaultCovalentMad = this.jmolData == null ? s : (short)0;
        boolean bl = false;
        while (bondIterator.hasNext()) {
            short s2 = (short)bondIterator.getEncodedOrder();
            this.bondAtoms(bondIterator.getAtomUniqueID1(), bondIterator.getAtomUniqueID2(), s2);
            if (s2 <= 1) continue;
            bl = true;
        }
        if (bl && this.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds()) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.defaultCovalentMad = s;
    }

    private void bondAtoms(Object object, Object object2, short s) {
        Atom atom = (Atom)this.htAtomMap.get(object);
        if (atom == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + object);
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(object2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + object2);
            return;
        }
        if (atom.isBonded(atom2)) {
            return;
        }
        Bond bond = this.bondMutually(atom, atom2, s, this.getDefaultMadFromOrder(s));
        if (bond.isAromatic()) {
            this.someModelsHaveAromaticBonds = true;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 4000);
        }
        this.setBond(this.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.StructureIterator structureIterator = jmolAdapter.getStructureIterator(object);
        if (structureIterator != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getStructureType(), structureIterator.getStructureID(), structureIterator.getSerialID(), structureIterator.getStrandCount(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
        if ((structureIterator = jmolAdapter.getStructureIterator(object)) != null) {
            while (structureIterator.hasNext()) {
                if (!structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getStructureType(), structureIterator.getStructureID(), 1, 1, structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
    }

    protected void defineStructure(int n, String string, String string2, int n2, int n3, char c, int n4, char c2, char c3, int n5, char c4) {
        if (n >= 0 || this.isTrajectory) {
            if (this.isTrajectory) {
                n = 0;
            }
            this.structuresDefinedInFile.set(n += this.baseModelIndex);
            super.defineStructure(n, string, string2, n2, n3, c, n4, c2, c3, n5, c4);
            return;
        }
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            this.structuresDefinedInFile.set(i);
            super.defineStructure(i, string, string2, n2, n3, c, n4, c2, c3, n5, c4);
        }
    }

    private void initializeUnitCellAndSymmetry() {
        int n;
        int n2;
        if (this.someModelsHaveUnitcells) {
            this.unitCells = new SymmetryInterface[this.modelCount];
            n2 = this.mergeModelSet != null && this.mergeModelSet.unitCells != null ? 1 : 0;
            for (n = 0; n < this.modelCount; ++n) {
                if (n2 != 0 && n < this.baseModelCount) {
                    this.unitCells[n] = this.mergeModelSet.unitCells[n];
                    continue;
                }
                this.unitCells[n] = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                this.unitCells[n].setSymmetryInfo(n, this.getModelAuxiliaryInfo(n));
            }
        }
        if (this.someModelsHaveSymmetry) {
            this.getAtomBits(0xF0000D, null);
            n = -1;
            int n3 = 0;
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                if (this.atoms[n2].modelIndex != n) {
                    n = this.atoms[n2].modelIndex;
                    n3 = this.baseAtomIndex + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomIndex") + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomCount");
                }
                if (n2 < n3) continue;
                this.bsSymmetry.set(n2);
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                n = this.atoms[n2].modelIndex;
                if (!this.unitCells[n].getCoordinatesAreFractional()) continue;
                this.unitCells[n].toCartesian(this.atoms[n2]);
                if (!Logger.debugging) continue;
                Logger.debug("atom " + n2 + ": " + this.atoms[n2]);
            }
        }
    }

    private void initializeBonding() {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.getModelSetAuxiliaryInfo("someModelsHaveCONECT") == null ? null : new BitSet();
        if (bitSet != null) {
            this.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bitSet);
        }
        int n = this.baseAtomIndex;
        int n2 = 0;
        boolean bl = this.viewer.getApplySymmetryToBonds();
        boolean bl2 = this.viewer.getAutoBond();
        boolean bl3 = this.viewer.getForceAutoBond();
        BitSet bitSet3 = null;
        boolean bl4 = false;
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            n2 = this.getModelAuxiliaryInfoInt(i, "initialAtomCount");
            if (n2 < 0) {
                n2 = this.atomCount;
            }
            if (!this.getModelAuxiliaryInfoBoolean(i, "noautobond")) {
                boolean bl5;
                int n3 = this.getModelAuxiliaryInfoInt(i, "initialBondCount");
                if (n3 < 0) {
                    n3 = this.bondCount;
                }
                boolean bl6 = this.models[i].isPDB;
                boolean bl7 = this.getModelAuxiliaryInfoBoolean(i, "hasSymmetry");
                boolean bl8 = bl5 = bl3 || bl2 && (n3 == 0 || bl6 && this.jmolData == null && n3 < n2 / 2 || bl7 && !bl);
                if (bl5) {
                    bl4 = true;
                    if (this.merging || this.modelCount > 1) {
                        if (bitSet3 == null) {
                            bitSet3 = new BitSet(this.atomCount);
                        }
                        int n4 = n + n2;
                        while (--n4 >= n) {
                            bitSet3.set(n4);
                        }
                    }
                }
            }
            n += n2;
        }
        if (bl4) {
            this.autoBond(bitSet3, bitSet3, bitSet, null);
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        Hashtable hashtable;
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.baseGroupIndex; ++n) {
                this.groups[n] = this.mergeModelSet.groups[n];
                this.groups[n].setModelSet(this);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chainOf[n], this.group3Of[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[n + 1]);
            this.chainOf[n] = null;
            this.group3Of[n] = null;
        }
        this.chainOf = null;
        this.group3Of = null;
        if (this.group3Lists != null && (hashtable = this.getModelSetAuxiliaryInfo()) != null) {
            hashtable.put("group3Lists", this.group3Lists);
            hashtable.put("group3Counts", this.group3Counts);
        }
        this.group3Counts = null;
        this.group3Lists = null;
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        Object object;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.atoms[n3].modelIndex;
        Group group = null;
        if (string != null && this.specialAtomIDs != null && this.haveBioClasses) {
            if (this.jbr == null && this.haveBioClasses) {
                try {
                    object = Class.forName("org.jmol.modelsetbio.Resolver");
                    this.jbr = (JmolBioResolver)((Class)object).newInstance();
                    this.haveBioClasses = true;
                }
                catch (Exception exception) {
                    Logger.error("developer error: org.jmol.modelsetbio.Resolver could not be found");
                    this.haveBioClasses = false;
                }
            }
            if (this.haveBioClasses) {
                group = this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, s, this.specialAtomIndexes, this.specialAtomIDs, this.atoms);
            }
        }
        if (group == null) {
            group = new Group(chain, string, n2, n3, n5);
            object = "o>";
        } else {
            Object object2 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (object = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, (String)object, string);
        }
        this.addGroup(chain, group);
        this.groups[n] = group;
        group.setGroupIndex(n);
        int n6 = n4;
        while (--n6 >= n3) {
            this.atoms[n6].setGroup(group);
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])ArrayUtil.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int n, String string, String string2) {
        int n2 = n + 1;
        if (this.group3Lists == null || this.group3Lists[n2] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n3 = this.group3Lists[n2].indexOf(string3);
        if (n3 < 0) {
            int n4 = n2;
            this.group3Lists[n4] = this.group3Lists[n4] + ",[" + string3 + "]";
            n3 = this.group3Lists[n2].indexOf(string3);
            this.group3Counts[n2] = ArrayUtil.setLength(this.group3Counts[n2], this.group3Counts[n2].length + 10);
        }
        int[] nArray = this.group3Counts[n2];
        int n5 = n3 / 6;
        nArray[n5] = nArray[n5] + 1;
        n3 = this.group3Lists[n2].indexOf(",[" + string3);
        if (n3 >= 0) {
            this.group3Lists[n2] = this.group3Lists[n2].substring(0, n3) + string + this.group3Lists[n2].substring(n3 + 2);
        }
        if (n >= 0) {
            this.countGroup(-1, string, string2);
        }
    }

    private void freeze() {
        this.htAtomMap.clear();
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(0);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount);
        }
        int n = 5;
        while (--n > 0) {
            this.numCached[n] = 0;
            Bond[][] bondArray = this.freeBonds[n];
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                bondArray[n2] = null;
            }
        }
        this.setAtomNamesAndNumbers();
        this.findElementsPresent();
        if (this.isPDB) {
            this.calculateStructuresAllExcept(this.structuresDefinedInFile, true);
        }
        this.molecules = null;
        this.moleculeCount = 0;
        this.currentModel = null;
        this.currentChain = null;
        this.setStructureIds();
    }

    private void setAtomNamesAndNumbers() {
        Atom atom;
        int n;
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        boolean bl = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
        int s = Integer.MAX_VALUE;
        int n2 = 1;
        for (n = 0; n < this.atomCount; ++n) {
            short s2;
            atom = this.atoms[n];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n3 = n2 = bl ? 0 : 1;
            }
            if (this.atomSerials[n] != 0) continue;
            this.atomSerials[n] = n < this.baseAtomIndex ? this.mergeModelSet.atomSerials[n] : n2++;
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        for (n = 0; n < this.atomCount; ++n) {
            if (this.atomNames[n] != null) continue;
            atom = this.atoms[n];
            this.atomNames[n] = atom.getElementSymbol() + atom.getAtomNumber();
        }
    }

    private void findElementsPresent() {
        int n;
        this.elementsPresent = new BitSet[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            this.elementsPresent[n] = new BitSet();
        }
        n = this.atomCount;
        while (--n >= 0) {
            int n2 = this.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 >= JmolConstants.elementNumberMax) {
                n2 = JmolConstants.elementNumberMax + JmolConstants.altElementIndexFromNumber(n2);
            }
            this.elementsPresent[this.atoms[n].modelIndex].set(n2);
        }
    }

    private void finalizeShapes() {
        if (this.someModelsHaveAromaticBonds && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds(false);
        }
        if (this.shapes == null) {
            return;
        }
        if (this.merging) {
            for (int i = 0; i < 32; ++i) {
                this.shapes[i] = this.mergeModelSet.shapes[i];
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(this);
            }
            if (this.baseModelCount == 1 && this.shapes[5] != null) {
                this.setShapeProperty(5, "clearModelIndex", null, null);
            }
            this.viewer.clearShapes();
            this.merging = false;
            return;
        }
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(5);
        this.loadShape(28);
        this.loadShape(29);
    }

    public void createAtomDataSet(int n, Object object, BitSet bitSet) {
        if (object == null) {
            return;
        }
        JmolAdapter jmolAdapter = this.viewer.getModelAdapter();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        float f = ((Float)this.viewer.getParameter("loadAtomDataTolerance")).floatValue();
        int n2 = -1;
        int n3 = 0;
        int n4 = n == 72352010 ? BitSetUtil.length(bitSet) : 0;
        Object object2 = jmolAdapter.getAtomIterator(object);
        while (((JmolAdapter.AtomIterator)object2).hasNext()) {
            float f2;
            float f3;
            float f4 = ((JmolAdapter.AtomIterator)object2).getX();
            if (Float.isNaN(f4 + (f3 = ((JmolAdapter.AtomIterator)object2).getY()) + (f2 = ((JmolAdapter.AtomIterator)object2).getZ()))) continue;
            if (n == 72352010) {
                while (++n2 < n4 && !bitSet.get(n2)) {
                }
                if (n2 == n4) break;
                ++n3;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + n2 + ": " + this.atoms[n2] + " --> (" + f4 + "," + f3 + "," + f2);
                }
                this.setAtomCoord(n2, f4, f3, f2);
                continue;
            }
            point3f.set(f4, f3, f2);
            BitSet bitSet2 = new BitSet();
            this.getAtomsWithin(-f, point3f, bitSet2, -1);
            this.getAtomsWithin(f, point3f, bitSet2, -1);
            bitSet2.and(bitSet);
            if (BitSetUtil.cardinalityOf(bitSet) == this.viewer.getAtomCount()) {
                n3 = BitSetUtil.cardinalityOf(bitSet2);
                if (n3 == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + point3f);
                    continue;
                }
                if (n3 > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n3 + " atoms found at position " + point3f);
                }
            }
            switch (n) {
                case 72352013: {
                    float f5 = ((JmolAdapter.AtomIterator)object2).getVectorX();
                    float f6 = ((JmolAdapter.AtomIterator)object2).getVectorY();
                    float f7 = ((JmolAdapter.AtomIterator)object2).getVectorZ();
                    if (Float.isNaN(f5 + f6 + f7)) break;
                    point3f2.set(f5, f6, f7);
                    if (Logger.debugging) {
                        Logger.info("xyz: " + point3f + " vib: " + point3f2);
                    }
                    this.setAtomCoord(bitSet2, 72352013, point3f2);
                    break;
                }
                case 55574786: {
                    this.setAtomProperty(bitSet2, n, ((JmolAdapter.AtomIterator)object2).getOccupancy(), 0.0f, null, null, null);
                    break;
                }
                case 38797578: {
                    this.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getPartialCharge(), null, null, null);
                    break;
                }
                case 38797585: {
                    this.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getBfactor(), null, null, null);
                }
            }
        }
        switch (n) {
            case 72352013: {
                object2 = jmolAdapter.getAtomSetName(object, 0);
                Logger.info("_vibrationName = " + (String)object2);
                this.viewer.setStringProperty("_vibrationName", (String)object2);
                break;
            }
            case 72352010: {
                Logger.info(n3 + " atom positions read");
                this.recalculateLeadMidpointsAndWingVectors(-1);
            }
        }
    }

    static {
        int n = JmolConstants.specialAtomNames.length;
        while (--n >= 0) {
            String string = JmolConstants.specialAtomNames[n];
            if (string == null) continue;
            Integer n2 = new Integer(n);
            htAtom.put(string, n2);
        }
    }
}

