/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.JmolConstants;

public abstract class AtomShape
extends Shape {
    public short[] mads;
    public short[] colixes;
    public byte[] paletteIDs;
    protected BitSet bsSizeSet;
    protected BitSet bsColixSet;
    public int atomCount;
    public Atom[] atoms;
    public boolean isActive;

    protected void initModelSet() {
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
        if (this.mads != null) {
            this.mads = ArrayUtil.setLength(this.mads, this.atomCount);
        }
        if (this.colixes != null) {
            this.colixes = ArrayUtil.setLength(this.colixes, this.atomCount);
        }
        if (this.paletteIDs != null) {
            this.paletteIDs = ArrayUtil.setLength(this.paletteIDs, this.atomCount);
        }
    }

    public void setSize(int n, BitSet bitSet) {
        this.setSize(n, Float.NaN, bitSet);
    }

    public void setSize(int n, float f, BitSet bitSet) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        boolean bl = n != 0;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (bitSet != null && !bitSet.get(n2)) continue;
            if (this.mads == null) {
                this.mads = new short[this.atomCount];
            }
            Atom atom = this.atoms[n2];
            this.mads[n2] = atom.convertEncodedMad(this.viewer, n, f);
            this.bsSizeSet.set(n2, bl);
            atom.setShapeVisibility(this.myVisibilityFlag, bl);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("color" == string) {
            this.isActive = true;
            short s = Graphics3D.getColix(object);
            byte by = JmolConstants.pidOf(object);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                this.setColixAndPalette(s, by, n);
            }
            return;
        }
        if ("translucency" == string) {
            this.isActive = true;
            boolean bl = object.equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[this.atomCount];
                    this.paletteIDs = new byte[this.atomCount];
                }
                this.colixes[n] = Graphics3D.getColixTranslucent(this.colixes[n], bl, this.translucentLevel);
                if (!bl) continue;
                this.bsColixSet.set(n);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])object)[1];
            this.atomCount = this.modelSet.getAtomCount();
            int n = ((int[])((Object[])object)[2])[1];
            int n2 = ((int[])((Object[])object)[2])[2];
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, n, n2);
            this.colixes = (short[])ArrayUtil.deleteElements(this.colixes, n, n2);
            this.paletteIDs = (byte[])ArrayUtil.deleteElements(this.paletteIDs, n, n2);
            BitSetUtil.deleteBits(this.bsSizeSet, bitSet);
            BitSetUtil.deleteBits(this.bsColixSet, bitSet);
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    void setColixAndPalette(short s, byte by, int n) {
        if (this.colixes == null || n >= this.colixes.length) {
            if (s == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLength(this.colixes, n + 1);
            this.paletteIDs = ArrayUtil.ensureLength(this.paletteIDs, n + 1);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        this.colixes[n] = s = this.setColix(s, by, n);
        this.bsColixSet.set(n, s != 0);
        this.paletteIDs[n] = by;
    }

    public void setModelClickability() {
        if (!this.isActive) {
            return;
        }
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        String string = JmolConstants.shapeClassBases[this.shapeID];
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.bsSizeSet != null && this.bsSizeSet.get(n)) {
                Shape.setStateInfo(hashtable, n, string + " " + (float)this.mads[n] / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(n)) continue;
            Shape.setStateInfo(hashtable2, n, this.getColorCommand(string, this.paletteIDs[n], this.colixes[n]));
        }
        return Shape.getShapeCommands(hashtable, hashtable2, this.atomCount);
    }
}

