/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Font3D;
import org.jmol.shape.Axes;
import org.jmol.shape.FontLineShapeRenderer;

public class AxesRenderer
extends FontLineShapeRenderer {
    private static final String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c", "X", "Y", "Z", null, null, null, "X", null, "Z", null, "(Y)", null};
    private final Point3f[] axisScreens = new Point3f[6];
    private final Point3f originScreen;
    private short[] colixes;

    public AxesRenderer() {
        int n = 6;
        while (--n >= 0) {
            this.axisScreens[n] = new Point3f();
        }
        this.originScreen = new Point3f();
        this.colixes = new short[3];
    }

    protected void render() {
        float f;
        float f2;
        int n;
        Axes axes = (Axes)this.shape;
        int n2 = this.viewer.getObjectMad(1);
        if (n2 == 0 || !this.g3d.checkTranslucent(false)) {
            return;
        }
        int n3 = this.viewer.getAxesMode();
        this.imageFontScaling = this.viewer.getImageFontScaling();
        if (this.viewer.areAxesTainted()) {
            Font3D font3D = axes.font3d;
            axes.initShape();
            if (font3D != null) {
                axes.font3d = font3D;
            }
        }
        int n4 = 6;
        int n5 = 0;
        SymmetryInterface[] symmetryInterfaceArray = this.modelSet.getCellInfos();
        boolean bl = axes.axisXY.z != 0.0f;
        int n6 = this.viewer.getCurrentModelIndex();
        if (this.viewer.isJmolDataFrame(n6)) {
            return;
        }
        if (n3 == 2 && symmetryInterfaceArray != null) {
            if (n6 < 0 || !symmetryInterfaceArray[n6].haveUnitCell()) {
                return;
            }
            n4 = 3;
            n5 = 6;
        } else if (bl) {
            n4 = 3;
            n5 = 9;
        } else if (n3 == 0) {
            n4 = 6;
            n5 = this.viewer.getAxesOrientationRasmol() ? 15 : 9;
        }
        boolean bl2 = this.viewer.isJmolDataFrame();
        int n7 = this.g3d.isAntialiased() ? 2 : 1;
        int n8 = this.g3d.getSlab();
        int n9 = n = n2 < 20 ? n2 * n7 : Integer.MIN_VALUE;
        if (bl) {
            if (n < 0) {
                n = (int)(n2 > 500 ? 5.0f : (float)n2 / 100.0f);
            }
            this.g3d.setSlab(0);
            this.pt0.set(this.viewer.transformPoint(axes.axisXY));
            this.originScreen.set(this.pt0.x, this.pt0.y, this.pt0.z);
            f2 = this.viewer.getScreenDim();
            f = f2 / 10.0f * axes.scale;
            for (int i = 0; i < 3; ++i) {
                this.viewer.rotatePoint(axes.getAxisPoint(i, false), this.axisScreens[i]);
                this.axisScreens[i].z *= -1.0f;
                this.axisScreens[i].scaleAdd(f, this.axisScreens[i], this.originScreen);
            }
        } else {
            this.viewer.transformPointNoClip(axes.getOriginPoint(bl2), this.originScreen);
            if (n == Integer.MIN_VALUE) {
                n = this.viewer.scaleToScreen((int)this.originScreen.z, n2);
            }
            int n10 = n4;
            while (--n10 >= 0) {
                this.viewer.transformPointNoClip(axes.getAxisPoint(n10, bl2), this.axisScreens[n10]);
            }
        }
        f2 = this.originScreen.x;
        f = this.originScreen.y;
        this.colixes[0] = this.viewer.getObjectColix(1);
        this.colixes[1] = this.viewer.getObjectColix(2);
        this.colixes[2] = this.viewer.getObjectColix(3);
        Font3D font3D = this.g3d.getFont3DScaled(axes.font3d, this.imageFontScaling);
        int n11 = n4;
        while (--n11 >= 0) {
            this.colix = this.colixes[n11 % 3];
            this.g3d.setColix(this.colix);
            String string = axisLabels[n11 + n5];
            if (string != null) {
                this.renderLabel(string, font3D, this.axisScreens[n11].x, this.axisScreens[n11].y, this.axisScreens[n11].z, f2, f);
            }
            this.renderLine(this.originScreen, this.axisScreens[n11], n, (byte)2, this.pt0, this.pt1);
        }
        if (n4 == 3 && !bl) {
            this.colix = this.viewer.getColixBackgroundContrast();
            this.g3d.setColix(this.colix);
            this.renderLabel("0", font3D, this.originScreen.x, this.originScreen.y, this.originScreen.z, f2, f);
        }
        if (bl) {
            this.g3d.setSlab(n8);
        }
    }

    private void renderLabel(String string, Font3D font3D, float f, float f2, float f3, float f4, float f5) {
        float f6;
        FontMetrics fontMetrics = font3D.fontMetrics;
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.stringWidth(string);
        float f7 = f - f4;
        float f8 = f2 - f5;
        if (f7 != 0.0f || f8 != 0.0f) {
            f6 = (float)Math.sqrt(f7 * f7 + f8 * f8);
            f7 = (float)n2 * 0.75f * f7 / f6;
            f8 = (float)n * 0.75f * f8 / f6;
            f += f7;
            f2 += f8;
        }
        f6 = f - (float)(n2 / 2);
        float f9 = f2 + (float)(n / 2);
        this.g3d.drawString(string, font3D, (int)f6, (int)f9, (int)f3, (int)f3);
    }
}

