/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BitSet bsOn = new BitSet();
    private BitSet bsSelected;
    private BitSet bsIgnore;
    static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    int lastSize = 0;
    float lastSolventRadius = 0.0f;

    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("Dots.setProperty: " + string + " " + object);
        }
        if ("init" == string) {
            this.initialize();
            return;
        }
        if ("translucency" == string && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == string) {
            this.bsIgnore = (BitSet)object;
            return;
        }
        if ("select" == string) {
            this.bsSelected = (BitSet)object;
            return;
        }
        if ("radius" == string) {
            this.thisRadius = ((Float)object).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.0f;
            }
            return;
        }
        if ("colorRGB" == string) {
            this.thisArgb = (Integer)object;
            return;
        }
        if ("atom" == string) {
            this.thisAtom = (Integer)object;
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            this.ec.allocDotsConvexMaps(this.atomCount);
            return;
        }
        if ("dots" == string) {
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BitSet)object);
            this.atoms[this.thisAtom].setShapeVisibility(this.myVisibilityFlag, true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.atomCount];
                for (int i = 0; i < this.atomCount; ++i) {
                    if (!this.atoms[i].isInFrame() || !this.atoms[i].isShapeVisible(this.myVisibilityFlag)) continue;
                    this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.colixes[this.thisAtom] = Graphics3D.getColix(this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == string) {
            this.bsSelected = null;
            this.setSize(0, bitSet);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[1];
            int n2 = ((int[])((Object[])object)[2])[2];
            BitSetUtil.deleteBits(this.bsOn, bitSet);
            this.ec.deleteAtoms(n, n2, bitSet);
        }
        super.setProperty(string, object, bitSet);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation(this.viewer, this.atomCount, this.mads);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSize(int n, float f, BitSet bitSet) {
        int n2;
        boolean bl2;
        if (this.bsSelected != null) {
            bitSet = this.bsSelected;
        }
        if (Logger.debugging) {
            Logger.debug("Dots.setSize " + n);
        }
        boolean bl3 = true;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        boolean bl4 = true;
        float f4 = 1.0f;
        this.isActive = true;
        if (Float.isNaN(f)) {
            switch (n) {
                case 0: {
                    bl3 = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (n <= Short.MIN_VALUE) {
                        f3 = -32768.0f;
                        if (n < Short.MIN_VALUE) {
                            f4 = (float)(Short.MIN_VALUE - n) / 100.0f;
                            break;
                        }
                    } else {
                        if (n < 0) {
                            bl4 = false;
                            break;
                        }
                        if (n <= 1001) {
                            f4 = (float)(n - 1) / 100.0f;
                            break;
                        }
                        if (n <= 11002) {
                            bl4 = false;
                            f3 = (float)(n - 1002) / 1000.0f;
                            break;
                        }
                        if (n <= 13002) {
                            f2 = (float)(n - 11002) / 1000.0f;
                            f4 = 1.0f;
                            break;
                        }
                        if (n >= Short.MAX_VALUE) {
                            f3 = 32767.0f;
                            if (n > Short.MAX_VALUE) {
                                f4 = (float)(n - Short.MAX_VALUE) / 100.0f;
                                break;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
            }
        } else if (n == 1) {
            f2 = f;
        } else {
            bl4 = false;
            f3 = f;
        }
        float f5 = !bl4 ? f3 : this.modelSet.getMaxVanderwaalsRadius();
        float f6 = this.viewer.getCurrentSolventProbeRadius();
        if (f2 == Float.MAX_VALUE) {
            float f7 = f2 = f6 != 0.0f ? f6 : 0.0f;
        }
        if (Logger.debugging) {
            Logger.startTimer();
        }
        boolean bl = bl2 = this.lastSolventRadius != f2 || n != 0 && n != this.lastSize || this.ec.getDotsConvexMax() == 0;
        if (bl3) {
            n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!bitSet.get(n2) || this.bsOn.get(n2)) continue;
                this.bsOn.set(n2);
                bl2 = true;
            }
        } else {
            n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!bitSet.get(n2)) continue;
                this.bsOn.set(n2, false);
            }
        }
        n2 = this.atomCount;
        while (--n2 >= 0) {
            this.atoms[n2].setShapeVisibility(this.myVisibilityFlag, this.bsOn.get(n2));
        }
        if (bl2) {
            this.mads = null;
            this.ec.newSet();
            this.lastSolventRadius = f2;
        }
        int[][] nArray = this.ec.getDotsConvexMaps();
        if (bl3 && nArray != null) {
            void var13_15;
            int bl5 = this.atomCount;
            while (--var13_15 >= 0) {
                if (!this.bsOn.get((int)var13_15)) continue;
                nArray[var13_15] = null;
            }
        }
        if (bl3) {
            this.lastSize = n;
            if (nArray == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            boolean bl6 = !this.viewer.getDotSurfaceFlag();
            boolean bl7 = this.viewer.getDotsSelectedOnlyFlag();
            this.ec.calculate(f2, f3, f4, f5, this.bsOn, this.bsIgnore, bl4, bl6, bl7, this.isSurface, true);
        }
        if (Logger.debugging) {
            Logger.checkTimer("dots generation time");
        }
    }

    public void setModelClickability() {
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        int[][] nArray = this.ec.getDotsConvexMaps();
        if (nArray == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = new Hashtable();
        int n = this.viewer.getAtomCount();
        String string = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == null || !this.bsOn.get(i)) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Shape.setStateInfo(hashtable, i, this.getColorCommand(string, this.paletteIDs[i], this.colixes[i]));
            }
            BitSet bitSet = new BitSet();
            int[] nArray2 = nArray[i];
            int n2 = nArray2.length << 5;
            int n3 = 0;
            while (--n2 >= 0) {
                if (!EnvelopeCalculation.getBit(nArray2, n2)) continue;
                ++n3;
                bitSet.set(n2);
            }
            if (n3 <= 0) continue;
            float f = this.ec.getAppropriateRadius(i);
            Shape.appendCmd(stringBuffer, string + i + " radius " + f + " " + Escape.escape(bitSet));
        }
        stringBuffer.append(Shape.getShapeCommands(hashtable, null, n));
        return stringBuffer.toString();
    }
}

