/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Escape;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public final class Measure {
    public static final float radiansPerDegree = (float)Math.PI / 180;

    public static float computeTorsion(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, boolean bl) {
        float f;
        float f2 = tuple3f.x - tuple3f2.x;
        float f3 = tuple3f.y - tuple3f2.y;
        float f4 = tuple3f.z - tuple3f2.z;
        float f5 = tuple3f3.x - tuple3f2.x;
        float f6 = tuple3f3.y - tuple3f2.y;
        float f7 = tuple3f3.z - tuple3f2.z;
        float f8 = tuple3f3.x - tuple3f4.x;
        float f9 = tuple3f3.y - tuple3f4.y;
        float f10 = tuple3f3.z - tuple3f4.z;
        float f11 = f3 * f7 - f4 * f6;
        float f12 = f4 * f5 - f2 * f7;
        float f13 = f2 * f6 - f3 * f5;
        float f14 = f6 * f10 - f7 * f9;
        float f15 = f7 * f8 - f5 * f10;
        float f16 = f5 * f9 - f6 * f8;
        float f17 = 1.0f / (f11 * f11 + f12 * f12 + f13 * f13);
        float f18 = 1.0f / (f14 * f14 + f15 * f15 + f16 * f16);
        float f19 = f11 * f14 + f12 * f15 + f13 * f16;
        float f20 = (float)Math.sqrt(f17);
        float f21 = f20 * (f = (float)Math.sqrt(f18));
        float f22 = f19 * f21;
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        if (f22 < -1.0f) {
            f22 = -1.0f;
        }
        float f23 = (float)Math.acos(f22);
        float f24 = f2 * f14 + f3 * f15 + f4 * f16;
        float f25 = Math.abs(f24);
        f23 = f24 / f25 > 0.0f ? f23 : -f23;
        return bl ? f23 / ((float)Math.PI / 180) : f23;
    }

    public static float computeAngle(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Vector3f vector3f, Vector3f vector3f2, boolean bl) {
        vector3f.sub(tuple3f, tuple3f2);
        vector3f2.sub(tuple3f3, tuple3f2);
        float f = vector3f.angle(vector3f2);
        return bl ? f / ((float)Math.PI / 180) : f;
    }

    public static float computeAngle(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, boolean bl) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        return Measure.computeAngle(tuple3f, tuple3f2, tuple3f3, vector3f, vector3f2, bl);
    }

    public static Object computeHelicalAxis(String string, int n, Point3f point3f, Point3f point3f2, Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        vector3f.sub(point3f2, point3f);
        Point4f point4f = new Point4f();
        point4f.x = vector3f.x;
        point4f.y = vector3f.y;
        point4f.z = vector3f.z;
        float f = quaternion.getTheta();
        Vector3f vector3f2 = quaternion.getNormal();
        point4f.x = vector3f.x;
        point4f.y = vector3f.y;
        point4f.z = vector3f.z;
        float f2 = vector3f.dot(vector3f2);
        if (Math.abs(f2) < 1.0E-4f) {
            f2 = 0.0f;
        }
        if (n == 0x40000003) {
            if (f2 != 0.0f) {
                vector3f2.scale(f2);
            }
            return vector3f2;
        }
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        if (vector3f3.dot(vector3f3) != 0.0f) {
            vector3f3.normalize();
        }
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f(vector3f2);
        if (f2 == 0.0f) {
            f2 = Float.MIN_VALUE;
        }
        vector3f5.scale(f2);
        vector3f4.sub(vector3f5, vector3f);
        vector3f4.scale(0.5f);
        vector3f3.scale(f == 0.0f ? 0.0f : (float)((double)vector3f4.length() / Math.tan((double)(f / 2.0f / 180.0f) * Math.PI)));
        Vector3f vector3f6 = new Vector3f(vector3f3);
        if (f != 0.0f) {
            vector3f6.add(vector3f4);
        }
        if (n == 592445697) {
            return vector3f6;
        }
        Point3f point3f3 = new Point3f(point3f);
        point3f3.sub(vector3f6);
        if (n == 135268357) {
            return point3f3;
        }
        if (f2 != Float.MIN_VALUE) {
            vector3f2.scale(f2);
        }
        Point3f point3f4 = new Point3f(point3f3);
        point3f4.add(vector3f2);
        f = Measure.computeTorsion(point3f, point3f3, point3f4, point3f2, true);
        if (Float.isNaN(f) || vector3f6.length() < 1.0E-4f) {
            point4f.set(vector3f2.x, vector3f2.y, vector3f2.z, 0.0f);
            quaternion.getThetaDirected(point4f);
            f = point4f.w;
        }
        if (n == 0x8100801) {
            return new Float(f);
        }
        if (n == 4112) {
            return "draw ID " + string + " VECTOR " + Escape.escape(point3f3) + " " + Escape.escape(vector3f2) + " color " + (f < 0.0f ? "{255.0 200.0 0.0}" : "{255.0 0.0 128.0}");
        }
        if (n == 538447907) {
            return "measure " + Escape.escape(point3f) + Escape.escape(point3f3) + Escape.escape(point3f4) + Escape.escape(point3f2);
        }
        float f3 = Math.abs(f == 0.0f ? 0.0f : 360.0f / f);
        float f4 = Math.abs(f2 == Float.MIN_VALUE ? 0.0f : vector3f2.length() * (f == 0.0f ? 1.0f : 360.0f / f));
        switch (n) {
            case 0x8100001: {
                return new Object[]{point3f3, vector3f2, vector3f6, new Point3f(f, f4, f3)};
            }
            case 6: {
                return new String[]{Escape.escape(point3f3), Escape.escape(vector3f2), Escape.escape(vector3f6), Escape.escape(new Point3f(f, f4, f3))};
            }
        }
        return null;
    }

    public static Point4f getPlaneThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        return new Point4f(vector3f.x, vector3f.y, vector3f.z, f);
    }

    public static float distanceToPlane(Point4f point4f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
    }

    public static float distanceToPlane(Point4f point4f, float f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / f;
    }

    public static float distanceToPlane(Vector3f vector3f, float f, Point3f point3f) {
        return vector3f == null ? Float.NaN : (vector3f.x * point3f.x + vector3f.y * point3f.y + vector3f.z * point3f.z + f) / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
    }

    public static void calcNormalizedNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f2.sub(point3f2, point3f);
        vector3f3.sub(point3f3, point3f);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
    }

    public static float getDirectedNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        if (point3f4 != null) {
            Point3f point3f5 = new Point3f(point3f);
            point3f5.add(vector3f);
            float f2 = point3f5.distance(point3f4);
            point3f5.set(point3f);
            point3f5.sub(vector3f);
            if (f2 > point3f5.distance(point3f4)) {
                vector3f.scale(-1.0f);
                f = -f;
            }
        }
        return f;
    }

    public static float getNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Measure.calcNormalizedNormal(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        vector3f2.set(point3f);
        float f = -vector3f2.dot(vector3f);
        return f;
    }

    public static void getNormalFromCenter(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, boolean bl, Vector3f vector3f) {
        boolean bl2;
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Measure.calcNormalizedNormal(point3f2, point3f3, point3f4, vector3f, vector3f2, vector3f3);
        point3f5.set(point3f2);
        point3f5.add(point3f3);
        point3f5.add(point3f4);
        point3f5.scale(0.33333334f);
        point3f6.set(vector3f);
        point3f6.scale(0.1f);
        point3f6.add(point3f5);
        boolean bl3 = bl2 = bl && point3f.distance(point3f6) < point3f.distance(point3f5) || !bl && point3f.distance(point3f5) < point3f.distance(point3f6);
        if (bl2) {
            vector3f.scale(-1.0f);
        }
    }

    public static void calcXYNormalToLine(Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(point3f);
        vector3f2.sub(point3f2);
        vector3f.cross(vector3f2, JmolConstants.axisY);
        vector3f.normalize();
        if (Float.isNaN(vector3f.x)) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        }
    }

    public static void projectOntoAxis(Point3f point3f, Point3f point3f2, Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.sub(point3f, point3f2);
        float f = vector3f2.dot(vector3f);
        point3f.set(vector3f);
        point3f.scaleAdd(f, point3f2);
        vector3f2.sub(point3f, point3f2);
    }

    public static void calcBestAxisThroughPoints(Point3f[] point3fArray, Point3f point3f, Vector3f vector3f, Vector3f vector3f2, int n) {
        int n2 = point3fArray.length;
        point3f.set(point3fArray[0]);
        vector3f.sub(point3fArray[n2 - 1], point3f);
        vector3f.normalize();
        Measure.calcAveragePointN(point3fArray, n2, point3f);
        int n3 = 0;
        while (n3++ < n && (double)Measure.findAxis(point3fArray, n2, point3f, vector3f, vector3f2) > 0.001) {
        }
        Point3f point3f2 = new Point3f(point3fArray[0]);
        Measure.projectOntoAxis(point3f2, point3f, vector3f, vector3f2);
        point3f.set(point3f2);
    }

    public static float findAxis(Point3f[] point3fArray, int n, Point3f point3f, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Vector3f vector3f5 = new Vector3f(vector3f);
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            point3f2.set(point3fArray[n2]);
            point3f3.set(point3f2);
            Measure.projectOntoAxis(point3f3, point3f, vector3f, vector3f2);
            vector3f4.sub(point3f2, point3f3);
            f2 += vector3f4.lengthSquared();
            vector3f4.cross(vector3f2, vector3f4);
            vector3f3.add(vector3f4);
            f += vector3f2.lengthSquared();
        }
        Vector3f vector3f6 = new Vector3f(vector3f3);
        vector3f6.scale(1.0f / f);
        vector3f4.cross(vector3f6, vector3f);
        vector3f.add(vector3f4);
        vector3f.normalize();
        vector3f4.set(vector3f);
        vector3f4.sub(vector3f5);
        return vector3f4.length();
    }

    public static void calcAveragePoint(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        point3f3.set((point3f.x + point3f2.x) / 2.0f, (point3f.y + point3f2.y) / 2.0f, (point3f.z + point3f2.z) / 2.0f);
    }

    public static void calcAveragePointN(Point3f[] point3fArray, int n, Point3f point3f) {
        point3f.set(point3fArray[0]);
        for (int i = 1; i < n; ++i) {
            point3f.add(point3fArray[i]);
        }
        point3f.scale(1.0f / (float)n);
    }
}

