/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ScriptCompilationTokenParser;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptFlowContext;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class ScriptCompiler
extends ScriptCompilationTokenParser {
    private static final String LOAD_TYPES = "append;files;menu;trajectory;models;xyz;vxyz;vibration;temperature;occupancy;partialcharge";
    private Viewer viewer;
    private String filename;
    private boolean isSilent;
    private Hashtable contextVariables;
    private Token[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private Vector ltoken;
    private Vector lltoken;
    private Vector vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private int tokLastMath;
    private boolean isShowCommand;
    char chFirst;

    ScriptCompiler(Viewer viewer) {
        this.viewer = viewer;
    }

    ScriptContext parseScriptForTokens(String string) {
        this.script = string;
        this.filename = null;
        this.isCheckOnly = true;
        this.isSilent = true;
        this.logMessages = false;
        this.preDefining = false;
        return this.parseScript(false);
    }

    private ScriptContext parseScript(boolean bl) {
        if (!this.compile0(bl)) {
            this.handleError();
        }
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.script = this.script;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.errorType = this.errorType;
        if (this.errorType != null) {
            scriptContext.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        scriptContext.aatoken = this.aatokenCompiled;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.contextVariables = this.contextVariables;
        return scriptContext;
    }

    ScriptContext compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = string2;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        return this.parseScript(true);
    }

    private void addContextVariable(String string) {
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put(string, new ScriptVariable(4, "").setName(string));
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    private boolean isContextVariable(String string) {
        return this.thisFunction != null ? this.thisFunction.isVariable(string) : this.contextVariables != null && this.contextVariables.containsKey(string);
    }

    private String cleanScriptComments(String string) {
        int n = string.indexOf("\u0000##");
        if (n >= 0) {
            this.scriptExtensions = string.substring(n + 1);
            string = string.substring(0, n);
        }
        this.haveComments = string.indexOf("#") >= 0;
        n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf((string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        return n2 < 0 || n3 < n ? string : string.substring(n + "**** Jmol Embedded Script ****".length(), n3);
    }

    private void addTokenToPrefix(Token token) {
        if (this.logMessages) {
            Logger.debug("addTokenToPrefix" + token);
        }
        this.ltoken.addElement(token);
        this.lastToken = token;
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean var1_1) {
        this.script = this.cleanScriptComments(this.script);
        this.cchScript = this.script.length();
        this.contextVariables = null;
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.thisFunction = null;
        this.flowContext = null;
        this.errorType = null;
        this.errorMessage = null;
        this.errorMessageUntranslated = null;
        this.errorLine = null;
        this.nSemiSkip = 0;
        this.ichToken = 0;
        this.ichCurrentCommand = 0;
        this.ichComment = 0;
        this.ichBrace = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        this.tokLastMath = 0;
        this.lastToken = Token.tokenOff;
        this.vBraces = new Vector<E>();
        this.iBrace = 0;
        this.braceCount = 0;
        this.parenCount = 0;
        this.ptSemi = -10;
        this.cchToken = 0;
        this.lnLength = 8;
        this.lineNumbers = new short[this.lnLength];
        this.lineIndices = new int[this.lnLength][2];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        this.iHaveQuotedString = false;
        this.lltoken = new Vector<E>();
        this.ltoken = new Vector<E>();
        this.tokCommand = 0;
        this.lastFlowCommand = null;
        this.tokenAndEquals = null;
        this.setBraceCount = 0;
        this.bracketCount = 0;
        this.forPoint3 = -1;
        this.setEqualPt = 0x7FFFFFFF;
        this.endOfLine = false;
        this.comment = null;
        this.isEndOfCommand = false;
        this.needRightParen = false;
        this.theTok = 0;
        var2_2 = 1;
        while (true) {
            block28: {
                block30: {
                    block29: {
                        if ((this.nTokens = this.ltoken.size()) == 0) {
                            if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                this.thisFunction.chpt0 = this.ichToken;
                            }
                            this.ichCurrentCommand = this.ichToken;
                            var2_2 = this.lineCurrent;
                        }
                        if (this.lookingAtLeadingWhitespace()) break block28;
                        this.endOfLine = false;
                        if (this.isEndOfCommand) break block29;
                        this.endOfLine = this.lookingAtEndOfLine();
                        switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                            case 2: {
                                break block28;
                            }
                            case 3: {
                                this.isEndOfCommand = true;
                                break block28;
                            }
                            case 1: {
                                this.isEndOfCommand = true;
                                this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                            }
                            default: {
                                v0 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtEndOfStatement() != false;
                            }
                        }
                    }
                    if (!this.isEndOfCommand) break block30;
                    this.isEndOfCommand = false;
                    switch (this.processTokenList(var2_2, var1_1)) {
                        case 2: {
                            break block28;
                        }
                        case 4: {
                            return false;
                        }
                        default: {
                            if (this.ichToken >= this.cchScript) {
                                this.setAaTokenCompiled();
                                return this.flowContext == null || this.error(11, Token.nameOf(this.flowContext.token.tok)) != false;
                            }
                            break block28;
                        }
                    }
                }
                if (this.nTokens <= 0) ** GOTO lbl-1000
                block9 : switch (this.checkSpecialParameterSyntax()) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        return false;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (this.lookingAtLookupToken(this.ichToken)) {
                            var3_3 = this.getPrefixToken();
                            switch (this.parseKnownToken(var3_3)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            switch (this.parseCommandParameter(var3_3)) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            this.addTokenToPrefix(this.theToken);
                            break;
                        }
                        if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                            if (this.nTokens == 0 && this.lookingAtImpliedString()) {
                                this.ichEnd = this.ichToken + this.cchToken;
                            }
                            return this.commandExpected();
                        }
                        return this.error(19, this.script.substring(this.ichToken, this.ichToken + 1));
                    }
                }
            }
            this.ichToken += this.cchToken;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = new Token[this.lltoken.size()][];
        this.lltoken.copyInto((Object[])this.aatokenCompiled);
    }

    private boolean lookingAtLeadingWhitespace() {
        int n;
        for (n = this.ichToken; n < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(n)); ++n) {
        }
        if (this.isLineContinuation(n, true)) {
            n += 1 + this.nCharNewLine(n + 1);
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean isLineContinuation(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n + 2 < this.cchScript && this.script.charAt(n) == '\\' && this.nCharNewLine(n + 1) > 0 || bl && this.lookingAtMathContinuation(n);
        if (bl2) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return bl2;
    }

    private boolean lookingAtMathContinuation(int n) {
        int n2;
        if (n >= this.cchScript || (n2 = this.nCharNewLine(n)) == 0 || this.lastToken.tok == 0x10000A) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        if (this.tokCommand != 36867 && this.tokCommand != 36865) {
            return false;
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        n += n2;
        while (n < this.cchScript && ScriptCompiler.isSpaceOrTab(this.script.charAt(n))) {
            ++n;
        }
        return this.lookingAtLookupToken(n) && this.tokLastMath == 1;
    }

    private boolean lookingAtEndOfLine() {
        int n = this.ichEnd = this.ichToken;
        if (this.ichToken >= this.cchScript) {
            this.ichEnd = this.cchScript;
            return true;
        }
        int n2 = this.nCharNewLine(n);
        if (n2 == 0) {
            return false;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = n2;
        return true;
    }

    private int nCharNewLine(int n) {
        char c;
        int n2 = n >= this.cchScript ? 0 : ((c = this.script.charAt(n)) != '\r' ? (c == '\n' ? 1 : 0) : (++n < this.cchScript && this.script.charAt(n) == '\n' ? 2 : 1));
        return n2;
    }

    private boolean lookingAtEndOfStatement() {
        boolean bl;
        boolean bl2 = bl = this.script.charAt(this.ichToken) == ';';
        if (bl && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!bl || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean bl;
        int n;
        char c = this.script.charAt(this.ichToken);
        int n2 = -1;
        if (this.ichToken == this.ichCurrentCommand && c == '$') {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            for (n = this.ichToken; c != ']' && n < this.cchScript && !this.eol(c = this.script.charAt(n)); ++n) {
            }
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            n2 = n;
        }
        if (c == '/' && n + 1 < this.cchScript) {
            switch (this.script.charAt(++n)) {
                case '/': {
                    n2 = this.ichToken;
                    this.ichEnd = n - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = n - 1;
                    String string = ++n < this.cchScript && (c = this.script.charAt(n)) == '*' ? "**/" : "*/";
                    n = this.script.indexOf(string, this.ichToken + 2);
                    if (n < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, n));
                    this.cchToken = n + (c == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl2 = bl = n2 < 0;
        if (bl && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > n) {
            n = this.ichComment;
        }
        while (n < this.cchScript) {
            c = this.script.charAt(n);
            if (this.eol(c)) {
                this.ichEnd = n;
                if (this.isLineContinuation(n - 1, false)) {
                    n += this.nCharNewLine(n);
                } else if (bl || c != ';') break;
            } else if (n2 <= 0 && c == '#') {
                n2 = n;
            }
            ++n;
        }
        if (n2 < 0) {
            return 0;
        }
        this.ichComment = n2;
        if (bl && this.nTokens == 0 && this.cchScript - n2 >= 3 && this.script.charAt(n2 + 1) == 'j' && this.script.charAt(n2 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (n2 != this.ichToken) {
            return 0;
        }
        if (bl && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (n == this.ichToken) {
            return 0;
        }
        this.cchToken = n - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private int processTokenList(short s, boolean bl) {
        if (this.nTokens > 0 || this.comment != null) {
            if (this.nTokens == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.addTokenToPrefix(new Token(0, this.comment.length() == 1 ? this.comment : this.comment.substring(1)));
                }
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (this.nTokens == 1 && this.tokenCommand.value.equals("{") && this.lastFlowCommand != null) {
                this.setBraceCount = 0;
                this.parenCount = 0;
                this.tokCommand = this.lastFlowCommand.tok;
                this.tokenCommand = this.lastFlowCommand;
                this.ltoken.removeElementAt(0);
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(this.nTokens == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.ltoken.size() > 0) {
                if (bl && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.debug("-------------------------------------");
                }
                if (!Token.tokAttr(this.tokCommand, 131072) || this.atokenInfix.length > 0 && this.atokenInfix[0].intValue <= 0) {
                    if (this.iCommand == this.lnLength) {
                        short[] sArray = new short[this.lnLength * 2];
                        System.arraycopy(this.lineNumbers, 0, sArray, 0, this.lnLength);
                        this.lineNumbers = sArray;
                        int[][] nArray = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, nArray, 0, this.lnLength);
                        this.lineIndices = nArray;
                        this.lnLength *= 2;
                    }
                    this.lineNumbers[this.iCommand] = s;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.addElement(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 36867) {
                    this.lastFlowCommand = null;
                }
            }
            this.tokenCommand = null;
            this.tokenAndEquals = null;
            this.comment = null;
            this.tokCommand = 0;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.setSize(0);
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
            if (this.endOfLine && this.flowContext != null && this.flowContext.checkForceEndIf(1)) {
                this.forceFlowEnd(this.flowContext.token);
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                this.lineCurrent = (short)(this.lineCurrent - 1);
                return 2;
            }
        }
        if (this.endOfLine) {
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        if (this.ichToken >= this.cchScript) {
            this.tokenCommand = Token.tokenAll;
            this.tokCommand = 1;
            this.theTok = 0;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private boolean compileCommand() {
        int n;
        int n2;
        block15: {
            int n3;
            int n4;
            block16: {
                block14: {
                    if (this.ltoken.size() == 0) {
                        this.atokenInfix = new Token[0];
                        this.ltoken.copyInto(this.atokenInfix);
                        return true;
                    }
                    this.tokenCommand = (Token)this.ltoken.firstElement();
                    this.tokCommand = this.tokenCommand.tok;
                    this.isImplicitExpression = Token.tokAttr(this.tokCommand, 36864);
                    this.isSetOrDefine = this.tokCommand == 36867 || this.tokCommand == 537931778;
                    this.isCommaAsOrAllowed = Token.tokAttr(this.tokCommand, 12288);
                    n2 = this.ltoken.size();
                    n4 = n2 - 1;
                    if (n2 != 1 || !Token.tokAttr(this.tokCommand, 524288)) break block14;
                    this.addTokenToPrefix(Token.tokenOn);
                    break block15;
                }
                if (this.tokCommand != 36867 || n2 <= 2) break block15;
                n3 = ((Token)this.ltoken.get((int)n4)).tok;
                if (n3 == 269484210 || n3 == 0x101000B1) break block16;
                n4 = 1;
                n3 = ((Token)this.ltoken.get((int)1)).tok;
                if (n3 != 269484210 && n3 != 0x101000B1) break block15;
            }
            this.ltoken.removeElementAt(n4);
            this.addTokenToPrefix(Token.tokenEquals);
            for (n = 1; n < n2 - 1; ++n) {
                this.addTokenToPrefix((Token)this.ltoken.elementAt(n));
            }
            this.addTokenToPrefix(n3 == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
            this.addTokenToPrefix(Token.intToken(1));
            if (((Token)this.ltoken.get((int)2)).tok == 0x10100040) {
                this.ltoken.setElementAt(Token.tokenSetArray, 0);
            }
        }
        if (this.tokenAndEquals != null) {
            int n5 = 0;
            for (n5 = 1; n5 < n2 && (n = ((Token)this.ltoken.elementAt((int)n5)).tok) != 269484226; ++n5) {
            }
            n2 = n5++;
            if (this.ltoken.size() < n5) {
                System.out.println("COMPILER ERROR! - andEquals ");
            } else {
                n = 1;
                while (n < n2) {
                    this.ltoken.insertElementAt((Token)this.ltoken.elementAt(n), n5);
                    ++n;
                    ++n5;
                }
                this.ltoken.setElementAt(Token.tokenEquals, n2);
                this.ltoken.insertElementAt(this.tokenAndEquals, n5);
                this.ltoken.insertElementAt(Token.tokenLeftParen, ++n5);
                this.addTokenToPrefix(Token.tokenRightParen);
            }
        }
        n2 = this.ltoken.size();
        this.atokenInfix = new Token[n2];
        this.ltoken.copyInto(this.atokenInfix);
        if (this.logMessages) {
            Logger.debug("token list:");
            for (n = 0; n < this.atokenInfix.length; ++n) {
                Logger.debug(n + ": " + this.atokenInfix[n]);
            }
            Logger.debug("vBraces list:");
            for (n = 0; n < this.vBraces.size(); ++n) {
                Logger.debug(n + ": " + this.vBraces.get(n));
            }
            Logger.debug("-------------------------------------");
        }
        return this.compileExpressions();
    }

    private String getPrefixToken() {
        String string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        if (string.length() == 1) {
            this.theToken = Token.getTokenFromName(string);
            if (this.theToken == null && (this.theToken = Token.getTokenFromName(string.toLowerCase())) != null) {
                this.theToken = new Token(this.theToken.tok, this.theToken.intValue, string);
            }
        } else {
            string = string.toLowerCase();
            this.theToken = Token.getTokenFromName(string);
        }
        if (this.theToken == null) {
            this.theToken = string.indexOf("property_") == 0 ? new Token(642777357, string.toLowerCase()) : new Token(1, string);
        }
        this.theTok = this.theToken.tok;
        return string;
    }

    private int checkSpecialParameterSyntax() {
        String string;
        int n;
        char c;
        if (this.nTokens == this.ptNewSetModifier && (this.tokCommand == 36867 || Token.tokAttr(this.tokCommand, 0x20000000))) {
            c = this.script.charAt(this.ichToken);
            if (c == '=') {
                this.setEqualPt = this.ichToken;
            }
            int n2 = n = "+-\\*/&|=".indexOf(c) >= 0 ? 1 : 0;
            if (Token.tokAttr(this.tokCommand, 0x20000000) && c == '=' || (this.isNewSet || this.isSetBrace) && (n != 0 || c == '.' || c == '[')) {
                this.tokenCommand = n != 0 ? Token.tokenSet : (c == '[' && !this.isSetBrace ? Token.tokenSetArray : Token.tokenSetProperty);
                this.tokCommand = 36867;
                this.ltoken.insertElementAt(this.tokenCommand, 0);
                this.cchToken = 1;
                switch (c) {
                    case '[': {
                        this.addTokenToPrefix(new Token(0x10100040, "["));
                        ++this.bracketCount;
                        return 2;
                    }
                    case '.': {
                        this.addTokenToPrefix(new Token(0x100008, "."));
                        return 2;
                    }
                    case '&': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '\\': 
                    case '|': {
                        if (this.ichToken + 1 >= this.cchScript) {
                            return this.ERROR(4);
                        }
                        if (this.script.charAt(this.ichToken + 1) == c || this.script.charAt(this.ichToken + 1) == '=') break;
                        return this.ERROR(1, "" + c);
                    }
                    default: {
                        this.lastToken = Token.tokenMinus;
                        return 2;
                    }
                }
            }
        }
        if (this.lookingAtString(!Token.tokAttr(this.tokCommand, 20480))) {
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            String string2 = (this.tokCommand == 135271426 || this.tokCommand == 536875012 || this.tokCommand == 135271428) && !this.iHaveQuotedString ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
            this.addTokenToPrefix(new Token(4, string2));
            this.iHaveQuotedString = true;
            if (this.tokCommand == 135272450 && string2.indexOf("@") < 0 && !this.getData(string2)) {
                return this.ERROR(11, "data");
            }
            return 2;
        }
        if (this.tokCommand == 4156 && this.nTokens == 1 && this.charToken()) {
            String string3 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            this.addTokenToPrefix(new Token(1, string3));
            return 2;
        }
        if (this.tokCommand == 135271426) {
            if (this.script.charAt(this.ichToken) == '@') {
                this.iHaveQuotedString = true;
                return 0;
            }
            if (this.nTokens == 1 && this.lookingAtLoadFormat()) {
                String string4 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (Parser.isOneOf(string4 = string4.toLowerCase(), LOAD_TYPES)) {
                    this.addTokenToPrefix(new Token(1, string4));
                } else if (string4.indexOf("=") == 0) {
                    this.addTokenToPrefix(new Token(4, string4));
                }
                return 2;
            }
            if (this.script.charAt(this.ichToken) != '{' && this.parenCount <= 0) {
                BitSet bitSet = this.lookingAtBitset();
                if (bitSet != null) {
                    this.addTokenToPrefix(new Token(0x40000007, bitSet));
                    return 2;
                }
                if (!this.iHaveQuotedString && this.lookingAtImpliedString()) {
                    String string5 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    int n3 = string5.indexOf(" ");
                    if (n3 > 0) {
                        this.cchToken = n3;
                        string5 = string5.substring(0, n3);
                    }
                    this.addTokenToPrefix(new Token(4, string5));
                    this.iHaveQuotedString = true;
                    return 2;
                }
            }
        } else if (this.tokCommand == 135271428) {
            if (!this.iHaveQuotedString && this.lookingAtImpliedString()) {
                String string6 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                int n4 = string6.indexOf(" ");
                if (n4 > 0) {
                    this.cchToken = n4;
                    string6 = string6.substring(0, n4);
                }
                this.addTokenToPrefix(new Token(4, string6));
                this.iHaveQuotedString = true;
                return 2;
            }
        } else if (this.tokCommand == 135270406) {
            n = this.cchToken;
            if (this.nTokens == 2 && this.lastToken.tok == 4116) {
                this.iHaveQuotedString = true;
            }
            if (!this.iHaveQuotedString && this.lookingAtImpliedString()) {
                string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (string.startsWith("@{")) {
                    this.iHaveQuotedString = true;
                } else if (string.indexOf(" ") < 0) {
                    this.addTokenToPrefix(new Token(4, string));
                    this.iHaveQuotedString = true;
                    return 2;
                }
                this.cchToken = n;
            }
        }
        if (Token.tokAttr(this.tokCommand, 20480) && (this.tokCommand != 135271428 || !this.iHaveQuotedString) && this.lookingAtImpliedString()) {
            String string7 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            this.addTokenToPrefix(new Token(4, string7));
            return 2;
        }
        float f = this.lookingAtExponential();
        if (!Float.isNaN(f)) {
            this.addTokenToPrefix(new Token(3, new Float(f)));
            return 2;
        }
        if (this.lookingAtObjectID(this.nTokens == 1)) {
            this.addTokenToPrefix(Token.getTokenFromName("$"));
            this.addTokenToPrefix(new Token(1, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            f = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
            int n5 = JmolConstants.modelValue(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addTokenToPrefix(new Token(3, n5, new Float(f)));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            c = this.script.charAt(this.ichToken);
            try {
                int n6 = c == '*' || c == '^' ? Integer.MAX_VALUE : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                char c2 = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (c2 == '^') {
                    c2 = ' ';
                }
                if (n6 < 0) {
                    n6 = -n6;
                    this.addTokenToPrefix(Token.tokenMinus);
                }
                int n7 = Group.getSeqcode(n6, c2);
                this.addTokenToPrefix(new Token(5, n7, "seqcode"));
                return 2;
            }
            catch (NumberFormatException numberFormatException) {
                return this.ERROR(9, "" + c);
            }
        }
        if (this.lookingAtInteger()) {
            string = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            int n8 = Integer.parseInt(string);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                ScriptFlowContext scriptFlowContext;
                ScriptFlowContext scriptFlowContext2;
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    scriptFlowContext2 = null;
                } else {
                    n8 = Math.abs(n8);
                    scriptFlowContext2 = scriptFlowContext = this.flowContext.getBreakableContext(n8);
                }
                if (scriptFlowContext == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                ((Token)this.ltoken.get((int)0)).intValue = scriptFlowContext.getPt0();
            }
            if (n8 == 0 && string.equals("-0")) {
                this.addTokenToPrefix(Token.tokenMinus);
            }
            this.addTokenToPrefix(new Token(2, n8, string));
            return 2;
        }
        if (this.tokCommand == 30412803 && this.nTokens == 2 || this.tokCommand == 4116 && this.nTokens == 2 || this.tokCommand == 4136 || this.lastToken.tok == 135280129 || this.lastToken.tok == 135268865 || this.lastToken.tok != 1 && !ScriptCompilationTokenParser.tokenAttr(this.lastToken, 0x8100000)) {
            boolean bl = this.script.charAt(this.ichToken) == '[';
            BitSet bitSet = this.lookingAtBitset();
            if (bitSet != null) {
                if (bl) {
                    this.addTokenToPrefix(new Token(0x40000007, new Bond.BondSet(bitSet)));
                } else {
                    this.addTokenToPrefix(new Token(0x40000007, bitSet));
                }
                return 2;
            }
        }
        return 0;
    }

    private int parseKnownToken(String string) {
        if (this.tokLastMath != 0) {
            this.tokLastMath = this.theTok;
        }
        switch (this.theTok) {
            case 269484226: {
                if (this.theTok != 269484226) break;
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    Token token = this.lastToken;
                    this.addTokenToPrefix(Token.tokenEquals);
                    this.addTokenToPrefix(token);
                    token = Token.getTokenFromName(string.substring(0, 1));
                    this.addTokenToPrefix(token);
                    this.addTokenToPrefix(Token.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                if (this.tokCommand == 36867) {
                    this.tokenAndEquals = Token.getTokenFromName(string.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 233481: 
            case 364548: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 135369224: {
                if (this.bracketCount > 0) break;
            }
            case 102402: 
            case 102406: 
            case 135369225: {
                if (this.nTokens <= 1 || this.tokCommand == 36867) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
            case 0x101000B1: 
            case 269484210: {
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.nTokens = this.ltoken.size();
                    this.addTokenToPrefix(Token.tokenEquals);
                    this.setEqualPt = 0;
                    for (int i = 1; i < this.nTokens; ++i) {
                        this.addTokenToPrefix((Token)this.ltoken.elementAt(i));
                    }
                    this.addTokenToPrefix(this.theTok == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
                    this.addTokenToPrefix(Token.intToken(1));
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                Token token = this.lastToken;
                this.addTokenToPrefix(Token.tokenEquals);
                this.addTokenToPrefix(token);
                this.addTokenToPrefix(this.theTok == 0x101000B1 ? Token.tokenMinus : Token.tokenPlus);
                this.addTokenToPrefix(Token.intToken(1));
                return 2;
            }
            case 269484420: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x100008: {
                if (this.tokCommand != 36867 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt) break;
                this.ltoken.insertElementAt(Token.tokenExpressionBegin, 1);
                this.addTokenToPrefix(Token.tokenExpressionEnd);
                this.ltoken.setElementAt(Token.tokenSetProperty, 0);
                this.setEqualPt = 0;
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                if (this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                    return 2;
                }
            }
            case 0x10100010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 135280129 && this.lastToken.tok != 135369224 && this.lastToken.tok != 135369225) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x10000E: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        this.nSemiSkip = 0;
                        this.parenCount = 0;
                        this.braceCount = 0;
                        this.vBraces.add(this.theToken);
                        ++this.iBrace;
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken + 1;
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10100011: {
                --this.parenCount;
                if (this.parenCount < 0) {
                    return this.ERROR(16, string);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(Token.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10100040: {
                ++this.bracketCount;
                break;
            }
            case 0x10100041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
        }
        return 0;
    }

    private int parseCommandParameter(String string) {
        this.nTokens = this.ltoken.size();
        switch (this.tokCommand) {
            case 0: {
                int n;
                this.lastToken = Token.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.tokenCommand = this.theToken;
                this.tokCommand = this.theTok;
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                    if (this.iBrace > 0 && (this.tokCommand == 364547 || this.tokCommand == 102402) && ((Token)this.vBraces.get((int)(this.iBrace - 1))).tok == 0x10000E) {
                        this.vBraces.remove(--this.iBrace);
                        this.vBraces.remove(--this.iBrace);
                    }
                }
                if ((n = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (n == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (Token.tokAttr(this.tokCommand, 102400)) {
                    if (!this.checkFlowCommand((String)this.tokenCommand.value)) {
                        return 4;
                    }
                    this.theToken = this.tokenCommand;
                    break;
                }
                if (this.theTok == 0x10000E) {
                    this.vBraces.add(this.tokenCommand);
                    ++this.iBrace;
                    this.tokCommand = 0;
                    return 2;
                }
                if (this.theTok != 0x10000A) {
                    this.lastFlowCommand = null;
                }
                if (Token.tokAttr(this.tokCommand, 4096)) break;
                boolean bl = this.isSetBrace = this.theTok == 0x10000A;
                if (this.isSetBrace && !this.lookingAtBraceSyntax()) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                }
                if (!(this.isSetBrace || this.theTok == 269484210 || this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 1) || Token.tokAttr(this.theTok, 0x20000000) || this.isContextVariable(string))) {
                    this.commandExpected();
                    return 4;
                }
                this.tokCommand = 36867;
                this.isNewSet = !this.isSetBrace;
                this.setBraceCount = this.isSetBrace ? 1 : 0;
                this.bracketCount = 0;
                this.setEqualPt = Integer.MAX_VALUE;
                this.ptNewSetModifier = this.isNewSet ? 1 : Integer.MAX_VALUE;
                break;
            }
            case 135499780: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = string;
                    return 2;
                }
                if (this.nTokens == 1) {
                    this.thisFunction = new ScriptFunction(string);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10100010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10100011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10100030 || this.theTok == 0x10100011) break;
                    return this.ERROR(15, ", )");
                }
                this.thisFunction.addVariable(string, true);
                break;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 135369225) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 135369225 && this.theTok != 0x10000A) {
                    return this.ERROR(0);
                }
                this.ltoken.removeElementAt(0);
                this.flowContext.token = new Token(102402, "elseif");
                this.ltoken.addElement(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 537038852: {
                if (this.nTokens != 1) break;
                this.addContextVariable(string);
                this.ltoken.removeElementAt(0);
                this.ltoken.addElement(Token.tokenSetVar);
                this.tokCommand = 36867;
                break;
            }
            case 233481: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, string, this.ichCurrentCommand)) {
                    return 4;
                }
                if (this.theTok != 135499780) break;
                return 2;
            }
            case 102406: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 102402: 
            case 135369225: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 135369224: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10100010) {
                        return this.ERROR(19, string);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && ((Token)this.ltoken.get((int)2)).tok == 537038852) {
                    this.addContextVariable(string);
                    break;
                }
                if (this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 36867: {
                if (this.theTok == 0x10000A) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x10000E) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == Integer.MAX_VALUE) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                boolean bl = false;
                if (this.theTok == 0x10100010) {
                    Token token = (Token)this.ltoken.get(0);
                    this.tokenCommand = new Token(135499780, 0, token.value);
                    this.ltoken.setElementAt(this.tokenCommand, 0);
                    this.tokCommand = 135499780;
                    break;
                }
                if (this.theTok != 1 && this.theTok != 269484226 && !Token.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.error(18, "SET", ": " + string);
                    }
                    return 4;
                }
                if (bl) {
                    this.addTokenToPrefix(this.theToken);
                    break;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 269484210 && this.lastToken.tok != 0x101000B1) break;
                this.ltoken.removeElementAt(0);
                this.tokenCommand = Token.tokenSet;
                this.tokCommand = 36867;
                this.ltoken.insertElementAt(this.tokenCommand, 0);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 12291: 
            case 12293: 
            case 12294: 
            case 135280129: 
            case 536883204: 
            case 537931778: {
                if (this.tokCommand == 537931778) {
                    if (this.nTokens == 1) {
                        if (this.theTok != 1) {
                            if (this.preDefining) {
                                if (!Token.tokAttr(this.theTok, 0x300000)) {
                                    this.error("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + string, null);
                                    return 4;
                                }
                            } else if (Token.tokAttr(this.theTok, 0x300000)) {
                                Logger.warn("WARNING: predefined term '" + string + "' has been redefined by the user until the next file load.");
                            } else if (!this.isCheckOnly && string.length() > 1) {
                                Logger.warn("WARNING: redefining " + string + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                                this.theToken.tok = 1;
                                this.theTok = 1;
                                Token.addToken(string, this.theToken);
                            }
                        }
                        this.addTokenToPrefix(this.theToken);
                        this.lastToken = Token.tokenComma;
                        return 2;
                    }
                    if (this.nTokens == 2 && this.theTok == 269484420) {
                        this.ltoken.insertElementAt(Token.tokenSet, 0);
                        return 2;
                    }
                }
                if (this.bracketCount != 0 || this.theTok == 1 || Token.tokAttr(this.theTok, 0x100000) || (this.theTok & 0xE0) == this.theTok) break;
                return this.ERROR(9, string);
            }
            case 12289: {
                if (this.theTok == 1 || this.theTok == 0x100007 || Token.tokAttr(this.theTok, 0x100000)) break;
                return this.ERROR(9, string);
            }
        }
        return 0;
    }

    private boolean checkFlowStartBrace(boolean bl) {
        if (!Token.tokAttr(this.tokCommand, 102400) || this.tokCommand == 102407 || this.tokCommand == 102408) {
            return false;
        }
        if (bl) {
            this.vBraces.add(this.tokenCommand);
            ++this.iBrace;
            this.braceCount = 0;
            this.parenCount = 0;
        }
        return true;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || ((Token)this.vBraces.get((int)(this.iBrace - 1))).tok != 0x10000E) {
            return 0;
        }
        this.vBraces.remove(--this.iBrace);
        Token token = (Token)this.vBraces.remove(--this.iBrace);
        if (this.theTok == 0x10000A) {
            --this.braceCount;
            --this.parenCount;
        }
        return this.forceFlowEnd(token);
    }

    private int forceFlowEnd(Token token) {
        Token token2 = this.tokenCommand;
        this.tokenCommand = new Token(233481, "end");
        this.tokCommand = this.tokenCommand.tok;
        if (!this.checkFlowCommand("end")) {
            return 0;
        }
        this.addTokenToPrefix(this.tokenCommand);
        switch (token.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                token = Token.tokenIf;
                break;
            }
            default: {
                token = Token.getTokenFromName((String)token.value);
            }
        }
        if (!this.checkFlowEnd(token.tok, (String)token.value, this.ichBrace)) {
            return 4;
        }
        if (token.tok != 135499780) {
            this.addTokenToPrefix(token);
        }
        this.tokenCommand = token2;
        if (this.tokenCommand != null) {
            this.tokCommand = this.tokenCommand.tok;
        }
        return 2;
    }

    private boolean checkFlowCommand(String string) {
        int n = this.lltoken.size();
        boolean bl = false;
        boolean bl2 = true;
        switch (this.tokCommand) {
            case 233481: {
                if (this.flowContext == null) {
                    return this.error(1, string);
                }
                bl = true;
                if (this.flowContext.token.tok == 135499780) break;
                this.tokenCommand = new Token(this.tokCommand, -this.flowContext.getPt0(), string);
                break;
            }
            case 102406: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 364548: {
                bl = true;
                if (this.flowContext != null && (this.flowContext.token.tok == 135369225 || this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402)) break;
                return this.error(1, string);
            }
            case 364547: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402) {
                    return this.error(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n);
                break;
            }
            case 102407: 
            case 102408: {
                ScriptFlowContext scriptFlowContext;
                bl2 = false;
                ScriptFlowContext scriptFlowContext2 = scriptFlowContext = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (scriptFlowContext == null) {
                    return this.error(1, string);
                }
                this.tokenCommand = new Token(this.tokCommand, scriptFlowContext.getPt0(), string);
                break;
            }
            case 102402: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402 && this.flowContext.token.tok != 364547) {
                    return this.error(1, "elseif");
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n);
                break;
            }
            case 135499780: {
                if (this.flowContext == null) break;
                return this.error(1, "function");
            }
        }
        if (bl) {
            this.flowContext.token.intValue = n;
            if (this.tokCommand == 364548) {
                this.flowContext = this.flowContext.getParent();
            }
        } else if (bl2) {
            this.tokenCommand = new Token(this.tokCommand, this.tokenCommand.value);
            if (this.tokCommand == 364547 || this.tokCommand == 102402) {
                this.flowContext.token = this.tokenCommand;
            } else {
                this.flowContext = new ScriptFlowContext(this, this.tokenCommand, n, this.flowContext);
            }
        }
        this.tokCommand = this.tokenCommand.tok;
        return true;
    }

    private boolean checkFlowEnd(int n, String string, int n2) {
        if ((this.flowContext == null || this.flowContext.token.tok != n) && (n != 135369225 || this.flowContext.token.tok != 364547 && this.flowContext.token.tok != 102402)) {
            return this.error(1, "end " + string);
        }
        switch (n) {
            case 102406: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 135499780: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(new Token(135499780, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, n2, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = null;
                this.tokenCommand.intValue = 0;
                this.flowContext = this.flowContext.getParent();
                return true;
            }
            default: {
                return this.error(19, "end " + string);
            }
        }
        this.flowContext = this.flowContext.getParent();
        return true;
    }

    private boolean getData(String string) {
        int n;
        this.ichToken += string.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((n = this.script.indexOf(this.chFirst + string + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.incrementLineCount(string2);
        this.addTokenToPrefix(new Token(135272450, string2));
        this.addTokenToPrefix(new Token(1, "end"));
        this.addTokenToPrefix(new Token(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private int incrementLineCount(String string) {
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n < 0 && n2 < 0) {
            return 0;
        }
        short s = this.lineCurrent;
        if (n < 0 || n2 < n) {
            n = n2;
        }
        int n3 = string.length();
        while (--n3 >= n) {
            char c = string.charAt(n3);
            if (c != '\n' && c != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - s;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return ScriptCompiler.eol(c, this.nSemiSkip);
    }

    static boolean eol(char c, int n) {
        return c == '\r' || c == '\n' || c == ';' && n <= 0;
    }

    private boolean lookingAtBraceSyntax() {
        int n = this.ichToken;
        int n2 = 1;
        while (++n < this.cchScript && n2 > 0) {
            switch (this.script.charAt(n)) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    --n2;
                }
            }
        }
        if (n < this.cchScript && this.script.charAt(n) == '[' && ++n2 == 1) {
            while (++n < this.cchScript && n2 > 0) {
                switch (this.script.charAt(n)) {
                    case '[': {
                        ++n2;
                        break;
                    }
                    case ']': {
                        --n2;
                    }
                }
            }
        }
        return n < this.cchScript && this.script.charAt(n) == '.' && n2 == 0;
    }

    private boolean lookingAtString(boolean bl) {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || bl && this.chFirst == '\'')) {
            return false;
        }
        int n = this.ichToken;
        boolean bl2 = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != this.chFirst || bl2)) {
            bl2 = c == '\\' ? !bl2 : false;
        }
        this.cchToken = n == this.cchScript ? -1 : ++n - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 98: {
                        n3 = 8;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = ScriptCompiler.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private boolean lookingAtLoadFormat() {
        int n;
        char c = '\u0000';
        for (n = this.ichToken; n < this.cchScript && ((c = this.script.charAt(n)) == '=' && n == this.ichToken || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == this.ichToken || !this.eol(c) && !ScriptCompiler.isSpaceOrTab(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString() {
        char c;
        int n;
        for (n = this.ichToken; n < this.cchScript && !this.eol(c = this.script.charAt(n)) && c != '}'; ++n) {
        }
        boolean bl = false;
        if (!(n <= this.ichToken || this.script.charAt(this.ichToken) != '@' && this.script.charAt(this.ichToken) != '%' || n > this.ichToken + 1 && (bl = this.script.charAt(this.ichToken + 1) == '{'))) {
            return false;
        }
        if (bl) {
            n = ScriptCompiler.ichMathTerminator(this.script, this.ichToken + 1, this.cchScript);
            if (n == this.cchScript) {
                return false;
            }
            this.cchToken = n + 1 - this.ichToken;
            return this.cchToken > 0;
        }
        while (--n > this.ichToken && Character.isWhitespace(this.script.charAt(n))) {
        }
        return (this.cchToken = ++n - this.ichToken) > 0;
    }

    static int ichMathTerminator(String string, int n, int n2) {
        int n3 = 1;
        char c = '\u0000';
        int n4 = 0;
        while (n3 > 0 && ++n < n2) {
            char c2 = string.charAt(n);
            if (c != '\u0000') {
                if (n4 == 92) {
                    c2 = '\u0000';
                } else if (c2 == c) {
                    c = '\u0000';
                }
                n4 = c2;
                continue;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    c = c2;
                    break;
                }
                case '{': {
                    ++n3;
                    break;
                }
                case '}': {
                    --n3;
                }
            }
        }
        return n;
    }

    private float lookingAtExponential() {
        boolean bl;
        boolean bl2;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n = this.ichToken;
        boolean bl3 = bl2 = this.script.charAt(n) == '-';
        if (bl2) {
            ++n;
        }
        int n2 = n;
        boolean bl4 = false;
        int n3 = 88;
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n == this.cchScript || !bl4) {
            return Float.NaN;
        }
        int n4 = n;
        int n5 = 1;
        int n6 = 0;
        boolean bl5 = bl = n3 == 69 || n3 == 101;
        if (!bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
            int n7 = n5 = n3 == 45 ? -1 : 1;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            n6 = n6 * 10 + n3 - 48;
        }
        if (n6 == 0) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        double d = Float.valueOf(this.script.substring(n2, n4)).doubleValue();
        return (float)(d *= (double)(bl2 ? -1 : 1) * Math.pow(10.0, n5 * n6));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n2 = 88;
        while (n < this.cchScript) {
            char c2 = this.script.charAt(n++);
            n2 = c2;
            if (!Character.isDigit(c2)) break;
            bl = true;
        }
        if (n2 != 46) {
            return false;
        }
        if (n < this.cchScript && !this.eol(c = this.script.charAt(n))) {
            if (Character.isLetter(c) || c == '?') {
                return false;
            }
            if (n + 1 < this.cchScript && (Character.isLetter(c = this.script.charAt(n + 1)) || c == '?')) {
                return false;
            }
        }
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        int n = this.ichToken;
        char c = ' ';
        if (n + 1 < this.cchScript && this.script.charAt(n) == '*' && this.script.charAt(n + 1) == '^') {
            c = '^';
            ++n;
        } else {
            if (this.script.charAt(n) == '-') {
                ++n;
            }
            while (n < this.cchScript) {
                char c2 = this.script.charAt(n);
                c = c2;
                if (!Character.isDigit(c2)) break;
                ++n;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !Character.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    BitSet lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || this.script.charAt(this.ichToken) != '(' && this.script.charAt(this.ichToken) != '[') {
            return null;
        }
        char c = this.script.charAt(this.ichToken) == '(' ? (char)')' : ']';
        char c2 = ' ';
        for (n = this.ichToken + 2; n < this.cchScript; ++n) {
            char c3 = this.script.charAt(n);
            c2 = c3;
            if (c3 == '}' || !Character.isDigit(c2) && !ScriptCompiler.isSpaceOrTab(c2) && c2 != 58) break;
        }
        if (c2 != '}' || n + 1 == this.cchScript || this.script.charAt(n + 1) != c) {
            return null;
        }
        int n2 = -1;
        int n3 = 0;
        BitSet bitSet = new BitSet();
        int n4 = this.ichToken + 2;
        while (n4 < n) {
            while (ScriptCompiler.isSpaceOrTab(c2 = this.script.charAt(n4))) {
                ++n4;
            }
            n3 = n4;
            while (Character.isDigit(c2 = this.script.charAt(n3))) {
                ++n3;
            }
            if (n3 == n4) {
                return null;
            }
            int n5 = Integer.parseInt(this.script.substring(n4, n3));
            if (c2 == ':') {
                n2 = n5;
            } else {
                if (n2 >= 0) {
                    if (n2 > n5) {
                        return null;
                    }
                    for (int i = n2; i <= n5; ++i) {
                        bitSet.set(i);
                    }
                } else {
                    bitSet.set(n5);
                }
                n2 = -1;
            }
            n4 = ++n3;
        }
        if (n2 >= 0) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return bitSet;
    }

    private boolean lookingAtObjectID(boolean bl) {
        int n = this.ichToken;
        if (n == this.cchScript || this.script.charAt(n) != '$') {
            return false;
        }
        if (++n != this.cchScript && this.script.charAt(n) == '\"') {
            return false;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            if (Character.isWhitespace(c)) {
                if (n != this.ichToken + 1) break;
                return false;
            }
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (bl) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++n;
        }
        this.cchToken = n - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int n) {
        if (n == this.cchScript) {
            return false;
        }
        int n2 = n;
        this.tokLastMath = 0;
        char c = this.script.charAt(n++);
        switch (c) {
            case '&': 
            case '+': 
            case '-': 
            case '|': {
                if (n < this.cchScript) {
                    if (this.script.charAt(n) == c) {
                        ++n;
                        if (c == '-' || c == '+') {
                            break;
                        }
                    } else if (this.script.charAt(n) == '=') {
                        ++n;
                    }
                }
                this.tokLastMath = 1;
                break;
            }
            case '/': {
                if (n < this.cchScript && this.script.charAt(n) == '/') break;
            }
            case '!': 
            case '*': 
            case '\\': {
                if (n < this.cchScript && this.script.charAt(n) == '=') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            case ')': 
            case '.': 
            case ']': 
            case '}': {
                break;
            }
            case '@': 
            case '{': {
                this.tokLastMath = 2;
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ':': 
            case ';': 
            case '[': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (n < this.cchScript && ((c = this.script.charAt(n)) == '<' || c == '=' || c == '>')) {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!Character.isLetter(c)) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (c == '?') {
                    this.tokLastMath = 1;
                }
                while (n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) || c == '_' || c == '?' || c == '~' || c == '\'') || c == '^' && n > n2 && Character.isDigit(this.script.charAt(n - 1)) || c == '\\' && n + 1 < this.cchScript && this.script.charAt(n + 1) == '?') {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - n2;
        return true;
    }

    private boolean charToken() {
        int n;
        char c;
        if (this.ichToken == this.cchScript || (c = this.script.charAt(this.ichToken)) == '\"' || c == '@') {
            return false;
        }
        for (n = this.ichToken; n < this.cchScript && !ScriptCompiler.isSpaceOrTab(c = this.script.charAt(n)) && c != '#' && c != '}' && !this.eol(c); ++n) {
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int ERROR(int n) {
        this.error(n, null, null);
        return 4;
    }

    private int ERROR(int n, String string) {
        this.error(n, string);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken : this.ichEnd);
        String string = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT._("script compiler ERROR: ") + this.errorMessage + ScriptEvaluator.setErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

