/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.popup.JmolPopup;
import org.jmol.shape.Shape;
import org.jmol.util.Base64;
import org.jmol.util.BitSetUtil;
import org.jmol.util.CifDataReader;
import org.jmol.util.CommandHistory;
import org.jmol.util.Escape;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TempArray;
import org.jmol.util.TextFormat;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptCompiler;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.TransformManager10;
import org.jmol.viewer.TransformManager11;

public class Viewer
extends JmolViewer
implements AtomDataServer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    ScriptCompiler compiler;
    Hashtable definedAtomSets;
    private MinimizerInterface minimizer;
    private SmilesMatcherInterface smilesMatcher;
    private SymmetryInterface symmetry;
    ScriptEvaluator eval;
    private AnimationManager animationManager;
    private DataManager dataManager;
    private FileManager fileManager;
    private ModelManager modelManager;
    private ModelSet modelSet;
    public MouseManager mouseManager;
    private PickingManager pickingManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempArray tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private String fullName = "";
    private String syncId = "";
    private String appletDocumentBase = "";
    private String appletCodeBase = "";
    private boolean jvm11orGreater = false;
    private boolean jvm12orGreater = false;
    private boolean jvm14orGreater = false;
    private boolean isSilent = false;
    private boolean isApplet = false;
    private boolean isPreviewOnly = false;
    boolean autoExit = false;
    boolean haveDisplay = true;
    private boolean isPrintOnly = false;
    private boolean mustRender = true;
    private boolean isCmdLine_c_or_C_Option = false;
    private boolean listCommands = false;
    private boolean isCmdLine_C_Option = true;
    private boolean useCommandThread = false;
    private boolean isSignedApplet = false;
    private boolean isDataOnly;
    private boolean mouseEnabled = true;
    private boolean noneSelected;
    private static final int FILE_STATUS_NOT_LOADED = -1;
    private static final int FILE_STATUS_ZAPPED = 0;
    private static final int FILE_STATUS_CREATING_MODELSET = 2;
    private static final int FILE_STATUS_MODELSET_CREATED = 3;
    private static final int FILE_STATUS_MODELS_DELETED = 5;
    static final String STATE_VERSION_STAMP = "# Jmol state version ";
    public static Object testData;
    public static Object testData2;
    BitSet bsFrameOffsets;
    Point3f[] frameOffsets;
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    private int maximumSize = Integer.MAX_VALUE;
    private float imageFontScaling = 1.0f;
    private boolean antialiasDisplay;
    String interruptScript = "";
    int scriptIndex;
    boolean isScriptQueued = true;
    int hoverAtomIndex = -1;
    String hoverText;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_HAND = 1;
    public static final int CURSOR_CROSSHAIR = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_WAIT = 4;
    private int currentCursor = 0;
    int prevFrame = Integer.MIN_VALUE;
    private String language = GT.getLanguage();
    boolean frankOn = true;
    private boolean scriptEditorVisible;
    JmolAppConsoleInterface appConsole;
    JmolScriptEditorInterface scriptEditor;
    JmolPopup jmolpopup;
    String menuStructure;
    boolean isTainted = true;
    private boolean creatingImage;
    public static final String SYNC_GRAPHICS_MESSAGE = "GET_GRAPHICS";
    public static final String SYNC_NO_GRAPHICS_MESSAGE = "SET_GRAPHICS_OFF";
    private String errorMessage;
    private String errorMessageUntranslated;
    private int currentShapeID = -1;
    private String currentShapeState;

    protected void finalize() throws Throwable {
        Logger.debug("viewer finalize " + this);
        super.finalize();
    }

    public JmolAdapter getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = new SmarterJmolAdapter();
        }
        return this.modelAdapter;
    }

    MinimizerInterface getMinimizer(boolean bl) {
        if (this.minimizer == null && bl) {
            this.minimizer = (MinimizerInterface)Interface.getOptionInterface("minimize.Minimizer");
            this.minimizer.setProperty("viewer", this);
        }
        return this.minimizer;
    }

    SmilesMatcherInterface getSmilesMatcher() {
        if (this.smilesMatcher == null) {
            this.smilesMatcher = (SmilesMatcherInterface)Interface.getOptionInterface("smiles.PatternMatcher");
        }
        this.smilesMatcher.setModelSet(this.modelSet);
        return this.smilesMatcher;
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public Object getSymmetryInfo(BitSet bitSet, String string, int n, Point3f point3f, String string2, int n2) {
        return this.modelSet.getSymmetryInfo(bitSet, string, n, point3f, string2, n2);
    }

    private void clearModelDependentObjects() {
        this.setFrameOffsets(null);
        if (this.minimizer != null) {
            this.minimizer.setProperty("clear", null);
            this.minimizer = null;
        }
        if (this.smilesMatcher != null) {
            this.smilesMatcher.setModelSet(null);
            this.smilesMatcher = null;
        }
        if (this.symmetry != null) {
            this.symmetry = null;
        }
    }

    StateManager.GlobalSettings getGlobalSettings() {
        return this.global;
    }

    public Viewer(Component component, JmolAdapter jmolAdapter) {
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.display = component;
        this.modelAdapter = jmolAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        this.stateManager = new StateManager(this);
        this.g3d = new Graphics3D(component);
        this.colorManager = new ColorManager(this, this.g3d);
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager11(this);
        this.selectionManager = new SelectionManager(this);
        this.pickingManager = new PickingManager(this);
        if (component != null) {
            this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(component, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(component, this) : new MouseManager10(component, this));
        }
        this.modelManager = new ModelManager(this);
        this.tempManager = new TempArray();
        this.dataManager = new DataManager();
        this.animationManager = new AnimationManager(this);
        this.repaintManager = new RepaintManager(this);
        this.initialize();
        this.fileManager = new FileManager(this);
        this.compiler = new ScriptCompiler(this);
        this.definedAtomSets = new Hashtable();
        this.eval = new ScriptEvaluator(this);
    }

    public static JmolViewer allocateViewer(Component component, JmolAdapter jmolAdapter, String string, URL uRL, URL uRL2, String string2, JmolStatusListener jmolStatusListener) {
        Viewer viewer = new Viewer(component, jmolAdapter);
        ((JmolViewer)viewer).setAppletContext(string, uRL, uRL2, string2);
        ((JmolViewer)viewer).setJmolStatusListener(jmolStatusListener);
        return viewer;
    }

    public static JmolViewer allocateViewer(Component component, JmolAdapter jmolAdapter) {
        return new Viewer(component, jmolAdapter);
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    boolean isPreviewOnly() {
        return this.isPreviewOnly;
    }

    public void setAppletContext(String string, URL uRL, URL uRL2, String string2) {
        string = string == null ? "" : string;
        this.fullName = string;
        this.appletDocumentBase = uRL == null ? "" : uRL.toString();
        this.appletCodeBase = uRL2 == null ? "" : uRL2.toString();
        int n = string.lastIndexOf("[");
        this.htmlName = n < 0 ? string : string.substring(0, n);
        String string3 = this.syncId = n < 0 ? "" : string.substring(n + 1, string.length() - 1);
        if (string2 == null) {
            string2 = "";
        }
        String string4 = "" + string2;
        this.isPrintOnly = string2.indexOf("-p") >= 0;
        boolean bl = this.isApplet = string2.indexOf("-applet") >= 0;
        if (this.isApplet) {
            Logger.info("applet context: " + string2);
            String string5 = null;
            n = string4.indexOf("-appletProxy ");
            if (n >= 0) {
                string5 = string4.substring(n + 13);
                string4 = string4.substring(0, n);
            }
            this.fileManager.setAppletContext(uRL, uRL2, string5);
            this.isSignedApplet = string4.indexOf("-signed") >= 0;
            n = string4.indexOf("-maximumSize ");
            if (n >= 0) {
                this.setMaximumSize(Parser.parseInt(string4.substring(n + 13)));
            }
            boolean bl2 = this.useCommandThread = string4.indexOf("-threaded") >= 0;
            if (this.useCommandThread) {
                this.scriptManager.startCommandWatcher(true);
            }
        } else {
            this.g3d.setBackgroundTransparent(string4.indexOf("-b") >= 0);
            boolean bl3 = this.isSilent = string4.indexOf("-i") >= 0;
            if (this.isSilent) {
                Logger.setLogLevel(3);
            }
            this.isCmdLine_c_or_C_Option = string4.toLowerCase().indexOf("-c") >= 0;
            this.isCmdLine_C_Option = string4.indexOf("-C") >= 0;
            this.listCommands = string4.indexOf("-l") >= 0;
            this.autoExit = string4.indexOf("-x") >= 0;
            this.isDataOnly = this.display == null;
            boolean bl4 = this.haveDisplay = this.display != null && string4.indexOf("-n") < 0;
            if (!this.haveDisplay) {
                this.display = null;
            }
            this.mustRender = this.haveDisplay;
            this.cd(".");
        }
        this.isPreviewOnly = string4.indexOf("#previewOnly") >= 0;
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        if (!this.isSilent) {
            Logger.info("(C) 2009 Jmol Development\nJmol Version " + Viewer.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName + "\nmemory:" + this.getParameter("_memory") + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        this.zap(false, false);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    public boolean isDataOnly() {
        return this.isDataOnly;
    }

    public static String getJmolVersion() {
        return JmolConstants.version + "  " + JmolConstants.date;
    }

    public String getExportDriverList() {
        return (String)this.global.getParameter("exportDrivers");
    }

    private static int getJmolVersionInt() {
        String string = JmolConstants.version;
        int n = -1;
        try {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt(string);
                return n;
            }
            n = 100000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(".")) < 0) {
                return n += 1000 * Integer.parseInt(string);
            }
            n += 1000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf("_")) >= 0) {
                string = string.substring(0, n2);
            }
            if ((n2 = string.indexOf(" ")) >= 0) {
                string = string.substring(0, n2);
            }
            n += Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    static int getLogLevel() {
        for (int i = 0; i < 7; ++i) {
            if (!Logger.isActiveLevel(i)) continue;
            return 7 - i;
        }
        return 0;
    }

    public Component getDisplay() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event event) {
        return this.mouseManager.handleOldJvm10Event(event);
    }

    void reset() {
        this.modelSet.calcBoundBoxDimensions(null);
        this.axesAreTainted = true;
        this.transformManager.homePosition();
        if (this.modelSet.setCrystallographicDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        } else {
            this.setAxesModeMolecular(false);
        }
        this.prevFrame = Integer.MIN_VALUE;
        this.refresh(1, "Viewer:homePosition()");
    }

    public void homePosition() {
        this.evalString("reset");
    }

    Hashtable getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.htmlName);
        hashtable.put("syncId", this.syncId);
        hashtable.put("fullName", this.fullName);
        if (this.isApplet) {
            hashtable.put("documentBase", this.appletDocumentBase);
            hashtable.put("codeBase", this.appletCodeBase);
            hashtable.put("registry", this.statusManager.getRegistryInfo());
        }
        hashtable.put("version", JmolConstants.version);
        hashtable.put("date", JmolConstants.date);
        hashtable.put("javaVendor", this.strJavaVendor);
        hashtable.put("javaVersion", this.strJavaVersion);
        hashtable.put("operatingSystem", this.strOSName);
        return hashtable;
    }

    void initialize() {
        this.global = this.stateManager.getGlobalSettings(this.global);
        this.setIntProperty("_version", Viewer.getJmolVersionInt(), true);
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        this.global.setParameterValue("_width", this.dimScreen.width);
        this.global.setParameterValue("_height", this.dimScreen.height);
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        Viewer.setAmbientPercent(this.global.ambientPercent);
        Viewer.setDiffusePercent(this.global.diffusePercent);
        Viewer.setSpecular(this.global.specular);
        Viewer.setSpecularPercent(this.global.specularPercent);
        Viewer.setSpecularExponent(this.global.specularExponent);
        Viewer.setSpecularPower(this.global.specularPower);
        if (this.modelSet != null) {
            this.animationManager.setAnimationOn(false);
        }
        this.animationManager.setAnimationFps(this.global.animationFps);
        this.statusManager.setAllowStatusReporting(this.global.statusReporting);
        this.setBooleanProperty("antialiasDisplay", this.global.antialiasDisplay);
        this.setTransformManagerDefaults();
    }

    String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    public void saveOrientation(String string) {
        this.stateManager.saveOrientation(string);
    }

    public boolean restoreOrientation(String string, float f) {
        return this.stateManager.restoreOrientation(string, f, true);
    }

    public void restoreRotation(String string, float f) {
        this.stateManager.restoreOrientation(string, f, false);
    }

    void saveModelOrientation() {
        this.modelSet.saveModelOrientation(this.animationManager.currentModelIndex, this.stateManager.getOrientation());
    }

    public StateManager.Orientation getOrientation() {
        return this.stateManager.getOrientation();
    }

    void restoreModelOrientation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, false);
        }
    }

    void saveBonds(String string) {
        this.stateManager.saveBonds(string);
    }

    boolean restoreBonds(String string) {
        this.clearModelDependentObjects();
        return this.stateManager.restoreBonds(string);
    }

    void saveState(String string) {
        this.stateManager.saveState(string);
    }

    public String getSavedState(String string) {
        return this.stateManager.getSavedState(string);
    }

    void saveStructure(String string) {
        this.stateManager.saveStructure(string);
    }

    String getSavedStructure(String string) {
        return this.stateManager.getSavedStructure(string);
    }

    public void saveCoordinates(String string, BitSet bitSet) {
        this.stateManager.saveCoordinates(string, bitSet);
    }

    String getSavedCoordinates(String string) {
        return this.stateManager.getSavedCoordinates(string);
    }

    void saveSelection(String string) {
        this.stateManager.saveSelection(string, this.selectionManager.bsSelection);
        this.stateManager.restoreSelection(string);
    }

    boolean restoreSelection(String string) {
        return this.stateManager.restoreSelection(string);
    }

    public Matrix4f getMatrixtransform() {
        return this.transformManager.getMatrixtransform();
    }

    Quaternion getRotationQuaternion() {
        return this.transformManager.getRotationQuaternion();
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    void setRotationRadius(float f, boolean bl) {
        if (bl) {
            f = this.transformManager.setRotationRadius(f, false);
        }
        if (!this.modelSet.setRotationRadius(this.animationManager.currentModelIndex, f)) {
            this.global.setParameterValue("rotationRadius", f);
        }
    }

    public Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    void setCenterAt(String string, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setCenterAt(string, point3f);
    }

    void setCenterBitSet(BitSet bitSet, boolean bl) {
        Point3f point3f;
        Point3f point3f2 = point3f = bitSet != null && BitSetUtil.cardinalityOf(bitSet) > 0 ? this.getAtomSetCenter(bitSet) : null;
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, bl);
    }

    void setNewRotationCenter(Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, true);
    }

    public Point3f getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(n, n2);
        if (!this.transformManager.vibrationOn && n != 0) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public Point3f getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    float getNavigationOffsetPercent(char c) {
        return this.transformManager.getNavigationOffsetPercent(c);
    }

    public boolean isNavigating() {
        return this.transformManager.isNavigating();
    }

    boolean isInPosition(Vector3f vector3f, float f) {
        return this.transformManager.isInPosition(vector3f, f);
    }

    void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        this.transformManager.move(vector3f, f, vector3f2, f2, f3, n);
        this.moveUpdate(f3);
    }

    void moveTo(float f, Point3f point3f, Vector3f vector3f, float f2, float f3, float f4, float f5, float f6, Point3f point3f2, float f7, float f8, float f9) {
        this.transformManager.moveTo(f, point3f, vector3f, f2, f3, f4, f5, f6, point3f2, f7, f8, f9);
        this.moveUpdate(f);
        this.finalizeTransformParameters();
    }

    void moveTo(float f, Point3f point3f, Matrix3f matrix3f, float f2, float f3, float f4, float f5, Point3f point3f2, float f6, float f7, float f8) {
        this.transformManager.moveTo(f, point3f, matrix3f, f2, f3, f4, f5, point3f2, f6, f7, f8);
        this.moveUpdate(f);
        this.finalizeTransformParameters();
    }

    private void moveUpdate(float f) {
        if (f > 0.0f) {
            this.requestRepaintAndWait();
        } else if (f == 0.0f) {
            this.setSync();
        }
    }

    String getMoveToText(float f) {
        return this.transformManager.getMoveToText(f, false);
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray, fArray, n, n2);
        this.moveUpdate(f);
    }

    public void navigate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3f);
        this.moveUpdate(f);
    }

    void navigate(float f, Point3f[][] point3fArray) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray);
        this.moveUpdate(f);
    }

    void navigateSurface(float f, String string) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigateSurface(f, string);
        this.moveUpdate(f);
    }

    public void navigate(float f, Vector3f vector3f, float f2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, vector3f, f2);
        this.moveUpdate(f);
    }

    void navTranslate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslate(f, point3f);
        this.moveUpdate(f);
    }

    void navTranslatePercent(float f, float f2, float f3) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslatePercent(f, f2, f3);
        this.moveUpdate(f);
    }

    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    void zoomBy(int n) {
        if (this.mouseEnabled) {
            this.transformManager.zoomBy(n);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomBy " + n : "");
    }

    void zoomByFactor(float f) {
        if (this.mouseEnabled) {
            this.transformManager.zoomByFactor(f);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomByFactor " + f : "");
    }

    void rotateXYBy(int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.rotateXYBy(n, n2, null);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateXYBy " + n + " " + n2 : "");
    }

    void rotateZBy(int n) {
        if (this.mouseEnabled) {
            this.transformManager.rotateZBy(n);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateZBy " + n : "");
    }

    void rotateMolecule(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        if (this.mouseEnabled) {
            this.transformManager.setRotateMolecule(true);
            this.transformManager.rotateXYBy(n, n2, this.selectionManager.bsSelection);
            this.transformManager.setRotateMolecule(false);
            this.refreshMeasures();
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateMolecule " + n + " " + n2 : "");
    }

    void translateXYBy(int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.translateXYBy(n, n2);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: translateXYBy " + n + " " + n2 : "");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateX(float f) {
        this.transformManager.rotateX(f);
        this.refresh(1, "Viewer:rotateX()");
    }

    public void rotateY(float f) {
        this.transformManager.rotateY(f);
        this.refresh(1, "Viewer:rotateY()");
    }

    public void rotateZ(float f) {
        this.transformManager.rotateZ(f);
        this.refresh(1, "Viewer:rotateZ()");
    }

    public void rotateX(int n) {
        this.rotateX((float)n * ((float)Math.PI / 180));
    }

    public void rotateY(int n) {
        this.rotateY((float)n * ((float)Math.PI / 180));
    }

    void translate(char c, float f, char c2) {
        int n = c2 == '\u0000' ? 0 : (c2 == '%' ? this.transformManager.percentToPixels(c, f) : this.transformManager.angstromsToPixels(f * (c2 == 'n' ? 10.0f : 1.0f)));
        switch (c) {
            case 'x': {
                if (c2 == '\u0000') {
                    this.transformManager.translateToXPercent(f);
                    break;
                }
                this.transformManager.translateXYBy(n, 0);
                break;
            }
            case 'y': {
                if (c2 == '\u0000') {
                    this.transformManager.translateToYPercent(f);
                    break;
                }
                this.transformManager.translateXYBy(0, n);
                break;
            }
            case 'z': {
                if (c2 == '\u0000') {
                    this.transformManager.translateToZPercent(f);
                    break;
                }
                this.transformManager.translateZBy(n);
            }
        }
        this.refresh(1, "Viewer:translate()");
    }

    public float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    public float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    public String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    public int getZoomPercent() {
        return (int)this.getZoomSetting();
    }

    float getZoomSetting() {
        return this.transformManager.getZoomSetting();
    }

    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    float getMaxZoomPercent() {
        return 200000.0f;
    }

    void slabReset() {
        this.transformManager.slabReset();
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    void slabByPixels(int n) {
        this.transformManager.slabByPercentagePoints(n);
    }

    void depthByPixels(int n) {
        this.transformManager.depthByPercentagePoints(n);
    }

    void slabDepthByPixels(int n) {
        this.transformManager.slabDepthByPercentagePoints(n);
    }

    void slabToPercent(int n) {
        this.transformManager.slabToPercent(n);
    }

    void slabInternal(Point4f point4f, boolean bl) {
        this.transformManager.slabInternal(point4f, bl);
    }

    void depthToPercent(int n) {
        this.transformManager.depthToPercent(n);
    }

    void setSlabDepthInternal(boolean bl) {
        this.transformManager.setSlabDepthInternal(bl);
    }

    public int zValueFromPercent(int n) {
        return this.transformManager.zValueFromPercent(n);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue, this.transformManager.zShadeEnabled, this.transformManager.zSlabValue, this.transformManager.zDepthValue);
    }

    public void rotatePoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.rotatePoint(point3f, point3f2);
    }

    public Point3i transformPoint(Point3f point3f) {
        return this.transformManager.transformPoint(point3f);
    }

    public Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        return this.transformManager.transformPoint(point3f, vector3f);
    }

    public void transformPoint(Point3f point3f, Point3i point3i) {
        this.transformManager.transformPoint(point3f, point3i);
    }

    public void transformPointNoClip(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPointNoClip(point3f, point3f2);
    }

    public void transformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPoint(point3f, point3f2);
    }

    public void transformPoints(Point3f[] point3fArray, Point3i[] point3iArray) {
        this.transformManager.transformPoints(point3fArray.length, point3fArray, point3iArray);
    }

    public void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.transformManager.transformVector(vector3f, vector3f2);
    }

    public void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.unTransformPoint(point3f, point3f2);
    }

    public float getScalePixelsPerAngstrom(boolean bl) {
        return this.transformManager.scalePixelsPerAngstrom * (bl || !this.global.antialiasDisplay ? 1.0f : 0.5f);
    }

    public short scaleToScreen(int n, int n2) {
        return this.transformManager.scaleToScreen(n, n2);
    }

    public float unscaleToScreen(int n, int n2) {
        return this.transformManager.unscaleToScreen(n, n2);
    }

    public float scaleToPerspective(int n, float f) {
        return this.transformManager.scaleToPerspective(n, f);
    }

    void setSpin(String string, int n) {
        if (!Parser.isOneOf(string, "x;y;z;fps;X;Y;Z;FPS")) {
            return;
        }
        int n2 = "x;y;z;fps;X;Y;Z;FPS".indexOf(string);
        switch (n2) {
            case 0: {
                this.transformManager.setSpinXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 2: {
                this.transformManager.setSpinXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 4: {
                this.transformManager.setSpinXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            default: {
                this.transformManager.setSpinFps(n);
                break;
            }
            case 10: {
                this.transformManager.setNavXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 12: {
                this.transformManager.setNavXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 14: {
                this.transformManager.setNavXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            case 16: {
                this.transformManager.setNavFps(n);
            }
        }
        this.global.setParameterValue((n2 < 10 ? "spin" : "nav") + string, n);
    }

    String getSpinState() {
        return this.transformManager.getSpinState(false);
    }

    void setSpinOn(boolean bl) {
        this.transformManager.setSpinOn(bl);
    }

    boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    void setNavOn(boolean bl) {
        this.transformManager.setNavOn(bl);
    }

    boolean getNavOn() {
        return this.transformManager.getNavOn();
    }

    void setNavXYZ(float f, float f2, float f3) {
        this.transformManager.setNavXYZ((int)f, (int)f2, (int)f3);
    }

    public String getOrientationText(int n) {
        return this.transformManager.getOrientationText(n);
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    public void getAxisAngle(AxisAngle4f axisAngle4f) {
        this.transformManager.getAxisAngle(axisAngle4f);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrix3f) {
        this.transformManager.getRotation(matrix3f);
    }

    private void setDefaultColors(String string) {
        this.colorManager.setDefaultColors(string);
        this.global.setParameterValue("colorRasmol", string.equals("rasmol"));
    }

    float getDefaultTranslucent() {
        return this.global.defaultTranslucent;
    }

    public int getColixArgb(short s) {
        return this.g3d.getColixArgb(s);
    }

    void setRubberbandArgb(int n) {
        this.colorManager.setRubberbandArgb(n);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int n, int n2) {
        this.global.setParameterValue("=color " + JmolConstants.elementNameFromNumber(n), Escape.escapeColor(n2));
        this.colorManager.setElementArgb(n, n2);
    }

    public float getVectorScale() {
        return this.global.vectorScale;
    }

    public void setVectorScale(float f) {
        this.global.setParameterValue("vectorScale", f);
        this.global.vectorScale = f;
    }

    public float getDefaultDrawArrowScale() {
        return this.global.defaultDrawArrowScale;
    }

    public void setDefaultDrawArrowScale(float f) {
        this.global.setParameterValue("defaultDrawArrowScale", f);
        this.global.defaultDrawArrowScale = f;
    }

    float getVibrationScale() {
        return this.global.vibrationScale;
    }

    float getVibrationPeriod() {
        return this.global.vibrationPeriod;
    }

    public boolean isVibrationOn() {
        return this.transformManager.vibrationOn;
    }

    public void setVibrationScale(float f) {
        this.transformManager.setVibrationScale(f);
        this.global.vibrationScale = f;
        this.global.setParameterValue("vibrationScale", f);
    }

    void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    public void setVibrationPeriod(float f) {
        this.transformManager.setVibrationPeriod(f);
        this.global.vibrationPeriod = f = Math.abs(f);
        this.global.setParameterValue("vibrationPeriod", f);
    }

    void setObjectColor(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.setObjectArgb(string, Graphics3D.getArgbFromString(string2));
    }

    void setObjectArgb(String string, int n) {
        int n2 = StateManager.getObjectIdFromName(string);
        if (n2 < 0) {
            return;
        }
        this.global.objColors[n2] = n;
        switch (n2) {
            case 0: {
                this.g3d.setBackgroundArgb(n);
                this.colorManager.setColixBackgroundContrast(n);
            }
        }
        this.global.setParameterValue(string + "Color", Escape.escapeColor(n));
    }

    void setBackgroundImage(String string, Image image) {
        this.global.backgroundImageFileName = string;
        this.g3d.setBackgroundImage(image);
    }

    int getObjectArgb(int n) {
        return this.global.objColors[n];
    }

    public short getObjectColix(int n) {
        int n2 = this.getObjectArgb(n);
        if (n2 == 0) {
            return this.getColixBackgroundContrast();
        }
        return Graphics3D.getColix(n2);
    }

    public String getObjectState(String string) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        int n2 = this.getObjectMad(n);
        StringBuffer stringBuffer = new StringBuffer("\n");
        Shape.appendCmd(stringBuffer, string + (n2 == 0 ? " off" : (n2 == 1 ? " on" : (n2 == -1 ? " dotted" : (n2 < 20 ? " " + n2 : " " + (float)n2 / 2000.0f)))));
        return stringBuffer.toString();
    }

    public void setColorBackground(String string) {
        this.setObjectColor("background", string);
    }

    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    void setObjectMad(int n, String string, int n2) {
        int n3 = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n3 < 0) {
            return;
        }
        if (n2 == -2 || n2 == -4) {
            int n4 = n2 + 3;
            n2 = this.getObjectMad(n3);
            if (n2 == 0) {
                n2 = n4;
            }
        }
        this.global.setParameterValue("show" + string, n2 != 0);
        boolean bl = this.global.objStateOn[n3] = n2 != 0;
        if (n2 == 0) {
            return;
        }
        this.global.objMad[n3] = n2;
        this.setShapeSize(n, n2, Float.NaN);
    }

    public int getObjectMad(int n) {
        return this.global.objStateOn[n] ? this.global.objMad[n] : 0;
    }

    public void setPropertyColorScheme(String string, boolean bl) {
        this.global.propertyColorScheme = string;
        this.colorManager.setColorScheme(string, bl);
    }

    public String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    String getSpecularState() {
        return this.global.getSpecularState();
    }

    private static void setSpecular(boolean bl) {
        ColorManager.setSpecular(bl);
    }

    boolean getSpecular() {
        return ColorManager.getSpecular();
    }

    private static void setSpecularPower(int n) {
        ColorManager.setSpecularPower(Math.abs(n));
    }

    private static void setSpecularExponent(int n) {
        ColorManager.setSpecularPower(-Math.abs(n));
    }

    private static void setAmbientPercent(int n) {
        ColorManager.setAmbientPercent(n);
    }

    static int getAmbientPercent() {
        return ColorManager.getAmbientPercent();
    }

    private static void setDiffusePercent(int n) {
        ColorManager.setDiffusePercent(n);
    }

    static int getDiffusePercent() {
        return ColorManager.getDiffusePercent();
    }

    private static void setSpecularPercent(int n) {
        ColorManager.setSpecularPercent(n);
    }

    static int getSpecularPercent() {
        return ColorManager.getSpecularPercent();
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        return this.colorManager.getColixAtomPalette(atom, by);
    }

    public short getColixBondPalette(Bond bond, byte by) {
        return this.colorManager.getColixBondPalette(bond, by);
    }

    public int[] getColorSchemeArray(String string) {
        return this.colorManager.getColorSchemeArray(string);
    }

    public String getColorSchemeList(String string, boolean bl) {
        return this.colorManager.getColorSchemeList(string, bl);
    }

    public static void setUserScale(int[] nArray) {
        ColorManager.setUserScale(nArray);
    }

    public short getColixForPropertyValue(float f) {
        return this.colorManager.getColixForPropertyValue(f);
    }

    Point3f getColorPointForPropertyValue(float f) {
        short s = this.colorManager.getColixForPropertyValue(f);
        Point3f point3f = new Point3f();
        return Graphics3D.colorPointFromInt(this.g3d.getColixArgb(s), point3f);
    }

    void select(BitSet bitSet, boolean bl) {
        this.selectionManager.select(bitSet, bl);
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, Float.NaN, null);
    }

    void selectBonds(BitSet bitSet) {
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, Float.NaN, bitSet);
    }

    void hide(BitSet bitSet, boolean bl) {
        this.selectionManager.hide(bitSet, bl);
    }

    void display(BitSet bitSet, boolean bl) {
        this.selectionManager.display(this.getModelAtomBitSet(-1, false), bitSet, bl);
    }

    BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int n) {
        return this.selectionManager.isSelected(n);
    }

    boolean isInSelectionSubset(int n) {
        return this.selectionManager.isInSelectionSubset(n);
    }

    void reportSelection(String string) {
        if (this.modelSet.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        if (this.isScriptQueued || this.global.debugScript) {
            this.scriptStatus(string);
        }
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        return this.modelSet.getAtomSetCenter(bitSet);
    }

    private void clearAtomSets() {
        this.setSelectionSubset(null);
        this.definedAtomSets.clear();
    }

    public void selectAll() {
        this.selectionManager.selectAll(false);
    }

    void setNoneSelected(boolean bl) {
        this.noneSelected = bl;
    }

    Boolean getNoneSelected() {
        return this.noneSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void clearSelection() {
        this.selectionManager.clearSelection(false);
        this.global.setParameterValue("hideNotSelected", false);
    }

    public void setSelectionSet(BitSet bitSet) {
        this.selectionManager.setSelectionSet(bitSet);
    }

    void setSelectionSubset(BitSet bitSet) {
        this.selectionManager.setSelectionSubset(bitSet);
    }

    public BitSet getSelectionSubset() {
        return this.selectionManager.bsSubset;
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    void setFormalCharges(int n) {
        this.modelSet.setFormalCharges(this.selectionManager.bsSelection, n);
    }

    public void addSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    public void removeSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    BitSet getAtomBitSet(Object object) {
        return ScriptEvaluator.getAtomBitSet(this.eval, object);
    }

    Vector getAtomBitSetVector(Object object) {
        return ScriptEvaluator.getAtomBitSetVector(this.eval, this.getAtomCount(), object);
    }

    public void setModeMouse(int n) {
        if (this.haveDisplay) {
            this.mouseManager.setModeMouse(n);
        }
        if (n == -1) {
            this.clearScriptQueue();
            this.haltScriptExecution();
            this.transformManager.setSpinOn(false);
            this.transformManager.setNavOn(false);
            this.transformManager.setVibrationPeriod(0.0f);
            this.scriptManager.startCommandWatcher(false);
            this.scriptManager.interruptQueueThreads();
            this.g3d.destroy();
            if (this.appConsole != null) {
                this.appConsole.dispose();
                this.appConsole = null;
            }
            if (this.scriptEditor != null) {
                this.scriptEditor.dispose();
                this.scriptEditor = null;
            }
        }
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    public int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    public int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    public BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl) {
        return this.fileManager.getBufferedReaderOrErrorMessageFromName(string, stringArray, bl, true);
    }

    void addLoadScript(String string) {
        this.fileManager.addLoadScript(string);
    }

    private Hashtable setLoadParameters(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        if (this.global.atomTypes.length() > 0) {
            hashtable.put("atomTypes", this.global.atomTypes);
        }
        if (!hashtable.containsKey("lattice")) {
            hashtable.put("lattice", this.global.getDefaultLattice());
        }
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        if (this.getPdbLoadInfo(2)) {
            hashtable.put("getHeader", Boolean.TRUE);
        }
        return hashtable;
    }

    public String openFile(String string) {
        this.zap(false, false);
        this.fileManager.createAtomSetCollectionFromFile(string, new Hashtable(), null, false);
        return this.createModelSetAndReturnError(false);
    }

    public void openFileAsynchronously(String string) {
        boolean bl;
        boolean bl2 = bl = !string.startsWith("\t");
        if (!bl) {
            string = string.substring(1);
        }
        string = string.replace('\\', '/');
        String string2 = this.fileManager.getFileTypeName(string);
        this.checkHalt("exit");
        if (this.scriptEditorVisible && (bl &= string2 == null)) {
            this.showEditor(new String[]{string, this.getFileAsString(string)});
        } else {
            this.evalString((bl ? "script " : "zap;load ") + Escape.escape(string));
        }
    }

    void openFile(String string, Hashtable hashtable, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("string[]")) {
            return;
        }
        Logger.startTimer();
        if (string.equalsIgnoreCase("string")) {
            String string3 = hashtable.containsKey("fileData") ? (String)hashtable.get("fileData") : this.fileManager.getInlineData(-1);
            this.createModelSetInline(string3, hashtable, bl, false);
        } else {
            if (!bl && string.charAt(0) != '?') {
                this.zap(false, false);
            }
            this.fileManager.createAtomSetCollectionFromFile(string, this.setLoadParameters(hashtable), string2, bl);
        }
        Logger.checkTimer("openFile(" + string + ")");
    }

    public String openFiles(String string, String[] stringArray) {
        this.openFiles(string, stringArray, null, false, null);
        return this.createModelSetAndReturnError(false);
    }

    String openFiles(String string, String[] stringArray, String string2, boolean bl, Hashtable hashtable) {
        if (!bl) {
            this.zap(false, false);
        }
        long l = System.currentTimeMillis();
        this.fileManager.createAtomSetCollectionFromFiles(string, stringArray, string2, bl, this.setLoadParameters(hashtable));
        long l2 = System.currentTimeMillis() - l;
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + (i == 0 ? "" : ",") + stringArray[i];
        }
        Logger.info("openFiles(" + stringArray.length + ") " + l2 + " ms");
        return string3;
    }

    public String openStringInline(String string) {
        return this.createModelSetInline(string, null, false, true);
    }

    private String createModelSetInline(String string, Hashtable hashtable, boolean bl, boolean bl2) {
        if (!bl) {
            this.zap(true, false);
        }
        this.fileManager.createAtomSetCollectionFromString(string, this.setLoadParameters(hashtable), bl);
        return bl2 ? this.createModelSetAndReturnError(bl) : null;
    }

    private String openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        if (!bl) {
            this.zap(true, false);
        }
        this.fileManager.createAtomSeCollectionFromStrings(stringArray, this.setLoadParameters(hashtable), bl);
        return this.createModelSetAndReturnError(bl);
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    public String loadInline(String string) {
        return this.loadInline(string, this.global.inlineNewlineChar, false);
    }

    public String loadInline(String string, boolean bl) {
        return this.loadInline(string, '\u0000', bl);
    }

    public String loadInline(String string, char c) {
        return this.loadInline(string, c, false);
    }

    String loadInline(String string, char c, boolean bl) {
        String string2;
        int n;
        String string3;
        if (string == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        Logger.debug(string);
        String string4 = string3 = string.indexOf(10) >= 0 ? "" : "\n";
        if (c != '\u0000' && c != '\n') {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
            }
            if (n < n2 && string.charAt(n) == c) {
                string = string.substring(n + 1);
            }
            string = TextFormat.simpleReplace(string, "" + c, string3);
        }
        if ((string2 = this.getDataSeparator()) != null && string2 != "" && (n = string.indexOf(string2)) >= 0) {
            int n3 = 2;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                ++n3;
            }
            String[] stringArray = new String[n3];
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                n4 = string.indexOf(string2, n5);
                if (n4 < 0) {
                    n4 = string.length();
                }
                stringArray[n] = string.substring(n5, n4);
                n5 = n4 + string2.length();
            }
            return this.openStringsInline(stringArray, hashtable, bl);
        }
        return this.createModelSetInline(string, hashtable, bl, true);
    }

    String getDataSeparator() {
        return (String)this.global.getParameter("dataseparator");
    }

    public String loadInline(String[] stringArray) {
        return this.loadInline(stringArray, false);
    }

    public String loadInline(String[] stringArray, boolean bl) {
        return stringArray == null || stringArray.length == 0 ? null : this.openStringsInline(stringArray, null, bl);
    }

    public boolean getApplySymmetryToBonds() {
        return this.global.applySymmetryToBonds;
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.global.applySymmetryToBonds = bl;
    }

    void setAtomData(int n, String string, String string2) {
        this.modelSet.setAtomData(n, string, string2);
    }

    public String openDOM(Object object) {
        this.zap(true, false);
        long l = System.currentTimeMillis();
        this.fileManager.createAtomSetCollectionFromDOM(object);
        long l2 = System.currentTimeMillis() - l;
        Logger.info("openDOM " + l2 + " ms");
        return this.createModelSetAndReturnError(false);
    }

    public String openReader(String string, String string2, Reader reader) {
        this.zap(true, false);
        this.fileManager.createAtomSetCollectionFromReader(string, string2, reader);
        return this.createModelSetAndReturnError(false);
    }

    String createModelSetAndReturnError(boolean bl) {
        String string;
        String string2 = this.getFullPathName();
        String string3 = this.getFileName();
        Object object = this.fileManager.getAtomSetCollectionOrError();
        this.fileManager.deallocateReaderThreads();
        if (object instanceof String || object == null) {
            string = (String)object;
            this.setFileLoadStatus(-1, string2, null, null, string);
            if (string != null && !bl && !string.equals("#CANCELED#")) {
                this.zap(string);
            }
        } else {
            if (bl) {
                this.clearAtomSets();
            }
            this.setFileLoadStatus(2, string2, string3, null, null);
            string = this.createModelSet(string2, string3, object, bl);
            this.setFileLoadStatus(3, string2, string3, this.getModelSetName(), string);
            if (bl) {
                this.selectAll();
                this.setTainted(true);
            }
            object = null;
            System.gc();
        }
        return string;
    }

    String loadAtomDataAndReturnError(int n) {
        Object object = this.fileManager.getAtomSetCollectionOrError();
        this.fileManager.deallocateReaderThreads();
        String string = object instanceof String || object == null ? (String)object : this.createAtomDataSet(n, object);
        return string;
    }

    private String createAtomDataSet(int n, Object object) {
        this.setErrorMessage(null);
        try {
            ((ModelLoader)this.modelSet).createAtomDataSet(n, object, this.selectionManager.bsSelection);
            if (n == 4162) {
                this.setStatusFrameChanged(Integer.MIN_VALUE);
            }
        }
        catch (Error error) {
            this.handleError(error, true);
            String string = this.getShapeErrorState();
            string = "ERROR adding vibrations: " + error + (string.length() == 0 ? "" : "|" + string);
            this.zap(string);
            this.setErrorMessage(string);
        }
        return this.getErrorMessage();
    }

    void deallocateReaderThreads() {
        this.fileManager.deallocateReaderThreads();
    }

    public void openClientFile(String string, String string2, Object object) {
        this.createModelSet(string, string2, object, false);
    }

    private String createModelSet(String string, String string2, Object object, boolean bl) {
        this.pushHoldRepaint("createModelSet");
        this.setErrorMessage(null);
        try {
            this.modelSet = this.modelManager.createModelSet(string, string2, object, bl);
            if (!bl) {
                this.initializeModel();
            }
        }
        catch (Error error) {
            this.handleError(error, true);
            String string3 = this.getShapeErrorState();
            string3 = "ERROR creating model: " + error + (string3.length() == 0 ? "" : "|" + string3);
            this.zap(string3);
            this.setErrorMessage(string3);
        }
        this.popHoldRepaint("createModelSet");
        return this.getErrorMessage();
    }

    public Object getCurrentFileAsBytes() {
        String string = this.getFullPathName();
        if (string.equals("string") || string.equals("string[]") || string.equals("JSNode")) {
            String string2 = this.getCurrentFileAsString();
            try {
                return string2.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string2;
            }
        }
        String string3 = this.modelManager.getModelSetPathName();
        if (string3 == null) {
            return "";
        }
        return this.fileManager.getFileAsBytes(string3);
    }

    public Object getFileAsBytes(String string) {
        return this.fileManager.getFileAsBytes(string);
    }

    public String getCurrentFileAsString() {
        String string = this.getFullPathName();
        if (string == "string") {
            return this.fileManager.getInlineData(-1);
        }
        if (string == "string[]") {
            int n = this.getCurrentModelIndex();
            if (n < 0) {
                return "";
            }
            return this.fileManager.getInlineData(n);
        }
        if (string == "JSNode") {
            return "<DOM NODE>";
        }
        String string2 = this.modelManager.getModelSetPathName();
        if (string2 == null) {
            return null;
        }
        return this.getFileAsString(string2, Integer.MAX_VALUE, true);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    public String getFileAsString(String string) {
        return this.getFileAsString(string, Integer.MAX_VALUE, false);
    }

    public String getFileAsString(String string, int n, boolean bl) {
        if (string == null) {
            return this.getCurrentFileAsString();
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        this.getFileAsString(stringArray, n, bl);
        return stringArray[1];
    }

    public String getFullPath(String string) {
        return this.fileManager.getFullPath(string, false);
    }

    public boolean getFileAsString(String[] stringArray, int n, boolean bl) {
        return this.fileManager.getFileDataOrErrorAsString(stringArray, n, bl);
    }

    String[] getFileInfo() {
        return this.fileManager.getFileInfo();
    }

    void setFileInfo(String[] stringArray) {
        this.fileManager.setFileInfo(stringArray);
    }

    public void autoCalculate(int n) {
        switch (n) {
            case 38797328: {
                this.modelSet.getSurfaceDistanceMax();
                break;
            }
            case 38797327: {
                this.modelSet.calculateStraightness();
            }
        }
    }

    int getSurfaceDistanceMax() {
        return this.modelSet.getSurfaceDistanceMax();
    }

    public void calculateStraightness() {
        this.modelSet.setHaveStraightness(false);
        this.modelSet.calculateStraightness();
    }

    public Point3f[] calculateSurface(BitSet bitSet, float f) {
        if (bitSet == null) {
            bitSet = this.selectionManager.bsSelection;
        }
        this.addStateScript("calculate surfaceDistance " + (f == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bitSet, null, "", false, true);
        return this.modelSet.calculateSurface(bitSet, f);
    }

    void calculateStructures(BitSet bitSet) {
        this.modelSet.calculateStructures(bitSet);
    }

    public AtomIndexIterator getWithinModelIterator(Atom atom, float f) {
        return this.modelSet.getWithinModelIterator(atom, f);
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        return this.modelSet.getWithinAtomSetIterator(n, f, bitSet, bl, bl2);
    }

    public void fillAtomData(AtomData atomData, int n) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.getFileName();
        this.modelSet.fillAtomData(atomData, n);
    }

    ModelCollection.StateScript addStateScript(String string, boolean bl, boolean bl2) {
        return this.addStateScript(string, null, null, null, null, bl, bl2);
    }

    ModelCollection.StateScript addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        return this.modelSet.addStateScript(string, bitSet, bitSet2, bitSet3, string2, bl, bl2);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    void setEchoStateActive(boolean bl) {
        this.modelSet.setEchoStateActive(bl);
    }

    public void zap(boolean bl, boolean bl2) {
        this.stopAnimationThreads();
        if (this.modelSet != null) {
            this.clearModelDependentObjects();
            this.fileManager.clear();
            this.repaintManager.clear();
            this.animationManager.clear();
            this.transformManager.clear();
            this.pickingManager.clear();
            this.selectionManager.clear();
            this.clearAllMeasurements();
            if (this.minimizer != null) {
                this.minimizer.setProperty("clear", null);
            }
            this.modelSet = this.modelManager.zap();
            if (this.haveDisplay) {
                this.mouseManager.clear();
            }
            this.stateManager.clear();
            this.global.clear();
            this.tempManager.clear();
            this.colorManager.clear();
            this.definedAtomSets.clear();
            this.dataManager.clear();
            System.gc();
        } else {
            this.modelSet = this.modelManager.zap();
        }
        this.initializeModel();
        if (bl) {
            this.setFileLoadStatus(0, null, bl2 ? "resetUndo" : null, null, null);
        }
        if (Logger.debugging) {
            Logger.checkMemory();
        }
    }

    private void zap(String string) {
        this.zap(true, false);
        this.echoMessage(string);
    }

    void echoMessage(String string) {
        int n = 26;
        this.loadShape(n);
        this.setShapeProperty(n, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(n, "target", "error");
        this.setShapeProperty(n, "text", string);
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    public boolean useMinimizationThread() {
        return this.global.useMinimizationThread && !this.autoExit;
    }

    private void initializeModel() {
        this.stopAnimationThreads();
        this.reset();
        this.selectAll();
        this.noneSelected = false;
        this.transformManager.setCenter();
        this.clearAtomSets();
        this.animationManager.initializePointers(1);
        this.setCurrentModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        if (this.haveDisplay) {
            this.mouseManager.startHoverWatcher(true);
        }
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    public String getModelSetName() {
        if (this.modelSet == null) {
            return null;
        }
        return this.modelSet.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelSet.getUnitCellInfoText();
    }

    public Hashtable getSpaceGroupInfo(String string) {
        return this.modelSet.getSpaceGroupInfo(string);
    }

    void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        this.modelSet.getPolymerPointsAndVectors(bitSet, vector);
    }

    public String getModelSetProperty(String string) {
        return this.modelSet.getModelSetProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSet.getModelSetAuxiliaryInfo(string);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelSet != null;
    }

    void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        return this.modelSet.getHybridizationAndAxes(n, vector3f, vector3f2, string, bl);
    }

    public BitSet getModelAtomBitSet(int n, boolean bl) {
        return this.modelSet.getModelAtomBitSet(n, bl);
    }

    public BitSet getModelBitSet(BitSet bitSet, boolean bl) {
        return this.modelSet.getModelBitSet(bitSet, bl);
    }

    public String getClientAtomStringProperty(Object object, String string) {
        return this.modelAdapter == null || string == null || string.length() == 0 ? null : this.modelAdapter.getClientAtomStringProperty(object, string);
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getBoundBoxCommand(boolean bl) {
        return this.modelSet.getBoundBoxCommand(bl);
    }

    void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl) {
        this.modelSet.setBoundBox(point3f, point3f2, bl);
    }

    public Point3f getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter(this.animationManager.currentModelIndex);
    }

    Point3f getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    void calcBoundBoxDimensions(BitSet bitSet) {
        this.modelSet.calcBoundBoxDimensions(bitSet);
        this.axesAreTainted = true;
    }

    BoxInfo getBoxInfo(BitSet bitSet) {
        return this.modelSet.getBoxInfo(bitSet);
    }

    float calcRotationRadius(Point3f point3f) {
        return this.modelSet.calcRotationRadius(this.animationManager.currentModelIndex, point3f);
    }

    public float calcRotationRadius(BitSet bitSet) {
        return this.modelSet.calcRotationRadius(bitSet);
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelSet.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.modelSet.getBoundBoxModels();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelSet.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelSet.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelSet.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int n) {
        if (n < 0) {
            return n;
        }
        return this.modelSet.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        if (n < 0) {
            return 0;
        }
        return this.modelSet.getModelFileNumber(n);
    }

    public String getModelNumberDotted(int n) {
        return n < 0 ? "0" : (this.modelSet == null ? null : this.modelSet.getModelNumberDotted(n));
    }

    public String getModelName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelName(n);
    }

    public Properties getModelProperties(int n) {
        return this.modelSet.getModelProperties(n);
    }

    public String getModelProperty(int n, String string) {
        return this.modelSet.getModelProperty(n, string);
    }

    public String getModelFileInfo() {
        return this.modelSet.getModelFileInfo(this.getVisibleFramesBitSet());
    }

    String getModelFileInfoAll() {
        return this.modelSet.getModelFileInfo(null);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return this.modelSet.getModelAuxiliaryInfo(n);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        return this.modelSet.getModelAuxiliaryInfo(n, string);
    }

    int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        return this.modelSet.getModelNumberIndex(n, bl, bl2);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int n) {
        return this.modelSet.modelHasVibrationVectors(n);
    }

    public int getChainCount() {
        return this.modelSet.getChainCount(true);
    }

    public int getChainCountInModel(int n) {
        return this.modelSet.getChainCountInModel(n, false);
    }

    public int getChainCountInModel(int n, boolean bl) {
        return this.modelSet.getChainCountInModel(n, bl);
    }

    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    public int getGroupCountInModel(int n) {
        return this.modelSet.getGroupCountInModel(n);
    }

    public int getPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    public int getPolymerCountInModel(int n) {
        return this.modelSet.getBioPolymerCountInModel(n);
    }

    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    public int getAtomCountInModel(int n) {
        return this.modelSet.getAtomCountInModel(n);
    }

    public int getBondCount() {
        return this.modelSet.getBondCount();
    }

    public int getBondCountInModel(int n) {
        return this.modelSet.getBondCountInModel(n);
    }

    BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.modelSet.getBondsForSelectedAtoms(bitSet, this.global.bondModeOr || BitSetUtil.cardinalityOf(bitSet) == 1);
    }

    boolean frankClicked(int n, int n2) {
        return this.frankOn && this.modelSet.frankClicked(n, n2);
    }

    public int findNearestAtomIndex(int n, int n2) {
        return this.modelSet == null || !this.getAtomPicking() ? -1 : this.modelSet.findNearestAtomIndex(n, n2);
    }

    void selectRectangle(Rectangle rectangle, int n) {
        BitSet bitSet = this.modelSet.findAtomsInRectangle(rectangle, this.getVisibleFramesBitSet());
        if (BitSetUtil.firstSetBit(bitSet) < 0) {
            return;
        }
        this.pickingManager.atomsPicked(bitSet, n);
    }

    void toCartesian(Point3f point3f) {
        int n = this.animationManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toCartesian(n, point3f);
    }

    void toUnitCell(Point3f point3f, Point3f point3f2) {
        int n = this.animationManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toUnitCell(n, point3f, point3f2);
    }

    void toFractional(Point3f point3f) {
        int n = this.animationManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toFractional(n, point3f);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection, true);
    }

    public void setBondTolerance(float f) {
        this.global.setParameterValue("bondTolerance", f);
        this.global.bondTolerance = f;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    public void setMinBondDistance(float f) {
        this.global.setParameterValue("minBondDistance", f);
        this.global.minBondDistance = f;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    int[] getAtomIndices(BitSet bitSet) {
        return this.modelSet.getAtomIndices(bitSet);
    }

    public BitSet getAtomBits(int n, Object object) {
        return this.modelSet.getAtomBits(n, object);
    }

    BitSet getSequenceBits(String string, BitSet bitSet) {
        return this.modelSet.getSequenceBits(string, bitSet);
    }

    BitSet getAtomsWithin(float f, Point3f point3f) {
        BitSet bitSet = new BitSet();
        this.modelSet.getAtomsWithin(f, point3f, bitSet, -1);
        if (f < 0.0f) {
            this.modelSet.getAtomsWithin(-f, point3f, bitSet, -1);
        }
        return bitSet;
    }

    BitSet getAtomsWithin(float f, Point4f point4f) {
        return this.modelSet.getAtomsWithin(f, point4f);
    }

    BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        return this.modelSet.getAtomsWithin(f, bitSet, bl);
    }

    BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        return this.modelSet.getAtomsConnected(f, f2, n, bitSet);
    }

    BitSet getBranchBitSet(int n, int n2) {
        return this.modelSet.getBranchBitSet(n, n2);
    }

    int getAtomIndexFromAtomNumber(int n) {
        return this.modelSet.getAtomIndexFromAtomNumber(n, this.getVisibleFramesBitSet());
    }

    public BitSet getElementsPresentBitSet(int n) {
        return this.modelSet.getElementsPresentBitSet(n);
    }

    public Hashtable getHeteroList(int n) {
        return this.modelSet.getHeteroList(n);
    }

    BitSet getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    void calcSelectedGroupsCount() {
        this.modelSet.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelSet.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelSet.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelSet.getFileHeader(this.animationManager.currentModelIndex);
    }

    Object getFileData() {
        return this.modelSet.getFileData(this.animationManager.currentModelIndex);
    }

    public Hashtable getCifData(int n) {
        String string = this.getModelFileName(n);
        String string2 = this.getFileAsString(string);
        if (string2 == null) {
            return null;
        }
        return CifDataReader.readCifData(new BufferedReader(new StringReader(string2)));
    }

    String getPDBHeader() {
        return this.modelSet.getPDBHeader(this.animationManager.currentModelIndex);
    }

    public Hashtable getModelInfo(Object object) {
        return this.modelSet.getModelInfo(this.getModelBitSet(this.getAtomBitSet(object), false));
    }

    public Hashtable getAuxiliaryInfo(Object object) {
        return this.modelSet.getAuxiliaryInfo(this.getModelBitSet(this.getAtomBitSet(object), false));
    }

    public Hashtable getShapeInfo() {
        return this.modelSet.getShapeInfo();
    }

    int getShapeIdFromObjectName(String string) {
        return this.modelSet.getShapeIdFromObjectName(string);
    }

    Vector getAllAtomInfo(Object object) {
        return this.modelSet.getAllAtomInfo(this.getAtomBitSet(object));
    }

    Vector getAllBondInfo(Object object) {
        return this.modelSet.getAllBondInfo(this.getAtomBitSet(object));
    }

    Vector getMoleculeInfo(Object object) {
        return this.modelSet.getMoleculeInfo(this.getAtomBitSet(object));
    }

    public String getChimeInfo(int n) {
        return this.modelSet.getChimeInfo(n, this.selectionManager.bsSelection);
    }

    public Hashtable getAllChainInfo(Object object) {
        return this.modelSet.getAllChainInfo(this.getAtomBitSet(object));
    }

    public Hashtable getAllPolymerInfo(Object object) {
        return this.modelSet.getAllPolymerInfo(this.getAtomBitSet(object));
    }

    public String getStateInfo() {
        return this.getStateInfo(null);
    }

    public String getStateInfo(String string) {
        StringBuffer stringBuffer;
        boolean bl = string == null || string.equalsIgnoreCase("all");
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = stringBuffer = bl ? new StringBuffer("function _setState() {\n") : null;
        if (bl) {
            stringBuffer2.append(STATE_VERSION_STAMP + Viewer.getJmolVersion() + ";\n");
        }
        if (this.isApplet && bl) {
            StateManager.appendCmd(stringBuffer2, "# fullName = " + Escape.escape(this.fullName));
            StateManager.appendCmd(stringBuffer2, "# documentBase = " + Escape.escape(this.appletDocumentBase));
            StateManager.appendCmd(stringBuffer2, "# codeBase = " + Escape.escape(this.appletCodeBase));
            stringBuffer2.append("\n");
        }
        if (bl || string.equalsIgnoreCase("windowState")) {
            stringBuffer2.append(this.global.getWindowState(stringBuffer));
        }
        if (bl) {
            stringBuffer2.append(this.getFunctionCalls(null));
        }
        if (bl || string.equalsIgnoreCase("fileState")) {
            stringBuffer2.append(this.fileManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("definedState")) {
            stringBuffer2.append(this.modelSet.getDefinedState(stringBuffer, true));
        }
        if (bl || string.equalsIgnoreCase("variableState")) {
            stringBuffer2.append(this.global.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("dataState")) {
            this.dataManager.getDataState(stringBuffer2, stringBuffer, this.modelSet.atoms, this.getAtomCount(), this.modelSet.getAtomicPropertyState(-1, null));
        }
        if (bl || string.equalsIgnoreCase("modelState")) {
            stringBuffer2.append(this.modelSet.getState(stringBuffer, true));
        }
        if (bl || string.equalsIgnoreCase("colorState")) {
            stringBuffer2.append(ColorManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("frameState")) {
            stringBuffer2.append(this.animationManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("perspectiveState")) {
            stringBuffer2.append(this.transformManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("selectionState")) {
            stringBuffer2.append(this.selectionManager.getState(stringBuffer));
        }
        if (stringBuffer != null) {
            StateManager.appendCmd(stringBuffer, "set refreshing true");
            StateManager.appendCmd(stringBuffer, "set antialiasDisplay " + this.global.antialiasDisplay);
            StateManager.appendCmd(stringBuffer, "set antialiasTranslucent " + this.global.antialiasTranslucent);
            StateManager.appendCmd(stringBuffer, "set antialiasImages " + this.global.antialiasImages);
            if (this.getSpinOn()) {
                StateManager.appendCmd(stringBuffer, "spin on");
            }
            stringBuffer.append("}\n\n_setState;\n");
        }
        if (bl) {
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    public String getStructureState() {
        return this.modelSet.getState(null, false);
    }

    String getProteinStructureState() {
        return this.modelSet.getProteinStructureState(this.selectionManager.bsSelection, false, false, false);
    }

    public String getCoordinateState(BitSet bitSet) {
        return this.modelSet.getAtomicPropertyState(2, bitSet);
    }

    void setCurrentColorRange(String string) {
        float[] fArray = this.getDataFloat(string);
        BitSet bitSet = fArray == null ? null : (BitSet)this.dataManager.getData(string)[2];
        this.setCurrentColorRange(fArray, bitSet);
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet) {
        this.colorManager.setCurrentColorRange(fArray, bitSet, this.global.propertyColorScheme);
    }

    public void setCurrentColorRange(float f, float f2) {
        this.colorManager.setCurrentColorRange(f, f2);
    }

    public float[] getCurrentColorRange() {
        return this.colorManager.getCurrentColorRange();
    }

    public void setData(String string, Object[] objectArray, int n, int n2, int n3, int n4, int n5) {
        this.dataManager.setData(this, string, objectArray, n, n2, n3, n4, n5);
    }

    Object[] getData(String string) {
        return this.dataManager.getData(string);
    }

    public float[] getDataFloat(String string) {
        return this.dataManager.getDataFloat(string);
    }

    float[][] getDataFloat2D(String string) {
        return this.dataManager.getDataFloat2D(string);
    }

    public float[][][] getDataFloat3D(String string) {
        return this.dataManager.getDataFloat3D(string);
    }

    public float getDataFloat(String string, int n) {
        return this.dataManager.getDataFloat(string, n);
    }

    public String getAltLocListInModel(int n) {
        return this.modelSet.getAltLocListInModel(n);
    }

    public BitSet setConformation() {
        return this.modelSet.setConformation(-1, this.selectionManager.bsSelection);
    }

    public BitSet setConformation(int n) {
        return this.modelSet.setConformation(this.animationManager.currentModelIndex, n);
    }

    int autoHbond(BitSet bitSet) {
        return this.autoHbond(this.selectionManager.bsSelection, this.selectionManager.bsSelection, bitSet, 0.0f, 0.0f);
    }

    int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, float f, float f2) {
        if (f < 0.0f) {
            f = this.global.hbondsDistanceMaximum;
        }
        if (f2 < 0.0f) {
            f2 = this.global.hbondsAngleMinimum;
        }
        return this.modelSet.autoHbond(bitSet, bitSet2, bitSet3, f, f2 *= (float)Math.PI / 180);
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        return this.modelSet.hasCalculatedHBonds(bitSet);
    }

    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public SymmetryInterface getCurrentUnitCell() {
        return this.modelSet.getUnitCell(this.getCurrentModelIndex());
    }

    void setCurrentUnitCellOffset(int n) {
        int n2 = this.animationManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(n2, n)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(n2) + "; set unitcell ", n);
        }
    }

    void setCurrentUnitCellOffset(Point3f point3f) {
        int n = this.animationManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(n, point3f)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(n) + "; set unitcell ", Escape.escape(point3f));
        }
    }

    public String getDefaultMeasurementLabel(int n) {
        switch (n) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    public int getMeasurementCount() {
        int n = this.getShapePropertyAsInt(5, "count");
        return n <= 0 ? 0 : n;
    }

    public String getMeasurementStringValue(int n) {
        String string = "" + this.getShapeProperty(5, "stringValue", n);
        return string;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(5, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(5, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int n) {
        int[] nArray = (int[])this.getShapeProperty(5, "countPlusIndices", n);
        return nArray;
    }

    void setPendingMeasurement(MeasurementPending measurementPending) {
        this.setShapeProperty(5, "pending", measurementPending);
    }

    MeasurementPending getPendingMeasurement() {
        return (MeasurementPending)this.getShapeProperty(5, "pending");
    }

    void clearAllMeasurements() {
        this.setShapeProperty(5, "clear", null);
    }

    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    public boolean getJustifyMeasurements() {
        return this.global.justifyMeasurements;
    }

    void setMeasurementFormats(String string) {
        this.setShapeProperty(5, "setFormats", string);
    }

    void defineMeasurement(Vector vector, float[] fArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this.setShapeProperty(5, "setConnected", bl3 ? Boolean.TRUE : Boolean.FALSE);
        this.setShapeProperty(5, "setRange", fArray);
        this.setShapeProperty(5, "setFormat", string);
        this.setShapeProperty(5, (bl ? "deleteVector" : (bl4 ? "showVector" : (bl5 ? "hideVector" : "defineVector"))) + (bl2 ? "_All" : ""), vector);
    }

    public void deleteMeasurement(int n) {
        this.setShapeProperty(5, "delete", new Integer(n));
    }

    void deleteMeasurement(int[] nArray) {
        this.setShapeProperty(5, "delete", nArray);
    }

    public void showMeasurement(int[] nArray, boolean bl) {
        this.setShapeProperty(5, bl ? "show" : "hide", nArray);
    }

    void hideMeasurements(boolean bl) {
        this.setShapeProperty(5, "hideAll", bl);
    }

    void toggleMeasurement(int[] nArray, String string) {
        this.setShapeProperty(5, string == null ? "toggle" : "toggleOn", nArray);
        if (string != null) {
            this.setShapeProperty(5, "setFormats", string);
        }
    }

    void setAnimationDirection(int n) {
        this.animationManager.setAnimationDirection(n);
    }

    void reverseAnimation() {
        this.animationManager.reverseAnimation();
    }

    int getAnimationDirection() {
        return this.animationManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.animationManager.getAnimationInfo();
    }

    public void setAnimationFps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 50) {
            n = 50;
        }
        this.global.setParameterValue("animationFps", n);
        this.animationManager.setAnimationFps(n);
    }

    public int getAnimationFps() {
        return this.animationManager.animationFps;
    }

    void setAnimationReplayMode(int n, float f, float f2) {
        this.animationManager.setAnimationReplayMode(n, f, f2);
    }

    int getAnimationReplayMode() {
        return this.animationManager.animationReplayMode;
    }

    void setAnimationOn(boolean bl) {
        boolean bl2 = this.animationManager.animationOn;
        if (bl == bl2) {
            return;
        }
        this.animationManager.setAnimationOn(bl);
    }

    void resumeAnimation() {
        if (this.animationManager.animationOn) {
            Logger.debug("animation is ON in resumeAnimation");
            return;
        }
        this.animationManager.resumeAnimation();
    }

    void pauseAnimation() {
        if (!this.animationManager.animationOn || this.animationManager.animationPaused) {
            return;
        }
        this.animationManager.pauseAnimation();
    }

    void setAnimationRange(int n, int n2) {
        this.animationManager.setAnimationRange(n, n2);
    }

    public BitSet getVisibleFramesBitSet() {
        BitSet bitSet = BitSetUtil.copy(this.animationManager.getVisibleFramesBitSet());
        this.modelSet.selectDisplayedTrajectories(bitSet);
        return bitSet;
    }

    boolean isAnimationOn() {
        return this.animationManager.animationOn;
    }

    void setAnimationNext() {
        this.animationManager.setAnimationNext();
    }

    void setAnimationPrevious() {
        this.animationManager.setAnimationPrevious();
    }

    void setAnimationLast() {
        this.animationManager.setAnimationLast();
    }

    void rewindAnimation() {
        this.animationManager.rewindAnimation();
    }

    void setCurrentModelIndex(int n) {
        if (n == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            this.setCurrentModelIndex(this.animationManager.currentModelIndex, true);
            return;
        }
        this.animationManager.setCurrentModelIndex(n);
    }

    void setTrajectory(int n) {
        this.modelSet.setTrajectory(n);
    }

    public void setTrajectory(BitSet bitSet) {
        this.modelSet.setTrajectory(bitSet);
    }

    boolean isTrajectory(int n) {
        return this.modelSet.isTrajectory(n);
    }

    public BitSet getBitSetTrajectories() {
        return this.modelSet.getBitSetTrajectories();
    }

    String getTrajectoryInfo() {
        return this.modelSet.getTrajectoryInfo();
    }

    void setFrameOffset(int n) {
        this.transformManager.setFrameOffset(n);
    }

    public void setFrameOffsets(BitSet bitSet) {
        this.bsFrameOffsets = bitSet;
        this.frameOffsets = this.modelSet.getFrameOffsets(this.bsFrameOffsets);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public BitSet getFrameOffsets() {
        return this.bsFrameOffsets;
    }

    public void setCurrentModelIndex(int n, boolean bl) {
        this.animationManager.setCurrentModelIndex(n, bl);
    }

    public int getCurrentModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    public int getDisplayModelIndex() {
        return this.getCurrentModelIndex();
    }

    boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(0) > 1000000;
    }

    void setBackgroundModelIndex(int n) {
        this.animationManager.setBackgroundModelIndex(n);
        this.global.setParameterValue("backgroundModel", this.modelSet.getModelNumberDotted(n));
    }

    public int getBackgroundModelIndex() {
        return this.animationManager.backgroundModelIndex;
    }

    void setFrameVariables(int n, int n2) {
        this.global.setParameterValue("_firstFrame", this.getModelNumberDotted(n));
        this.global.setParameterValue("_lastFrame", this.getModelNumberDotted(n2));
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean bl) {
        if (this.wasInMotion ^ bl) {
            this.animationManager.setInMotion(bl);
            if (bl) {
                ++this.motionEventNumber;
            } else {
                this.repaintManager.refresh();
            }
            this.wasInMotion = bl;
        }
    }

    public boolean getInMotion() {
        return this.animationManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.pushHoldRepaint(null);
    }

    void pushHoldRepaint(String string) {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    void popHoldRepaint(String string) {
        this.repaintManager.popHoldRepaint();
    }

    void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    boolean getRefreshing() {
        return this.refreshing;
    }

    public void refresh(int n, String string) {
        if (this.repaintManager == null || !this.refreshing) {
            return;
        }
        if (n > 0) {
            this.repaintManager.refresh();
        }
        if (n % 3 != 0 && this.statusManager.doSync()) {
            this.statusManager.setSync(n == 2 ? string : null);
        }
    }

    void requestRepaintAndWait() {
        if (!this.haveDisplay) {
            return;
        }
        this.repaintManager.requestRepaintAndWait();
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    void setSync() {
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    public void viewerNotifyRepaintDone() {
        this.repaintManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean bl = this.axesAreTainted;
        this.axesAreTainted = false;
        return bl;
    }

    private void setMaximumSize(int n) {
        this.maximumSize = Math.max(n, 100);
    }

    public void setScreenDimension(Dimension dimension) {
        dimension.height = Math.min(dimension.height, this.maximumSize);
        dimension.width = Math.min(dimension.width, this.maximumSize);
        int n = dimension.height;
        int n2 = dimension.width;
        if (this.transformManager.stereoMode == 1) {
            n2 = (n2 + 1) / 2;
        }
        if (this.dimScreen.width == n2 && this.dimScreen.height == n) {
            return;
        }
        this.resizeImage(n2, n, false, false, true);
    }

    public float getImageFontScaling() {
        return this.imageFontScaling;
    }

    private void resizeImage(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl && this.creatingImage) {
            return;
        }
        if (n > 0) {
            if (bl && !bl3) {
                this.setImageFontScaling(n, n2);
            }
            this.dimScreen.width = n;
            this.dimScreen.height = n2;
        }
        this.antialiasDisplay = false;
        if (bl3) {
            this.imageFontScaling = 1.0f;
            this.antialiasDisplay = this.global.antialiasDisplay;
        } else if (bl && !bl2) {
            this.antialiasDisplay = this.global.antialiasImages;
        }
        if (this.antialiasDisplay) {
            this.imageFontScaling *= 2.0f;
        }
        if (n > 0 && !bl) {
            this.global.setParameterValue("_width", n);
            this.global.setParameterValue("_height", n2);
            this.setStatusResized(n, n2);
        }
        if (n <= 0) {
            n = this.dimScreen.width;
            n2 = this.dimScreen.height;
        }
        this.transformManager.setScreenParameters(n, n2, bl || bl3 ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
        this.g3d.setWindowParameters(n, n2, this.antialiasDisplay);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.global.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    public String generateOutput(String string, String string2, int n, int n2) {
        if (this.isDataOnly) {
            return "";
        }
        this.mustRender = true;
        this.saveState("_Export");
        int n3 = this.dimScreen.width;
        int n4 = this.dimScreen.height;
        this.resizeImage(n, n2, true, true, false);
        this.setModelVisibility();
        String string3 = this.repaintManager.generateOutput(string, this.g3d, this.modelSet, string2);
        this.resizeImage(n3, n4, true, true, true);
        return string3;
    }

    public void renderScreenImage(Graphics graphics, Graphics graphics2, Dimension dimension, Rectangle rectangle) {
        if (this.creatingImage) {
            return;
        }
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (dimension != null) {
            this.setScreenDimension(dimension);
        }
        if (graphics2 == null) {
            Image image = this.getScreenImage();
            if (this.transformManager.stereoMode == 1) {
                this.render1(graphics, image, this.dimScreen.width, 0);
                image = this.getImage(false);
            }
            this.render1(graphics, image, 0, 0);
        } else {
            this.render1(graphics2, this.getImage(true), 0, 0);
            this.render1(graphics, this.getImage(false), 0, 0);
        }
        this.viewerNotifyRepaintDone();
    }

    public void renderScreenImage(Graphics graphics, Dimension dimension, Rectangle rectangle) {
        this.renderScreenImage(graphics, null, dimension, rectangle);
    }

    private Image getImage(boolean bl) {
        Image image = null;
        try {
            this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(bl));
            this.render();
            this.g3d.endRendering();
            image = this.g3d.getScreenImage();
        }
        catch (Error error) {
            this.handleError(error, false);
            this.setErrorMessage("Error during rendering: " + error);
        }
        return image;
    }

    private void render() {
        boolean bl = this.antialiasDisplay && this.global.antialiasTranslucent;
        this.repaintManager.render(this.g3d, this.modelSet);
        if (this.g3d.setPass2(bl)) {
            this.transformManager.setAntialias(bl);
            this.repaintManager.render(this.g3d, this.modelSet);
            this.transformManager.setAntialias(this.antialiasDisplay);
        }
    }

    private Image getStereoImage(int n) {
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(true));
        this.render();
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(false));
        this.render();
        this.g3d.endRendering();
        switch (n) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics graphics, Image image, int n, int n2) {
        if (graphics != null && image != null) {
            try {
                graphics.drawImage(image, n, n2, null);
            }
            catch (NullPointerException nullPointerException) {
                Logger.error("Sun!! ... fix graphics your bugs!");
            }
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        return this.transformManager.stereoMode <= 1 ? this.getImage(this.transformManager.stereoMode == 1) : this.getStereoImage(this.transformManager.stereoMode);
    }

    public Object getImageAs(String string, int n, int n2, int n3, String string2, OutputStream outputStream) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        this.mustRender = true;
        this.resizeImage(n2, n3, true, false, false);
        this.setModelVisibility();
        this.creatingImage = true;
        JmolImageCreatorInterface jmolImageCreatorInterface = null;
        Object object = null;
        string = string.toLowerCase();
        if (!Parser.isOneOf(string, "jpg;jpeg;jpg64;jpeg64")) {
            try {
                jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (jmolImageCreatorInterface == null) {
            Image image = this.getScreenImage();
            if (image != null) {
                try {
                    if (n < 0) {
                        n = 75;
                    }
                    object = JpegEncoder.getBytes(image, n, "");
                    this.releaseScreenImage();
                    if (string.equals("jpg64") || string.equals("jpeg64")) {
                        object = object == null ? "" : Base64.getBase64((byte[])object).toString();
                    }
                }
                catch (Error error) {
                    this.releaseScreenImage();
                    this.handleError(error, false);
                    this.setErrorMessage("Error creating image: " + error);
                    object = this.getErrorMessage();
                }
            }
        } else {
            jmolImageCreatorInterface.setViewer(this);
            try {
                object = jmolImageCreatorInterface.getImageBytes(string, n, string2, null, outputStream);
            }
            catch (IOException iOException) {
                object = iOException;
                this.setErrorMessage("Error creating image: " + iOException);
            }
            catch (Error error) {
                this.handleError(error, false);
                this.setErrorMessage("Error creating image: " + error);
                object = this.getErrorMessage();
            }
        }
        this.creatingImage = false;
        this.resizeImage(n4, n5, true, false, true);
        return object;
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    boolean getAllowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts;
    }

    public String evalFile(String string) {
        int n = string.indexOf(" -noqueue");
        if (n >= 0) {
            return (String)this.evalStringWaitStatus("String", string.substring(0, n), "", true, false, false);
        }
        return this.scriptManager.addScript(string, true, false);
    }

    public String script(String string) {
        return this.evalString(string);
    }

    String getInterruptScript() {
        String string = this.interruptScript;
        this.interruptScript = "";
        if (Logger.debugging && string != "") {
            Logger.debug("interrupt: " + string);
        }
        return string;
    }

    public String evalString(String string) {
        return this.evalStringQuiet(string, false, true);
    }

    public String evalStringQuiet(String string) {
        return this.evalStringQuiet(string, true, true);
    }

    String evalStringQuiet(String string, boolean bl, boolean bl2) {
        String string2;
        boolean bl3;
        if (bl2 && this.statusManager.syncingScripts && string.indexOf("#NOSYNC;") < 0) {
            this.syncScript(string + " #NOSYNC;", null);
        }
        if (this.eval.isExecutionPaused() && string.charAt(0) != '!') {
            string = '!' + TextFormat.trim(string, "\n\r\t ");
        }
        boolean bl4 = bl3 = string.length() > 0 && string.charAt(0) == '!';
        if (bl3) {
            string = string.substring(1);
        }
        if ((string2 = this.checkScriptExecution(string)) != null) {
            return string2;
        }
        if (this.isScriptExecuting() && (bl3 || this.eval.isExecutionPaused())) {
            this.interruptScript = string;
            if (string.indexOf("moveto ") == 0) {
                this.scriptManager.flushQueue("moveto ");
            }
            return "!" + string;
        }
        this.interruptScript = "";
        if (bl) {
            string = string + "\u0000## EDITOR_IGNORE ##";
        }
        return this.scriptManager.addScript(string, false, bl && !this.getMessageStyleChime());
    }

    private String checkScriptExecution(String string) {
        String string2 = string;
        if (string2.indexOf("\u0000##") >= 0) {
            string2 = string2.substring(0, string2.indexOf("\u0000##"));
        }
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkStepping(string2)) {
            return "script processing stepped";
        }
        if (this.checkHalt(string2)) {
            return "script execution halted";
        }
        return null;
    }

    boolean usingScriptQueue() {
        return this.scriptManager.useQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    public boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.scriptStatus("", "execution resumed", 0, null);
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkStepping(String string) {
        if (string.equalsIgnoreCase("step")) {
            this.stepScriptExecution();
            return true;
        }
        if (string.equalsIgnoreCase("?")) {
            this.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    public boolean checkHalt(String string) {
        if (string.equalsIgnoreCase("pause")) {
            this.pauseScriptExecution();
            if (this.scriptEditorVisible) {
                this.scriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        if ((string = string.toLowerCase()).startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            if (this.isCmdLine_c_or_C_Option) {
                Logger.info("exit -- stops script checking");
            }
            this.isCmdLine_c_or_C_Option = false;
            return string.equals("exit");
        }
        if (string.startsWith("quit")) {
            this.haltScriptExecution();
            if (this.isCmdLine_c_or_C_Option) {
                Logger.info("quit -- stops script checking");
            }
            this.isCmdLine_c_or_C_Option = false;
            return string.equals("quit");
        }
        return false;
    }

    public String scriptWait(String string) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        String string2 = (String)this.evalStringWaitStatus("JSON", string, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false, false);
        GT.setDoTranslate(bl);
        return string2;
    }

    public Object scriptWaitStatus(String string, String string2) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        Object object = this.evalStringWaitStatus("object", string, string2, false, false, false);
        GT.setDoTranslate(bl);
        return object;
    }

    public Object evalStringWaitStatus(String string, String string2, String string3) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(string, string2, string3, false, false, false);
    }

    synchronized Object evalStringWaitStatus(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (string2 == null) {
            return null;
        }
        String string4 = this.checkScriptExecution(string2);
        if (string4 != null) {
            return string4;
        }
        String string5 = this.statusManager.getStatusList();
        this.getProperty("String", "jmolStatus", string3);
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl5 = bl4 = string2.indexOf(")") == 0;
        if (bl4) {
            string2 = string2.substring(1);
        }
        bl4 = bl4 || !bl3;
        this.setErrorMessage(null);
        boolean bl6 = bl ? this.eval.compileScriptFile(string2, bl2) : this.eval.compileScriptString(string2, bl2);
        String string6 = this.eval.getErrorMessage();
        String string7 = this.eval.getErrorMessageUntranslated();
        this.setErrorMessage(string6, string7);
        if (bl6) {
            this.isScriptQueued = bl3;
            if (!bl2) {
                this.scriptStatus(null, string2, -2 - ++this.scriptIndex, null);
            }
            this.eval.evaluateCompiledScript(this.isCmdLine_c_or_C_Option, this.isCmdLine_C_Option, bl4, this.listCommands);
            string6 = this.eval.getErrorMessage();
            string7 = this.eval.getErrorMessageUntranslated();
            this.setErrorMessage(string6, string7);
            if (!bl2) {
                this.scriptStatus("Jmol script terminated", string6, 1 + this.eval.getExecutionWalltime(), string7);
            }
        } else {
            this.scriptStatus(string6);
            this.scriptStatus("Jmol script terminated", string6, 1, string7);
        }
        if (string6 != null && this.autoExit) {
            this.exitJmol();
        }
        if (this.isCmdLine_c_or_C_Option) {
            if (string6 == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + string7);
            }
        }
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (string.equalsIgnoreCase("String")) {
            return string7;
        }
        Object object = this.getProperty(string, "jmolStatus", string3);
        this.getProperty("object", "jmolStatus", string5);
        return object;
    }

    void exitJmol() {
        Logger.debug("exitJmol -- exiting");
        System.out.flush();
        System.exit(0);
    }

    private Object scriptCheck(String string, boolean bl) {
        if (string.indexOf(")") == 0 || string.indexOf("!") == 0) {
            string = string.substring(1);
        }
        ScriptContext scriptContext = new ScriptEvaluator(this).checkScriptSilent(string);
        if (bl || scriptContext.errorMessage == null) {
            return scriptContext;
        }
        return scriptContext.errorMessage;
    }

    public synchronized Object scriptCheck(String string) {
        return this.scriptCheck(string, false);
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void stepScriptExecution() {
        this.eval.stepPausedExecution();
    }

    public void pauseScriptExecution() {
        this.eval.pauseExecution();
    }

    String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    String getLoadFormat() {
        return this.global.loadFormat;
    }

    public String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    public int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    public float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    public boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    public boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    public boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    public void setMarBond(short s) {
        this.global.bondRadiusMilliAngstroms = s;
        this.global.setParameterValue("bondRadiusMilliAngstroms", s);
        this.setShapeSize(1, s * 2, Float.NaN, BitSetUtil.setAll(this.getAtomCount()));
    }

    void hoverOn(int n, int n2) {
        Atom atom;
        if (this.eval != null && this.isScriptExecuting() || n == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        if (!this.isInSelectionSubset(n)) {
            return;
        }
        this.loadShape(30);
        if (n2 == 1 && this.getPickingMode() == 2 && (atom = this.modelSet.getAtomAt(n)) != null && atom.isShapeVisible(JmolConstants.getShapeVisibilityFlag(4))) {
            this.setShapeProperty(30, "specialLabel", GT._("Drag to move label"));
        }
        this.setShapeProperty(30, "text", null);
        this.setShapeProperty(30, "target", new Integer(n));
        this.hoverText = null;
        this.hoverAtomIndex = n;
        this.refresh(3, "hover on atom");
    }

    int getHoverDelay() {
        return this.global.hoverDelayMs;
    }

    public void hoverOn(int n, int n2, String string) {
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(30);
        this.setShapeProperty(30, "xy", new Point3i(n, n2, 0));
        this.setShapeProperty(30, "target", null);
        this.setShapeProperty(30, "specialLabel", null);
        this.setShapeProperty(30, "text", string);
        this.hoverAtomIndex = -1;
        this.hoverText = string;
        this.refresh(3, "hover on point");
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(30, "target", null);
            this.hoverAtomIndex = -1;
        }
        if (this.hoverText != null) {
            this.setShapeProperty(30, "text", null);
            this.hoverText = null;
        }
        this.setShapeProperty(30, "specialLabel", null);
        this.refresh(3, "hover off");
    }

    void setLabel(String string) {
        this.modelSet.setLabel(string, this.selectionManager.bsSelection);
    }

    void togglePickingLabel(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.selectionManager.bsSelection;
        }
        this.loadShape(4);
        this.modelSet.setShapeProperty(4, "toggleLabel", null, bitSet);
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    public void clearShapes() {
        this.repaintManager.clear();
    }

    public void loadShape(int n) {
        this.modelSet.loadShape(n);
    }

    void setShapeSize(int n, int n2, float f) {
        this.setShapeSize(n, n2, f, this.selectionManager.bsSelection);
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        this.setShapeSize(n, n2, Float.NaN, bitSet);
    }

    public void setShapeSize(int n, int n2, float f, BitSet bitSet) {
        this.modelSet.setShapeSize(n, n2, f, bitSet);
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (n < 0) {
            return;
        }
        this.modelSet.setShapeProperty(n, string, object, this.selectionManager.bsSelection);
    }

    void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (n < 0) {
            return;
        }
        this.modelSet.setShapeProperty(n, string, object, bitSet);
    }

    void setShapePropertyArgb(int n, String string, int n2) {
        this.setShapeProperty(n, string, n2 == 0 ? null : new Integer(n2 | 0xFF000000));
    }

    public Object getShapeProperty(int n, String string) {
        return this.modelSet.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    public boolean getShapeProperty(int n, String string, Object[] objectArray) {
        return this.modelSet.getShapeProperty(n, string, objectArray);
    }

    Object getShapeProperty(int n, String string, int n2) {
        return this.modelSet.getShapeProperty(n, string, n2);
    }

    int getShapePropertyAsInt(int n, String string) {
        Object object = this.getShapeProperty(n, string);
        return object == null || !(object instanceof Integer) ? Integer.MIN_VALUE : (Integer)object;
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    boolean getRasmolHydrogenSetting() {
        return this.global.rasmolHydrogenSetting;
    }

    boolean getRasmolHeteroSetting() {
        return this.global.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.global.debugScript;
    }

    public void setDebugScript(boolean bl) {
        this.global.debugScript = bl;
        this.global.setParameterValue("debugScript", bl);
        this.eval.setDebugging();
    }

    void atomPicked(int n, Point3fi point3fi, int n2, boolean bl) {
        this.pickingManager.atomPicked(n, point3fi, n2, bl);
    }

    void clearClickCount() {
        this.setTainted(true);
    }

    public void setCursor(int n) {
        int n2;
        if (this.currentCursor == n || this.display == null) {
            return;
        }
        this.currentCursor = n;
        switch (this.currentCursor) {
            case 1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                this.display.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.display.setCursor(Cursor.getPredefinedCursor(n2));
    }

    private void setPickingMode(String string) {
        int n = JmolConstants.getPickingMode(string);
        if (n < 0) {
            n = 1;
        }
        this.pickingManager.setPickingMode(n);
        this.global.setParameterValue("picking", JmolConstants.getPickingModeName(this.pickingManager.getPickingMode()));
    }

    public int getPickingMode() {
        return this.pickingManager.getPickingMode();
    }

    public boolean getDrawPicking() {
        return this.global.drawPicking;
    }

    public boolean getBondPicking() {
        return this.global.bondPicking;
    }

    private boolean getAtomPicking() {
        return this.global.atomPicking;
    }

    private void setPickingStyle(String string) {
        int n = JmolConstants.getPickingStyle(string);
        if (n < 0) {
            n = 0;
        }
        this.pickingManager.setPickingStyle(n);
        this.global.setParameterValue("pickingStyle", JmolConstants.getPickingStyleName(this.pickingManager.getPickingStyle()));
    }

    int getPickingStyle() {
        return this.pickingManager.getPickingStyle();
    }

    public boolean getDrawHover() {
        return this.pickingManager.getDrawHover();
    }

    public String getAtomInfo(int n) {
        return n >= 0 ? this.modelSet.getAtomInfo(n, null) : (String)this.modelSet.getShapeProperty(5, "pointInfo", -n);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.modelSet.getAtomInfoXYZ(n, bl);
    }

    public void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.statusManager.setJmolCallbackListener(jmolCallbackListener);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener, null);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.getMessageQueue();
    }

    Object getStatusChanged(String string) {
        return this.statusManager.getStatusChanged(string);
    }

    void popupMenu(int n, int n2) {
        if (this.isPreviewOnly || this.global.disablePopupMenu) {
            return;
        }
        if (this.jmolpopup == null) {
            this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this, (boolean)true, (String)this.menuStructure, (boolean)true);
        }
        this.jmolpopup.show(n, n2);
    }

    String getMenu(String string) {
        if (this.jmolpopup == null) {
            this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this, (boolean)true, (String)this.menuStructure, (boolean)true);
        }
        return this.jmolpopup == null ? "" : this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|_GET_MENU|" + string);
    }

    void setMenu(String string, boolean bl) {
        if (bl) {
            Logger.info("Setting menu " + (string.length() == 0 ? "to Jmol defaults" : "from file " + string));
        }
        if (string.length() == 0) {
            string = null;
        } else if (bl) {
            string = this.getFileAsString(string);
        }
        this.getProperty("DATA_API", "setMenu", string);
        this.statusManager.setCallbackFunction("menu", string);
    }

    void setStatusFrameChanged(int n) {
        String string;
        int n2;
        int n3 = this.animationManager.currentModelIndex;
        if (n == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            n = n3;
        }
        this.transformManager.setVibrationPeriod(Float.NaN);
        int n4 = this.animationManager.firstModelIndex;
        int n5 = this.animationManager.lastModelIndex;
        if (n4 == n5) {
            n3 = n4;
        }
        int n6 = n2 = this.getModelFileNumber(n3);
        int n7 = n2 % 1000000;
        int n8 = this.getModelFileNumber(n4);
        int n9 = this.getModelFileNumber(n5);
        if (n6 == 0) {
            string = this.getModelNumberDotted(n4);
            if (n4 != n5) {
                string = string + " - " + this.getModelNumberDotted(n5);
            }
            if (n8 / 1000000 == n9 / 1000000) {
                n6 = n8;
            }
        } else {
            string = this.getModelNumberDotted(n3);
        }
        if (n6 != 0) {
            n6 = n6 < 1000000 ? 1 : n6 / 1000000;
        }
        this.global.setParameterValue("_currentFileNumber", n6);
        this.global.setParameterValue("_currentModelNumberInFile", n7);
        this.global.setParameterValue("_frameID", n2);
        this.global.setParameterValue("_modelNumber", string);
        this.global.setParameterValue("_modelName", n3 < 0 ? "" : this.getModelName(n3));
        this.global.setParameterValue("_modelTitle", n3 < 0 ? "" : this.getModelTitle(n3));
        this.global.setParameterValue("_modelFile", n3 < 0 ? "" : this.getModelFileName(n3));
        if (n3 == this.prevFrame) {
            return;
        }
        this.prevFrame = n3;
        this.statusManager.setStatusFrameChanged(n, n6, n7, this.animationManager.animationDirection < 0 ? -n8 : n8, this.animationManager.currentDirection < 0 ? -n9 : n9);
    }

    public void scriptEcho(String string) {
        this.statusManager.setScriptEcho(string, this.isScriptQueued);
        if (this.listCommands && string != null && string.indexOf("$[") == 0) {
            Logger.info(string);
        }
    }

    void notifyError(String string, String string2, String string3) {
        this.statusManager.notifyError(string, string2, string3);
    }

    String jsEval(String string) {
        return this.statusManager.jsEval(string);
    }

    public void setStatusAtomHovered(int n, String string) {
        this.global.setParameterValue("_atomhovered", n);
        this.statusManager.setStatusAtomHovered(n, string);
    }

    private void setFileLoadStatus(int n, String string, String string2, String string3, String string4) {
        this.setErrorMessage(string4);
        this.global.setParameterValue("_loadPoint", n);
        boolean bl = n == 3 || n == 0 || n == -1;
        this.statusManager.setFileLoadStatus(string, string2, string3, string4, n, bl);
    }

    public void setStatusMeasuring(String string, int n, String string2) {
        this.statusManager.setStatusMeasuring(string, n, string2);
    }

    public void notifyMinimizationStatus() {
        Object object = this.getParameter("_minimizationStep");
        this.statusManager.notifyMinimizationStatus((String)this.getParameter("_minimizationStatus"), object instanceof String ? new Integer(0) : (Integer)object, (Float)this.getParameter("_minimizationEnergy"), (Float)this.getParameter("_minimizationEnergyDiff"));
    }

    public void setStatusAtomPicked(int n, String string) {
        if (string == null) {
            string = this.global.pickLabel;
            string = string.length() == 0 ? this.getAtomInfoXYZ(n, this.getMessageStyleChime()) : this.modelSet.getAtomInfo(n, string);
        }
        this.global.setParameterValue("_atompicked", n);
        this.global.setParameterValue("_pickinfo", string);
        this.statusManager.setStatusAtomPicked(n, string);
    }

    public void setStatusResized(int n, int n2) {
        this.statusManager.setStatusResized(n, n2);
    }

    void scriptStatus(String string) {
        this.scriptStatus(string, "", 0, null);
    }

    void scriptStatus(String string, String string2) {
        this.scriptStatus(string, string2, 0, null);
    }

    void scriptStatus(String string, String string2, int n, String string3) {
        this.statusManager.setScriptStatus(string, string2, n, string3);
    }

    private String getModelTitle(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(n);
    }

    private String getModelFileName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelFileName(n);
    }

    public String dialogAsk(String string, String string2) {
        return this.statusManager.dialogAsk(string, string2);
    }

    int getScriptDelay() {
        return this.global.scriptDelay;
    }

    public void showUrl(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(":") < 0) {
            String string2 = this.fileManager.getAppletDocumentBase();
            if (string2 == "") {
                string2 = this.fileManager.getFullPathName();
            }
            if (string2.indexOf("/") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            } else if (string2.indexOf("\\") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("\\") + 1);
            }
            string = string2 + string;
        }
        Logger.info("showUrl:" + string);
        this.statusManager.showUrl(string);
    }

    public void setMeshCreator(Object object) {
        this.loadShape(22);
        this.setShapeProperty(22, "meshCreator", object);
    }

    void showConsole(boolean bl) {
        if (this.appConsole == null) {
            this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        }
        this.appConsole.setVisible(bl);
    }

    void clearConsole() {
        this.statusManager.clearConsole();
    }

    Object getParameterEscaped(String string) {
        return this.global.getParameterEscaped(string, 0);
    }

    public Object getParameter(String string) {
        return this.global.getParameter(string);
    }

    ScriptVariable getOrSetNewVariable(String string, boolean bl) {
        return this.global.getOrSetNewVariable(string, bl);
    }

    ScriptVariable setUserVariable(String string, ScriptVariable scriptVariable) {
        return this.global.setUserVariable(string, scriptVariable);
    }

    void unsetProperty(String string) {
        this.global.unsetUserVariable(string);
    }

    String getVariableList() {
        return this.global.getVariableList();
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, true);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        if (this.global.htPropertyFlags.containsKey(string = string.toLowerCase())) {
            return (Boolean)this.global.htPropertyFlags.get(string);
        }
        if (string.equalsIgnoreCase("executionPaused")) {
            return this.eval.isExecutionPaused();
        }
        if (string.equalsIgnoreCase("executionStepping")) {
            return this.eval.isExecutionStepping();
        }
        if (string.equalsIgnoreCase("haveBFactors")) {
            return this.modelSet.getBFactors() != null;
        }
        if (string.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (string.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (string.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (this.global.htUserVariables.containsKey(string)) {
            ScriptVariable scriptVariable = this.global.getUserVariable(string);
            if (scriptVariable.tok == 0x10000D) {
                return true;
            }
            if (scriptVariable.tok == 0x10000C) {
                return false;
            }
        }
        if (bl) {
            Logger.error("viewer.getBooleanProperty(" + string + ") - unrecognized");
        }
        return false;
    }

    public void setStringProperty(String string, String string2) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, string2);
            return;
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("atomTypes")) {
            this.global.atomTypes = string2;
        } else if (!string.equalsIgnoreCase("currentLocalPath")) {
            if (string.equalsIgnoreCase("pickLabel")) {
                this.global.pickLabel = string2;
            } else if (string.equalsIgnoreCase("quaternionFrame")) {
                this.global.quaternionFrame = string2.length() == 2 && string2.startsWith("R") ? string2.substring(0, 2) : "" + (string2.toLowerCase() + "p").charAt(0);
                if (!Parser.isOneOf(this.global.quaternionFrame, "a;n;c;p;q;RC;RP")) {
                    this.global.quaternionFrame = "p";
                }
                this.modelSet.setHaveStraightness(false);
            } else {
                if (string.equalsIgnoreCase("defaultVDW")) {
                    this.setDefaultVdw(string2);
                    return;
                }
                if (string.equalsIgnoreCase("language")) {
                    this.setLanguage(string2);
                    string2 = GT.getLanguage();
                } else if (string.equalsIgnoreCase("loadFormat")) {
                    this.global.loadFormat = string2;
                } else {
                    if (string.equalsIgnoreCase("backgroundColor")) {
                        this.setObjectColor("background", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("axesColor")) {
                        this.setObjectColor("axis1", string2);
                        this.setObjectColor("axis2", string2);
                        this.setObjectColor("axis3", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("axis1Color")) {
                        this.setObjectColor("axis1", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("axis2Color")) {
                        this.setObjectColor("axis2", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("axis3Color")) {
                        this.setObjectColor("axis3", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("boundBoxColor")) {
                        this.setObjectColor("boundbox", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("unitCellColor")) {
                        this.setObjectColor("unitcell", string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("propertyColorScheme")) {
                        this.setPropertyColorScheme(string2, false);
                        return;
                    }
                    if (string.equalsIgnoreCase("propertyColorSchemeOverload")) {
                        this.setPropertyColorScheme(string2, true);
                        return;
                    }
                    if (string.equalsIgnoreCase("hoverLabel")) {
                        this.setShapeProperty(30, "atomLabel", string2);
                    } else if (string.equalsIgnoreCase("defaultDistanceLabel")) {
                        this.global.defaultDistanceLabel = string2;
                    } else if (string.equalsIgnoreCase("defaultAngleLabel")) {
                        this.global.defaultAngleLabel = string2;
                    } else if (string.equalsIgnoreCase("defaultTorsionLabel")) {
                        this.global.defaultTorsionLabel = string2;
                    } else if (string.equalsIgnoreCase("defaultLoadScript")) {
                        this.global.defaultLoadScript = string2;
                    } else if (string.equalsIgnoreCase("appletProxy")) {
                        this.fileManager.setAppletProxy(string2);
                    } else if (string.equalsIgnoreCase("defaultDirectory")) {
                        if (string2 == null) {
                            string2 = "";
                        }
                        this.global.defaultDirectory = string2 = string2.replace('\\', '/');
                    } else if (string.equalsIgnoreCase("helpPath")) {
                        this.global.helpPath = string2;
                    } else if (string.equalsIgnoreCase("defaults")) {
                        this.setDefaults(string2);
                    } else if (string.equalsIgnoreCase("defaultColorScheme")) {
                        this.setDefaultColors(string2);
                    } else {
                        if (string.equalsIgnoreCase("picking")) {
                            this.setPickingMode(string2);
                            return;
                        }
                        if (string.equalsIgnoreCase("pickingStyle")) {
                            this.setPickingStyle(string2);
                            return;
                        }
                        if (!string.equalsIgnoreCase("dataSeparator")) {
                            if (string.toLowerCase().indexOf("callback") >= 0) {
                                this.statusManager.setCallbackFunction(string, string2.length() == 0 || string2.equalsIgnoreCase("none") ? null : string2);
                            } else {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        string = string.toLowerCase();
        boolean bl2 = this.global.htParameterValues.containsKey(string);
        if (!bl2 && bl && string.charAt(0) != '@' && (this.global.htPropertyFlags.containsKey(string) || this.global.htPropertyFlagsRemoved.containsKey(string))) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to string value: {0}", string));
            return;
        }
        if (bl2) {
            this.global.setParameterValue(string, string2);
        } else {
            this.global.setUserVariable(string, new ScriptVariable(4, string2));
        }
    }

    public String getLanguage() {
        return this.language;
    }

    private void setLanguage(String string) {
        new GT(string);
        this.language = GT.getLanguage();
        if (this.jmolpopup != null) {
            this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this, (boolean)true, (String)this.menuStructure, (boolean)true);
        }
        this.statusManager.setCallbackFunction("language", this.language);
    }

    private void setPropertyError(String string) {
        Logger.error(string);
        this.scriptEcho(string);
    }

    void removeUserVariable(String string) {
        this.global.removeUserVariable(string);
        if (string.indexOf("callback") >= 0) {
            this.statusManager.setCallbackFunction(string, null);
        }
    }

    boolean isJmolVariable(String string) {
        return this.global.isJmolVariable(string);
    }

    public void setFloatProperty(String string, float f) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, f);
            return;
        }
        this.setFloatProperty(string, f, false);
    }

    private boolean setFloatProperty(String string, float f, boolean bl) {
        boolean bl2 = false;
        if (string.equalsIgnoreCase("navX")) {
            this.setSpin("X", (int)f);
        } else if (string.equalsIgnoreCase("navY")) {
            this.setSpin("Y", (int)f);
        } else if (string.equalsIgnoreCase("navZ")) {
            this.setSpin("Z", (int)f);
        } else if (string.equalsIgnoreCase("navFPS")) {
            if (Float.isNaN(f)) {
                return true;
            }
            this.setSpin("FPS", (int)f);
        } else if (string.equalsIgnoreCase("hbondsAngleMinimum")) {
            this.global.hbondsAngleMinimum = f;
        } else if (string.equalsIgnoreCase("hbondsDistanceMaximum")) {
            this.global.hbondsDistanceMaximum = f;
        } else if (string.equalsIgnoreCase("pointGroupDistanceTolerance")) {
            this.global.pointGroupDistanceTolerance = f;
        } else if (string.equalsIgnoreCase("pointGroupLinearTolerance")) {
            this.global.pointGroupLinearTolerance = f;
        } else if (string.equalsIgnoreCase("ellipsoidAxisDiameter")) {
            if (bl) {
                f /= 1000.0f;
            }
        } else if (string.equalsIgnoreCase("spinX")) {
            this.setSpin("x", (int)f);
        } else if (string.equalsIgnoreCase("spinY")) {
            this.setSpin("y", (int)f);
        } else if (string.equalsIgnoreCase("spinZ")) {
            this.setSpin("z", (int)f);
        } else if (string.equalsIgnoreCase("spinFPS")) {
            this.setSpin("fps", (int)f);
        } else if (string.equalsIgnoreCase("defaultDrawArrowScale")) {
            this.setDefaultDrawArrowScale(f);
        } else if (string.equalsIgnoreCase("defaultTranslucent")) {
            this.global.defaultTranslucent = f;
        } else if (string.equalsIgnoreCase("axesScale")) {
            this.setAxesScale(f);
        } else if (string.equalsIgnoreCase("visualRange")) {
            this.setVisualRange(f);
        } else if (string.equalsIgnoreCase("navigationDepth")) {
            this.setNavigationDepthPercent(0.0f, f);
        } else if (string.equalsIgnoreCase("navigationSpeed")) {
            this.global.navigationSpeed = f;
        } else if (string.equalsIgnoreCase("navigationSlab")) {
            this.transformManager.setNavigationSlabOffsetPercent(f);
        } else if (string.equalsIgnoreCase("cameraDepth")) {
            this.transformManager.setCameraDepthPercent(f);
            this.refresh(1, "set cameraDepth");
        } else {
            if (string.equalsIgnoreCase("rotationRadius")) {
                this.setRotationRadius(f, true);
                return true;
            }
            if (string.equalsIgnoreCase("hoverDelay")) {
                this.global.hoverDelayMs = (int)(f * 1000.0f);
            } else if (string.equalsIgnoreCase("sheetSmoothing")) {
                this.global.sheetSmoothing = f;
            } else if (string.equalsIgnoreCase("dipoleScale")) {
                this.global.dipoleScale = f;
            } else if (string.equalsIgnoreCase("stereoDegrees")) {
                this.transformManager.setStereoDegrees(f);
            } else {
                if (string.equalsIgnoreCase("vectorScale")) {
                    this.setVectorScale(f);
                    return true;
                }
                if (string.equalsIgnoreCase("vibrationPeriod")) {
                    this.setVibrationPeriod(f);
                    return true;
                }
                if (string.equalsIgnoreCase("vibrationScale")) {
                    this.setVibrationScale(f);
                    return true;
                }
                if (string.equalsIgnoreCase("bondTolerance")) {
                    this.setBondTolerance(f);
                    return true;
                }
                if (string.equalsIgnoreCase("minBondDistance")) {
                    this.setMinBondDistance(f);
                    return true;
                }
                if (string.equalsIgnoreCase("scaleAngstromsPerInch")) {
                    this.transformManager.setScaleAngstromsPerInch(f);
                } else if (string.equalsIgnoreCase("solventProbeRadius")) {
                    this.global.solventProbeRadius = f;
                } else {
                    if (string.equalsIgnoreCase("radius")) {
                        this.setFloatProperty("solventProbeRadius", f);
                        return true;
                    }
                    if (bl) {
                        return false;
                    }
                    bl2 = true;
                }
            }
        }
        string = string.toLowerCase();
        boolean bl3 = this.global.htParameterValues.containsKey(string);
        if (!bl3 && bl2 && this.global.htPropertyFlags.containsKey(string)) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", string));
            return true;
        }
        if (bl3) {
            this.global.setParameterValue(string, f);
        } else {
            this.global.setUserVariable(string, new ScriptVariable(3, new Float(f)));
        }
        return true;
    }

    public void setIntProperty(String string, int n) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, n);
            return;
        }
        this.setIntProperty(string, n, true);
    }

    private void setIntProperty(String string, int n, boolean bl) {
        boolean bl2 = false;
        if (string.equalsIgnoreCase("helixStep")) {
            this.global.helixStep = n;
            this.modelSet.setHaveStraightness(false);
        } else if (!string.equalsIgnoreCase("propertyDataColumnCount") && !string.equalsIgnoreCase("propertyAtomNumberColumnCount")) {
            if (string.equalsIgnoreCase("dotDensity")) {
                this.global.dotDensity = n;
            } else if (string.equalsIgnoreCase("delayMaximumMs")) {
                this.global.delayMaximumMs = n;
            } else {
                if (string.equalsIgnoreCase("logLevel")) {
                    Logger.setLogLevel(n);
                    Logger.info("logging level set to " + n);
                    this.global.setParameterValue("logLevel", n);
                    this.eval.setDebugging();
                    return;
                }
                if (string.equalsIgnoreCase("axesMode")) {
                    switch (n) {
                        case 1: {
                            this.setAxesModeMolecular(true);
                            return;
                        }
                        case 0: {
                            this.setAxesModeMolecular(false);
                            return;
                        }
                        case 2: {
                            this.setAxesModeUnitCell(true);
                            return;
                        }
                    }
                    return;
                }
                if (!string.equalsIgnoreCase("propertyDataField")) {
                    if (string.equalsIgnoreCase("strandCount")) {
                        this.setStrandCount(0, n);
                        return;
                    }
                    if (string.equalsIgnoreCase("strandCountForStrands")) {
                        this.setStrandCount(12, n);
                        return;
                    }
                    if (string.equalsIgnoreCase("strandCountForMeshRibbon")) {
                        this.setStrandCount(13, n);
                        return;
                    }
                    if (string.equalsIgnoreCase("perspectiveModel")) {
                        this.setPerspectiveModel(n);
                    } else if (string.equalsIgnoreCase("showScript")) {
                        this.global.scriptDelay = n;
                    } else if (string.equalsIgnoreCase("specularPower")) {
                        Viewer.setSpecularPower(n);
                    } else if (string.equalsIgnoreCase("specularExponent")) {
                        Viewer.setSpecularExponent(n);
                    } else {
                        if (string.equalsIgnoreCase("specular")) {
                            this.setIntProperty("specularPercent", n);
                            return;
                        }
                        if (string.equalsIgnoreCase("diffuse")) {
                            this.setIntProperty("diffusePercent", n);
                            return;
                        }
                        if (string.equalsIgnoreCase("ambient")) {
                            this.setIntProperty("ambientPercent", n);
                            return;
                        }
                        if (string.equalsIgnoreCase("specularPercent")) {
                            Viewer.setSpecularPercent(n);
                        } else if (string.equalsIgnoreCase("diffusePercent")) {
                            Viewer.setDiffusePercent(n);
                        } else if (string.equalsIgnoreCase("ambientPercent")) {
                            Viewer.setAmbientPercent(n);
                        } else if (string.equalsIgnoreCase("ribbonAspectRatio")) {
                            this.global.ribbonAspectRatio = n;
                        } else if (string.equalsIgnoreCase("pickingSpinRate")) {
                            this.global.pickingSpinRate = n < 1 ? 1 : n;
                        } else if (string.equalsIgnoreCase("animationFps")) {
                            this.setAnimationFps(n);
                        } else if (string.equalsIgnoreCase("percentVdwAtom")) {
                            this.setPercentVdwAtom(n);
                        } else {
                            if (string.equalsIgnoreCase("bondRadiusMilliAngstroms")) {
                                this.setMarBond((short)n);
                                return;
                            }
                            if (string.equalsIgnoreCase("hermiteLevel")) {
                                this.global.hermiteLevel = n;
                            } else {
                                if ((n != 0 && n != 1 || !this.setBooleanProperty(string, n == 1, false)) && this.setFloatProperty(string, n, true)) {
                                    return;
                                }
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        string = string.toLowerCase();
        boolean bl3 = this.global.htParameterValues.containsKey(string);
        if (!bl3 && bl2 && this.global.htPropertyFlags.containsKey(string)) {
            this.setPropertyError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", string));
            return;
        }
        if (!bl) {
            return;
        }
        if (bl3) {
            this.global.setParameterValue(string, n);
        } else {
            this.global.setUserVariable(string, ScriptVariable.intVariable(n));
        }
    }

    int getDelayMaximum() {
        return this.global.delayMaximumMs;
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, bl);
            return;
        }
        this.setBooleanProperty(string, bl, true);
    }

    boolean setBooleanProperty(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = true;
        if (string.equalsIgnoreCase("imageState")) {
            this.global.imageState = bl;
        } else if (string.equalsIgnoreCase("useMinimizationThread")) {
            this.global.useMinimizationThread = bl;
        } else if (string.equalsIgnoreCase("autoLoadOrientation")) {
            this.global.autoLoadOrientation = bl;
        } else if (string.equalsIgnoreCase("allowKeyStrokes")) {
            if (this.global.disablePopupMenu) {
                bl = false;
            }
            this.global.allowKeyStrokes = bl;
        } else if (string.equalsIgnoreCase("showKeyStrokes")) {
            this.global.showKeyStrokes = bl;
        } else if (string.equalsIgnoreCase("fontCaching")) {
            this.global.fontCaching = bl;
        } else if (string.equalsIgnoreCase("atomPicking")) {
            this.global.atomPicking = bl;
        } else if (string.equalsIgnoreCase("bondPicking")) {
            this.global.bondPicking = bl;
        } else if (string.equalsIgnoreCase("selectAllModels")) {
            this.global.selectAllModels = bl;
        } else if (string.equalsIgnoreCase("messageStyleChime")) {
            this.global.messageStyleChime = bl;
        } else if (string.equalsIgnoreCase("pdbSequential")) {
            this.global.pdbSequential = bl;
        } else if (string.equalsIgnoreCase("pdbGetHeader")) {
            this.global.pdbGetHeader = bl;
        } else if (string.equalsIgnoreCase("fontScaling")) {
            this.global.fontScaling = bl;
        } else if (string.equalsIgnoreCase("syncMouse")) {
            this.setSyncTarget(0, bl);
        } else if (string.equalsIgnoreCase("syncScript")) {
            this.setSyncTarget(1, bl);
        } else if (string.equalsIgnoreCase("wireframeRotation")) {
            this.global.wireframeRotation = bl;
        } else if (string.equalsIgnoreCase("isosurfacePropertySmoothing")) {
            this.global.isosurfacePropertySmoothing = bl;
        } else if (string.equalsIgnoreCase("drawPicking")) {
            this.global.drawPicking = bl;
        } else if (string.equalsIgnoreCase("antialiasDisplay")) {
            this.setAntialias(0, bl);
        } else if (string.equalsIgnoreCase("antialiasTranslucent")) {
            this.setAntialias(1, bl);
        } else if (string.equalsIgnoreCase("antialiasImages")) {
            this.setAntialias(2, bl);
        } else if (string.equalsIgnoreCase("smartAromatic")) {
            this.global.smartAromatic = bl;
        } else if (string.equalsIgnoreCase("applySymmetryToBonds")) {
            this.setApplySymmetryToBonds(bl);
        } else if (string.equalsIgnoreCase("appendNew")) {
            this.setAppendNew(bl);
        } else if (string.equalsIgnoreCase("autoFPS")) {
            this.global.autoFps = bl;
        } else if (string.equalsIgnoreCase("useNumberLocalization")) {
            this.global.useNumberLocalization = bl;
            TextFormat.setUseNumberLocalization(this.global.useNumberLocalization);
        } else if (string.equalsIgnoreCase("showFrank")) {
            this.setFrankOn(bl);
        } else if (string.equalsIgnoreCase("solventProbe")) {
            this.global.solventOn = bl;
        } else if (string.equalsIgnoreCase("dynamicMeasurements")) {
            this.setDynamicMeasurements(bl);
        } else if (string.equalsIgnoreCase("allowRotateSelected")) {
            this.setAllowRotateSelected(bl);
        } else {
            if (string.equalsIgnoreCase("showScript")) {
                this.setIntProperty("showScript", bl ? 1 : 0);
                return true;
            }
            if (string.equalsIgnoreCase("allowEmbeddedScripts")) {
                this.global.allowEmbeddedScripts = bl;
            } else if (string.equalsIgnoreCase("navigationPeriodic")) {
                this.global.navigationPeriodic = bl;
            } else if (string.equalsIgnoreCase("zShade")) {
                this.transformManager.setZShadeEnabled(bl);
            } else if (string.equalsIgnoreCase("drawHover")) {
                this.pickingManager.setDrawHover(bl);
            } else if (string.equalsIgnoreCase("navigationMode")) {
                this.setNavigationMode(bl);
            } else if (string.equalsIgnoreCase("navigateSurface")) {
                this.global.navigateSurface = bl;
            } else if (string.equalsIgnoreCase("hideNavigationPoint")) {
                this.global.hideNavigationPoint = bl;
            } else if (string.equalsIgnoreCase("showNavigationPointAlways")) {
                this.global.showNavigationPointAlways = bl;
            } else if (string.equalsIgnoreCase("refreshing")) {
                this.setRefreshing(bl);
            } else if (string.equalsIgnoreCase("justifyMeasurements")) {
                this.global.justifyMeasurements = bl;
            } else if (string.equalsIgnoreCase("ssBondsBackbone")) {
                this.global.ssbondsBackbone = bl;
            } else if (string.equalsIgnoreCase("hbondsBackbone")) {
                this.global.hbondsBackbone = bl;
            } else if (string.equalsIgnoreCase("hbondsSolid")) {
                this.global.hbondsSolid = bl;
            } else if (string.equalsIgnoreCase("specular")) {
                Viewer.setSpecular(bl);
            } else if (string.equalsIgnoreCase("slabEnabled")) {
                this.transformManager.setSlabEnabled(bl);
            } else if (string.equalsIgnoreCase("zoomEnabled")) {
                this.transformManager.setZoomEnabled(bl);
            } else if (string.equalsIgnoreCase("highResolution")) {
                this.global.highResolutionFlag = bl;
            } else if (string.equalsIgnoreCase("traceAlpha")) {
                this.global.traceAlpha = bl;
            } else if (string.equalsIgnoreCase("zoomLarge")) {
                this.global.zoomLarge = bl;
                this.transformManager.scaleFitToScreen(false, bl, false, true);
            } else if (string.equalsIgnoreCase("languageTranslation")) {
                GT.setDoTranslate(bl);
            } else if (string.equalsIgnoreCase("hideNotSelected")) {
                this.selectionManager.setHideNotSelected(bl);
            } else if (string.equalsIgnoreCase("colorRasmol")) {
                this.setDefaultColors(bl ? "rasmol" : "jmol");
            } else if (string.equalsIgnoreCase("scriptQueue")) {
                this.scriptManager.setQueue(bl);
            } else if (string.equalsIgnoreCase("dotSurface")) {
                this.global.dotSurface = bl;
            } else if (string.equalsIgnoreCase("dotsSelectedOnly")) {
                this.global.dotsSelectedOnly = bl;
            } else if (string.equalsIgnoreCase("selectionHalos")) {
                this.setSelectionHalos(bl);
            } else if (string.equalsIgnoreCase("selectHydrogen")) {
                this.global.rasmolHydrogenSetting = bl;
            } else if (string.equalsIgnoreCase("selectHetero")) {
                this.global.rasmolHeteroSetting = bl;
            } else if (string.equalsIgnoreCase("showMultipleBonds")) {
                this.global.showMultipleBonds = bl;
            } else if (string.equalsIgnoreCase("showHiddenSelectionHalos")) {
                this.global.showHiddenSelectionHalos = bl;
            } else if (string.equalsIgnoreCase("windowCentered")) {
                this.transformManager.setWindowCentered(bl);
            } else if (string.equalsIgnoreCase("displayCellParameters")) {
                this.global.displayCellParameters = bl;
            } else if (string.equalsIgnoreCase("testFlag1")) {
                this.global.testFlag1 = bl;
            } else if (string.equalsIgnoreCase("testFlag2")) {
                this.global.testFlag2 = bl;
            } else if (string.equalsIgnoreCase("testFlag3")) {
                this.global.testFlag3 = bl;
            } else if (string.equalsIgnoreCase("testFlag4")) {
                this.global.testFlag4 = bl;
            } else if (string.equalsIgnoreCase("ribbonBorder")) {
                this.global.ribbonBorder = bl;
            } else if (string.equalsIgnoreCase("cartoonRockets")) {
                this.global.cartoonRockets = bl;
            } else if (string.equalsIgnoreCase("rocketBarrels")) {
                this.global.rocketBarrels = bl;
            } else if (string.equalsIgnoreCase("greyscaleRendering")) {
                this.global.greyscaleRendering = bl;
                this.g3d.setGreyscaleMode(this.global.greyscaleRendering);
            } else if (string.equalsIgnoreCase("measurementLabels")) {
                this.global.measurementLabels = bl;
            } else {
                if (string.equalsIgnoreCase("axesWindow")) {
                    this.setAxesModeMolecular(!bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesMolecular")) {
                    this.setAxesModeMolecular(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesUnitCell")) {
                    this.setAxesModeUnitCell(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesOrientationRasmol")) {
                    this.setAxesOrientationRasmol(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("debugScript")) {
                    this.setDebugScript(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("perspectiveDepth")) {
                    this.setPerspectiveDepth(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showAxes")) {
                    this.setShowAxes(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showBoundBox")) {
                    this.setShowBbcage(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showHydrogens")) {
                    this.setShowHydrogens(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showMeasurements")) {
                    this.setShowMeasurements(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showUnitcell")) {
                    this.setShowUnitCell(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("frank")) {
                    return this.setBooleanProperty("showFrank", bl, true);
                }
                if (string.equalsIgnoreCase("solvent")) {
                    return this.setBooleanProperty("solventProbe", bl, true);
                }
                if (string.equalsIgnoreCase("bonds")) {
                    return this.setBooleanProperty("showMultipleBonds", bl, true);
                }
                if (string.equalsIgnoreCase("hydrogen")) {
                    return this.setBooleanProperty("selectHydrogen", bl, true);
                }
                if (string.equalsIgnoreCase("hetero")) {
                    return this.setBooleanProperty("selectHetero", bl, true);
                }
                if (string.equalsIgnoreCase("showSelections")) {
                    return this.setBooleanProperty("selectionHalos", bl, true);
                }
                bl4 = false;
                if (string.equalsIgnoreCase("bondModeOr")) {
                    this.global.bondModeOr = bl;
                } else if (string.equalsIgnoreCase("zeroBasedXyzRasmol")) {
                    this.global.zeroBasedXyzRasmol = bl;
                    this.reset();
                } else if (string.equalsIgnoreCase("rangeSelected")) {
                    this.global.rangeSelected = bl;
                } else if (string.equalsIgnoreCase("measureAllModels")) {
                    this.global.measureAllModels = bl;
                } else if (string.equalsIgnoreCase("statusReporting")) {
                    this.statusManager.setAllowStatusReporting(bl);
                } else if (string.equalsIgnoreCase("chainCaseSensitive")) {
                    this.global.chainCaseSensitive = bl;
                } else if (string.equalsIgnoreCase("hideNameInPopup")) {
                    this.global.hideNameInPopup = bl;
                } else if (string.equalsIgnoreCase("disablePopupMenu")) {
                    this.global.disablePopupMenu = bl;
                } else if (string.equalsIgnoreCase("forceAutoBond")) {
                    this.global.forceAutoBond = bl;
                } else {
                    if (string.equalsIgnoreCase("autobond")) {
                        this.setAutoBond(bl);
                        return true;
                    }
                    bl3 = true;
                }
                if (!bl2) {
                    return !bl3;
                }
                bl3 = true;
            }
        }
        if (!bl2) {
            return !bl3;
        }
        boolean bl5 = this.global.htPropertyFlags.containsKey(string = string.toLowerCase());
        if (!bl5 && bl3 && this.global.htParameterValues.containsKey(string)) {
            this.setPropertyError(GT._("ERROR: Cannot set value of this variable to a boolean: {0}", string));
            return true;
        }
        if (bl5) {
            this.global.setParameterValue(string, bl);
        } else {
            this.global.setUserVariable(string, ScriptVariable.getBoolean(bl));
        }
        if (bl3) {
            return false;
        }
        if (bl4) {
            this.setTainted(true);
        }
        return true;
    }

    public boolean getPdbLoadInfo(int n) {
        switch (n) {
            case 1: {
                return this.global.pdbSequential;
            }
            case 2: {
                return this.global.pdbGetHeader;
            }
        }
        return false;
    }

    boolean getSelectAllModels() {
        return this.global.selectAllModels;
    }

    boolean getMessageStyleChime() {
        return this.global.messageStyleChime;
    }

    public boolean getFontCaching() {
        return this.global.fontCaching;
    }

    public boolean getFontScaling() {
        return this.global.fontScaling;
    }

    void showParameter(String string, boolean bl, int n) {
        String string2 = "" + this.global.getParameterEscaped(string, n);
        if (bl || string2.indexOf("<not defined>") < 0) {
            this.showString(string + " = " + string2, false);
        }
    }

    public void showString(String string, boolean bl) {
        if (this.isScriptQueued && (!this.isSilent || bl)) {
            Logger.warn(string);
        }
        this.scriptEcho(string);
    }

    String getAllSettings(String string) {
        return this.global.getAllSettings(string);
    }

    public boolean getDotSurfaceFlag() {
        return this.global.dotSurface;
    }

    public boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnly;
    }

    public int getDotDensity() {
        return this.global.dotDensity;
    }

    public boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    boolean getIsosurfacePropertySmoothing() {
        return this.global.isosurfacePropertySmoothing;
    }

    public boolean getWireframeRotation() {
        return this.global.wireframeRotation;
    }

    boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    void setNavigationDepthPercent(float f, float f2) {
        this.transformManager.setNavigationDepthPercent(f, f2);
        this.refresh(1, "set navigationDepth");
    }

    float getNavigationSpeed() {
        return this.global.navigationSpeed;
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.isNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion();
    }

    public void setVisualRange(float f) {
        this.transformManager.setVisualRange(f);
        this.refresh(1, "set visualRange");
    }

    float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    public boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    public boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    public boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    public boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    public void setPerspectiveDepth(boolean bl) {
        this.global.setParameterValue("perspectiveDepth", bl);
        this.transformManager.setPerspectiveDepth(bl);
    }

    public void setAxesOrientationRasmol(boolean bl) {
        this.global.setParameterValue("axesOrientationRasmol", bl);
        this.global.axesOrientationRasmol = bl;
        this.reset();
    }

    public boolean getAxesOrientationRasmol() {
        return this.global.axesOrientationRasmol;
    }

    void setAxesScale(float f) {
        this.global.axesScale = f;
        this.axesAreTainted = true;
    }

    public Point3f[] getAxisPoints() {
        return this.getObjectMad(1) == 0 || this.getAxesMode() != 2 || (Boolean)this.getShapeProperty(27, "axesTypeXY") != false ? null : (Point3f[])this.getShapeProperty(27, "axisPoints");
    }

    public float getAxesScale() {
        return this.global.axesScale;
    }

    private void setAxesModeMolecular(boolean bl) {
        this.global.axesMode = bl ? 1 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesunitcell");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesmolecular");
        this.global.setParameterValue("axesMode", this.global.axesMode);
        this.global.setParameterValue(bl ? "axesMolecular" : "axesWindow", true);
    }

    void setAxesModeUnitCell(boolean bl) {
        this.global.axesMode = bl ? 2 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesmolecular");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesunitcell");
        this.global.setParameterValue(bl ? "axesUnitcell" : "axesWindow", true);
        this.global.setParameterValue("axesMode", this.global.axesMode);
    }

    public int getAxesMode() {
        return this.global.axesMode;
    }

    public boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean bl) {
        if (this.modelSet == null || bl == this.getSelectionHaloEnabled()) {
            return;
        }
        this.global.setParameterValue("selectionHalos", bl);
        this.loadShape(8);
        this.modelSet.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelSet.getSelectionHaloEnabled();
    }

    public boolean getBondSelectionModeOr() {
        return this.global.bondModeOr;
    }

    public boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    public boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    public boolean getCartoonRocketFlag() {
        return this.global.cartoonRockets;
    }

    public boolean getRocketBarrelFlag() {
        return this.global.rocketBarrels;
    }

    private void setStrandCount(int n, int n2) {
        switch (n) {
            case 12: {
                this.global.strandCountForStrands = n2;
                break;
            }
            case 13: {
                this.global.strandCountForMeshRibbon = n2;
                break;
            }
            default: {
                this.global.strandCountForStrands = n2;
                this.global.strandCountForMeshRibbon = n2;
            }
        }
        this.global.setParameterValue("strandCount", n2);
        this.global.setParameterValue("strandCountForStrands", this.global.strandCountForStrands);
        this.global.setParameterValue("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
    }

    public int getStrandCount(int n) {
        return n == 12 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    boolean getNavigationPeriodic() {
        return this.global.navigationPeriodic;
    }

    private void stopAnimationThreads() {
        this.setVibrationOff();
        this.setSpinOn(false);
        this.setNavOn(false);
        this.setAnimationOn(false);
        this.repaintManager.cancelRendering();
    }

    private void setNavigationMode(boolean bl) {
        this.global.navigationMode = bl;
        if (bl && !this.transformManager.canNavigate()) {
            this.stopAnimationThreads();
            this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            this.transformManager.homePosition();
        }
        this.transformManager.setNavigationMode(bl);
    }

    public boolean getNavigationMode() {
        return this.global.navigationMode;
    }

    public boolean getNavigateSurface() {
        return this.global.navigateSurface;
    }

    public void setTransformManager(TransformManager transformManager) {
        this.stopAnimationThreads();
        this.transformManager = transformManager;
        transformManager.setViewer(this, this.dimScreen.width, this.dimScreen.height);
        this.setTransformManagerDefaults();
        transformManager.homePosition();
    }

    private void setPerspectiveModel(int n) {
        if (this.transformManager.perspectiveModel == n) {
            return;
        }
        this.stopAnimationThreads();
        switch (n) {
            case 10: {
                this.transformManager = new TransformManager10(this, this.dimScreen.width, this.dimScreen.height);
                break;
            }
            default: {
                this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            }
        }
        this.setTransformManagerDefaults();
        this.transformManager.homePosition();
    }

    private void setTransformManagerDefaults() {
        this.transformManager.setCameraDepthPercent(this.global.cameraDepth);
        this.transformManager.setPerspectiveDepth(this.global.perspectiveDepth);
        this.transformManager.setStereoDegrees(-5.0f);
        this.transformManager.setVisualRange(this.global.visualRange);
        this.transformManager.setSpinOn(false);
        this.transformManager.setVibrationPeriod(0.0f);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public float getCameraDepth() {
        return this.global.cameraDepth;
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    public boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    public int getHermiteLevel() {
        return this.global.hermiteLevel;
    }

    public boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    public void setAutoBond(boolean bl) {
        this.global.setParameterValue("autobond", bl);
        this.global.autoBond = bl;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        this.clearModelDependentObjects();
        this.clearAllMeasurements();
        return this.modelSet.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void rebond() {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        this.modelSet.autoBond(null, null, null, null);
        this.addStateScript("connect;", false, true);
    }

    void setPdbConectBonding(boolean bl) {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        BitSet bitSet = new BitSet();
        this.modelSet.setPdbConectBonding(0, 0, bitSet);
        if (bl) {
            this.modelSet.autoBond(null, null, bitSet, null);
            this.addStateScript("connect PDB AUTO;", false, true);
            return;
        }
        this.addStateScript("connect PDB;", false, true);
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    public boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    public void setPercentVdwAtom(int n) {
        this.global.setParameterValue("percentVdwAtom", n);
        this.global.percentVdwAtom = n;
        this.setShapeSize(0, -n, Float.NaN);
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    public short getDefaultMadAtom() {
        return (short)(this.global.percentVdwAtom == 0 ? 0 : -2000 - this.global.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    public boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    public void setShowHydrogens(boolean bl) {
        this.global.setParameterValue("showHydrogens", bl);
        this.global.showHydrogens = bl;
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public void setShowBbcage(boolean bl) {
        this.setObjectMad(28, "boundbox", (short)(bl ? -4 : 0));
        this.global.setParameterValue("showBoundBox", bl);
    }

    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean bl) {
        this.setObjectMad(29, "unitcell", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showUnitCell", bl);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    public void setShowAxes(boolean bl) {
        this.setObjectMad(27, "axes", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showAxes", bl);
    }

    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    public void setFrankOn(boolean bl) {
        if (this.isPreviewOnly) {
            bl = false;
        }
        this.frankOn = bl;
        this.setObjectMad(31, "frank", (short)(bl ? 1 : 0));
    }

    public boolean getShowFrank() {
        if (this.isPreviewOnly || this.isApplet && this.creatingImage) {
            return false;
        }
        return this.isSignedApplet || this.frankOn;
    }

    public boolean isSignedApplet() {
        return this.isSignedApplet;
    }

    public void setShowMeasurements(boolean bl) {
        this.global.setParameterValue("showMeasurements", bl);
        this.global.showMeasurements = bl;
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    public boolean getShowMeasurementLabels() {
        return this.global.measurementLabels;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    void setMeasureDistanceUnits(String string) {
        this.global.setMeasureDistanceUnits(string);
        this.setShapeProperty(5, "reformatDistances", null);
    }

    public String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    public boolean getUseNumberLocalization() {
        return this.global.useNumberLocalization;
    }

    void setAppendNew(boolean bl) {
        this.global.appendNew = bl;
    }

    public boolean getAppendNew() {
        return this.global.appendNew;
    }

    boolean getAutoFps() {
        return this.global.autoFps;
    }

    public void setRasmolDefaults() {
        this.setDefaults("RasMol");
    }

    public void setJmolDefaults() {
        this.setDefaults("Jmol");
    }

    private void setDefaults(String string) {
        if (string.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
        this.setShapeSize(0, this.getDefaultMadAtom(), Float.NaN, this.getModelAtomBitSet(-1, true));
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    private void setAntialias(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.global.antialiasDisplay = bl;
                break;
            }
            case 1: {
                this.global.antialiasTranslucent = bl;
                break;
            }
            case 2: {
                this.global.antialiasImages = bl;
                return;
            }
        }
        this.resizeImage(0, 0, false, false, true);
    }

    public Point3f[] allocTempPoints(int n) {
        return this.tempManager.allocTempPoints(n);
    }

    public void freeTempPoints(Point3f[] point3fArray) {
        this.tempManager.freeTempPoints(point3fArray);
    }

    public Point3i[] allocTempScreens(int n) {
        return this.tempManager.allocTempScreens(n);
    }

    public void freeTempScreens(Point3i[] point3iArray) {
        this.tempManager.freeTempScreens(point3iArray);
    }

    public byte[] allocTempBytes(int n) {
        return this.tempManager.allocTempBytes(n);
    }

    public void freeTempBytes(byte[] byArray) {
        this.tempManager.freeTempBytes(byArray);
    }

    Font3D getFont3D(String string, String string2, float f) {
        return this.g3d.getFont3D(string, string2, f);
    }

    public String formatText(String string) {
        int n = string.indexOf("@{");
        if (n < 0 && (n = string.indexOf("%{")) < 0) {
            return string;
        }
        String string2 = TextFormat.simpleReplace(string, "%{", "@{");
        while ((n = string2.indexOf("@{")) >= 0) {
            int n2 = ++n + 1;
            int n3 = string2.length();
            if ((n = ScriptCompiler.ichMathTerminator(string2, n, n3)) >= n3) {
                return string2;
            }
            String string3 = string2.substring(n2, n);
            if (string3.length() == 0) {
                return string2;
            }
            Object object = this.evaluateExpression(string3);
            if (object instanceof Point3f) {
                object = Escape.escape((Point3f)object);
            }
            string2 = string2.substring(0, n2 - 2) + object.toString() + string2.substring(n + 1);
        }
        return string2;
    }

    String getElementSymbol(int n) {
        return this.modelSet.getElementSymbol(n);
    }

    int getElementNumber(int n) {
        return this.modelSet.getElementNumber(n);
    }

    public String getAtomName(int n) {
        return this.modelSet.getAtomName(n);
    }

    public int getAtomNumber(int n) {
        return this.modelSet.getAtomNumber(n);
    }

    float getAtomX(int n) {
        return this.modelSet.getAtomX(n);
    }

    float getAtomY(int n) {
        return this.modelSet.getAtomY(n);
    }

    float getAtomZ(int n) {
        return this.modelSet.getAtomZ(n);
    }

    public Point3f getAtomPoint3f(int n) {
        return this.modelSet.getAtomAt(n);
    }

    public float getAtomRadius(int n) {
        return this.modelSet.getAtomRadius(n);
    }

    public float getAtomVdwRadius(int n) {
        return this.modelSet.getAtomVdwRadius(n);
    }

    public int getAtomArgb(int n) {
        return this.g3d.getColixArgb(this.modelSet.getAtomColix(n));
    }

    String getAtomChain(int n) {
        return this.modelSet.getAtomChain(n);
    }

    public int getAtomModelIndex(int n) {
        return this.modelSet.getAtomModelIndex(n);
    }

    String getAtomSequenceCode(int n) {
        return this.modelSet.getAtomSequenceCode(n);
    }

    public float getBondRadius(int n) {
        return this.modelSet.getBondRadius(n);
    }

    public short getBondOrder(int n) {
        return this.modelSet.getBondOrder(n);
    }

    void assignAromaticBonds() {
        this.modelSet.assignAromaticBonds();
    }

    public boolean getSmartAromatic() {
        return this.global.smartAromatic;
    }

    void resetAromatic() {
        this.modelSet.resetAromatic();
    }

    public int getBondArgb1(int n) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix1(n));
    }

    public int getBondModelIndex(int n) {
        return this.modelSet.getBondModelIndex(n);
    }

    public int getBondArgb2(int n) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix2(n));
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelSet.getPolymerLeadMidPoints(n, n2);
    }

    void setStereoMode(int[] nArray, int n, float f) {
        this.setFloatProperty("stereoDegrees", f);
        this.setBooleanProperty("greyscaleRendering", n > 1);
        if (nArray != null) {
            this.transformManager.setStereoMode(nArray);
        } else {
            this.transformManager.setStereoMode(n);
        }
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    public Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String string, String string2, String string3) {
        return this.getProperty(string, string2, (Object)string3);
    }

    boolean isScriptEditorVisible() {
        return this.scriptEditorVisible;
    }

    public Object getProperty(String string, String string2, Object object) {
        if ("DATA_API".equals(string)) {
            switch ("scriptCheck.........scriptContext.......scriptEditor........scriptEditorState...getAppConsole.......getScriptEditor.....setMenu.............wrappedState........spaceGroupInfo......disablePopupMenu....".indexOf(string2)) {
                case 0: {
                    return this.scriptCheck((String)object, true);
                }
                case 20: {
                    return this.eval.getScriptContext();
                }
                case 40: {
                    this.showEditor((String[])object);
                    return null;
                }
                case 60: {
                    this.scriptEditorVisible = (Boolean)object;
                    return null;
                }
                case 80: {
                    if (object instanceof JmolAppConsoleInterface) {
                        this.appConsole = (JmolAppConsoleInterface)object;
                    } else if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                        this.appConsole = (this.isApplet ? (JmolAppConsoleInterface)Interface.getOptionInterface("console.AppletConsole") : (JmolAppConsoleInterface)Interface.getApplicationInterface("jmolpanel.AppConsole")).getAppConsole(this, this.display);
                    }
                    this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                    return this.appConsole;
                }
                case 100: {
                    if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                        this.getProperty("DATA_API", "appConsole", Boolean.TRUE);
                        this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                    }
                    return this.scriptEditor;
                }
                case 120: {
                    this.menuStructure = (String)object;
                    return this.menuStructure;
                }
                case 140: {
                    if (!this.global.imageState) {
                        return "";
                    }
                    return "\n/****** Jmol Embedded Script **** \n" + this.getStateInfo() + "\n**/";
                }
                case 160: {
                    return this.getSpaceGroupInfo(null);
                }
                case 180: {
                    this.global.disablePopupMenu = true;
                    return null;
                }
            }
            System.out.println("ERROR IN getProperty DATA_API: " + string);
            return null;
        }
        return PropertyManager.getProperty(this, string, string2, object);
    }

    void showEditor(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{null, null};
        }
        if (stringArray[1] == null) {
            stringArray[1] = "<no data>";
        }
        String string = stringArray[1];
        String string2 = stringArray[0];
        JmolScriptEditorInterface jmolScriptEditorInterface = (JmolScriptEditorInterface)this.getProperty("DATA_API", "getScriptEditor", Boolean.TRUE);
        if (string2 != null) {
            jmolScriptEditorInterface.setFilename(string);
            jmolScriptEditorInterface.output(string2);
        }
        jmolScriptEditorInterface.setVisible(true);
    }

    String getModelExtract(Object object) {
        return this.fileManager.getFullPathName() + "\nJmol version " + Viewer.getJmolVersion() + "\nEXTRACT: " + object + "\n" + this.modelSet.getModelExtract(this.getAtomBitSet(object));
    }

    public String getHexColorFromIndex(short s) {
        return this.g3d.getHexColorFromIndex(s);
    }

    void setModelVisibility() {
        if (this.modelSet == null) {
            return;
        }
        this.modelSet.setModelVisibility();
    }

    void setFrameTitle(int n, String string) {
        this.modelSet.setFrameTitle(n, string);
    }

    String getFrameTitle(int n) {
        return this.modelSet.getFrameTitle(n);
    }

    void setTainted(boolean bl) {
        this.isTainted = bl && this.refreshing;
        this.axesAreTainted = bl && this.refreshing;
    }

    Point3fi checkObjectClicked(int n, int n2, int n3) {
        return this.modelSet.checkObjectClicked(n, n2, n3, this.getVisibleFramesBitSet());
    }

    boolean checkObjectHovered(int n, int n2) {
        if (this.modelSet == null) {
            return false;
        }
        return this.modelSet.checkObjectHovered(n, n2, this.getVisibleFramesBitSet());
    }

    void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (this.getPickingMode()) {
            case 2: {
                n6 = 4;
                break;
            }
            case 4: {
                n6 = 21;
            }
        }
        this.modelSet.checkObjectDragged(n, n2, n3, n4, n5, this.getVisibleFramesBitSet(), n6);
    }

    void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, BitSet bitSet) {
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        this.transformManager.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bitSet);
        this.refresh(-1, "rotateAxisAngleAtCenter");
    }

    void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, BitSet bitSet) {
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, f, f2, false, bl, bitSet);
        this.refresh(-1, "rotateAxisAboutPointsInternal");
    }

    int getPickingSpinRate() {
        return this.global.pickingSpinRate;
    }

    public void startSpinningAxis(Point3f point3f, Point3f point3f2, boolean bl) {
        if (this.getSpinOn() || this.getNavOn()) {
            this.setSpinOn(false);
            this.setNavOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, this.global.pickingSpinRate, Float.MAX_VALUE, bl, true, null);
    }

    public Vector3f getModelDipole() {
        return this.modelSet.getModelDipole(this.getCurrentModelIndex());
    }

    public Vector3f calculateMolecularDipole() {
        return this.modelSet.calculateMolecularDipole(this.getCurrentModelIndex());
    }

    public float getDipoleScale() {
        return this.global.dipoleScale;
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        this.modelSet.getAtomIdentityInfo(n, hashtable);
    }

    void setDefaultLattice(Point3f point3f) {
        this.global.setDefaultLattice(point3f);
        this.global.setParameterValue("defaultLattice", Escape.escape(point3f));
    }

    Point3f getDefaultLattice() {
        return this.global.getDefaultLattice();
    }

    BitSet getTaintedAtoms(byte by) {
        return this.modelSet.getTaintedAtoms(by);
    }

    public void setTaintedAtoms(BitSet bitSet, byte by) {
        this.modelSet.setTaintedAtoms(bitSet, by);
    }

    public String getData(String string, String string2) {
        String string3 = "";
        string3 = string2.toLowerCase().indexOf("property_") == 0 ? "{selected}.label(\"%{" + string2 + "}\")" : (string2.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.equalsIgnoreCase("MOL") ? "\"line1\nline2\nline3\n\"+(\"\"+{selected}.size)%-3+(\"\"+{selected}.bonds.size)%-3+\"  0  0  0\n\"+{selected}.labels(\"%10.4x%10.4y%10.4z %-2e  0  0  0  0  0\").lines+{selected}.bonds.labels(\"%3D1%3D2%3ORDER  0  0  0\").lines" : (string2.startsWith("USER:") ? "{selected}.label(\"" + string2.substring(5) + "\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines")));
        if (!string.equals("selected")) {
            string3 = TextFormat.simpleReplace(string3, "selected", string);
        }
        return (String)this.evaluateExpression(string3);
    }

    public synchronized Object evaluateExpression(Object object) {
        return ScriptEvaluator.evaluateExpression(this, object);
    }

    Object getHelixData(BitSet bitSet, int n) {
        return this.modelSet.getHelixData(bitSet, n);
    }

    public String getPdbData(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet();
        }
        return this.modelSet.getPdbAtomData(bitSet);
    }

    String getPdbData(int n, String string) {
        return this.modelSet.getPdbData(n, string, this.selectionManager.bsSelection, false);
    }

    public boolean isJmolDataFrame(int n) {
        return this.modelSet.isJmolDataFrame(n);
    }

    public boolean isJmolDataFrame() {
        return this.modelSet.isJmolDataFrame(this.animationManager.currentModelIndex);
    }

    int getJmolDataFrameIndex(int n, String string) {
        return this.modelSet.getJmolDataFrameIndex(n, string);
    }

    void setJmolDataFrame(String string, int n, int n2) {
        this.modelSet.setJmolDataFrame(string, n, n2);
    }

    void setFrameTitle(String string) {
        this.loadShape(26);
        this.modelSet.setFrameTitle(this.animationManager.currentModelIndex, string);
    }

    public String getFrameTitle() {
        return this.modelSet.getFrameTitle(this.animationManager.currentModelIndex);
    }

    String getJmolFrameType(int n) {
        return this.modelSet.getJmolFrameType(n);
    }

    public int getJmolDataSourceFrame(int n) {
        return this.modelSet.getJmolDataSourceFrame(n);
    }

    void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        this.modelSet.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 38797330: 
            case 38797331: 
            case 38797332: 
            case 38797571: 
            case 38797572: 
            case 38797573: 
            case 38797574: 
            case 38797575: 
            case 38797576: {
                this.refreshMeasures();
            }
        }
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoord(n, f, f2, f3);
    }

    void setAtomCoord(BitSet bitSet, int n, Object object) {
        this.modelSet.setAtomCoord(bitSet, n, object);
        this.refreshMeasures();
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoordRelative(n, f, f2, f3);
    }

    void setAtomCoordRelative(Point3f point3f) {
        this.modelSet.setAtomCoordRelative(point3f, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    void setAllowRotateSelected(boolean bl) {
        this.global.allowRotateSelected = bl;
    }

    boolean allowRotateSelected() {
        return this.global.allowRotateSelected;
    }

    void invertSelected(Point3f point3f, BitSet bitSet) {
        this.modelSet.invertSelected(point3f, null, bitSet);
        this.refreshMeasures();
    }

    void invertSelected(Point3f point3f, Point4f point4f) {
        this.modelSet.invertSelected(point3f, point4f, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    synchronized void moveSelected(int n, int n2, int n3, int n4, boolean bl) {
        if (this.isJmolDataFrame()) {
            return;
        }
        BitSet bitSet = this.selectionManager.bsSelection;
        if (n == Integer.MIN_VALUE) {
            this.setSelectionHalos(true);
            this.refresh(3, "moveSelected");
            return;
        }
        if (n == Integer.MAX_VALUE) {
            this.setSelectionHalos(false);
            this.refresh(3, "moveSelected");
            return;
        }
        if (bl) {
            Point3f point3f = this.getAtomSetCenter(bitSet);
            Point3i point3i = this.transformPoint(point3f);
            Point3f point3f2 = new Point3f(point3i.x + n, point3i.y + n2, point3i.z);
            this.unTransformPoint(point3f2, point3f2);
            point3f2.sub(point3f);
            this.modelSet.setAtomCoordRelative(point3f2, bitSet);
        } else {
            this.transformManager.setRotateMolecule(true);
            this.transformManager.rotateXYBy(n, n2, bitSet);
            this.transformManager.setRotateMolecule(false);
        }
        this.refreshMeasures();
    }

    void rotateAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, boolean bl, Point3f point3f, boolean bl2, BitSet bitSet) {
        this.modelSet.rotateAtoms(matrix3f, matrix3f2, bitSet, bl, point3f, bl2);
        this.refreshMeasures();
    }

    public void refreshMeasures() {
        this.setShapeProperty(5, "refresh", null);
    }

    void setDynamicMeasurements(boolean bl) {
        this.global.dynamicMeasurements = bl;
    }

    public boolean getDynamicMeasurements() {
        return this.global.dynamicMeasurements;
    }

    public float[][] functionXY(String string, int n, int n2) {
        float[][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data2d_") != 0) {
            return this.statusManager.functionXY(string, n, n2);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        if (string2 == null) {
            fArray = this.getDataFloat2D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2];
        float[] fArray2 = new float[n * n2];
        Parser.parseFloatArray(string2, null, fArray2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = fArray2[n3++];
            }
        }
        return fArray;
    }

    float[][][] functionXYZ(String string, int n, int n2, int n3) {
        float[][][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data3d_") != 0) {
            return this.statusManager.functionXYZ(string, n, n2, n3);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        if (string2 == null) {
            fArray = this.getDataFloat3D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2][n3];
        float[] fArray2 = new float[n * n2 * n3];
        Parser.parseFloatArray(string2, null, fArray2);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = fArray2[n4++];
                }
            }
        }
        return fArray;
    }

    void getHelp(String string) {
        if (string.length() > 0 && string.indexOf("?") != 0 && this.global.helpPath.indexOf("?") < 0) {
            string = "?search=" + string;
        }
        this.showUrl(this.global.helpPath + string);
    }

    void addCommand(String string) {
        if (!this.autoExit) {
            this.commandHistory.addCommand(TextFormat.replaceAllCharacters(string, "\r\n\t", " "));
        }
    }

    String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int n) {
        return this.commandHistory.getSetHistory(n);
    }

    public void writeTextFile(String string, String string2) {
        this.createImage(string, "txt", string2, Integer.MIN_VALUE, 0, 0);
    }

    public String clipImage(String string) {
        try {
            JmolImageCreatorInterface jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("util.ImageCreator");
            jmolImageCreatorInterface.setViewer(this);
            return jmolImageCreatorInterface.clipImage(string);
        }
        catch (Error error) {
            return GT._("clipboard is not accessible -- use signed applet");
        }
    }

    String createImage(String string, String string2, Object object, int n, int n2, int n3, BitSet bitSet) {
        if (bitSet == null) {
            return this.createImage(string, string2, object, n, n2, n3);
        }
        int n4 = this.getModelCount();
        String string3 = "";
        int n5 = 0;
        int n6 = string.indexOf(".");
        if (n6 < 0) {
            n6 = string.length();
        }
        String string4 = string.substring(0, n6);
        String string5 = string.substring(n6);
        for (int i = 0; i < n4; ++i) {
            if (!bitSet.get(i)) continue;
            this.setCurrentModelIndex(i);
            string = "0000" + ++n5;
            string = string4 + string.substring(string.length() - 4) + string5;
            String string6 = this.createImage(string, string2, object, n, n2, n3);
            Logger.info(string6);
            string3 = string3 + string6 + "\n";
            if (string6.startsWith("OK")) continue;
            return "ERROR WRITING FILE SET: \n" + string3;
        }
        if (string3.length() == 0) {
            string3 = "OK\n";
        }
        return string3 + "\n" + n5 + " files created";
    }

    public String createImage(String string, String string2, Object object, int n, int n2, int n3) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        if (n != Integer.MIN_VALUE) {
            this.mustRender = true;
            this.resizeImage(n2, n3, true, false, false);
            this.setModelVisibility();
        }
        this.creatingImage = true;
        String string3 = null;
        try {
            if (string == null) {
                string3 = this.clipImage((String)object);
            } else {
                boolean bl;
                boolean bl2;
                boolean bl3 = bl2 = string.indexOf("?") == 0;
                if (bl2) {
                    string = string.substring(1);
                }
                boolean bl4 = bl = string.indexOf("?") == 0;
                if (bl) {
                    string = string.substring(1);
                }
                string = FileManager.setLocalPathForWritingFile(this, string);
                String[] stringArray = new String[]{(bl || this.isApplet && bl2 ? "?" : "") + string};
                string3 = this.statusManager.createImage(stringArray, string2, object, n);
                if (!this.isApplet && string3 == null) {
                    JmolImageCreatorInterface jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
                    jmolImageCreatorInterface.setViewer(this);
                    string3 = (String)jmolImageCreatorInterface.createImage(stringArray[0], string2, object, n);
                    this.statusManager.createImage(new String[]{string3}, string2, null, n);
                }
            }
        }
        catch (Throwable throwable) {
            string3 = "ERROR creating image: " + throwable;
            Logger.error(this.setErrorMessage(string3));
        }
        this.creatingImage = false;
        if (n != Integer.MIN_VALUE) {
            this.resizeImage(n4, n5, true, false, true);
        }
        return "CANCELED".equals(string3) ? null : string3;
    }

    private void setImageFontScaling(int n, int n2) {
        float f = this.global.zoomLarge == n2 > n ? n2 : n;
        this.imageFontScaling = f / (float)this.getScreenDim();
    }

    private void setSyncTarget(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.statusManager.syncingMouse = bl;
                break;
            }
            case 1: {
                this.statusManager.syncingScripts = bl;
                break;
            }
            case 2: {
                this.statusManager.syncSend(bl ? SYNC_GRAPHICS_MESSAGE : SYNC_NO_GRAPHICS_MESSAGE, "*");
                if (Float.isNaN(this.transformManager.stereoDegrees)) {
                    this.setFloatProperty("stereoDegrees", -5.0f);
                }
                if (bl) {
                    this.setBooleanProperty("syncMouse", false);
                    this.setBooleanProperty("syncScript", false);
                }
                return;
            }
        }
        if (!this.statusManager.syncingScripts && !this.statusManager.syncingMouse) {
            this.refresh(-1, "set sync");
        }
    }

    public void syncScript(String string, String string2) {
        if (string.equalsIgnoreCase(SYNC_GRAPHICS_MESSAGE)) {
            this.statusManager.setSyncDriver(5);
            this.statusManager.syncSend(string, string2);
            this.setBooleanProperty("syncMouse", false);
            this.setBooleanProperty("syncScript", false);
            return;
        }
        boolean bl = "~".equals(string2);
        if (!bl && !".".equals(string2)) {
            this.statusManager.syncSend(string, string2);
            if (!"*".equals(string2)) {
                return;
            }
        }
        if (string.equalsIgnoreCase("on")) {
            this.statusManager.setSyncDriver(1);
            return;
        }
        if (string.equalsIgnoreCase("off")) {
            this.statusManager.setSyncDriver(0);
            return;
        }
        if (string.equalsIgnoreCase("slave")) {
            this.statusManager.setSyncDriver(2);
            return;
        }
        int n = this.statusManager.getSyncMode();
        if (n == 0) {
            return;
        }
        if (n != 1) {
            bl = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.htmlName + " syncing with script: " + string);
        }
        if (bl) {
            this.statusManager.setSyncDriver(3);
        }
        if (string.indexOf("Mouse: ") != 0) {
            this.evalStringQuiet(string, true, false);
            return;
        }
        String[] stringArray = Parser.getTokens(string);
        String string3 = stringArray[1];
        switch (stringArray.length) {
            case 3: {
                if (string3.equals("zoomByFactor")) {
                    this.zoomByFactor(Parser.parseFloat(stringArray[2]));
                    break;
                }
                if (string3.equals("zoomBy")) {
                    this.zoomBy(Parser.parseInt(stringArray[2]));
                    break;
                }
                if (!string3.equals("rotateZBy")) break;
                this.rotateZBy(Parser.parseInt(stringArray[2]));
                break;
            }
            case 4: {
                if (string3.equals("rotateXYBy")) {
                    this.rotateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (string3.equals("translateXYBy")) {
                    this.translateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (!string3.equals("rotateMolecule")) break;
                this.rotateMolecule(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
            }
        }
        if (bl) {
            this.setSyncDriver(4);
        }
    }

    void setSyncDriver(int n) {
        this.statusManager.setSyncDriver(n);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    void setProteinType(byte by, BitSet bitSet) {
        this.modelSet.setProteinType(bitSet == null ? this.selectionManager.bsSelection : bitSet, by);
    }

    public Point3f getBondPoint3f1(int n) {
        return this.modelSet.getBondAtom1(n);
    }

    public Point3f getBondPoint3f2(int n) {
        return this.modelSet.getBondAtom2(n);
    }

    public Vector3f getVibrationVector(int n) {
        return this.modelSet.getVibrationVector(n, false);
    }

    public int getVanderwaalsMar(int n) {
        return this.dataManager.defaultVdw == 3 ? this.dataManager.userVdwMars[n] : JmolConstants.getVanderwaalsMar(n, this.dataManager.defaultVdw);
    }

    public int getVanderwaalsMar(int n, int n2) {
        if (n2 == 3 && this.dataManager.bsUserVdws == null) {
            n2 = this.dataManager.defaultVdw;
        }
        return n2 == 3 ? this.dataManager.userVdwMars[n] : JmolConstants.getVanderwaalsMar(n, n2);
    }

    void setDefaultVdw(String string) {
        this.dataManager.setDefaultVdw(string);
        this.global.setParameterValue("defaultVDW", this.getDefaultVdw(Integer.MIN_VALUE));
    }

    String getDefaultVdw(int n) {
        return this.dataManager.getDefaultVdw(n, null);
    }

    public int deleteAtoms(BitSet bitSet, boolean bl) {
        this.clearModelDependentObjects();
        if (!bl) {
            return this.selectionManager.deleteAtoms(bitSet);
        }
        this.fileManager.addLoadScript("zap " + Escape.escape(bitSet));
        this.setCurrentModelIndex(0, false);
        this.animationManager.setAnimationOn(false);
        BitSet bitSet2 = this.modelSet.deleteModels(bitSet);
        this.setAnimationRange(0, 0);
        this.eval.deleteAtomsInVariables(bitSet2);
        this.repaintManager.clear();
        this.animationManager.clear();
        this.animationManager.initializePointers(1);
        if (this.getModelCount() > 1) {
            this.setCurrentModelIndex(-1, true);
        }
        this.hoverAtomIndex = -1;
        this.setFileLoadStatus(5, null, null, null, null);
        this.refreshMeasures();
        return BitSetUtil.cardinalityOf(bitSet2);
    }

    public void deleteModelAtoms(int n, int n2, BitSet bitSet) {
        this.dataManager.deleteModelAtoms(n, n2, bitSet);
    }

    public BitSet getDeletedAtoms() {
        return this.selectionManager.bsDeleted;
    }

    public char getQuaternionFrame() {
        return this.global.quaternionFrame.charAt(this.global.quaternionFrame.length() == 2 ? 1 : 0);
    }

    public int getHelixStep() {
        return this.global.helixStep;
    }

    String calculatePointGroup() {
        return this.modelSet.calculatePointGroup(this.selectionManager.bsSelection);
    }

    public Hashtable getPointGroupInfo(Object object) {
        return this.modelSet.getPointGroupInfo(this.getAtomBitSet(object));
    }

    public String getPointGroupAsString(boolean bl, String string, int n, float f) {
        return this.modelSet.getPointGroupAsString(this.selectionManager.bsSelection, bl, string, n, f);
    }

    public float getPointGroupTolerance(int n) {
        switch (n) {
            case 0: {
                return this.global.pointGroupDistanceTolerance;
            }
            case 1: {
                return this.global.pointGroupLinearTolerance;
            }
        }
        return 0.0f;
    }

    Object getFileAsImage(String string, Hashtable hashtable) {
        if (!this.haveDisplay) {
            return "no display";
        }
        Object object = this.fileManager.getFileAsImage(string, hashtable);
        if (object instanceof String) {
            return object;
        }
        Image image = (Image)object;
        MediaTracker mediaTracker = new MediaTracker(this.display);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    String cd(String string) {
        String string2;
        if (string == null) {
            string = ".";
        } else if (string.length() == 0) {
            this.setStringProperty("defaultDirectory", "");
            string = ".";
        }
        string = this.fileManager.getDefaultDirectory(string + (string.equals("=") || string.endsWith("/") ? "" : "/X"));
        if (string.length() > 0) {
            this.setStringProperty("defaultDirectory", string);
        }
        if ((string2 = this.fileManager.getFullPath(string + "/", true)).startsWith("file:/")) {
            FileManager.setLocalPath(this, string, false);
        }
        return string;
    }

    private String setErrorMessage(String string) {
        return this.setErrorMessage(string, null);
    }

    private String setErrorMessage(String string, String string2) {
        this.errorMessageUntranslated = string2;
        this.errorMessage = string;
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public Shape getShape(int n) {
        return this.modelSet == null ? null : this.modelSet.getShape(n);
    }

    public void setShapeErrorState(int n, String string) {
        this.currentShapeID = n;
        this.currentShapeState = string;
    }

    public String getShapeErrorState() {
        if (this.currentShapeID < 0) {
            return "";
        }
        if (this.modelSet != null) {
            this.modelSet.releaseShape(this.currentShapeID);
        }
        this.repaintManager.clear(this.currentShapeID);
        return JmolConstants.getShapeClassName(this.currentShapeID) + " " + this.currentShapeState;
    }

    public void handleError(Error error, boolean bl) {
        try {
            if (bl) {
                this.zap("" + error);
            }
            Logger.error("viewer handling error condition: " + error);
            this.notifyError("Error", "doClear=" + bl + "; " + error, "" + error);
        }
        catch (Throwable throwable) {
            try {
                Logger.error("Could not notify error " + error + ": due to " + throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    float[] getAtomicCharges() {
        return this.modelSet.getAtomicCharges();
    }

    ScriptFunction getFunction(String string) {
        return this.stateManager.getFunction(string);
    }

    void addFunction(ScriptFunction scriptFunction) {
        this.stateManager.addFunction(scriptFunction);
    }

    public void clearFunctions() {
        this.stateManager.clearFunctions();
    }

    public boolean isFunction(String string) {
        return this.stateManager.isFunction(string);
    }

    public String getFunctionCalls(String string) {
        return this.stateManager.getFunctionCalls(string);
    }

    void showMessage(String string) {
        if (!this.isPrintOnly) {
            Logger.warn(string);
        }
    }

    public String getMoInfo(int n) {
        return this.modelSet.getMoInfo(n);
    }

    boolean isRepaintPending() {
        return this.repaintManager.repaintPending;
    }
}

