/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.Structure;
import org.gstreamer.ValueList;
import org.gstreamer.elements.RGBDataAppSink;
import org.gstreamer.interfaces.Property;
import org.gstreamer.interfaces.PropertyProbe;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSCapture
extends PImage
implements PConstants {
    protected Method captureEventMethod;
    protected boolean available;
    protected String fps;
    protected int captureWidth;
    protected int captureHeight;
    protected Object eventHandler;
    protected RGBDataAppSink videoSink = null;
    protected int[] copyPixels = null;
    protected Pipeline gpipe;
    protected ArrayList<int[]> suppResList;
    protected ArrayList<String> suppFpsList;
    protected boolean firstFrame = true;

    public GSCapture(PApplet parent, int requestWidth, int requestHeight) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.platformInit(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], "", false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.platformInit(requestWidth, requestHeight, new String[0], new int[0], new String[0], new String[0], String.valueOf(frameRate) + "/1", false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String cameraName) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.platformInit(requestWidth, requestHeight, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, "", false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, int frameRate, String cameraName) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.platformInit(requestWidth, requestHeight, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, String.valueOf(frameRate) + "/1", false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, int frameRate, String sourceName, String cameraName) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], new String[]{GSCapture.devicePropertyName()}, new String[]{cameraName}, String.valueOf(frameRate) + "/1", false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String frameRate, String sourceName, String[] strPropNames, String[] strPropValues) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.init(requestWidth, requestHeight, sourceName, new String[0], new int[0], strPropNames, strPropValues, frameRate, false);
    }

    public GSCapture(PApplet parent, int requestWidth, int requestHeight, String frameRate, String sourceName, String[] strPropNames, String[] strPropValues, String[] intPropNames, int[] intPropValues) {
        super(requestWidth, requestHeight, 1);
        this.parent = parent;
        this.init(requestWidth, requestHeight, sourceName, intPropNames, intPropValues, strPropNames, strPropValues, frameRate, false);
    }

    public void delete() {
        if (this.gpipe != null) {
            try {
                if (this.gpipe.isPlaying()) {
                    this.gpipe.stop();
                }
            }
            catch (IllegalStateException e) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.copyPixels = null;
            this.pixels = null;
            if (this.videoSink != null) {
                this.videoSink.removeListener();
                this.videoSink.dispose();
                this.videoSink = null;
            }
            this.gpipe.dispose();
            this.gpipe = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    public void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.captureEventMethod = this.parent.getClass().getMethod("captureEvent", GSCapture.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean available() {
        return this.available;
    }

    public void play() {
        this.gpipe.setState(State.PLAYING);
    }

    public void pause() {
        this.gpipe.setState(State.PAUSED);
    }

    public synchronized void read() {
        this.loadPixels();
        if (this.copyPixels == null) {
            return;
        }
        if (this.firstFrame) {
            super.init(this.captureWidth, this.captureHeight, 1);
            this.loadPixels();
            this.firstFrame = false;
        }
        int[] temp = this.pixels;
        this.pixels = this.copyPixels;
        this.updatePixels();
        this.copyPixels = temp;
        this.available = false;
    }

    public int[][] resolutions() {
        int n = this.suppResList.size();
        int[][] res = new int[n][2];
        int i = 0;
        while (i < n) {
            int[] wh = this.suppResList.get(i);
            res[i] = new int[]{wh[0], wh[1]};
            ++i;
        }
        return res;
    }

    public String[] framerates() {
        int n = this.suppFpsList.size();
        String[] res = new String[n];
        int i = 0;
        while (i < n) {
            res[i] = this.suppFpsList.get(i);
            ++i;
        }
        return res;
    }

    public static String[] list() {
        if (PApplet.platform == 3) {
            return GSCapture.list("v4l2src");
        }
        if (PApplet.platform == 1) {
            return GSCapture.list("dshowvideosrc");
        }
        if (PApplet.platform == 2) {
            return GSCapture.list("osxvideosrc");
        }
        return null;
    }

    public static String[] list(String sourceName) {
        return GSCapture.list(sourceName, GSCapture.devicePropertyName());
    }

    protected static String[] list(String sourceName, String propertyName) {
        Object[] values;
        Property property;
        GSVideo.init();
        String[] valuesListing = new String[]{};
        Element videoSource = ElementFactory.make((String)sourceName, (String)"Source");
        PropertyProbe probe = PropertyProbe.wrap((Element)videoSource);
        if (probe != null && (property = probe.getProperty(propertyName)) != null && (values = probe.getValues(property)) != null) {
            valuesListing = new String[values.length];
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof String) {
                    valuesListing[i] = (String)values[i];
                }
                ++i;
            }
        }
        return valuesListing;
    }

    protected synchronized void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.captureWidth = w;
        this.captureHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke((Object)this.parent, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling captureEvent() for capture object");
                e.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    protected void platformInit(int requestWidth, int requestHeight, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, String frameRate, boolean addDecoder) {
        if (PApplet.platform == 3) {
            this.init(requestWidth, requestHeight, "v4l2src", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, addDecoder);
        } else if (PApplet.platform == 1) {
            this.init(requestWidth, requestHeight, "ksvideosrc", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, addDecoder);
        } else if (PApplet.platform == 2) {
            this.init(requestWidth, requestHeight, "osxvideosrc", intPropNames, intPropValues, strPropNames, strPropValues, frameRate, addDecoder);
        } else {
            this.parent.die("Error: unrecognized platform.", null);
        }
    }

    protected void init(int requestWidth, int requestHeight, String sourceName, String[] intPropNames, int[] intPropValues, String[] strPropNames, String[] strPropValues, String frameRate, boolean addDecoder) {
        String str;
        int[] wh;
        this.gpipe = null;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        this.setEventHandlerObject(this.parent);
        this.gpipe = new Pipeline("GSCapturePipeline");
        Element videoSource = ElementFactory.make((String)sourceName, (String)"Source");
        if (intPropNames.length != intPropValues.length) {
            this.parent.die("Error: number of integer property names is different from number of values.", null);
        }
        int i = 0;
        while (i < intPropNames.length) {
            videoSource.set(intPropNames[i], (Object)intPropValues[i]);
            ++i;
        }
        if (strPropNames.length != strPropValues.length) {
            this.parent.die("Error: number of string property names is different from number of values.", null);
        }
        i = 0;
        while (i < strPropNames.length) {
            videoSource.set(strPropNames[i], (Object)strPropValues[i]);
            ++i;
        }
        this.fps = frameRate;
        String fpsStr = "";
        if (!this.fps.equals("")) {
            fpsStr = ", framerate=" + this.fps;
        }
        Element conv = ElementFactory.make((String)"ffmpegcolorspace", (String)"ColorConverter");
        Element videofilter = ElementFactory.make((String)"capsfilter", (String)"ColorFilter");
        videofilter.setCaps(new Caps("video/x-raw-rgb, width=" + requestWidth + ", height=" + requestHeight + ", bpp=32, depth=24" + fpsStr));
        this.videoSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

            public void rgbFrame(int w, int h, IntBuffer buffer) {
                GSCapture.this.invokeEvent(w, h, buffer);
            }
        });
        this.videoSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
        if (addDecoder) {
            Element decoder = ElementFactory.make((String)"decodebin2", (String)"Decoder");
            this.gpipe.addMany(new Element[]{videoSource, decoder, conv, videofilter, this.videoSink});
            Element.linkMany((Element[])new Element[]{videoSource, decoder, conv, videofilter, this.videoSink});
        } else {
            this.gpipe.addMany(new Element[]{videoSource, conv, videofilter, this.videoSink});
            Element.linkMany((Element[])new Element[]{videoSource, conv, videofilter, this.videoSink});
        }
        this.play();
        this.getSuppResAndFpsList();
        boolean suppRes = this.suppResList.size() <= 0;
        int i2 = 0;
        while (i2 < this.suppResList.size()) {
            wh = this.suppResList.get(i2);
            if (requestWidth == wh[0] && requestHeight == wh[1]) {
                suppRes = true;
                break;
            }
            ++i2;
        }
        if (!suppRes) {
            System.err.println("The requested resolution of " + requestWidth + "x" + requestHeight + " is not supported by the capture device.");
            System.err.println("Use one of the following resolutions instead:");
            i2 = 0;
            while (i2 < this.suppResList.size()) {
                wh = this.suppResList.get(i2);
                System.err.println(String.valueOf(wh[0]) + "x" + wh[1]);
                ++i2;
            }
        }
        boolean suppFps = this.suppFpsList.size() <= 0;
        int i3 = 0;
        while (i3 < this.suppFpsList.size()) {
            str = this.suppFpsList.get(i3);
            if (frameRate.equals("") || frameRate.equals(str)) {
                suppFps = true;
                break;
            }
            ++i3;
        }
        if (!suppFps) {
            System.err.println("The requested framerate of " + frameRate + " is not supported by the capture device.");
            System.err.println("Use one of the following framerates instead:");
            i3 = 0;
            while (i3 < this.suppFpsList.size()) {
                str = this.suppFpsList.get(i3);
                System.err.println(str);
                ++i3;
            }
        }
    }

    protected void getSuppResAndFpsList() {
        this.suppResList = new ArrayList();
        this.suppFpsList = new ArrayList();
        for (Element src : this.gpipe.getSources()) {
            for (Pad pad : src.getPads()) {
                Caps caps = pad.getCaps();
                int n = caps.size();
                int i = 0;
                while (i < n) {
                    Structure str = caps.getStructure(i);
                    int w = (Integer)str.getValue("width");
                    int h = (Integer)str.getValue("height");
                    boolean newRes = true;
                    int j = 0;
                    while (j < this.suppResList.size()) {
                        int[] wh = this.suppResList.get(j);
                        if (w == wh[0] && h == wh[1]) {
                            newRes = false;
                            break;
                        }
                        ++j;
                    }
                    if (newRes) {
                        this.suppResList.add(new int[]{w, h});
                    }
                    if (PApplet.platform == 1) {
                        String str2 = str.toString();
                        int n0 = str2.indexOf("framerate=(fraction)");
                        if (-1 < n0) {
                            String temp = str2.substring(n0 + 20, str2.length());
                            int n1 = temp.indexOf("[");
                            int n2 = temp.indexOf("]");
                            if (-1 < n1 && -1 < n2) {
                                temp = temp.substring(n1 + 1, n2);
                                String[] fractions = temp.split(",");
                                int k = 0;
                                while (k < fractions.length) {
                                    this.addFpsStr(fractions[k].trim());
                                    ++k;
                                }
                            } else {
                                int n3 = temp.indexOf(",");
                                int n4 = temp.indexOf(";");
                                if (-1 < n3 || -1 < n4) {
                                    int n5 = -1;
                                    n5 = n3 == -1 ? n4 : (n4 == -1 ? n3 : PApplet.min((int)n3, (int)n4));
                                    temp = temp.substring(0, n5);
                                    this.addFpsStr(temp.trim());
                                }
                            }
                        }
                    } else {
                        boolean sigleFrac = false;
                        try {
                            Fraction fr = str.getFraction("framerate");
                            this.addFps(fr);
                            sigleFrac = true;
                        }
                        catch (Exception fr) {
                            // empty catch block
                        }
                        if (!sigleFrac) {
                            ValueList flist = str.getValueList("framerate");
                            int k = 0;
                            while (k < flist.getSize()) {
                                Fraction fr = flist.getFraction(k);
                                this.addFps(fr);
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void addFps(Fraction fr) {
        int frn = fr.numerator;
        int frd = fr.denominator;
        this.addFpsStr(String.valueOf(frn) + "/" + frd);
    }

    protected void addFpsStr(String frstr) {
        boolean newFps = true;
        int j = 0;
        while (j < this.suppFpsList.size()) {
            String frstr0 = this.suppFpsList.get(j);
            if (frstr.equals(frstr0)) {
                newFps = false;
                break;
            }
            ++j;
        }
        if (newFps) {
            this.suppFpsList.add(frstr);
        }
    }

    protected static String devicePropertyName() {
        if (PApplet.platform == 3) {
            return "device";
        }
        if (PApplet.platform == 1) {
            return "device-name";
        }
        if (PApplet.platform == 2) {
            return "device";
        }
        return "";
    }

    protected static String indexPropertyName() {
        if (PApplet.platform == 3) {
            return "device-index";
        }
        if (PApplet.platform == 1) {
            return "device-index";
        }
        if (PApplet.platform == 2) {
            return "device-index";
        }
        return "";
    }
}

