/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSLibraryLoader {
    private static GSLibraryLoader instance;
    static final Object[][] WIN32_DEPENDENCIES;
    static final Object[][] OSX_DEPENDENCIES;
    static final Object[][] DEFAULT_DEPENDENCIES;
    static final Object[][] dependencies;
    private static final Map<String, Object> loadedMap;
    private static final int RECURSIVE_LOAD_MAX_DEPTH = 5;

    static {
        WIN32_DEPENDENCIES = new Object[][]{{"SDL", new String[0], false}, {"glew32", new String[0], false}, {"iconv-2", new String[0], false}, {"liba52-0", new String[0], false}, {"libbz2", new String[0], false}, {"libcairo-2", new String[0], false}, {"libdca-0", new String[0], false}, {"libdvdcss-2", new String[0], false}, {"libdvdnav-4", new String[0], false}, {"libdvdnavmini-4", new String[0], false}, {"libdvdread-4", new String[0], false}, {"libfaac-0", new String[0], false}, {"libfaad-2", new String[0], false}, {"libfontconfig-1", new String[0], false}, {"libfreetype-6", new String[0], false}, {"libgcrypt-11", new String[0], false}, {"libgnutls-26", new String[0], false}, {"libgnutls-extra-26", new String[0], false}, {"libgnutls-openssl-26", new String[0], false}, {"libgpg-error-0", new String[0], false}, {"libid3tag-0", new String[0], false}, {"libjpeg-8", new String[0], false}, {"libmad-0", new String[0], false}, {"libmms-0", new String[0], false}, {"libmp3lame-0", new String[0], false}, {"libmpeg2-0", new String[0], false}, {"libmpeg2convert-0", new String[0], false}, {"libneon-27", new String[0], false}, {"libnice-0", new String[0], false}, {"libogg-0", new String[0], false}, {"liboil-0.3-0", new String[0], false}, {"libopenjpeg-2", new String[0], false}, {"libpango-1.0-0", new String[0], false}, {"libpangocairo-1.0-0", new String[0], false}, {"libpangoft2-1.0-0", new String[0], false}, {"libpangowin32-1.0-0", new String[0], false}, {"libpixman-1-0", new String[0], true}, {"libpng14-14", new String[0], false}, {"liborc-0.4-0", new String[0], false}, {"libschroedinger-1.0-0", new String[0], false}, {"libsoup-2.4-1", new String[0], false}, {"libspeex-1", new String[0], false}, {"libtheora-0", new String[0], false}, {"libtheoradec-1", new String[0], false}, {"libtheoraenc-1", new String[0], false}, {"libvorbis-0", new String[0], false}, {"libvorbisenc-2", new String[0], false}, {"libvorbisfile-3", new String[0], false}, {"libwavpack-1", new String[0], false}, {"libx264-107", new String[0], false}, {"libxml2-2", new String[0], false}, {"pthreadGC2", new String[0], false}, {"xvidcore", new String[0], false}, {"z", new String[0], false}, {"avutil-gpl-50", new String[0], false}, {"avformat-gpl-52", new String[0], false}, {"avcodec-gpl-52", new String[0], false}, {"swscale-gpl-0", new String[0], false}, {"libcelt-0", new String[0], false}, {"libgdk_pixbuf-2.0-0", new String[0], false}, {"librsvg-2-2", new String[0], false}, {"libflac-8", new String[0], false}, {"gio-2.0", new String[0], true}, {"glib-2.0", new String[0], true}, {"gmodule-2.0", new String[0], true}, {"gobject-2.0", new String[0], true}, {"gthread-2.0", new String[0], true}, {"gstapp-0.10", new String[0], true}, {"gstaudio-0.10", new String[0], true}, {"gstbase-0.10", new String[0], true}, {"gstcdda-0.10", new String[0], true}, {"gstcontroller-0.10", new String[0], true}, {"gstdataprotocol-0.10", new String[0], true}, {"gstfarsight-0.10", new String[0], true}, {"gstfft-0.10", new String[0], true}, {"gstgl-0.10", new String[0], true}, {"gstinterfaces-0.10", new String[0], true}, {"gstnet-0.10", new String[0], true}, {"gstnetbuffer-0.10", new String[0], true}, {"gstpbutils-0.10", new String[0], true}, {"gstphotography-0.10", new String[0], true}, {"gstreamer-0.10", new String[0], true}, {"gstriff-0.10", new String[0], true}, {"gstrtp-0.10", new String[0], true}, {"gstrtsp-0.10", new String[0], true}, {"gstsdp-0.10", new String[0], true}, {"gsttag-0.10", new String[0], true}, {"gstvideo-0.10", new String[0], true}, {"gstbasevideo-0.10", new String[0], true}};
        OSX_DEPENDENCIES = new Object[][]{{"gstbase-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstinterfaces-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstcontroller-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstaudio-0.10", new String[]{"gstbase-0.10"}, true}, {"gstvideo-0.10", new String[]{"gstbase-0.10"}, true}};
        DEFAULT_DEPENDENCIES = new Object[][]{{"gstreamer-0.10", new String[0], true}, {"gstbase-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstinterfaces-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstcontroller-0.10", new String[]{"gstreamer-0.10"}, true}, {"gstaudio-0.10", new String[]{"gstbase-0.10"}, true}, {"gstvideo-0.10", new String[]{"gstbase-0.10"}, true}};
        dependencies = Platform.isWindows() ? WIN32_DEPENDENCIES : (Platform.isMac() ? OSX_DEPENDENCIES : DEFAULT_DEPENDENCIES);
        loadedMap = new HashMap<String, Object>();
    }

    private GSLibraryLoader() {
    }

    private void preLoadLibs() {
        Object[][] objectArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] a = objectArray[n2];
            this.load(a[0].toString(), DummyLibrary.class, true, 0, (Boolean)a[2]);
            ++n2;
        }
    }

    private String[] findDeps(String name) {
        Object[][] objectArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] a = objectArray[n2];
            if (name.equals(a[0])) {
                return (String[])a[1];
            }
            ++n2;
        }
        return new String[0];
    }

    public Object load(String name, Class<?> clazz, boolean reqLib) {
        return this.load(name, clazz, true, 0, reqLib);
    }

    private Object load(String name, Class<?> clazz, boolean forceReload, int depth, boolean reqLib) {
        assert (depth < 5) : String.format("recursive max load depth %s has been exceeded", depth);
        Object library = loadedMap.get(name);
        if (library == null || forceReload) {
            try {
                String[] deps;
                String[] stringArray = deps = this.findDeps(name);
                int n = deps.length;
                int n2 = 0;
                while (n2 < n) {
                    String lib = stringArray[n2];
                    this.load(lib, DummyLibrary.class, false, depth + 1, reqLib);
                    ++n2;
                }
                library = GSLibraryLoader.loadLibrary(name, clazz, reqLib);
                if (library != null) {
                    loadedMap.put(name, library);
                }
            }
            catch (Exception e) {
                if (reqLib) {
                    throw new RuntimeException(String.format("can not load library %s", name, e));
                }
                System.out.println(String.format("can not load library %s", name, e));
            }
        }
        return library;
    }

    private static Object loadLibrary(String name, Class<?> clazz, boolean reqLib) {
        String[] stringArray;
        if (Platform.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "lib%s";
            stringArray2[1] = "lib%s-0";
            stringArray = stringArray2;
            stringArray2[2] = "%s";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "%s-0";
            stringArray = stringArray3;
            stringArray3[1] = "%s";
        }
        String[] nameFormats = stringArray;
        UnsatisfiedLinkError linkError = null;
        String[] stringArray4 = nameFormats;
        int n = nameFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String fmt = stringArray4[n2];
            try {
                String s = String.format(fmt, name);
                Object obj = Native.loadLibrary((String)s, clazz);
                return obj;
            }
            catch (UnsatisfiedLinkError ex) {
                linkError = ex;
                ++n2;
            }
        }
        if (reqLib) {
            throw new UnsatisfiedLinkError(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", name, System.getProperty("jna.library.path"), linkError));
        }
        System.out.println(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", name, System.getProperty("jna.library.path"), linkError));
        return null;
    }

    public static synchronized GSLibraryLoader getInstance() {
        if (instance == null) {
            instance = new GSLibraryLoader();
            instance.preLoadLibs();
        }
        return instance;
    }

    public static interface DummyLibrary
    extends Library {
    }
}

