/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bus;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSMovie
extends PImage
implements PConstants {
    protected Method movieEventMethod;
    protected String filename;
    protected boolean playing;
    protected boolean paused;
    protected boolean repeat;
    protected boolean available;
    protected int fps;
    protected float rate;
    protected int movieWidth;
    protected int movieHeight;
    protected Object eventHandler;
    protected RGBDataAppSink videoSink;
    protected int[] copyPixels;
    protected PlayBin2 gplayer;
    protected boolean firstFrame;

    public GSMovie(PApplet parent, String filename) {
        this(parent, filename, 30);
    }

    public GSMovie(PApplet parent, String filename, int ifps) {
        block11: {
            super(1, 1, 1);
            this.playing = false;
            this.paused = false;
            this.repeat = false;
            this.videoSink = null;
            this.copyPixels = null;
            this.firstFrame = true;
            this.parent = parent;
            this.gplayer = null;
            GSVideo.init();
            try {
                File file;
                try {
                    file = new File(parent.dataPath(filename));
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSMovie Player");
                        this.gplayer.setInputFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.gplayer != null) break block11;
                try {
                    file = new File(filename);
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSMovie Player");
                        this.gplayer.setInputFile(file);
                        break block11;
                    }
                    System.err.println("File " + filename + " does not exist. Please check location.");
                }
                catch (Exception e) {
                    PApplet.println((String)"Shit coming...");
                    e.printStackTrace();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        if (this.gplayer == null) {
            parent.die("Could not load movie file " + filename, null);
        }
        try {
            this.filename = filename;
            this.fps = ifps;
            parent.registerDispose((Object)this);
            this.setEventHandlerObject(parent);
            this.videoSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int w, int h, IntBuffer buffer) {
                    GSMovie.this.invokeEvent(w, h, buffer);
                }
            });
            this.videoSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
            this.gplayer.setVideoSink((Element)this.videoSink);
            this.videoSink.dispose();
            Bus bus = this.gplayer.getBus();
            bus.connect(new Bus.EOS(){

                public void endOfStream(GstObject element) {
                    GSMovie.this.eosEvent();
                }
            });
            this.rate = 1.0f;
            this.frameRate(this.fps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete() {
        if (this.gplayer != null) {
            try {
                if (this.gplayer.isPlaying()) {
                    this.gplayer.stop();
                }
            }
            catch (IllegalStateException e) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.copyPixels = null;
            this.pixels = null;
            if (this.videoSink != null) {
                this.videoSink.removeListener();
                this.videoSink.dispose();
                this.videoSink = null;
            }
            this.gplayer.dispose();
            this.gplayer = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    public void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", GSMovie.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSourceWidth() {
        Dimension dim = this.gplayer.getVideoSize();
        if (dim != null) {
            return dim.width;
        }
        return 0;
    }

    public int getSourceHeight() {
        Dimension dim = this.gplayer.getVideoSize();
        if (dim != null) {
            return dim.width;
        }
        return 0;
    }

    public float getSourceFrameRate() {
        return (float)this.gplayer.getVideoSinkFrameRate();
    }

    public void frameRate(int ifps) {
        long stop;
        long start;
        if (ifps == 0) {
            System.err.println("FPS of zero is invalid");
            return;
        }
        float ffps = ifps;
        float f = ffps / (float)this.fps;
        if (this.playing) {
            this.gplayer.pause();
        }
        long t = this.gplayer.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            start = t;
            stop = -1L;
        } else {
            start = 0L;
            stop = t;
        }
        boolean res = this.gplayer.seek((double)(this.rate * f), Format.TIME, 1, SeekType.SET, start, SeekType.SET, stop);
        if (!res) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gplayer.play();
        }
        this.fps = ifps;
    }

    public void speed(float irate) {
        if ((double)PApplet.abs((float)(this.rate - irate)) > 0.1) {
            this.rate = irate;
            this.frameRate(this.fps);
        }
    }

    public float duration() {
        float sec = this.gplayer.queryDuration().toSeconds();
        float nanosec = this.gplayer.queryDuration().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public float time() {
        float sec = this.gplayer.queryPosition().toSeconds();
        float nanosec = this.gplayer.queryPosition().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public long length() {
        return (int)(this.duration() * this.getSourceFrameRate());
    }

    public int frame() {
        return (int)(this.time() * this.getSourceFrameRate());
    }

    public void jump(float where) {
        long stop;
        long start;
        boolean res;
        if (this.playing) {
            this.gplayer.pause();
        }
        if (!(res = this.gplayer.seek(1.0, Format.TIME, 1, SeekType.SET, start = GSVideo.secToNanoLong(where), SeekType.SET, stop = -1L))) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gplayer.play();
        }
    }

    public void jump(int frame) {
        float srcFramerate = this.getSourceFrameRate();
        float frameDuration = 1.0f / srcFramerate;
        float where = ((float)frame + 0.5f) * frameDuration;
        float diff = this.duration() - where;
        if (diff < 0.0f) {
            where += diff - 0.25f * frameDuration;
        }
        this.jump(where);
    }

    public boolean available() {
        return this.available;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    public void play() {
        this.playing = true;
        this.paused = false;
        this.gplayer.play();
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.playing = false;
        this.paused = true;
        this.gplayer.pause();
    }

    public void stop() {
        if (this.playing) {
            this.goToBeginning();
            this.playing = false;
        }
        this.paused = false;
        this.gplayer.stop();
    }

    public synchronized void read() {
        this.loadPixels();
        if (this.copyPixels == null) {
            return;
        }
        if (this.firstFrame) {
            super.init(this.movieWidth, this.movieHeight, 1);
            this.loadPixels();
            this.firstFrame = false;
        }
        int[] temp = this.pixels;
        this.pixels = this.copyPixels;
        this.updatePixels();
        this.copyPixels = temp;
        this.available = false;
    }

    public void goToBeginning() {
        boolean res = this.gplayer.seek(ClockTime.fromNanos((long)0L));
        if (!res) {
            System.err.println("Seek operation failed.");
        }
    }

    public void goToEnd() {
        long nanos = this.gplayer.queryDuration().getNanoSeconds();
        boolean res = this.gplayer.seek(ClockTime.fromNanos((long)nanos));
        if (!res) {
            System.err.println("Seek operation failed.");
        }
    }

    public void volume(float v) {
        if (this.playing) {
            this.gplayer.setVolume((double)v);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        } else {
            this.playing = false;
        }
    }

    protected synchronized void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.movieWidth = w;
        this.movieHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.playing && this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                e.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }
}

