/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.io.File;
import java.nio.ByteBuffer;
import org.gstreamer.Buffer;
import org.gstreamer.elements.RGBDataFileSink;
import processing.core.PApplet;

public class GSMovieMaker {
    private PApplet parent;
    private boolean recording;
    private RGBDataFileSink recorder;
    private int width;
    private int height;
    private int nConsecutiveFilledQueue;
    public static final int THEORA = 0;
    public static final int XVID = 1;
    public static final int X264 = 2;
    public static final int DIRAC = 3;
    public static final int MJPEG = 4;
    public static final int MJPEG2K = 5;
    public static final int WORST = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int BEST = 4;

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename) {
        this.init(parent, requestWidth, requestHeight, filename, 0, 2, 30);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, int codecType, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, codecType, 2, ifps);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, int codecType, int codecQuality, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, codecType, codecQuality, ifps);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, String encoder, String muxer, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, encoder, muxer, null, null, ifps);
    }

    public GSMovieMaker(PApplet parent, int requestWidth, int requestHeight, String filename, String encoder, String muxer, String[] propNames, Object[] propValues, int ifps) {
        this.init(parent, requestWidth, requestHeight, filename, encoder, muxer, propNames, propValues, ifps);
    }

    public void delete() {
        this.recorder.stop();
        this.recorder.dispose();
    }

    public void dispose() {
        this.delete();
    }

    public void addFrame(int[] pixels) {
        if (this.recording && pixels.length == this.width * this.height) {
            Buffer srcBuffer = new Buffer(this.width * this.height * 4);
            ByteBuffer tmpBuffer = srcBuffer.getByteBuffer();
            tmpBuffer.clear();
            tmpBuffer.asIntBuffer().put(pixels);
            int n = this.recorder.getNumQueuedFrames();
            if (n > 0) {
                ++this.nConsecutiveFilledQueue;
                if (3 < this.nConsecutiveFilledQueue) {
                    System.err.println("Warning: GSMovieMaker is filling up with unprocessed frames. Try using a lower framerate (both for drawing and saving), or a smaller video resolution.");
                }
            } else {
                this.nConsecutiveFilledQueue = 0;
            }
            this.recorder.pushRGBFrame(srcBuffer);
        }
    }

    public void start() {
        this.recorder.start();
        this.recording = true;
    }

    public void finish() {
        this.recording = false;
        this.recorder.stop();
    }

    public int queuedFrames() {
        return this.recorder.getNumQueuedFrames();
    }

    public boolean isRecording() {
        return this.recording;
    }

    protected void init(PApplet iparent, int requestWidth, int requestHeight, String filename, int codecType, int codecQuality, int ifps) {
        this.parent = iparent;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        this.width = requestWidth;
        this.height = requestHeight;
        String[] propNames = null;
        Object[] propValues = null;
        String encoder = "";
        String muxer = "";
        String fn = filename.toLowerCase();
        if (fn.endsWith(".ogg")) {
            muxer = "oggmux";
        } else if (fn.endsWith(".avi")) {
            muxer = "avimux";
        } else if (fn.endsWith(".mov")) {
            muxer = "qtmux";
        } else if (fn.endsWith(".flv")) {
            muxer = "flvmux";
        } else if (fn.endsWith(".mkv")) {
            muxer = "matroskamux";
        } else if (fn.endsWith(".mp4")) {
            muxer = "mp4mux";
        } else if (fn.endsWith(".3gp")) {
            muxer = "gppmux";
        } else if (fn.endsWith(".mpg")) {
            muxer = "ffmux_mpeg";
        } else if (fn.endsWith(".mj2")) {
            muxer = "mj2mux";
        } else {
            this.parent.die("Unrecognized video container", null);
        }
        if (codecType == 0) {
            encoder = "theoraenc";
            propNames = new String[1];
            propValues = new Object[1];
            propNames[0] = "quality";
            Integer q = 31;
            if (codecQuality == 0) {
                q = 0;
            } else if (codecQuality == 1) {
                q = 15;
            } else if (codecQuality == 2) {
                q = 31;
            } else if (codecQuality == 3) {
                q = 47;
            } else if (codecQuality == 4) {
                q = 63;
            }
            propValues[0] = q;
        } else if (codecType == 3) {
            encoder = "schroenc";
            propNames = new String[1];
            propValues = new Object[1];
            propNames[0] = "quality";
            Double q = 5.0;
            if (codecQuality == 0) {
                q = 0.0;
            } else if (codecQuality == 1) {
                q = 2.5;
            } else if (codecQuality == 2) {
                q = 5.0;
            } else if (codecQuality == 3) {
                q = 7.5;
            } else if (codecQuality == 4) {
                q = 10.0;
            }
            propValues[0] = q;
        } else if (codecType == 1) {
            encoder = "xvidenc";
        } else if (codecType == 2) {
            encoder = "x264enc";
            propNames = new String[2];
            propValues = new Object[2];
            propNames[0] = "pass";
            Integer p = 5;
            propValues[0] = p;
            propNames[1] = "quantizer";
            Integer q = 21;
            if (codecQuality == 0) {
                q = 50;
            } else if (codecQuality == 1) {
                q = 35;
            } else if (codecQuality == 2) {
                q = 21;
            } else if (codecQuality == 3) {
                q = 15;
            } else if (codecQuality == 4) {
                q = 1;
            }
            propValues[1] = q;
        } else if (codecType == 4) {
            encoder = "jpegenc";
            propNames = new String[1];
            propValues = new Object[1];
            propNames[0] = "quality";
            Integer q = 85;
            if (codecQuality == 0) {
                q = 0;
            } else if (codecQuality == 1) {
                q = 30;
            } else if (codecQuality == 2) {
                q = 50;
            } else if (codecQuality == 3) {
                q = 85;
            } else if (codecQuality == 4) {
                q = 100;
            }
            propValues[0] = q;
        } else if (codecType == 5) {
            encoder = "jp2kenc";
        } else {
            this.parent.die("Unrecognized video codec", null);
        }
        this.initRecorder(filename, ifps, encoder, muxer, propNames, propValues);
    }

    protected void init(PApplet iparent, int requestWidth, int requestHeight, String filename, String encoder, String muxer, String[] propNames, Object[] propValues, int ifps) {
        this.parent = iparent;
        GSVideo.init();
        this.parent.registerDispose((Object)this);
        this.width = requestWidth;
        this.height = requestHeight;
        this.initRecorder(filename, ifps, encoder, muxer, propNames, propValues);
    }

    protected void initRecorder(String filename, int ifps, String encoder, String muxer, String[] propNames, Object[] propValues) {
        File file = new File(this.parent.savePath(filename));
        this.recorder = new RGBDataFileSink("MovieMaker", this.width, this.height, ifps, encoder, propNames, propValues, muxer, file);
        this.recorder.setQueueSize(100);
        this.recording = false;
        this.nConsecutiveFilledQueue = 0;
    }
}

