/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.ClockTime;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.SeekType;
import org.gstreamer.elements.DataSink;
import org.gstreamer.elements.RGBDataSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSPipeline
extends PImage
implements PConstants {
    protected Method pipelineEventMethod;
    protected String pipeline;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected boolean available;
    protected int pipeWidth;
    protected int pipeHeight;
    protected Object eventHandler;
    protected RGBDataSink videoSink = null;
    protected int[] copyPixels = null;
    protected Pipeline gpipe;
    protected boolean firstFrame = true;
    protected int streamType;
    protected DataSink dataSink = null;
    public byte[] data = null;
    public String dataCaps;
    protected String tempDataCaps;
    protected byte[] copyData = null;

    public GSPipeline(PApplet parent, String pipeStr) {
        this(parent, pipeStr, 1);
    }

    public GSPipeline(PApplet parent, String pipeStr, int type) {
        super(1, 1, 1);
        this.parent = parent;
        this.gpipe = null;
        GSVideo.init();
        parent.registerDispose((Object)this);
        this.setEventHandlerObject(parent);
        int idx = pipeStr.lastIndexOf(33);
        String lastElem = pipeStr.substring(idx + 1, pipeStr.length()).trim();
        String[] parts = lastElem.split(" ");
        String lastElemName = parts.length > 0 ? parts[0] : "";
        boolean fakeSink = lastElemName.equals("fakesink");
        boolean fileSink = lastElemName.equals("filesink");
        if (PApplet.platform == 1) {
            pipeStr = pipeStr.replace("\\", "\\\\");
        }
        if (fakeSink || fileSink) {
            this.pipeline = pipeStr;
            this.gpipe = Pipeline.launch((String)pipeStr);
        } else if (type == 1) {
            String caps = " ! ffmpegcolorspace ! video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ";
            caps = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? String.valueOf(caps) + "red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000" : String.valueOf(caps) + "red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF";
            StringBuilder finalPipeStr = new StringBuilder(pipeStr);
            finalPipeStr.append(caps);
            finalPipeStr.append(" ! fakesink name=VideoSink");
            this.pipeline = finalPipeStr.toString();
            this.gpipe = Pipeline.launch((String)this.pipeline);
            this.videoSink = new RGBDataSink("rgb", this.gpipe, new RGBDataSink.Listener(){

                public void rgbFrame(boolean pre, int w, int h, IntBuffer buffer) {
                    GSPipeline.this.invokeVideoEvent(w, h, buffer);
                }
            });
            this.videoSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
        } else if (type == 0) {
            this.pipeline = pipeStr;
            this.gpipe = Pipeline.launch((String)pipeStr);
        } else if (type == 2) {
            StringBuilder finalPipeStr = new StringBuilder(pipeStr);
            finalPipeStr.append(" ! fakesink name=DataSink");
            this.pipeline = finalPipeStr.toString();
            this.gpipe = Pipeline.launch((String)this.pipeline);
            this.dataSink = new DataSink("rgb", this.gpipe, new DataSink.Listener(){

                public void dataFrame(boolean pre, Caps caps, int size, ByteBuffer buffer) {
                    GSPipeline.this.invokeRawEvent(caps, size, buffer);
                }
            });
            this.dataSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
        } else {
            System.err.println("Unrecognized stream type: Please use VIDEO, AUDIO, or RAW.");
            return;
        }
        Bus bus = this.gpipe.getBus();
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject element) {
                GSPipeline.this.eosEvent();
            }
        });
        this.streamType = type;
    }

    public void delete() {
        if (this.gpipe != null) {
            try {
                if (this.gpipe.isPlaying()) {
                    this.gpipe.stop();
                }
            }
            catch (IllegalStateException e) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.copyPixels = null;
            this.pixels = null;
            if (this.videoSink != null) {
                this.videoSink.removeListener();
                this.videoSink.dispose();
                this.videoSink = null;
            }
            this.copyData = null;
            this.data = null;
            if (this.dataSink != null) {
                this.dataSink.removeListener();
                this.dataSink.dispose();
                this.dataSink = null;
            }
            this.gpipe.dispose();
            this.gpipe = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    public void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.pipelineEventMethod = this.eventHandler.getClass().getMethod("pipelineEvent", GSPipeline.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float duration() {
        float sec = this.gpipe.queryDuration().toSeconds();
        float nanosec = this.gpipe.queryDuration().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public float time() {
        float sec = this.gpipe.queryPosition().toSeconds();
        float nanosec = this.gpipe.queryPosition().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public void jump(float where) {
        long stop;
        long start;
        boolean res;
        if (this.playing) {
            this.gpipe.pause();
        }
        if (!(res = this.gpipe.seek(1.0, Format.TIME, 1, SeekType.SET, start = GSVideo.secToNanoLong(where), SeekType.SET, stop = -1L))) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gpipe.play();
        }
    }

    public boolean available() {
        return this.available;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    public void play() {
        this.playing = true;
        this.paused = false;
        this.gpipe.play();
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.playing = false;
        this.paused = true;
        this.gpipe.pause();
    }

    public void stop() {
        if (this.playing) {
            this.goToBeginning();
            this.playing = false;
        }
        this.paused = false;
        this.gpipe.stop();
    }

    public synchronized void read() {
        if (this.streamType == 1) {
            this.loadPixels();
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.pipeWidth, this.pipeHeight, 1);
                this.loadPixels();
                this.firstFrame = false;
            }
            int[] temp = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = temp;
        } else if (this.streamType == 2) {
            if (this.copyData == null) {
                return;
            }
            this.dataCaps = this.tempDataCaps;
            if (this.data == null) {
                this.data = new byte[this.copyData.length];
            }
            byte[] temp = this.data;
            this.data = this.copyData;
            this.copyData = temp;
        }
        this.available = false;
    }

    public void goToBeginning() {
        boolean res = this.gpipe.seek(ClockTime.fromNanos((long)0L));
        if (!res) {
            System.err.println("Seek operation failed.");
        }
    }

    public void goToEnd() {
        long nanos = this.gpipe.queryDuration().getNanoSeconds();
        boolean res = this.gpipe.seek(ClockTime.fromNanos((long)nanos));
        if (!res) {
            System.err.println("Seek operation failed.");
        }
    }

    public float getProperty(String name) {
        if (this.playing) {
            return ((Number)this.gpipe.get(name)).floatValue();
        }
        return 0.0f;
    }

    public void setProperty(String name, float v) {
        if (this.playing) {
            this.gpipe.set(name, (Object)Float.valueOf(v));
        }
    }

    public void volume(float v) {
        this.setProperty("volume", v);
    }

    public String getPipeline() {
        return this.pipeline;
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        } else {
            this.playing = false;
        }
    }

    protected synchronized void invokeVideoEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.pipeWidth = w;
        this.pipeHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling pipelineEvent() for " + this.pipeline);
                e.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }

    protected synchronized void invokeRawEvent(Caps caps, int n, ByteBuffer buffer) {
        this.available = true;
        this.tempDataCaps = caps.toString();
        if (this.copyData == null) {
            this.copyData = new byte[n];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyData);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyData = null;
            return;
        }
        if (this.playing && this.pipelineEventMethod != null) {
            try {
                this.pipelineEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling pipelineEvent() for " + this.pipeline);
                e.printStackTrace();
                this.pipelineEventMethod = null;
            }
        }
    }
}

