/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSVideo;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.DataAppSink;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class GSPlayer
extends PImage
implements PConstants {
    protected Method playerEventMethod;
    protected String filename;
    protected boolean playing;
    protected boolean paused;
    protected boolean repeat;
    protected boolean available;
    protected int fps;
    protected float rate;
    protected int movieWidth;
    protected int movieHeight;
    protected Object eventHandler;
    protected RGBDataAppSink videoSink;
    protected int[] copyPixels;
    protected PlayBin2 gplayer;
    protected boolean firstFrame;
    protected int streamType;
    protected DataAppSink dataSink;
    public byte[] data;
    public String dataCaps;
    protected String tempDataCaps;
    protected byte[] copyData;

    public GSPlayer(PApplet parent, String filename) {
        this(parent, filename, 30, 1);
    }

    public GSPlayer(PApplet parent, String filename, int type) {
        this(parent, filename, 30, type);
    }

    public GSPlayer(PApplet parent, String filename, int ifps, int type) {
        block17: {
            super(1, 1, 1);
            this.playing = false;
            this.paused = false;
            this.repeat = false;
            this.videoSink = null;
            this.copyPixels = null;
            this.firstFrame = true;
            this.dataSink = null;
            this.data = null;
            this.copyData = null;
            this.parent = parent;
            this.gplayer = null;
            GSVideo.init();
            try {
                File file;
                try {
                    file = new File(parent.dataPath(filename));
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSPlayer");
                        this.gplayer.setInputFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.gplayer != null) break block17;
                try {
                    file = new File(filename);
                    if (file.exists()) {
                        this.gplayer = new PlayBin2("GSPlayer");
                        this.gplayer.setInputFile(file);
                        break block17;
                    }
                    System.err.println("File " + filename + " does not exist. Please check location.");
                }
                catch (Exception exception) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.gplayer == null) {
            parent.die("Could not load media file " + filename, null);
        }
        try {
            this.filename = filename;
            this.fps = ifps;
            parent.registerDispose((Object)this);
            this.setEventHandlerObject(parent);
            if (type == 1) {
                this.videoSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                    public void rgbFrame(int w, int h, IntBuffer buffer) {
                        GSPlayer.this.invokeVideoEvent(w, h, buffer);
                    }
                });
                this.videoSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
                this.gplayer.setVideoSink((Element)this.videoSink);
                this.videoSink.dispose();
            } else if (type == 0) {
                this.gplayer.setVideoSink(ElementFactory.make((String)"fakesink", (String)"audiosink"));
            } else if (type == 2) {
                this.dataSink = new DataAppSink("data", new DataAppSink.Listener(){

                    public void dataFrame(Caps caps, int size, ByteBuffer buffer) {
                        GSPlayer.this.invokeRawEvent(caps, size, buffer);
                    }
                });
                this.dataSink.setPassDirectBuffer(GSVideo.passDirectBuffer);
                this.gplayer.setVideoSink((Element)this.dataSink);
                this.dataSink.dispose();
            } else {
                System.err.println("Unrecognized stream type: Please use VIDEO, AUDIO, or RAW.");
                return;
            }
            Bus bus = this.gplayer.getBus();
            bus.connect(new Bus.EOS(){

                public void endOfStream(GstObject element) {
                    GSPlayer.this.eosEvent();
                }
            });
            this.rate = 1.0f;
            this.frameRate(this.fps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.streamType = type;
    }

    public void delete() {
        if (this.gplayer != null) {
            try {
                if (this.gplayer.isPlaying()) {
                    this.gplayer.stop();
                }
            }
            catch (IllegalStateException e) {
                System.err.println("error when deleting player, maybe some native resource is already disposed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.copyPixels = null;
            this.pixels = null;
            if (this.videoSink != null) {
                this.videoSink.removeListener();
                this.videoSink.dispose();
                this.videoSink = null;
            }
            this.copyData = null;
            this.data = null;
            if (this.dataSink != null) {
                this.dataSink.removeListener();
                this.dataSink.dispose();
                this.dataSink = null;
            }
            this.gplayer.dispose();
            this.gplayer = null;
        }
    }

    public void dispose() {
        this.delete();
    }

    public void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.playerEventMethod = this.eventHandler.getClass().getMethod("playerEvent", GSPlayer.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSourceWidth() {
        Dimension dim = this.gplayer.getVideoSize();
        if (dim != null) {
            return dim.width;
        }
        return 0;
    }

    public int getSourceHeight() {
        Dimension dim = this.gplayer.getVideoSize();
        if (dim != null) {
            return dim.width;
        }
        return 0;
    }

    public float getSourceFrameRate() {
        return (float)this.gplayer.getVideoSinkFrameRate();
    }

    public void frameRate(int ifps) {
        long stop;
        long start;
        if (ifps == 0) {
            System.err.println("FPS of zero is invalid");
            return;
        }
        float ffps = ifps;
        float f = ffps / (float)this.fps;
        if (this.playing) {
            this.gplayer.pause();
        }
        long t = this.gplayer.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            start = t;
            stop = -1L;
        } else {
            start = 0L;
            stop = t;
        }
        boolean res = this.gplayer.seek((double)(this.rate * f), Format.TIME, 1, SeekType.SET, start, SeekType.SET, stop);
        if (!res) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gplayer.play();
        }
        this.fps = ifps;
    }

    public void speed(float irate) {
        this.rate = irate;
        this.frameRate(this.fps);
    }

    public float duration() {
        float sec = this.gplayer.queryDuration().toSeconds();
        float nanosec = this.gplayer.queryDuration().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public float time() {
        float sec = this.gplayer.queryPosition().toSeconds();
        float nanosec = this.gplayer.queryPosition().getNanoSeconds();
        return sec + GSVideo.nanoSecToSecFrac(nanosec);
    }

    public long length() {
        return (int)(this.duration() * this.getSourceFrameRate());
    }

    public int frame() {
        return (int)(this.time() * this.getSourceFrameRate());
    }

    public void jump(float where) {
        long stop;
        long start;
        boolean res;
        if (this.playing) {
            this.gplayer.pause();
        }
        if (!(res = this.gplayer.seek(1.0, Format.TIME, 1, SeekType.SET, start = GSVideo.secToNanoLong(where), SeekType.SET, stop = -1L))) {
            System.err.println("Seek operation failed.");
        }
        if (this.playing) {
            this.gplayer.play();
        }
    }

    public void jump(int frame) {
        float srcFramerate = this.getSourceFrameRate();
        float frameDuration = 1.0f / srcFramerate;
        float where = ((float)frame + 0.5f) * frameDuration;
        float diff = this.duration() - where;
        if (diff < 0.0f) {
            where += diff - 0.25f * frameDuration;
        }
        this.jump(where);
    }

    public boolean available() {
        return this.available;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    public void play() {
        this.playing = true;
        this.paused = false;
        this.gplayer.play();
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.playing = false;
        this.paused = true;
        this.gplayer.pause();
    }

    public void stop() {
        if (this.playing) {
            this.goToBeginning();
            this.playing = false;
        }
        this.paused = false;
        this.gplayer.stop();
    }

    public synchronized void read() {
        if (this.streamType == 1) {
            this.loadPixels();
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.movieWidth, this.movieHeight, 1);
                this.loadPixels();
                this.firstFrame = false;
            }
            int[] temp = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = temp;
        } else if (this.streamType == 2) {
            if (this.copyData == null) {
                return;
            }
            this.dataCaps = this.tempDataCaps;
            if (this.data == null) {
                this.data = new byte[this.copyData.length];
            }
            byte[] temp = this.data;
            this.data = this.copyData;
            this.copyData = temp;
        }
        this.available = false;
    }

    public void goToBeginning() {
        this.gplayer.seek(ClockTime.fromNanos((long)0L));
    }

    public void volume(float v) {
        if (this.playing) {
            this.gplayer.setVolume((double)v);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    protected void eosEvent() {
        if (this.repeat) {
            this.goToBeginning();
        } else {
            this.playing = false;
        }
    }

    protected synchronized void invokeVideoEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.movieWidth = w;
        this.movieHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.playing && this.playerEventMethod != null) {
            try {
                this.playerEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling playerEvent() for " + this.filename);
                e.printStackTrace();
                this.playerEventMethod = null;
            }
        }
    }

    protected synchronized void invokeRawEvent(Caps caps, int n, ByteBuffer buffer) {
        this.available = true;
        this.tempDataCaps = caps.toString();
        if (this.copyData == null) {
            this.copyData = new byte[n];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyData);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyData = null;
            return;
        }
        if (this.playing && this.playerEventMethod != null) {
            try {
                this.playerEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling playerEvent() for " + this.filename);
                e.printStackTrace();
                this.playerEventMethod = null;
            }
        }
    }
}

