/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.gsvideo;

import codeanticode.gsvideo.GSLibraryLoader;
import codeanticode.gsvideo.GSLibraryPath;
import java.io.File;
import java.util.List;
import org.gstreamer.Gst;
import org.gstreamer.Plugin;
import org.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;

public class GSVideo
implements PConstants {
    protected static String VERSION_STRING = "0.8";
    protected static long INSTANCES_COUNT = 0L;
    protected static String gstreamerBinPath = "";
    protected static String gstreamerPluginsPath = "";
    protected static boolean defaultGLibContext = false;
    public static boolean globalGStreamer = true;
    public static boolean passDirectBuffer = true;
    public static String globalGStreamerPath;
    public static String globalPluginsFolder;
    public static String localGStreamerPath;
    public static String localPluginsFolder;
    public static final int AUDIO = 0;
    public static final int VIDEO = 1;
    public static final int RAW = 2;

    static {
        globalPluginsFolder = "gstreamer-0.10";
        if (PApplet.platform == 2) {
            globalGStreamerPath = "/System/Library/Frameworks/GStreamer.framework/Versions/Current/lib";
        } else if (PApplet.platform == 1) {
            globalGStreamerPath = "";
        } else if (PApplet.platform == 3) {
            globalGStreamerPath = "/usr/lib";
        }
        localGStreamerPath = "";
        localPluginsFolder = "plugins";
    }

    public static void init() {
        if (INSTANCES_COUNT == 0L) {
            PApplet.println((String)("GSVideo version: " + VERSION_STRING));
            GSVideo.initImpl();
        }
        ++INSTANCES_COUNT;
    }

    public static void restart() {
        GSVideo.removePlugins();
        Gst.deinit();
        GSVideo.initImpl();
    }

    protected static void initImpl() {
        GSLibraryLoader loader;
        if (PApplet.platform == 3) {
            globalGStreamer = true;
            GSVideo.setLinuxPath();
        } else if (PApplet.platform == 1) {
            GSVideo.setWindowsPath();
        } else if (PApplet.platform == 2) {
            GSVideo.setMacOSXPath();
        }
        if (!gstreamerBinPath.equals("")) {
            System.setProperty("jna.library.path", gstreamerBinPath);
        }
        if (PApplet.platform == 3 && !globalGStreamer) {
            System.err.println("Loading local version of GStreamer not supported in Linux at this time.");
        }
        if (PApplet.platform == 1 && !globalGStreamer && (loader = GSLibraryLoader.getInstance()) == null) {
            System.err.println("Cannot load local version of GStreamer libraries.");
        }
        if (PApplet.platform == 2) {
            // empty if block
        }
        String[] args = new String[]{""};
        Gst.setUseDefaultContext((boolean)defaultGLibContext);
        Gst.init((String)"GSVideo", (String[])args);
        GSVideo.addPlugins();
    }

    protected static void addPlugins() {
        Registry reg;
        boolean res;
        if (!gstreamerPluginsPath.equals("") && !(res = (reg = Registry.getDefault()).scanPath(gstreamerPluginsPath))) {
            System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginsPath);
        }
    }

    protected static void removePlugins() {
        Registry reg = Registry.getDefault();
        List list = reg.getPluginList();
        int i = 0;
        while (i < list.size()) {
            Plugin plg = (Plugin)list.get(i);
            reg.removePlugin(plg);
            ++i;
        }
    }

    protected static void setLinuxPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath libPath = new GSLibraryPath();
                String path = libPath.get();
                gstreamerBinPath = String.valueOf(path) + "/gstreamer/linux";
                gstreamerPluginsPath = String.valueOf(path) + "/gstreamer/linux/" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = String.valueOf(localGStreamerPath) + "/" + localPluginsFolder;
            }
        }
    }

    protected static void setWindowsPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = "";
            gstreamerPluginsPath = "";
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath libPath = new GSLibraryPath();
                String path = libPath.get();
                gstreamerBinPath = String.valueOf(path) + "\\gstreamer\\win";
                gstreamerPluginsPath = String.valueOf(path) + "\\gstreamer\\win\\" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = String.valueOf(localGStreamerPath) + "\\" + localPluginsFolder;
            }
        }
    }

    protected static void setMacOSXPath() {
        if (globalGStreamer && GSVideo.lookForGlobalGStreamer()) {
            gstreamerBinPath = globalGStreamerPath;
            gstreamerPluginsPath = String.valueOf(globalGStreamerPath) + "/" + globalPluginsFolder;
        } else {
            globalGStreamer = false;
            if (localGStreamerPath.equals("")) {
                GSLibraryPath libPath = new GSLibraryPath();
                String path = libPath.get();
                gstreamerBinPath = String.valueOf(path) + "/gstreamer/macosx";
                gstreamerPluginsPath = String.valueOf(path) + "/gstreamer/macosx/" + localPluginsFolder;
            } else {
                gstreamerBinPath = localGStreamerPath;
                gstreamerPluginsPath = String.valueOf(localGStreamerPath) + "/" + localPluginsFolder;
            }
        }
    }

    protected static boolean lookForGlobalGStreamer() {
        String[] searchPaths = null;
        if (!globalGStreamerPath.equals("")) {
            searchPaths = new String[]{globalGStreamerPath};
        }
        if (searchPaths == null) {
            String lpaths = System.getProperty("java.library.path");
            String pathsep = System.getProperty("path.separator");
            searchPaths = lpaths.split(pathsep);
        }
        int i = 0;
        while (i < searchPaths.length) {
            String path = searchPaths[i];
            if (GSVideo.libgstreamerPresent(path, "libgstreamer")) {
                globalGStreamerPath = path;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean libgstreamerPresent(String dir, String file) {
        File libPath = new File(dir);
        String[] files = libPath.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (-1 < files[i].indexOf(file)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected static float nanoSecToSecFrac(float nanosec) {
        int i = 0;
        while (i < 3) {
            nanosec = (float)((double)nanosec / 1000.0);
            ++i;
        }
        return nanosec;
    }

    protected static long secToNanoLong(float sec) {
        Float f = new Float((double)sec * 1.0E9);
        return f.longValue();
    }
}

