/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import peasy.PeasyCam;
import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.Vector3D;
import processing.core.PApplet;

public class pmol
extends PApplet {
    int bg = -1;
    int ca = -2236929;
    int cb = -5592321;
    float rmin = 0.1f;
    float rmax = 1.0f;
    float ra = 0.33333334f;
    float rb = 0.16666667f;
    float opacity = 120.0f;
    int detail = 30;
    PeasyCam cam;
    boolean reset;
    boolean transparent = true;
    float rt;
    float dx;
    float dy;
    float dz;
    float dmax;
    float xmin;
    float ymin;
    float zmin;
    float xmax;
    float ymax;
    float zmax;
    AtomSetCollection asc;
    int select = -1;

    public void setup() {
        this.size(500, 500, "processing.core.PGraphics3D");
        this.sphereDetail(this.detail / 2);
        this.cam = new PeasyCam((PApplet)this, 500.0);
        this.noStroke();
        this.nextMol();
    }

    public void draw() {
        this.background(this.bg);
        this.lights();
        this.scale(0.8f);
        this.drawMolecule(this.asc);
    }

    public void keyPressed() {
        block0 : switch (this.key) {
            case ' ': {
                this.nextMol();
                break;
            }
            case 't': {
                this.transparent = !this.transparent;
                break;
            }
            case '\uffff': {
                switch (this.keyCode) {
                    case 38: {
                        this.ra *= 1.1f;
                        break block0;
                    }
                    case 40: {
                        this.ra /= 1.1f;
                        this.rb = pmol.min((float)this.ra, (float)this.rb);
                        break block0;
                    }
                    case 37: {
                        this.rb /= 1.1f;
                        break block0;
                    }
                    case 39: {
                        this.rb *= 1.1f;
                        this.ra = pmol.max((float)this.ra, (float)this.rb);
                    }
                }
            }
        }
        this.ra = pmol.constrain((float)this.ra, (float)this.rmin, (float)this.rmax);
        this.rb = pmol.constrain((float)this.rb, (float)this.rmin, (float)this.rmax);
    }

    public void drawMolecule(AtomSetCollection atomSetCollection) {
        Atom atom;
        int n;
        if (this.reset) {
            this.xmin = Float.MAX_VALUE;
            this.ymin = Float.MAX_VALUE;
            this.zmin = Float.MAX_VALUE;
            this.xmax = -3.4028235E38f;
            this.ymax = -3.4028235E38f;
            this.zmax = -3.4028235E38f;
            n = 0;
            while (n < atomSetCollection.getAtomCount()) {
                atom = atomSetCollection.getAtom(n);
                this.xmin = pmol.min((float)this.xmin, (float)atom.x);
                this.ymin = pmol.min((float)this.ymin, (float)atom.y);
                this.zmin = pmol.min((float)this.zmin, (float)atom.z);
                this.xmax = pmol.max((float)this.xmax, (float)atom.x);
                this.ymax = pmol.max((float)this.ymax, (float)atom.y);
                this.zmax = pmol.max((float)this.zmax, (float)atom.z);
                ++n;
            }
            this.dx = (this.xmax + this.xmin) / 2.0f;
            this.dy = (this.ymax + this.ymin) / 2.0f;
            this.dz = (this.zmax + this.zmin) / 2.0f;
            this.dmax = pmol.max((float)pmol.max((float)(this.xmax - this.xmin), (float)(this.ymax - this.ymin)), (float)(this.zmax - this.zmin));
            this.reset = false;
        }
        this.scale(1.0f, -1.0f);
        this.scale((float)this.width / this.dmax);
        this.translate(-this.dx, -this.dy, -this.dz);
        this.rt = pmol.sqrt((float)(this.ra * this.ra - this.rb * this.rb));
        n = 0;
        while (n < atomSetCollection.getBondCount()) {
            atom = atomSetCollection.getBond(n);
            Atom atom2 = atomSetCollection.getAtom(atom.atomIndex1);
            Atom atom3 = atomSetCollection.getAtom(atom.atomIndex2);
            this.fill(this.cb, this.transparent ? this.opacity : 255.0f);
            this.tube(atom2.x, atom2.y, atom2.z, atom3.x, atom3.y, atom3.z, this.rb);
            ++n;
        }
        n = 0;
        while (n < atomSetCollection.getAtomCount()) {
            atom = atomSetCollection.getAtom(n);
            this.pushMatrix();
            this.translate(atom.x, atom.y, atom.z);
            this.fill(this.ca, this.transparent ? this.opacity : 255.0f);
            this.sphere(this.ra);
            this.popMatrix();
            ++n;
        }
    }

    public void tube(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = pmol.dist((float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
        if (2.0f * this.rt > f8) {
            return;
        }
        this.pushMatrix();
        this.translate(f, f2, f3);
        Rotation rotation = new Rotation(new Vector3D(0.0, 0.0, 1.0), new Vector3D((double)(f4 - f), (double)(f5 - f2), (double)(f6 - f3)));
        this.beginShape(17);
        int n = 0;
        while (n <= this.detail) {
            float f9 = (float)n * ((float)Math.PI * 2) / (float)this.detail;
            float f10 = f7 * pmol.cos((float)f9);
            float f11 = f7 * pmol.sin((float)f9);
            this.rvertex(f10, f11, f8 - this.rt, rotation);
            this.rvertex(f10, f11, this.rt, rotation);
            ++n;
        }
        this.endShape(2);
        this.popMatrix();
    }

    public void rvertex(float f, float f2, float f3, Rotation rotation) {
        Vector3D vector3D = rotation.applyTo(new Vector3D((double)f, (double)f2, (double)f3));
        this.vertex((float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ());
    }

    public void lights() {
        int n = 120;
        int n2 = -1;
        boolean bl = true;
        this.ambientLight(n, n, n);
        this.directionalLight(n, n, n, n2, n2, n2);
        this.directionalLight(n, n, n, (float)bl, (float)bl, (float)bl);
        this.directionalLight(n, n, n, n2, n2, (float)bl);
        this.directionalLight(n, n, n, (float)bl, (float)bl, n2);
    }

    public void nextMol() {
        String[] stringArray = new String[]{"jmol", "ala", "arg", "asn", "asp", "cys", "gln", "glu", "gly", "his", "ile", "leu", "lys", "met", "phe", "pro", "ser", "thr", "trp", "tyr", "val", "kaolinite_small"};
        String string = stringArray[++this.select % stringArray.length];
        this.asc = this.readAtoms(String.valueOf(string) + ".mol", "Mol");
        this.reset = true;
    }

    public AtomSetCollection readAtoms(String string, String string2) {
        return (AtomSetCollection)new SmarterJmolAdapter().getAtomSetCollectionFromReader(string, string2, this.createReader(string), new Hashtable());
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#DFDFDF", "pmol"});
    }
}

