/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.StateManager;

public final class Model {
    ModelSet modelSet;
    int modelIndex;
    int fileIndex;
    boolean isPDB;
    boolean isTrajectory;
    int trajectoryBaseIndex;
    int selectedTrajectory = -1;
    boolean hasCalculatedHBonds;
    Hashtable dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    int firstAtomIndex;
    int atomCount = -1;
    BitSet bsAtoms;
    int bondCount = -1;
    int firstMolecule;
    int moleculeCount;
    int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    int chainCount = 0;
    Chain[] chains = new Chain[8];
    int bioPolymerCount = 0;
    Polymer[] bioPolymers = new Polymer[8];
    int biosymmetryCount;
    Hashtable auxiliaryInfo;
    Properties properties;
    float defaultRotationRadius;
    StateManager.Orientation orientation;
    boolean structureTainted;

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    Model(ModelSet modelSet, int n, int n2, String string, Properties properties, Hashtable hashtable) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.jmolData = string;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        this.auxiliaryInfo = hashtable;
        if (hashtable.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)hashtable.get("biosymmetryCount");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            hashtable.put("jmolData", string);
            hashtable.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
    }

    void setNAltLocs(int n) {
        this.nAltLocs = n;
    }

    void setNInsertions(int n) {
        this.nInsertions = n;
    }

    void addSecondaryStructure(byte by, String string, int n, int n2, char c, int n3, char c2, int n4) {
        int n5 = this.bioPolymerCount;
        while (--n5 >= 0) {
            Polymer polymer = this.bioPolymers[n5];
            polymer.addSecondaryStructure(by, string, n, n2, c, n3, c2, n4);
        }
    }

    void calculateStructures() {
        this.modelSet.proteinStructureTainted = true;
        this.structureTainted = true;
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].clearStructures();
            this.bioPolymers[n].calculateStructures();
        }
    }

    public boolean isStructureTainted() {
        return this.structureTainted;
    }

    void setConformation(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].setConformation(bitSet, this.nAltLocs);
        }
    }

    public Chain[] getChains() {
        return this.chains;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != '\u0000') continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCount(boolean bl) {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            int n3 = this.chains[n2].groupCount;
            while (--n3 >= 0) {
                if (this.chains[n2].groups[n3].isHetero() != bl) continue;
                ++n;
            }
        }
        return n;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bitSet);
        }
    }

    void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcSelectedMonomersCount(bitSet);
        }
    }

    void selectSeqcodeRange(int n, int n2, char c, BitSet bitSet, boolean bl) {
        int n3 = this.chainCount;
        while (--n3 >= 0) {
            if (c != '\t' && c != this.chains[n3].chainID && (bl || c != Character.toUpperCase(this.chains[n3].chainID))) continue;
            int n4 = 0;
            while (n4 >= 0) {
                n4 = this.chains[n3].selectSeqcodeRange(n4, n, n2, bitSet);
            }
        }
    }

    int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].getGroupCount();
            }
        }
        return this.groupCount;
    }

    Chain getChain(char c) {
        int n = this.chainCount;
        while (--n >= 0) {
            Chain chain = this.chains[n];
            if (chain.getChainID() != c) continue;
            return chain;
        }
        return null;
    }

    Chain getChain(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    public Polymer getBioPolymer(int n) {
        return this.bioPolymers[n];
    }

    void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            int n2 = this.bioPolymers[n].getType();
            if (n2 != 1 && n2 != 2) continue;
            if (n2 == 1) {
                this.bioPolymers[n].calcHydrogenBonds(null, bitSet, bitSet2);
            }
            int n3 = this.bioPolymerCount;
            while (--n3 >= 0) {
                if (n == n3 || this.bioPolymers[n] == null || n2 != this.bioPolymers[n3].getType()) continue;
                this.bioPolymers[n3].calcHydrogenBonds(this.bioPolymers[n], bitSet, bitSet2);
            }
        }
    }

    public boolean isAtomHidden(int n) {
        return this.modelSet.isAtomHidden(n);
    }

    public void addHydrogenBond(Atom atom, Atom atom2, short s, BitSet bitSet, BitSet bitSet2, float f) {
        this.hasCalculatedHBonds = true;
        this.modelSet.addHydrogenBond(atom, atom2, s, bitSet, bitSet2, f);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    void fixIndices(int n, int n2, BitSet bitSet) {
        int n3;
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (n3 = 0; n3 < this.chainCount; ++n3) {
            this.chains[n3].fixIndices(n2);
        }
        for (n3 = 0; n3 < this.bioPolymerCount; ++n3) {
            this.bioPolymers[n3].recalculateLeadMidpointsAndWingVectors();
        }
        BitSetUtil.deleteBits(this.bsAtoms, bitSet);
    }
}

